#include "item.h"
#include "mephbot.h"

ITEMSTRUCT *ParseItemDrop(BYTE *Packet, DWORD Length) {
	ITEMSTRUCT *item = new ITEMSTRUCT;

	BitFields iPacket(Packet,Length);	
	
	item->MessageID = iPacket.GetField(8);
	item->Action = iPacket.GetField(8);

	item->MessageSize = iPacket.GetField(8);
	item->ItemType = iPacket.GetField(8);
	item->ItemID = iPacket.GetField(32);

	// flags
	item->isSocketsFull = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(3),3,iPacket.pos);
	item->isIdentified = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
	item->isSwitchin = iPacket.GetField(1);
	item->isSwitchout = iPacket.GetField(1);
	item->isBroken = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
	item->fromBelt = iPacket.GetField(1);
	item->hasSockets = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
	item->isJustGenerated = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(2),2,iPacket.pos);
	item->isEar = iPacket.GetField(1);
	item->isStartitem = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(3),3,iPacket.pos);
	item->isMiscItem = iPacket.GetField(1);
	item->isEthereal = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
	item->isPersonalized = iPacket.GetField(1);
	item->isGamble = iPacket.GetField(1);
	item->isRuneWord = iPacket.GetField(1);
	
	DebugItemBits(iPacket.GetField(5),5,iPacket.pos);
	item->MPQVersionField = iPacket.GetField(10);
	
	item->Location = iPacket.GetField(3);
	item->PositionX = iPacket.GetField(16);
	item->PositionY = iPacket.GetField(16);

	// isEar need to return now, until ear packets are decoded  
	if(item->isEar) {
		return item;
	}

	// read in itemcode, its a string;
	item->ItemCode[0] = iPacket.GetField(8);
	item->ItemCode[1] = iPacket.GetField(8);
	item->ItemCode[2] = iPacket.GetField(8);
	item->ItemCode[3] = iPacket.GetField(8);

	// chomp off the space if it exists
	if(item->ItemCode[3] == ' ') {
		item->ItemCode[3] = '\0';
	} else {
		item->ItemCode[4] = '\0';
	}

	// gold is a special case
	if(strcmp(item->ItemCode,"gld") == 0) {
		item->GoldSize = iPacket.GetField(1);
		if(item->GoldSize == ITEM_GOLDSIZE_12BIT) {
			item->GoldAmount = iPacket.GetField(12);
		} else {
			item->GoldAmount = iPacket.GetField(32);
		}
		item->ItemLevel = ITEM_UNSET;
		item->Ilvl = ITEM_UNSET;
		return item;
	}

	// more special cases need to look into properly decoding them
	if(strcmp(item->ItemCode,"ibk") == 0 ||
		strcmp(item->ItemCode,"tbk") == 0 ||
		strcmp(item->ItemCode,"key") == 0) {
		item->ItemLevel = ITEM_UNSET;
		item->Ilvl = ITEM_UNSET;
		return item;
	}
	

	// packet not long enough to read ItemLevel
	if(iPacket.pos + 14 >= iPacket.max) {
		// causes way to much spam
	/*	if(Debug == DEBUG_DEVEL) {
			server->GamePrintInfo("ParseItemDrop: Return before ItemLevel");
		}
		*/
		item->Ilvl = ITEM_UNSET;
		item->ItemLevel = ITEM_UNSET;
		return item;
	}

	DebugItemBits(iPacket.GetField(8),8,iPacket.pos);
	DebugItemBits(iPacket.GetField(2),2,iPacket.pos);
	item->ItemLevel = iPacket.GetField(4);
	item->Ilvl = iPacket.GetField(7);
	return item;
}


/// FROM IID.D2H BY blue mind.
ITEMSTRUCT *ParseInvItemDrop(BYTE *Packet, DWORD Length) {
	ITEMSTRUCT *item = new ITEMSTRUCT;

	BitFields iPacket(Packet,Length);	

	// dump the packet
	
	item->MessageID = iPacket.GetField(8);

	if(item->MessageID != ITEM_MESSAGEID_DROP) 
	{
		delete item;
		return NULL;
	}
	
	item->Action = iPacket.GetField(8);

	item->MessageSize = iPacket.GetField(8);
	item->ItemType = iPacket.GetField(8);
	item->ItemID = iPacket.GetField(32);

	// flags
	item->isSocketsFull = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(3),3,iPacket.pos);
	item->isIdentified = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
	item->isSwitchin = iPacket.GetField(1);
	item->isSwitchout = iPacket.GetField(1);
	item->isBroken = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
	item->fromBelt = iPacket.GetField(1);
	item->hasSockets = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
	item->isJustGenerated = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(2),2,iPacket.pos);
	item->isEar = iPacket.GetField(1);
	item->isStartitem = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(3),3,iPacket.pos);
	item->isMiscItem = iPacket.GetField(1);
	item->isEthereal = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
	item->isPersonalized = iPacket.GetField(1);
	item->isGamble = iPacket.GetField(1);
	item->isRuneWord = iPacket.GetField(1);
	
	DebugItemBits(iPacket.GetField(5),5,iPacket.pos);
	item->MPQVersionField = iPacket.GetField(10);

	item->Location = iPacket.GetField(3);
	
	switch(item->Location) {
		case 3: case 5:
			item->PositionX = iPacket.GetField(16);
			item->PositionY = iPacket.GetField(16);
			break;
		default:
			item->BodyCode  = iPacket.GetField(4);
			item->PositionX = iPacket.GetField(4);
			item->PositionY = iPacket.GetField(4);
			item->StorageCode = iPacket.GetField(3);
	}

	// isEar need to return now, until ear packets are decoded  
	if(item->isEar) {
		return item;
	}

	// read in itemcode, its a string;
	item->ItemCode[0] = iPacket.GetField(8);
	item->ItemCode[1] = iPacket.GetField(8);
	item->ItemCode[2] = iPacket.GetField(8);
	item->ItemCode[3] = iPacket.GetField(8);

	// chomp off the space if it exists
	if(item->ItemCode[3] == ' ') {
		item->ItemCode[3] = '\0';
	} else {
		item->ItemCode[4] = '\0';
	}

	// gold is a special case
	if(strcmp(item->ItemCode,"gld") == 0) {
		item->GoldSize = iPacket.GetField(1);
		if(item->GoldSize == ITEM_GOLDSIZE_12BIT) {
			item->GoldAmount = iPacket.GetField(12);
		} else {
			item->GoldAmount = iPacket.GetField(32);
		}
		item->ItemLevel = ITEM_UNSET;
		item->Ilvl = ITEM_UNSET;
		return item;
	}

	// more special cases need to look into properly decoding them
	if(strcmp(item->ItemCode,"ibk") == 0 ||
		strcmp(item->ItemCode,"tbk") == 0 ||
		strcmp(item->ItemCode,"key") == 0) {
		item->ItemLevel = ITEM_UNSET;
		item->Ilvl = ITEM_UNSET;
		return item;
	}
	

	// packet not long enough to read ItemQuality
	if(iPacket.pos + 14 >= iPacket.max) {
		// causes way to much spam
	/*	if(Debug == DEBUG_DEVEL) {
			server->GamePrintInfo("ParseItemDrop: Return before ItemQuality");
		}
		*/ 
		item->Ilvl = ITEM_UNSET;
		item->ItemLevel = ITEM_UNSET;
		return item;
	}

	iPacket.GetField(3);
	item->Ilvl = iPacket.GetField(7);
	item->ItemLevel = iPacket.GetField(3);
	return item;
}

void DebugItemBits(BYTE data, BYTE size, DWORD pos) {
}


// from mousepad with some small mods
DWORD GetBitField(BYTE* data, DWORD pos, DWORD len, DWORD max) {
	// trying to read beyond the end of the packet

	if(pos + len > max) {

		// if we are already at or beyond the end of packet, return 0;
		if(pos >= max) {
			return 0;
		}
		// otherwise adjust len to all remaining bits
		len = max - pos;
	}

	return (DWORD)(*(unsigned __int64 *)(data+pos/8)<<(64-len-(pos&7))>>(64-len));
}