// item.cpp
// ackmed@gotwalls.com
#include "item.h"
#include "mephbot.h"

ITEMSTRUCT *ParseItemDrop(BYTE *Packet, DWORD Length) {
	ITEMSTRUCT *item = new ITEMSTRUCT;

	BitFields iPacket(Packet,Length);	

	// dump the packet
	item->MessageID = iPacket.GetField(8);

	item->Action = iPacket.GetField(8);

	item->MessageSize = iPacket.GetField(8);
	item->ItemType = iPacket.GetField(8);
	item->ItemID = iPacket.GetField(32);

	// flags
	item->isSocketsFull = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(3),3,iPacket.pos);
	item->isIdentified = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
	item->isSwitchin = iPacket.GetField(1);
	item->isSwitchout = iPacket.GetField(1);
	item->isBroken = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
	item->fromBelt = iPacket.GetField(1);
	item->hasSockets = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
	item->isJustGenerated = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(2),2,iPacket.pos);
	item->isEar = iPacket.GetField(1);
	item->isStartitem = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(3),3,iPacket.pos);
	item->isMiscItem = iPacket.GetField(1);
	item->isEthereal = iPacket.GetField(1);
	DebugItemBits(iPacket.GetField(1),1,iPacket.pos);
	item->isPersonalized = iPacket.GetField(1);
	item->isGamble = iPacket.GetField(1);
	item->isRuneWord = iPacket.GetField(1);
	
	DebugItemBits(iPacket.GetField(5),5,iPacket.pos);
	item->MPQVersionField = iPacket.GetField(10);
	
	item->Location = iPacket.GetField(3);
	item->PositionX = iPacket.GetField(16);
	item->PositionY = iPacket.GetField(16);

	// isEar need to return now, until ear packets are decoded  
	if(item->isEar) {
		return item;
	}

	// read in itemcode, its a string;
	item->ItemCode[0] = iPacket.GetField(8);
	item->ItemCode[1] = iPacket.GetField(8);
	item->ItemCode[2] = iPacket.GetField(8);
	item->ItemCode[3] = iPacket.GetField(8);

	// chomp off the space if it exists
	if(item->ItemCode[3] == ' ') {
		item->ItemCode[3] = '\0';
	} else {
		item->ItemCode[4] = '\0';
	}

	// gold is a special case
	if(strcmp(item->ItemCode,"gld") == 0) {
		item->GoldSize = iPacket.GetField(1);
		if(item->GoldSize == ITEM_GOLDSIZE_12BIT) {
			item->GoldAmount = iPacket.GetField(12);
		} else {
			item->GoldAmount = iPacket.GetField(32);
		}
		item->ItemLevel = ITEM_UNSET;
		return item;
	}

	// more special cases need to look into properly decoding them
	if(strcmp(item->ItemCode,"ibk") == 0 ||
		strcmp(item->ItemCode,"tbk") == 0 ||
		strcmp(item->ItemCode,"key") == 0) {
		item->ItemLevel = ITEM_UNSET;
		return item;
	}
	

	// packet not long enough to read ItemLevel
	if(iPacket.pos + 14 >= iPacket.max) {
		item->ItemLevel = ITEM_UNSET;
		return item;
	}

	DebugItemBits(iPacket.GetField(8),8,iPacket.pos);
	DebugItemBits(iPacket.GetField(2),2,iPacket.pos);
	item->ItemLevel = iPacket.GetField(4);
	return item;
}

void DumpItemStruct(ITEMSTRUCT *item) {

	char DumpString[1024];

	if(item == NULL) {
		return;
	}
	sprintf(DumpString,"%s","DumpItemStruct ");

	// stuff that isnt useful for normal users

	sprintf(DumpString,"%s ItemType: ",DumpString);
	switch(item->ItemType) {
		case ITEM_ITEMTYPE_HELM:
			sprintf(DumpString,"%s helm",DumpString);
			break;
		case ITEM_ITEMTYPE_ARMOR:
			sprintf(DumpString,"%s armor",DumpString);
			break;
		case ITEM_ITEMTYPE_WEAPON:
			sprintf(DumpString,"%s weapon",DumpString);
			break;
		case ITEM_ITEMTYPE_BOW:
			sprintf(DumpString,"%s bow",DumpString);
			break;
		case ITEM_ITEMTYPE_SHIELD:
			sprintf(DumpString,"%s shield",DumpString);
			break;
		case ITEM_ITEMTYPE_EXPANSION:
			sprintf(DumpString,"%s expansion",DumpString);
			break;
		case ITEM_ITEMTYPE_OTHER:
			sprintf(DumpString,"%s other",DumpString);
			break;
		default:
			sprintf(DumpString,"%s ?%.2x",DumpString,item->ItemType);
			break;
	}

	// need to stop if isEar is set
	if(item->isEar) {
		sprintf(DumpString,"%s isEar",DumpString);
		server->GamePrintString(DumpString);
		return;
	}

	sprintf(DumpString,"%s ItemCode: \"%s\"",DumpString,item->ItemCode);
	
	if(item->ItemLevel != ITEM_UNSET) {
		sprintf(DumpString,"%s ItemLevel:",DumpString);
		switch(item->ItemLevel) {
			case ITEM_LEVEL_INFERIOR:
				sprintf(DumpString,"%s inferior",DumpString);
				break;
			case ITEM_LEVEL_NORMAL:
				sprintf(DumpString,"%s normal",DumpString);
				break;
			case ITEM_LEVEL_SUPERIOR:
				sprintf(DumpString,"%s superior",DumpString);
				break;
			case ITEM_LEVEL_MAGIC:
				sprintf(DumpString,"%s magic",DumpString);
				break;
			case ITEM_LEVEL_SET:
				sprintf(DumpString,"%s set",DumpString);
				break;
			case ITEM_LEVEL_RARE:
				sprintf(DumpString,"%s rare",DumpString);
				break;
			case ITEM_LEVEL_UNIQUE:
				sprintf(DumpString,"%s unique",DumpString);
				break;
			case ITEM_LEVEL_CRAFT:
				sprintf(DumpString,"%s craft",DumpString);
				break;
			default:
				sprintf(DumpString,"%s ?%.2x",DumpString,item->ItemLevel);
				break;
		}
	}
	sprintf(DumpString,"%s Flags:",DumpString);
	if(item->hasSockets) 
		sprintf(DumpString,"%s hasSockets",DumpString);
	if(item->isEthereal) 
		sprintf(DumpString,"%s isEthereal",DumpString);
	if(item->isSocketsFull) 
		sprintf(DumpString,"%s isSocketsFull",DumpString);
	if(item->isIdentified) {
		sprintf(DumpString,"%s isIdentified",DumpString);
	} else {
		sprintf(DumpString,"%s isUnidentified",DumpString);
	}

	server->GamePrintString(DumpString);
}	

void DebugItemBits(BYTE data, BYTE size, DWORD pos) {
// fill me in!
//	BYTE n;

}
// from mousepad with some small mods
DWORD GetBitField(BYTE* data, DWORD pos, DWORD len, DWORD max) {
	// trying to read beyond the end of the packet

	if(pos + len > max) {

		// if we are already at or beyond the end of packet, return 0;
		if(pos >= max) {
			return 0;
		}
		// otherwise adjust len to all remaining bits
		len = max - pos;
	}

	return (DWORD)(*(unsigned __int64 *)(data+pos/8)<<(64-len-(pos&7))>>(64-len));
}