//////////////////////////////////////////////////////////////////////////////
//
// mephbot.cpp by syadasti <mike@gogulski.com>
// Copyright (c) 2002 by Mike Gogulski
//
// Based on original code by Mousepad, ackmed, thohell, Gayak, g0llum, icky,
// Onlyer, YobGuls, Mozart McLaus, FallNAngel, Jonathan Wu, druttis, Cigamit
// masterste0, Herzog_Zwei, and others
//
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
//
// Version History
//
// 0.1		Initial code
// 0.2		Added .ini file handling, repair, nova, many speed improvements
//			and bugfixes
// 0.3		Bunches more features and fixes, FIRST ALPHA RELEASE
// 0.4		Second alpha release, see mephbot-dev.txt for release notes
// 0.5		Quick bugfix mostly in STATE_ATTACK_MEPH, see mephbot-dev.txt
// 0.6		New stairs-finding method, message serialization, runs minimized,
//			no more keystrokes/mouseclicks (all packets), split single source
//			into multiple files, PKTK code integration, other fixes, see
//			mephbot-dev.txt
//			FIRST BETA RELEASE
// 0.7		Faster stairs-finding with Dijkstra's shortest path algorithm
//			Eliminated several user options. Fixed chicken code.
//			INI-configurable skill selection.  Improved precast logic.
//			Dodging code from Gayak.  Fixes to TeleportAway().
//			See mephbot-dev.txt
//			SECOND BETA RELEASE
//
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
//
// DEPENDENCIES
//
// Microsoft Windows Platform SDK (for iphlpapi.h/.lib)
//
// d2hackit.dll			Diablo 2 hack framework
// gt.d2h				potion drinking triggers
// tr.d2h				belt management, potion drinking
// pickit.d2h			item pickup
// mover.d2h			dumping 1x1 items into stash
//
//////////////////////////////////////////////////////////////////////////////

#pragma once
#include "mephbot.h"
#include "packethelper.h"
#include "waypoint.h"
#include "util.h"
#include "automation.h"
#include "item.h"
#include "maphack.h"
#include "dijkstra.h"
#include "skills.h"

//////////////////////////////////////////////////////////////////////////////
//
// globals, flags, buffers, etc.
//
//////////////////////////////////////////////////////////////////////////////
FUNCTIONENTRYPOINTS	*server;
THISGAMESTRUCT *thisgame;

BOOL	fInGame = FALSE,
		fModuleActive = TRUE,
		fJustLoaded = TRUE,
		fFindingPathToPortal = FALSE;

DWORD	Tick1 = 0,
		TickStairs = 0,
		TickWaypoint = 0,
		TickGlobal = 0,
		TickGame = 0,
		state = 0,
		nextstate = 0,
		NumRuns = 0;

DWORD WirtID = 0;
DWORD LegID = 0;
WORD WirtX = 0, WirtY = 0;
WORD WirtPos[2]={0x61d8,0x143b};
//int WirtPathIndex=0;

char	szInfoBuf[1024];
char	szRunName[32];

WORD oldpx, oldpy;

DWORD PortalObjID = 0x00;

//LinkedList *MessageQueue = new LinkedList;
//LinkedList *mq;

BYTE CurrentLevel = 0;

//THREAD_DATA td;

int DeltaTeleport = 40;
int DeltaTeleportAway = 4;					// when fleeing meph... maybe calculateable?

int cNoTeleportProgress = 0;

int currentsafe = 0, lastsafe = 0;

HWND hD2Window;

//////////////////////////////////////////////////////////////////////////////
//
// User-settable variables from mephbot.ini
// These are the burned-in defaults
// All time values are in tenths of a second
//
// FIXME:  I'm not really maintaining this anymore, just the INI defaults
// probably need to sync these with those before general release
//
//////////////////////////////////////////////////////////////////////////////

BOOL fOverheadInfo = TRUE;
int DelayStep = 7;
int FastCastPct = 10;
int DelayOverheadUpdate = 5;
int DelayPickup = 10;

//////////////////////////////////////////////////////////////////////////////
//
// Defines, statics
//
//////////////////////////////////////////////////////////////////////////////

// we're not using this now, but it's a screen-independent way to select
// character
/*
char *CharacterSelectString[9] = {
	NULL,
	"",								// 1
	"{RIGHT}",						// 2
	"{DOWN}",						// 3
	"{DOWN}{RIGHT}",				// 4
	"{DOWN}{DOWN}",					// 5
	"{DOWN}{DOWN}{RIGHT}",			// 6
	"{DOWN}{DOWN}{DOWN}",			// 7
	"{DOWN}{DOWN}{DOWN}{RIGHT}" };	// 8*/

char *StateNames[MAXSTATES] = {
	"STATE UNKNOWN! ",
	"Taking Waypoint ",
	"Finding portal ",
	"Teleporting to portal ",
	"Moving to portal ",
	"Taking portal ",
	"Teleporting to Wirt ",
	"Clicking on Wirt ",
	"Taking Wirt's Leg ",
	"Going back to town ",
	"Finished "};

int aRandBox[4][2] = {
	{ 1, 0},
	{ 0, 1},
	{ 0,-1},
	{-1, 0} };
/*
WORD PathToWirt[][2] = {
	{0x6243, 0x13f8},{0x6243, 0x13f8},{0x6243, 0x13f8},{0x6243, 0x13f8},
	{0x6226, 0x140c},{0x6226, 0x140c},{0x6226, 0x140c},{0x6226, 0x140c},
	{0x6203, 0x1423},{0x6203, 0x1423},{0x6203, 0x1423},{0x6203, 0x1423},
	{0x61e1, 0x143c},{0x61e1, 0x143c},{0x61e1, 0x143c},{0x61e1, 0x143c} };
*/

//////////////////////////////////////////////////////////////////////////////
//
// Module info
//
//////////////////////////////////////////////////////////////////////////////

DWORD	ModuleVersion = MAKELONG(VERSION_MAJOR, VERSION_MINOR);
char	ModuleAuthor[] = "Gayak (Syadasti)";
char	ModuleWebsite[] = "gayak.50megs.com";
char	ModuleDescription[] = "wirtbot";
char	ModuleEmail[] = "170@guyau.qc.ca";

//////////////////////////////////////////////////////////////////////////////
//
// Module commands
//
//////////////////////////////////////////////////////////////////////////////

MODULECOMMANDSTRUCT ModuleCommands[]= {
	{ "go", OnCommandGo,
		"goc0 Start the bot.\n" },
	{ "help", OnGameCommandHelp,
		"helpc0 display this help text\n" },
	{NULL}
};

//////////////////////////////////////////////////////////////////////////////
//
// Local functions
//
//////////////////////////////////////////////////////////////////////////////

VOID PRIVATE ChangeState(int newstate) {
	state = newstate;
	return; }

BOOL PRIVATE InGame(VOID) {
	if (!fInGame) {
		return FALSE; }
	if (!thisgame) {
		return FALSE; }
	if (!thisgame->player) {
		return FALSE; }
	// we could add socket 4000 detection here, but that might be expensive
	return TRUE; }

VOID PRIVATE SendD2HackitCommand(char *Cmd) {
	server->GameCommandLine(Cmd);}

VOID PRIVATE TeleportTo(WORD x, WORD y) {
	oldpx = PLAYERX;
	oldpy = PLAYERY;
	//SelectSkillByName("Teleport", SKILL_RIGHT);
	//CastRightClickSkillOnLocation(x, y);
	CastSkillOnLocationByName("Teleport", SKILL_RIGHT, x, y);
	return; }

// both of these functions were just wrong... we needed to do some trig here
// okay.. so after doing the trig we discover no trig is needed

VOID PRIVATE TeleportToward(WORD x, WORD y, int delta) {
	WORD targetx, targety;
	WORD r = (WORD)Dist(PLAYERX, PLAYERY, x, y);
	if (delta > 0 && r <= (WORD)delta) {
		targetx = x;
		targety = y; }
	else {
		targetx = PLAYERX + ((WORD)delta * (x - (WORD)PLAYERX)) / (r > 0 ? r : 1);
		targety = PLAYERY + ((WORD)delta * (y - (WORD)PLAYERY)) / (r > 0 ? r : 1); }
	TeleportTo(targetx, targety);
	return; }

// the hideous "drunkard's teleport" method for solving the maze.
// Not very efficient
// add: bias against teleporting directly away from stairs
VOID PRIVATE TeleportRandomly() {
	int rnd = rand() % 4;
	TeleportTo(PLAYERX + DeltaTeleport * aRandBox[rnd][0],
		PLAYERY + DeltaTeleport * aRandBox[rnd][1]);
	return; }

VOID PRIVATE TeleportRandomly(int delta) {
	int oDeltaTeleport = DeltaTeleport;
	DeltaTeleport = delta;
	TeleportRandomly();
	DeltaTeleport = oDeltaTeleport;
	return; }

VOID PRIVATE OverheadInfo(VOID) {
	if (fOverheadInfo && InGame()) {
		char OverheadInfoBuf[4096];
		sprintf(OverheadInfoBuf, "c3--------c1Wirtbotc6-c1Statusc3-------- ");
		sprintf(OverheadInfoBuf, "%sc7%s ", OverheadInfoBuf, StateNames[state]);
		sprintf(OverheadInfoBuf, "%sc0%s ", OverheadInfoBuf, szInfoBuf);
		sprintf(OverheadInfoBuf, "%sc7x%.4X y%.4X Lv%d ",
			OverheadInfoBuf, PLAYERX, PLAYERY, (int)GetCurrentLevel());
		if (GetCurrentLevel() == 4 && PortalX && PortalY) {
			sprintf(OverheadInfoBuf, "%sc7Distance to Portal: c1%d ", OverheadInfoBuf, Dist(PLAYERX, PLAYERY, PortalX, PortalY)); }
		if (GetCurrentLevel() == 38 && Dist(PLAYERX, PLAYERY, WirtPos[0], WirtPos[1])<400 ) {
			sprintf(OverheadInfoBuf, "%sc7Distance to Wirt: c1%d ", OverheadInfoBuf, Dist(PLAYERX, PLAYERY, WirtPos[0], WirtPos[1])); }
		sprintf(OverheadInfoBuf,"%sc3------------------------------------",OverheadInfoBuf);
		OverheadPkt(OverheadInfoBuf); } }

BOOL PRIVATE OnCommandGo(char **argv, int argc) {
	ChangeState(STATE_TAKE_WAYPOINT);
	Tick1 = TickGame = TickStairs = 0;
	WirtX = WirtY = 0;
	PortalX = PortalY = 0;
	CurrentLevel = 0;
//	WirtPathIndex=0;
	return TRUE; }

//////////////////////////////////////////////////////////////////////////////
//
// Functions called by D2Hackit
//
//////////////////////////////////////////////////////////////////////////////

BOOL EXPORT OnClientStart() {
	fModuleActive = TRUE;
	fJustLoaded = TRUE;
	Tick1 = TickGame = TickStairs = 0;
	// Start thread
//	td.Active = TRUE;
//	mq = MessageQueue;
	//td.mq = MessageQueue;			// FIXME: why did i do this?
//	td.hD2Window = hD2Window;
	DWORD dummy = 0;

	ChangeState(0);
	return TRUE; }

BOOL EXPORT OnClientStop() {
	// kill keys & clicks thread
//	td.Active = FALSE;
	// doing WriteStats() here sometimes causes an access violation in ntdll:strtoul(),
	// but this seems to only happen when the user exits mephbot with "unload mephbot"
	fModuleActive = FALSE;
	fInGame = FALSE;
	return TRUE; }
			
VOID EXPORT OnGameJoin(THISGAMESTRUCT *aThisgame) {
	thisgame = aThisgame;
//	td.thisgame = thisgame;
	fInGame = TRUE;
	Tick1 = TickGame = TickStairs = 0;
	WirtX = WirtY = 0;
	PortalX = PortalY = 0;
	CurrentLevel = 0;
//	WirtPathIndex=0;

	// clean up linked lists
//	MessageQueue->PurgeList();
	
//	srand(time(NULL));
	return; }

VOID EXPORT OnGameLeave(THISGAMESTRUCT *aThisgame) {
	thisgame = NULL;
//	td.thisgame = NULL;
	fInGame = FALSE;
	fJustLoaded = FALSE;
	// this is causing a bogus invalid message to be received by ThreadProc, but seems
	// to be harmless
//	MessageQueue->PurgeList();
	ChangeState(0);
	return; }

// is run approximately every tenth of a second
DWORD EXPORT OnGameTimerTick(VOID) {

	if (!fModuleActive) {
		Tick1 = 0;
		return TRUE; }	

	Tick1++;
	TickGlobal++;
	if (InGame()) {
		TickGame++; }

	if (InGame() && state != 0) {
		CurrentLevel = GetCurrentLevel(); }

	if (InGame() && state != 0 && state != STATE_FINISHED) {
		OverheadInfo(); }

	switch (state) {

	case STATE_UNKNOWN: {
		break; }

	case STATE_TAKE_WAYPOINT: {
		if (CurrentLevel == 4) {				// Stony Field
			Tick1 = 0;
			ChangeState(STATE_FIND_PORTAL); }
		else if (Tick1 == DelayStep) {
			server->GameCommandLine("fastwp 1 3");
			Tick1 = 0;}
		break; }

	case STATE_FIND_PORTAL: {
//		if (Tick1==DelayStep){DrawAutomapAct();}
		if (!fFindingPathToPortal) {
			if (PortalX && PortalY) {
				fFindingPathToPortal = TRUE;		// make sure we don't double up these calls
				FindPortalPath();				// big mojo
				oldpx = PLAYERX; oldpy = PLAYERY;

				PortalPathIndex = 0;			// 0 is player
				Tick1 = 0;
				fFindingPathToPortal = FALSE;
				ChangeState(STATE_TELEPORT_TOWARD_PORTAL); }
			else if (Tick1==DelayStep) {
				Tick1=-10;
				//DrawAutomapAct(); 
				PostMessage(hD2Window, WM_KEYDOWN, VK_SUBTRACT, 0);
				PostMessage(hD2Window, WM_KEYUP, VK_SUBTRACT, 0); }
		}
		break; }
		
	case STATE_TELEPORT_TOWARD_PORTAL: {
		if (Tick1 == QUICKSPELLDELAY) {
			if (Dist(PLAYERX, PLAYERY, PortalX, PortalY) <= DeltaTeleport) {
				TeleportTo(PortalX, PortalY);
				Tick1 = 0;
				ChangeState(STATE_TELEPORT_TO_PORTAL); }
			else if (Dist(PLAYERX, PLAYERY, PortalPath[PortalPathIndex][0], PortalPath[PortalPathIndex][1]) <= DeltaTeleport) {
				Tick1 = (QUICKSPELLDELAY * 2) - 1; }
			else if (Dist(PLAYERX, PLAYERY, oldpx, oldpy) < 5) {
				if (++cNoTeleportProgress == 1) {
					TeleportToward(PortalX, PortalY, DeltaTeleport); }
				else if (cNoTeleportProgress == 2) {
					cNoTeleportProgress = 0;
					TeleportRandomly(); }
				Tick1 = 0; }
			else {
				cNoTeleportProgress = 0;
				Tick1 = 0;
				TeleportToward(PortalPath[PortalPathIndex][0], PortalPath[PortalPathIndex][1], DeltaTeleport / 2/*((rand() % 2) + 2)*/); } }
		if (Tick1 == QUICKSPELLDELAY * 2) {
			if (Dist(PLAYERX, PLAYERY, PortalPath[PortalPathIndex][0], PortalPath[PortalPathIndex][1]) < 3) {
				Tick1 = QUICKSPELLDELAY - 1; }
			else {
				Tick1 = 0;
				TeleportTo(PortalPath[PortalPathIndex][0], PortalPath[PortalPathIndex][1]); }
			if (++PortalPathIndex == HopsToPortal) {
				ChangeState(STATE_TELEPORT_TO_PORTAL); } }
		break; }
		
		
	case STATE_TELEPORT_TO_PORTAL: {
		// this state takes us from wherever the previous state ended, directly to the 
		// stairs to Durance 3.  It is intended to correct for undershoot in the previous
		// state, and might be removable if we could get the code above tighter
		if (Tick1 == QUICKSPELLDELAY || Tick1 == QUICKSPELLDELAY * 2) {
			TeleportToward(PortalX, PortalY, (int)Dist(PLAYERX, PLAYERY, PortalX, PortalY) / 2); }
		if (Tick1 == QUICKSPELLDELAY * 3) {
			TakeStep(PortalX, PortalY);
			Tick1 = 0;
			ChangeState(STATE_TAKE_PORTAL); }
		break; }

	case STATE_TAKE_PORTAL: {
		if (CurrentLevel == 38) {					// Tristam
			cNoTeleportProgress = 0;
			Tick1 = 0;
			ChangeState(STATE_TELEPORT_TO_WIRT); }
		else if (Dist(PLAYERX, PLAYERY, PortalX, PortalY) > DeltaTeleport) {
			Tick1 = 0;
			ChangeState(STATE_TELEPORT_TO_PORTAL); }
		else if (Tick1 == DelayStep) {
			RunToEntity(2,PortalObjID);
			InteractWithEntity(2,PortalObjID); }
		else if (Tick1 == DelayStep * 2) {
			TakeStep(PortalX, PortalY);
			Tick1 = 0; }
		break; }
		
	case STATE_TELEPORT_TO_WIRT: {
		if (CurrentLevel!=38) {ChangeState(0);}
		if ( Dist(PLAYERX,PLAYERY,WirtPos[0],WirtPos[1])<5 ) {
			ChangeState(STATE_CLICK_ON_WIRT); }
		if (Tick1 == QUICKSPELLDELAY) {
			if (Dist(PLAYERX,PLAYERY,WirtPos[0],WirtPos[1])>=DeltaTeleport)
				TeleportToward(WirtPos[0], WirtPos[1], DeltaTeleport);
			else TeleportTo(WirtPos[0], WirtPos[1]);
			Tick1 = 0;}
		break; }

	case STATE_CLICK_ON_WIRT: {
		if (CurrentLevel!=38) {ChangeState(0);}
		if ( Dist(PLAYERX,PLAYERY,WirtPos[0],WirtPos[1])>=5 ) {
			ChangeState(STATE_TELEPORT_TO_WIRT); 
			Tick1=0; }
		if (LegID) {
			ChangeState(STATE_TAKE_LEG);
			Tick1=0; }
		if (!WirtID) {
			ChangeState(0);}
		else if (Tick1 == DelayStep) {
			RunToEntity(2,WirtID);
			InteractWithEntity(2,WirtID);
			Tick1 = 0;
			// State changes when the leg drops on the ground.
		}
		break; }
		
	case STATE_TAKE_LEG: {
		if (CurrentLevel!=38) {ChangeState(0);}
		if ( Dist(PLAYERX,PLAYERY,WirtPos[0],WirtPos[1])>=5 ) {
			ChangeState(STATE_TELEPORT_TO_WIRT); 
			Tick1=0; }
		if (!LegID) {
			ChangeState(0);}
		else if (Tick1 == DelayStep) {
			BYTE tak[13]={0x16,0x04,0,0,0,0,0,0,0,0,0,0,0};
			memcpy(&tak[5],&LegID,4);
			SendPacketToServer(tak, 13);
			Tick1 = 0;
			// State changes when you receive the leg in the inventory.
		}
		break; }
		
		
	case STATE_WP_TOWN: {
		if (CurrentLevel == 1) {				// Town
			Tick1 = 0;
			ChangeState(STATE_FINISHED); }
		else if (Tick1 == DelayStep) {
			server->GameCommandLine("fastwp 1 1");
			Tick1 = 0;}
		break; }

	case STATE_FINISHED: {
		if (Tick1==DelayStep) {
		OverheadPkt("\0");
		ChangeState(0);}
		break; }
		
	default: {
		ChangeState(STATE_UNKNOWN);
		break; }
	}
	
	return TRUE; }

DWORD EXPORT OnGamePacketBeforeReceived(BYTE *aPacket, DWORD aLen) {
	ITEMSTRUCT *item;

	if (!fModuleActive || !InGame()) {
		return aLen; }

/*	
stairs down
                        ObjectID--- lid-- PosX- PosY-
03:47:15p  RECV:  51 02 01 00 00 00 7a 01 02 14 2d 14 00 00  (null)  00000z0000000
*/
	if (aPacket[0] == 0x51 && aPacket[1] == 0x02) {				// possible waypoint/stair info
		WORD lid;
		memcpy(&lid, &aPacket[6], 2);
		if (lid == 0x003c) {						// Red Portal
			memcpy(&PortalObjID, &aPacket[2], 4);
			memcpy(&PortalX,&aPacket[8],2);
			memcpy(&PortalY,&aPacket[10],2); }
		if (lid == 0x010c) {						// Wirt
			memcpy(&WirtID, &aPacket[2], 4); }
		return aLen; }

	// Leg is dropped
	if (aPacket[0] == 0x9c && aPacket[1] == 0x00 && state==STATE_CLICK_ON_WIRT) {
		item = ParseItemDrop(aPacket, aLen);

		if(!strcmp(item->ItemCode, "leg")) {
			memcpy(&LegID, &aPacket[4], sizeof(DWORD));
			ChangeState(STATE_TAKE_LEG); }
		delete item; }

	// Leg is taken
	if (aPacket[0] == 0x9c && aPacket[1] == 0x04 ) {
		item = ParseInvItemDrop(aPacket, aLen);

		if(!strcmp(item->ItemCode, "leg")) {
			if (state==STATE_TAKE_LEG || state==STATE_CLICK_ON_WIRT) {
				ChangeState(STATE_WP_TOWN); }
		}
		delete item; }

	return aLen; }


DWORD EXPORT OnGamePacketBeforeSent(BYTE *aPacket, DWORD aLen) {

	if (!fModuleActive || !InGame()) {
		return aLen; }

	// (nicked in turn from Cigamit's shopbot.d2h)
	if (aPacket[0] == 0x03) {										// player run
		ClientWalkUpdate(aPacket, aLen);
		return aLen; }
	
	return aLen; }


//////////////////////////////////////////////////////////////////////
//
// Dll entry/exit
//
//////////////////////////////////////////////////////////////////////
BOOL APIENTRY DllMain(HANDLE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
	BOOL hResult = TRUE;
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		
		srand(time(NULL));

		// from maphack.cpp
		// I don't *think* I need this... maybe I should ask Mousepad...
		//DisableThreadLibraryCalls(hInstDLL);
		// Create server struct			
		server = new FUNCTIONENTRYPOINTS; 
		
		// Bind exported functions from server
		HMODULE hModule;
		hModule = (HMODULE)GetModuleHandle("D2HackIt");

		// for AutoIT replacement functions
		hD2Window = FindWindow("Diablo II", "Diablo II");

		// Macros make this look a lot nicer :)
		BIND_TO_SERVER(GamePrintInfo);
		BIND_TO_SERVER(GamePrintError);
		BIND_TO_SERVER(GamePrintVerbose);
		BIND_TO_SERVER(GamePrintString);
		BIND_TO_SERVER(GameCommandLine);
		BIND_TO_SERVER(GameSendPacketToServer);
		BIND_TO_SERVER(GameSendPacketToGame);
		BIND_TO_SERVER(GetFingerprint);
		BIND_TO_SERVER(Intercept);
		BIND_TO_SERVER(GetHackProfileString);
		BIND_TO_SERVER(SetHackProfileString);
		BIND_TO_SERVER(GetThisgameStruct);
		
		// set up maphack stuff
		return InstallPatches();
		break;
		
	case DLL_PROCESS_DETACH:
		// stop maphack stuff
		if (!lpReserved) RemovePatches();
		// kill client
		delete server;
		break;
	} 
	return hResult;
}


//////////////////////////////////////////////////////////////////////
//
// Stubfunctions for 'property get' functions.
//
//////////////////////////////////////////////////////////////////////
LPCSTR	EXPORT GetModuleAuthor()		{return ModuleAuthor;}
LPCSTR	EXPORT GetModuleWebsite()		{return ModuleWebsite;}
DWORD	EXPORT GetModuleVersion()		{return ModuleVersion;}
LPCSTR	EXPORT GetModuleEmail()			{return ModuleEmail;}
LPCSTR	EXPORT GetModuleDescription()	{return ModuleDescription;}

//////////////////////////////////////////////////////////////////////
//
// OnClientCommandLine
// -------------------------------------------------------------------
// The modules own extension of the command line interface. Any custom
// commands you add are parsed here.
//
// Return value should be TRUE, but it is not used at this 
// time.
//
// Arguments when we get here:
// argv[0]			Name of module
// argv[1]			Name of command (If supplied)
// argv[2 ... n]	The rest
//
// Syntax in the game: .<module> <arguments>
//
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnGameCommandLine(char *argv[], int argc) {
	// Check if user supplied anything at all, if not assume help...
	if (argc==1)
		argv[argc++]="help";
	
	MODULECOMMANDSTRUCT* mcs=ModuleCommands;
	
	while (mcs->szName) {
		if (!stricmp(mcs->szName, argv[1]))
			break;
		mcs++; }
	
	char *p,*t,*msg,*fMsg;
	fMsg=new char[256];
	//
	// Is this a built-in function ?
	if (mcs->szName) {
		//
		// If functions returns FALSE, show usage help
		if (!mcs->pFunc(argv, argc)) {
			t=new char[strlen(mcs->szUsage)+1];
			server->GamePrintInfo("Usage:");
			sprintf((char*)t, "%s", mcs->szUsage);
			if (strlen((char*)t)) {
				msg=p=t;
				while (*p != 0) {
					if (*p == '\n') {
						*(p++) = 0;
						sprintf(fMsg, "c4.%s %s", argv[0], msg);
						server->GamePrintInfo((char*)fMsg);
						if (*p != 0)
							msg = p; }
					else
						p++; }
				sprintf(fMsg, "c4.%s %s", argv[0], msg);
				server->GamePrintInfo((char*)fMsg); }
			delete t; } }
	else {
		// Unknown command, show catch-all help phrase.
		t=new char[128];
		sprintf(t, "Unknown command c4'%s %s'c0 - try c4'.%s help'c0 to get help.",
			argv[0], argv[1], argv[0]);
		server->GamePrintError(t);
		delete t; }

	delete fMsg;
	return TRUE; }


//////////////////////////////////////////////////////////////////////
//
// OnGameCommandHelp
// -------------------------------------------------------------------
// Our default help function.
//
// Syntax in the game: .<module> <arguments>
//
//////////////////////////////////////////////////////////////////////
BOOL PRIVATE OnGameCommandHelp(char **argv, int argc) {
	// If command line is longer than 2, show usage for 'help'
	if (argc > 2) return FALSE;
	
	char t[1024];
	sprintf(t, "Available commands for %s:", argv[0]);
	server->GamePrintInfo(t);
	
	// Loop through ModuleCommands[] and print their names
	for (int i=0; ModuleCommands[i].szName != NULL; i++) {
		sprintf(t, "c4.%s %s", argv[0], ModuleCommands[i].szName);
		server->GamePrintInfo(t); }
	
	sprintf(t, "For help on a specific command, type c4.%s <command> help", argv[0]);
	server->GamePrintInfo(t);
	return TRUE; }
