//////////////////////////////////////////////////////////////////////////////
// mephbot.h by syadasti <mike@gogulski.com>
// Copyright (c) 2002 by Mike Gogulski
//
// Based on original code by Mousepad, ackmed, thohell, Gayak, g0llum, icky,
// Onlyer, YobGuls, Mozart McLaus, FallNAngel, Jonathan Wu, druttis, Cigamit
// masterste0, Herzog_Zwei, and others
//////////////////////////////////////////////////////////////////////////////
#pragma once
#include <windows.h>
#include <time.h>
#include <math.h>
#include <stdarg.h>

#include "external/D2Hackit.h"
#include "external/D2Client.h"

#define	VERSION_MAJOR	0
#define	VERSION_MINOR	2

//////////////////////////////////////////////////////////////////////////////
// globals
//////////////////////////////////////////////////////////////////////////////

extern BOOL inGame;
extern WORD PortalX, PortalY;
extern int DebugLevel;
extern BOOL fDebug, fDebugToScreen;
extern char szLogFileName[];
extern LinkedList *mq;
extern BOOL fWindowed;
extern WORD CurrWeapon;
extern DWORD TickGlobal;
extern DWORD Tick1;
extern int CurrentSkill[];
extern int DeltaTeleport, DeltaTeleport2;


//////////////////////////////////////////////////////////////////////////////
// prototypes
//////////////////////////////////////////////////////////////////////////////
extern BOOL PRIVATE InstallPatches();
extern VOID PRIVATE RemovePatches();
extern VOID PRIVATE SetUpLogInfo(VOID);
extern BOOL PRIVATE OnCommandGo(char **, int);
extern BOOL PRIVATE OnCommandHelp(char **, int);
extern DWORD PRIVATE GetDistanceSquared(DWORD, DWORD, DWORD, DWORD);
extern VOID PRIVATE ExitGame(VOID);
extern VOID PRIVATE ChangeState(int);
extern VOID PRIVATE OverheadInfo(VOID);
extern BOOL PRIVATE InGame(VOID);

//////////////////////////////////////////////////////////////////////////////
// constants
//////////////////////////////////////////////////////////////////////////////
// BE CAREFUL HERE!!! Must update strings in mephbot.cpp as well.
enum {
	STATE_UNKNOWN = 0,
	STATE_TAKE_WAYPOINT,
	STATE_FIND_PORTAL,
	STATE_TELEPORT_TOWARD_PORTAL,
	STATE_TELEPORT_TO_PORTAL,
	STATE_TAKE_PORTAL,
	STATE_TELEPORT_TO_WIRT,
	STATE_CLICK_ON_WIRT,
	STATE_TAKE_LEG,
	STATE_WP_TOWN,
	STATE_FINISHED,
	MAXSTATES };

#define	DISTANCE_TOO_CLOSE			-1
#define	DISTANCE_IN_RANGE			0
#define	DISTANCE_TOO_FAR			1

//////////////////////////////////////////////////////////////////////////////
// macros
//////////////////////////////////////////////////////////////////////////////

#define	QUICKSPELLDELAY	(FastCastPctToTickDelay(FastCastPct))
#define	PLAYERX			(thisgame->player->PlayerPositionX)
#define	PLAYERY			(thisgame->player->PlayerPositionY)
#define	PLAYERID		(thisgame->player->PlayerID)
#define	ARRAY_SIZE(x)	(sizeof(x) / (sizeof(x[0])))

//////////////////////////////////////////////////////////////////////////////
// typedefs
//////////////////////////////////////////////////////////////////////////////

typedef struct Obj {
	//int type;		// npc/monster/fixed object
	DWORD id;
	WORD x, y;
} OBJ;

