//////////////////////////////////////////////////////////////////////
// ClientImplementation.cpp
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
#include "..\ClientCore.cpp"	  // Include the backend of the module


//////////////////////////////////////////////////////////////////////
// Global stuff.
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
THISGAMESTRUCT* thisgame;

BOOL PRIVATE OnGameCommandOn(char** argv, int argc);
BOOL PRIVATE OnGameCommandOff(char** argv, int argc);
BOOL start();

BOOL go=1;

BYTE fake[38]= {0x9d,0x06,0x26,0x10,0xFF,0xFF,0xFF,0xFF,0,0x01,0,0,0,0x11,0,0x82,0x01,0x64,0x04,0x01,0x80,0x26,0xc6,0x06,0x82,0xb1,0x80,0x15,0x97,0xd9,0x74,0x80,0x02,0,0x5b,0,0xfe,0x03};

//////////////////////////////////////////////////////////////////////
// CLIENTINFO
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
DWORD	ModuleVersion=MAKELONG(0,2);
char	ModuleAuthor[]="Gayak";
char	ModuleWebsite[]="http://gayak.50megs.com";
char	ModuleDescription[]="Creates a virtual 4-rows belt.";
char	ModuleEmail[]="170@guyau.qc.ca";

//////////////////////////////////////////////////////////////////////
// MODULECOMMANDSTRUCT ModuleCommands[]
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////

MODULECOMMANDSTRUCT ModuleCommands[]=
{
	{	// The 'help' command is implemented in ClientCore.cpp and 
		// should not need to be changed.
		"help",
		OnGameCommandHelp,
		"helpc0 List commands available in this module.\n"
		"<command> helpc0 Shows detailed help for <command> in this module."
	},
	{		
		"on",
		OnGameCommandOn,
		"onc0 Toggle xbelt on."
	},
	{		
		"off",
		OnGameCommandOff,
		"offc0 Toggle xbelt off."
	},

	{NULL}
};

//////////////////////////////////////////////////////////////////////
// OnClientStart
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnClientStart()
{
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// OnClientStop
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
BOOL EXPORT OnClientStop()
{
	return TRUE;
}

//////////////////////////////////////////////////////////////////////
// EVENTS
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////

BOOL start() {
	memcpy(&fake[9],&thisgame->player->PlayerID,4);
	return server->GameSendPacketToGame(fake, 38);
}


BOOL PRIVATE OnGameCommandOn(char** argv, int argc)
{
	server->GamePrintInfo("c3Toggled xbelt on.");
	go=1;
	return start();
}

BOOL PRIVATE OnGameCommandOff(char** argv, int argc)
{
	server->GamePrintInfo("c3Toggled xbelt off.");
	go=0;
	return 1;
}

//////////////////////////////////////////////////////////////////////
// OnGameJoin
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
VOID EXPORT OnGameJoin(THISGAMESTRUCT* athisgame)
{
	thisgame=athisgame;
	if (go) {start();}
	return;
}

//////////////////////////////////////////////////////////////////////
// OnGameLeave
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
VOID EXPORT OnGameLeave(THISGAMESTRUCT* athisgame)
{
	return;
}

//////////////////////////////////////////////////////////////////////
// OnGamePacketBeforeSent
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
DWORD EXPORT OnGamePacketBeforeSent(BYTE* aPacket, DWORD aLen)
{
	if ( ((aPacket[0]==0x1d && aPacket[5]==0x08) || (aPacket[0]==0x1c && aPacket[1]==0x08)) && go) {
		server->GamePrintInfo("c3You cannot take that virtual belt. If you want your old belt, you need to turn the module off and to rejoin the game.");
		return 0;
	}

	return aLen;
}

//////////////////////////////////////////////////////////////////////
// OnGamePacketBeforeReceived
// -------------------------------------------------------------------
//////////////////////////////////////////////////////////////////////
DWORD EXPORT OnGamePacketBeforeReceived(BYTE* aPacket, DWORD aLen)
{	
	if (aPacket[0]==0x77 && aPacket[1]==0x0c) {
		start();}
	return aLen;
}

// That's it... Wasn't that tough!!!
// Have fun. Gayak.