#define _WIN32
#define WIN32
#include <windows.h>
#include <windowsx.h>
#include <dsound.h>

#include "dsutil.h"
#include "midi.h"

long FAR PASCAL WindowProc(HWND hWnd,UINT message,WPARAM wParam,LPARAM lParam);

// *********************************************************************
// Variables globales
// *********************************************************************

HWND hwnd;                             // Handle de la ventana principal
HINSTANCE hInstance;
char ClassName[] = "ClaseDirectSound";     // Nombre de la clase de ventana
char Titulo[] = "Ejemplo DirectSound - por Iaki Ecenarro"; // Titulo de la ventana


// *********************************************************************
// Variables globales de DirectSound
// *********************************************************************

LPDIRECTSOUND  lpDirectSound = NULL;
DSCAPS         dscaps;
LPDIRECTSOUNDBUFFER DanceBuffer = NULL;
LPDIRECTSOUNDBUFFER ChaingunBuffer = NULL;


BOOLEAN        bActive = FALSE;
char ChaingunPlaying = 0;


// *********************************************************************
// Funciones de DirectSound
// *********************************************************************

BOOLEAN CleanupAndExit( char *err ); // prototipo de la funcion de salida
                                      // si hay errores


/* --------------------------------------------------------------------------
   BOOLEAN DirectSoundInit()
   -------------------------
   Todo lo necesario para iniciar DirectSound.
   Devuelve TRUE si no ha habido problemas
   ------------------------------------------------------------------------- */

BOOLEAN DirectSoundInit( HWND hwnd )
{
   HRESULT hr;

   // crear el objeto DirectSound
   hr = DirectSoundCreate(NULL, &lpDirectSound, NULL);
   if( hr != DS_OK ) return CleanupAndExit("Error en DirectSoundCreate!");

   // establecer el nivel de cooperacion
	hr = lpDirectSound->SetCooperativeLevel(hwnd, DSSCL_NORMAL);
	if( hr != DS_OK) return CleanupAndExit("Error en SetCooperativeLevel!");

   // obtener los datos del sistema
   dscaps.dwSize = sizeof( DSCAPS );
   lpDirectSound->GetCaps( &dscaps );

   ChaingunBuffer = DSLoadSoundBuffer( lpDirectSound, "CHAINGUN" );
   if( ChaingunBuffer )
   {
      DanceBuffer = DSLoadSoundBuffer( lpDirectSound, "HURT" );
      if( DanceBuffer ) bActive = TRUE;
      else ChaingunBuffer->Release();
   }
   if( bActive )
   {
      ChaingunBuffer->SetVolume( -1000 );
      PlayMidi("duke3d.mid", hwnd);
   }
   else
      return CleanupAndExit( "Error cargando los sonidos" );
   return TRUE;
}

/* --------------------------------------------------------------------------
   void DirectSoundEnd( void )
   ---------------------------
   Destruir el objeto directsound y salir
   ------------------------------------------------------------------------- */

void DirectSoundEnd( void )
{
   bActive = FALSE;
   if( DanceBuffer ) DanceBuffer->Release();
   if( ChaingunBuffer ) ChaingunBuffer->Release();
	if( lpDirectSound ) lpDirectSound->Release();
}

/* --------------------------------------------------------------------------
   BOOLEAN CleanUpAndExit()
   ------------------------
   Llamada por DirectDrawInit() cuando ha ocurrido algun error.
   Destruye todos los objetos directsound, y muestra un mensaje
   de error al usuario.
   ------------------------------------------------------------------------- */

BOOLEAN CleanupAndExit( char *err )
{
   DirectSoundEnd();
   MessageBox( hwnd, err, "Direct-X Error", MB_OK );
   return FALSE;
}


// *********************************************************************

long FAR PASCAL WindowProc( HWND hwnd, UINT message,
                            WPARAM wParam, LPARAM lParam )
{
   PAINTSTRUCT ps;
   RECT rc;
   char *Str1 = "Utiliza los botones del ratn para oir los sonidos:";
   char *Str2 = "Botn izquierdo: Duke Nukem te invita a bailar.";
   char *Str3 = "Botn derecho: disparar / dejar de disparar";

   switch (message)
   {
      case WM_PAINT:
          BeginPaint(hwnd, &ps);
          GetClientRect(hwnd, &rc);
          SetTextAlign( ps.hdc, TA_CENTER | TA_TOP );
          TextOut( ps.hdc, rc.right/2, rc.bottom/2-30, Str1, strlen(Str1));
          TextOut( ps.hdc, rc.right/2, rc.bottom/2, Str2, strlen(Str2));
          TextOut( ps.hdc, rc.right/2, rc.bottom/2+30, Str3, strlen(Str3));
          EndPaint(hwnd, &ps);
          break;

      case MCI_NOTIFY:
      {
         if (wParam == MCI_NOTIFY_SUCCESSFUL)
         {
             ReplayMidi( hwnd );
         }
      }
      break;

      case WM_LBUTTONUP:
         if( bActive )
         {
            DanceBuffer->Stop();
            DanceBuffer->Play(0,0,0);
         }
         break;

      case WM_RBUTTONUP:
         if( bActive )
         {
            if( ChaingunPlaying )
            {
               ChaingunBuffer->Stop();
               ChaingunPlaying = 0;
            }
            else
            {
               ChaingunBuffer->Play(0,0,DSBPLAY_LOOPING);
               ChaingunPlaying++;
            }
         }
         break;

      case WM_KEYDOWN:
         switch( wParam )
         {
            case VK_ESCAPE: SendMessage(hwnd, WM_DESTROY,0,0); break;
         }
         break;

   	case WM_DESTROY:
         StopMidi();
         DirectSoundEnd();
         PostQuitMessage( 0 );
         break;

   	default: return DefWindowProc(hwnd, message, wParam, lParam);
	}
   return 0;
}

// --------------------------------------------------------------------------

#pragma 	argsused
int PASCAL WinMain( HINSTANCE xhInstance, HINSTANCE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow )
{
   MSG msg;
   WNDCLASS wc;

   if (hPrevInstance) return -1; // Retorna si hay instancia previa

   hInstance = xhInstance;          // set global var

   // Definir la clase de ventana
   wc.style = CS_HREDRAW | CS_VREDRAW;
   wc.lpfnWndProc = WindowProc;           //Funcion que maneja los mensajes
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   wc.hInstance = hInstance;
   wc.hIcon = LoadIcon( hInstance, IDI_APPLICATION );
   wc.hCursor = LoadCursor( NULL, IDC_ARROW );
   wc.hbrBackground = GetStockObject( WHITE_BRUSH );
   wc.lpszMenuName = NULL;
   wc.lpszClassName = ClassName;

   RegisterClass( &wc );
   hwnd = CreateWindowEx(
		  0,                               // Estilo Extra ventana
		  ClassName,                       // Nombre de la clase
		  Titulo,                          // Titulo ventana
		  WS_OVERLAPPEDWINDOW,             // Estilo de la ventana
		  50,                              // Posicion X
		  50,                              // Posicion Y
		  400,                             // Ancho
		  200,                             // Alto
		  NULL,                            // Handle ventana padre
		  NULL,                            // Handle del menu
		  hInstance,                       // Handle de la aplicacion
		  NULL );				              // lPParam

   if( !hwnd ) return FALSE;
   ShowWindow( hwnd, nCmdShow );
   UpdateWindow( hwnd );

   // Hasta aqui todo lo habitual de un programa de Windows.

   // Inicializar DirectSound
   bActive = FALSE;
   if( ! DirectSoundInit( hwnd ) )
   {
      // Si ha habido algun error, nos vamos.
      DestroyWindow( hwnd );
      return FALSE;
   }

   // Bucle de mensajes
   while( 1 )
   {
      if( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) )
      {
         if( !GetMessage( &msg, NULL, 0, 0 ) )
            return msg.wParam;
         TranslateMessage(&msg);
         DispatchMessage(&msg);
      }
      else
      {
         WaitMessage();
      }
   }
}

