; asmfile for graphics.pas
; assemble with : tasm


; Yeah I know it - not many comments --- Zaifrun
; FastDraw is a general mode 13h library - it is not made specifically
; for Netmaze. FastDraw is made by Zaifrun & Gnome ( a good friend of mine)

dosseg
.model tpascal

.data
.code
.386

locals @@

public getrgb
public setrgb
public cls
public movemem
public setvga256

public settext
public waittrace
public drawbox
public drawpix
public drawcircle

public drawrectangle
public getpix
public copymem
public setpal
public getpal

public drawline
public detectvga
public movemem_notblack
public drawpoly
public drawcolorcircle          ; used only in netmaze 3.7




drawpoly proc far x1:word,y1:word,x2:word,y2:word,x3:word,y3:word,x4:word,y4:word,color:byte,where:word
local ycount:word,bigx:word,litx:word,ymin:word,ymax:word,mul1:word,mul2:word,mul3:word,mul4,div1,div2,div3,div4:word = stacksize
  sub  sp,stacksize
  cld
  mov  ax,[where]
  mov  es,ax
  ; find ymin og ymax
  mov  cx,-10000
  mov  bx,10000
  cmp  [y1],bx
  jg   vid1
  mov  bx,[y1]
vid1:
  cmp  [y1],cx
  jl   vid2
  mov  cx,[y1]
vid2:
  cmp  [y2],bx
  jg   vid3
  mov  bx,[y2]
vid3:
  cmp  [y2],cx
  jl   vid4
  mov  cx,[y2]
vid4:
  cmp  [y3],bx
  jg   vid5
  mov  bx,[y3]
vid5:
  cmp  [y3],cx
  jl   vid6
  mov  cx,[y3]
vid6:
  cmp  [y4],bx
  jg   vid7
  mov  bx,[y4]
vid7:
  cmp  [y4],cx
  jl   vid8
  mov  cx,[y4]
vid8:
  mov  [ymin],bx
  mov  [ymax],cx
  mov  ax,[x1]
  sub  ax,[x4]
  mov  [mul1],ax
  mov  ax,[x2]
  sub  ax,[x1]
  mov  [mul2],ax
  mov  ax,[x3]
  sub  ax,[x2]
  mov  [mul3],ax
  mov  ax,[x4]
  sub  ax,[x3]
  mov  [mul4],ax
; mul1:=x1-x4 div1:=y1-y4
; mul2:=x2-x1 div2:=y2-y1
; mul3:=x3-x2 div3:=y3-y2
; mul4:=x4-x3 div4:=y4-y3
  mov  ax,[y1]
  sub  ax,[y4]
  mov  [div1],ax
  mov  ax,[y2]
  sub  ax,[y1]
  mov  [div2],ax
  mov  ax,[y3]
  sub  ax,[y2]
  mov  [div3],ax
  mov  ax,[y4]
  sub  ax,[y3]
  mov  [div4],ax
  cmp  [ymin],0
  jge  vid9
  mov  [ymin],0
vid9:
  cmp  [ymax],199
  jle  vid10
  mov  [ymax],199
vid10:
  mov  si,[ymin]
mainloop:
 mov  [litx],320
 mov  [bigx],-1
 ;       if (y4>=y) or (y1>=y) then
 ;       if (y4<=y) or (y1<=y) then
 ;         if not(y4=y1) then
 ;           begin
 ;             x:=(y-y4)*mul1 div div1+x4;
 ;             if x<litx then litx:=x;
 ;             if x>bigx then bigx:=x;
 ;           end;
 cmp  [y4],si
 jge  start1
 cmp  [y1],si
 jge  start1
 jmp  end1
 start1:
 cmp  [y4],si
 jle  start2
 cmp  [y1],si
 jle  start2
 jmp  end1
 start2:
 mov  ax,[y1]
 cmp  [y4],ax
 je   end1
 mov  ax,si
 sub  ax,[y4]
 imul [mul1]
 idiv [div1]
 add  ax,[x4]
 cmp  ax,[litx]
 jge  new1
 mov  [litx],ax
 new1:
 cmp  ax,[bigx]
 jle  end1
 mov  [bigx],ax
 end1:

 cmp  [y1],si
 jge  start3
 cmp  [y2],si
 jge  start3
 jmp  end2
 start3:
 cmp  [y1],si
 jle  start4
 cmp  [y2],si
 jle  start4
 jmp  end2
 start4:
 mov  ax,[y2]
 cmp  [y1],ax
 je   end2
 mov  ax,si
 sub  ax,[y1]
 imul [mul2]
 idiv [div2]
 add  ax,[x1]
 cmp  ax,[litx]
 jge  new2
 mov  [litx],ax
 new2:
 cmp  ax,[bigx]
 jle  end2
 mov  [bigx],ax
 end2:

 cmp  [y2],si
 jge  start5
 cmp  [y3],si
 jge  start5
 jmp  end3
 start5:
 cmp  [y2],si
 jle  start6
 cmp  [y3],si
 jle  start6
 jmp  end3
 start6:
 mov  ax,[y3]
 cmp  [y2],ax
 je   end3
 mov  ax,si
 sub  ax,[y2]
 imul [mul3]
 idiv [div3]
 add  ax,[x2]
 cmp  ax,[litx]
 jge  new3
 mov  [litx],ax
 new3:
 cmp  ax,[bigx]
 jle  end3
 mov  [bigx],ax
 end3:

 cmp  [y3],si
 jge  start7
 cmp  [y4],si
 jge  start7
 jmp  end4
 start7:
 cmp  [y3],si
 jle  start8
 cmp  [y4],si
 jle  start8
 jmp  end4
 start8:
 mov  ax,[y4]
 cmp  [y3],ax
 je   end4
 mov  ax,si
 sub  ax,[y3]
 imul [mul4]
 idiv [div4]
 add  ax,[x3]
 cmp  ax,[litx]
 jge  new4
 mov  [litx],ax
 new4:
 cmp  ax,[bigx]
 jle  end4
 mov  [bigx],ax
 end4:
 cmp  [bigx],319
 jle  t1
 mov  [bigx],319
t1:
 cmp  [litx],0
 jge  t2
 mov  [litx],0
t2:
 mov  ax,[bigx]
 cmp  [litx],ax
 jg   out1
 cmp  ax,0
 jl   out1
 mov  cx,[bigx]
 sub  cx,[litx]
 inc  cx
 mov  di,si
 mov  dx,di
 shl  di,8
 shl  dx,6
 add  di,dx
 add  di,[litx]
 mov  al,[color]
 mov  ah,al
 mov  dx,cx
 and  dx,00000001b
 or   dx,0
 je   out2
 stosb
 dec  cx
out2:
 shr  cx,1
 rep  stosw
out1:
  inc  si
  cmp  si,[ymax]
  jle  mainloop
  add  sp,stacksize
  ret
drawpoly endp



movemem_notblack proc far source:word,dest:word
  push ds
  mov  ds,[source]
  mov  es,[dest]
  xor  si,si
 @again:
  mov  al,ds:[si]
  or   al,0
  je @notcopy
  mov  es:[si],al
 @notcopy:
  inc  si
  cmp  si,64000d
  jbe  @again
  pop  ds
  ret
movemem_notblack endp


DetectVGA proc far
  mov   ax,1A00h
  int   10h
  cmp   al,1Ah
  je    @vga
  mov   al,0
  jmp   @exit
@vga:
  mov   al,1
@exit:
  ret
detectvga endp


setpal proc far buffer : dword
  push ds
  lds  si,buffer
  cld
  mov  cx,768d
  mov  dx,3c8h
  xor  al,al
  out  dx,al
  inc  dx
  rep  outsb
  pop  ds
  ret
setpal endp

getpal proc far buffer : dword
  les  di,buffer
  mov  cx,768d
  cld
  xor  al,al
  mov  dx,3c7h
  out  dx,al
  mov  dx,3c9h
  rep  insb
  ret
getpal endp

; copies a rectangular area of graphics memory
copymem proc far source :word, dest:word,x :word,y:byte,x1:word,y1:byte,newx:word,newy:byte,black :byte
  push ds
  push es
  mov  ax,[x]
  mov  bh,[y]
  mov  bl,[y1]
  mov  dx,[x1]
mov ds,[source]
mov es,[dest]
cmp ax,dx
jbe @vid4
mov cx,ax
mov ax,dx
mov dx,cx
@vid4:
 cmp bh,bl
 jbe @vid2
 mov ch,bh
 mov bh,bl
 mov bl,ch
@vid2:

xor cx,cx
mov cl,bh
shl cx,6
mov si,cx
xor cx,cx
mov cl,bh
shl cx,8
add si,cx
add si,ax

xor cx,cx
mov cl,[newy]
shl cx,6
xor di,di
add di,cx
xor cx,cx
mov cl,[newy]
shl cx,8
add di,cx
add di,[newx]
mov cs:[county],bh
mov cs:[countx],ax
@yloop:
 @xloop:
  mov cl,ds:[si]
 cmp [black],0
 jne @true
  or  cl,0
  je  @vid8
  mov es:[di],cl
@true: mov es:[di],cl
 @vid8:
  inc si
  inc di
  cmp cs:[countx],dx
  inc cs:[countx]
 jbe @xloop
mov cx,319d
sub cx,dx
add cx,ax
add si,cx
add di,cx
mov cs:[countx],ax
cmp cs:[county],bl
inc cs:[county]
jbe @yloop
pop es
pop ds
ret
 countx dw ?
 county db ?
copymem endp

drawrectangle proc far x1 : word,y1 : byte,x2 : word,y2:byte,color:byte,where : word
  mov  dx,[where]
  mov  es,dx
  mov  ax,[x1]
  mov  bx,[x2]
  mov  cl,[y1]
  mov  ch,[y2]
  cmp  ax,bx
  jbe  @vid
  xchg ax,bx
@vid:
  cmp  cl,ch
  jbe  @vid1
  xchg cl,ch
@vid1:
  xor  dl,dl
  mov  dh,cl
  mov  si,dx
  xor  dh,dh
  mov  dl,cl
  shl  dx,6
  add  si,dx
  add  si,ax
  ;si= offset 1
  mov  di,ax
  dec  di
  mov  dh,[color]
  push si
@loop111:
  mov  es:[si],dh
  inc  di
  inc  si
  cmp  di,bx
  je   @exitloop1
  jmp  @loop111
@exitloop1:
  pop  si
  mov  dl,cl
  dec  dl
@loop2:
  mov  es:[si],dh
  add  si,320
  inc  dl
  cmp  dl,ch
  je   @exitloop2
  jmp  @loop2
@exitloop2:
  xor  dx,dx
  mov  dl,ch
  mov  dh,dl
  xor  dl,dl
  mov  si,dx
  xor  dx,dx
  mov  dl,ch
  shl  dx,6
  add  si,dx
  add  si,bx
  ;si = offset 2
  mov  di,bx
  mov  dh,[color]
  inc  di
  push si
@loop3:
  mov  es:[si],dh
  dec  si
  dec  di
  cmp  di,ax
  je   @exitloop3
  jmp  @loop3
@exitloop3:
  pop  si
  mov  dl,ch
  inc  dl
@loop4:
  mov  es:[si],dh
  sub  si,320
  dec  dl
  cmp  dl,cl
  je   @exitloop4
  jmp  @loop4
@exitloop4:
  ret
drawrectangle endp

drawcircle proc far centerx : word, centery: byte, radius : byte, color : byte,screen : word
  MOV AX,[Screen]
  MOV ES,AX
  XOR AH,AH
  MOV AL,[CenterY]
  XOR BL,BL
  MOV BH,AL
  SHL AX,6
  ADD BX,AX
  ADD BX,[CenterX]      ;BX = offset(320*centery+centerx)
  XOR DH,DH
  MOV DL,[Radius]       ;DL = y(Radius)
  MOV CX,DX
  XOR AL,AL
  MOV AH,CL
  SHL CX,1
  MOV DI,CX
  NEG DI
  ADD DI,3              ;DI = d(3-Radius*2)
  SHL CX,5
  ADD AX,CX
  MOV SI,AX             ;SI = 320y(320*Radius)
  MOV AX,-1             ;AX = x(-1)
  MOV CX,-320           ;AX = 320x(-320)
  MOV DH,[Color]        ;DH = Color(Color)

@IGEN:
  INC AX              ;  {x:=x+1}
  ADD CX,320          ;  {320x:=320x+320}
  PUSH BX
  ADD BX,AX
  ADD BX,SI
  MOV ES:[BX],DH       ; {screenaddr(offset+x+320y)=color}
  POP BX
  PUSH BX
  ADD BX,AX
  SUB BX,SI
  MOV ES:[BX],DH        ;{screenaddr(offset+x-320y)=color}
  POP BX
  PUSH BX
  SUB BX,AX
  ADD BX,SI
  MOV ES:[BX],DH       ; {screenaddr(offset-x+320y)=color}
  POP BX
  PUSH BX
  SUB BX,AX
  SUB BX,SI
  MOV ES:[BX],DH       ; {screenaddr(offset-x-320y)=color}
  POP BX
  PUSH BX
  ADD BL,DL
  ADC BH,0
  ADD BX,CX
  MOV ES:[BX],DH       ; {screenaddr(offset+y+320x)=color}
  POP BX
  PUSH BX
  ADD BL,DL
  ADC BH,0
  SUB BX,CX
  MOV ES:[BX],DH       ; {screenaddr(offset+y-320x)=color}
  POP BX
  PUSH BX
  SUB BL,DL
  SBB BH,0
  ADD BX,CX
  MOV ES:[BX],DH       ; {screenaddr(offset-y+320x)=color}
  POP BX
  PUSH BX
  SUB BL,DL
  SBB BH,0
  SUB BX,CX
  MOV ES:[BX],DH       ; {screenaddr(offset-y-320x)=color}
  POP BX
  CMP DI,0
  JGE @CHANGEY
    ADD DI,6
    ADD DI,AX
    ADD DI,AX
    ADD DI,AX
    ADD DI,AX
    CMP CX,SI
    JAE @END
  JMP @IGEN
@CHANGEY:
    ADD DI,10
    PUSH AX
    SUB AL,DL
    SBB AH,0
    ADD DI,AX
    ADD DI,AX
    ADD DI,AX
    ADD DI,AX
    POP AX
    DEC DL
    SUB SI,320
    CMP CX,SI
    JAE @END
  JMP @IGEN
@END:
   ret
drawcircle endp


drawcolorcircle proc far\
centerx:word,centery:byte,radius:byte,color1:byte,color2:byte,screen : word
; parameters
  MOV AX,[Screen]
  MOV ES,AX
  XOR AH,AH
  MOV AL,[CenterY]
  XOR BL,BL
  MOV BH,AL
  SHL AX,6
  ADD BX,AX
  ADD BX,[CenterX]      ;{BX = offset(320*centery+centerx) }
  XOR DH,DH
  MOV DL,[Radius]       ;{DL = y(Radius)}
  MOV CX,DX
  XOR AL,AL
  MOV AH,CL
  SHL CX,1
  MOV DI,CX
  NEG DI
  ADD DI,3              ;{DI = d(3-Radius*2)}
  SHL CX,5
  ADD AX,CX
  MOV SI,AX             ;{SI = 320y(320*Radius)}
  MOV AX,-1             ;{AX = x(-1)}
  MOV CX,-320           ;{AX = 320x(-320)}
@@IGEN:
  INC AX                ;  {x:=x+1}
  ADD CX,320            ;{320x:=320x+320}
  PUSH BX
  ADD BX,AX
  ADD BX,SI
  mov dh,[color1]
  MOV ES:[BX],DH        ;{5:screenaddr(offset+x+320y)=color}
  POP BX
  PUSH BX
  ADD BX,AX
  SUB BX,SI
  mov dh,[color2]
  MOV ES:[BX],DH        ;{2:screenaddr(offset+x-320y)=color}
  POP BX
  PUSH BX
  SUB BX,AX
  ADD BX,SI
  push cx
  push dx
  mov  dx,[centerx]
  movzx cx,[radius]
  sub dx,cx
  add dx,ax
  inc dx
  cmp dx,0
  jl  @@nope1
  mov dh,[color2]
  MOV ES:[BX],DH        ;{6:screenaddr(offset-x+320y)=color}
  @@nope1:
  pop dx
  pop cx

  POP BX
  PUSH BX
  SUB BX,AX
  SUB BX,SI
  mov dh,[color1]
  MOV ES:[BX],DH       ; {1:screenaddr(offset-x-320y)=color}
  POP BX
  PUSH BX
  ADD BL,DL
  ADC BH,0
  ADD BX,CX
  mov dh,[color2]
  MOV ES:[BX],DH       ; {4:screenaddr(offset+y+320x)=color}
  POP BX
  PUSH BX
  ADD BL,DL
  ADC BH,0
  SUB BX,CX
  mov dh,[color1]
  MOV ES:[BX],DH       ; {3:screenaddr(offset+y-320x)=color}
  POP BX
  PUSH BX
  SUB BL,DL
  SBB BH,0
  ADD BX,CX
  push cx
  push dx
  mov  dx,[centerx]
  movzx cx,[radius]
  sub dx,cx
  add dx,ax
  sub dx,0
  cmp dx,0
  jl  @@nope2
  mov dh,[color1]
  MOV ES:[BX],DH       ; {7:screenaddr(offset-y+320x)=color}
  @@nope2:
  pop dx
  pop cx
  POP BX
  PUSH BX
  SUB BL,DL
  SBB BH,0
  SUB BX,CX
  mov dh,[color2]
  MOV ES:[BX],DH       ; {8:screenaddr(offset-y-320x)=color}
  POP BX
  CMP DI,0
  JGE @@CHANGEY
    ADD DI,6
    ADD DI,AX
    ADD DI,AX
    ADD DI,AX
    ADD DI,AX
    CMP CX,SI
    JAE @@END
  JMP @@IGEN
@@CHANGEY:
    ADD DI,10
    PUSH AX
    SUB AL,DL
    SBB AH,0
    ADD DI,AX
    ADD DI,AX
    ADD DI,AX
    ADD DI,AX
    POP AX
    DEC DL
    SUB SI,320
    CMP CX,SI
    JAE @@END
  JMP @@IGEN
@@END:
  RET
drawcolorcircle endp




getpix proc far x : word, y : word,where : word
  mov  ax,[y]
  mov  bx,ax
  rol  ax,8
  shl  bx,6
  add  bx,ax
  add  bx,[x]
  mov  ax,[where]
  mov  es,ax
  mov  al,es:[bx]
  ret
getpix endp


drawbox proc far x:word,y:byte,x1:word,y1:byte,color:byte,where : word
  cld
  mov ax,[where]
  mov es,ax
  mov ax,[x]
  mov bx,[x1]
  mov cl,[y]
  mov ch,[y1]
  cmp ax,bx
  jbe @next1
  xchg ax,bx
@next1:
   cmp cl,ch
   jbe @next2
   xchg cl,ch
@next2:
   xor dx,dx
   mov dl,cl
   mov dh,dl
   xor dl,dl
   mov si,dx
   xor dh,dh
   mov dl,cl
   shl dx,6
   add si,dx
   add si,ax
   ;si = offset
   dec ax
   mov di,bx
   sub di,ax
   xchg si,di
   mov  dx,cx
   xor  ax,ax
   mov  al,[color]
   mov  bx,di
@loopit1:
  mov  cx,si
  rep  stosb
  add  bx,320d
  mov  di,bx
  inc dl
  cmp dl,dh
  ja @exitloo1
  jmp @loopit1
@exitloo1:
  ret
drawbox endp

waittrace proc far
  mov dx,3DAh
@l1:
  in  al,dx
  and al,08h
  jnz @l1
@l2:
  in al,dx
  and al,08h
  jz  @l2
  ret
waittrace endp

setvga256 proc far
  mov ax,13h
  int 10h
  ret
setvga256 endp


settext proc far
  mov ax,3h
  int 10h
  ret
settext endp


cls proc far  col : byte, where : word
  mov   es,[where]
  mov   cx, 32000
  xor   di,di
  mov   al,[col]
  mov   ah,al
  rep   stosw
  ret
cls endp


MoveMem Proc far Source : word,Dest : word
    push    ds
    mov     ax, [dest]
    mov     es, ax
    mov     ax, [source]
    mov     ds, ax
    xor     si,si
    xor     di,di
    mov     cx, 16000
    rep     movsd
    pop     ds
    ret
MoveMem endp


Drawpix proc far x : word, y  : word, col : byte, where : word
  mov  ax,[y]
  mov  di,ax
  rol  ax,8
  shl  di,6
  add  di,ax
  add  di,[x]
  mov  ax,[where]
  mov  es,ax
  mov  al,[color]
  mov  es:[di],al
  ret
drawpix endp

getrgb proc far color : byte, red : dword, green : dword,blue : dword
  mov    dx,3c7h
  mov    al,[color]
  out    dx,al
  mov    dx,3c9h
  in     al,dx
  les    si,red
  mov    es:[si],al
  in     al,dx
  les    si,green
  mov    es:[si],al
  in     al,dx
  les    si,blue
  mov    es:[si],al
ret  ; 12 bytes
getrgb endp

setrgb proc far color : byte, red : byte, green : byte,blue : byte
    mov         dx,3c8h
    mov         al,[color]
    out         dx,al
    mov         dx,3c9h
    mov         al,[red]
    out         dx,al
    mov         al,[green]
    out         dx,al
    mov         al,[blue]
    out         dx,al
    ret
setrgb endp

DrawLine PROC FAR X1:WORD,Y1:WORD,X2:WORD,Y2:WORD,Color:BYTE,Screen:WORD
  MOV AX,[X1]           ;IF ONLY ONE PIXEL, DRAW IT
  CMP AX,[X2]
  JNE @GO
  CMP AX,[Y1]
  JNE @GO
  CMP AX,[Y2]
  JE @DOT
@GO:
  MOV AX,[SCREEN]
  MOV ES,AX             ;ES IS SET TO (VGAMEM)
  MOV SI,[X2]
  SUB SI,[X1]
  JNS @DELTAX
  NEG SI
@DELTAX:                ;DELTAX IS SI
  MOV DI,[Y2]
  SUB DI,[Y1]
  JNS @DELTAY
  NEG DI
@DELTAY:                ;DELTAY IS DI
  CMP SI,DI
  JL  @DELTAYISIT
;DELTAXISIT:            ;DELTAX > DELTAY
  MOV CX,SI             ;CX IS COUNTER
  MOV DX,[X1]
  CMP DX,[X2]
  JL  @X2ISIT
;X1ISIT:                ;X1>X2
  MOV AX,-1
  MOV DX,[Y1]
  CMP DX,[Y2]
  JL  @Y2ISIT
;Y1ISIT:                ;X1>X2 & Y1>Y2
  MOV CS:[FS1],-321
  JMP @LINEPROC
@Y2ISIT:                ;X1>X2 & Y2>Y1
  MOV CS:[FS1],319
  JMP @LINEPROC
@X2ISIT:                ;X2>X1
  MOV AX,1
  MOV DX,[Y1]
  CMP DX,[Y2]
  JL  @Y2ISITA
;Y1ISITA:               ;X2>X1 & Y1>Y2
  MOV CS:[FS1],-319
  JMP @LINEPROC
@Y2ISITA:               ;X2>Y1 & Y2>Y1
  MOV CS:[FS1],321
  JMP @LINEPROC
@DELTAYISIT:            ;DELTAY > DELTAX
  MOV CX,DI
  XCHG SI,DI
  MOV DX,[Y1]
  CMP DX,[Y2]
  JL  @Y2ISIT2
;Y1ISIT2:               ;Y1>Y2
  MOV AX,-320
  MOV DX,[X1]
  CMP DX,[X2]
  JL  @X2ISIT2
;X1ISIT2:               ;Y1>Y2 & X1>X2
  MOV CS:[FS1],-321
  JMP @LINEPROC
@X2ISIT2:
  MOV CS:[FS1],-319     ;Y1>Y2 & X2>X1
  JMP @LINEPROC
@Y2ISIT2:               ;Y2>Y1
  MOV AX,320
  MOV DX,[X1]
  CMP DX,[X2]
  JL  @X2ISIT2A
;X1ISIT2A:              ;Y2>Y1 & X1>X2
  MOV CS:[FS1],319
  JMP @LINEPROC
@X2ISIT2A:              ;Y2>Y1 & X2>X1
  MOV CS:[FS1],321
@LINEPROC:
  INC CX
  PUSH DI
  MOV BX,[Y1]
  MOV DI,BX
  SHL BX,8
  SHL DI,6
  ADD BX,DI
  ADD BX,[X1]           ;BX is START
  POP DI
  SHL DI,1
  MOV DX,DI
  SUB DI,SI
  SHL SI,1
  NEG SI
  ADD SI,DX
@IGEN2:
  PUSH AX
  MOV AL,[Color]
  MOV ES:[BX],AL
  POP AX
  CMP DI,0
  JGE @GE
;L
  ADD DI,DX
  ADD BX,AX
  LOOP @IGEN2
  JMP @END2
@GE:
  ADD DI,SI
  ADD BX,CS:[FS1]
  LOOP @IGEN2
@END2:
  RET
@DOT:
  PUSH [X1]
  PUSH [X1]
  PUSH Word Ptr [Color]
  PUSH [Screen]
  CALL DrawPix
  RET
FS1 DW ?
DrawLine ENDP

end
