Unit NetSound;
{ A sound unit for NetMaze 3.7}

Interface

type
  FX = (laser,shot3,missile,coin,owndeath,getready,otherdeath,hugeshield);

const
  MaxChannels = 5{+8};{8 players max}
  MaxSamples  = 8;
  MaxDrivers  = 2;             { sound cards supported by NetMaze }
  BaseOfs     = 194848;
  soundsize   = 216694;
  soundofs : array[1..maxdrivers] of word =   (0,11416{,21846,34124});

  {the file 'code.drv' contains the soundrivers for sb16,sb1,gus,pas}

var
  SoundOk : Boolean;  {is true if sound is on AND sound hardware is ok}
  NumberOfChannels:byte;
  CurrentChannel:Byte;
  SoundVolume:byte;
  guf:byte;



Procedure InitSound;
Procedure StopSound;
Procedure PlayFX(sample:FX;chan:byte);

Implementation

uses
  MSE_TP,netfame,util;

var
  ModHeader:GdmHeader;

{$F+}
{$L detectfm.obj}
function detectfm:boolean; external;
{$F-}

Procedure PlayFX(sample:FX;chan:byte);
var
  ch:byte;
begin
  if soundok and (soundvolume>0) then
  begin
      {[TP] Procedure PlaySample(Channel 1-32, Sample 0-255: Byte; Rate :
               Word; Vol, Pan : Byte);}
    if chan=0 then
    begin
    ch:=currentchannel;
    case sample of
      laser..missile: ch:=1;
    end;
    mse_tp.PlaySample(ch,ord(sample),22050,soundvolume,8);
    if ch<>1 then inc(CurrentChannel);
    if CurrentChannel>maxchannels then CurrentChannel:=2;
    end else mse_tp.PlaySample(chan,ord(sample),22050,soundvolume,8);
  end;
end;

Procedure InitSound;
var
  base:word;
  irq,dma:byte;
  soundcard:string;
  F     : File;
  Flags : Word;
  J     : Byte;
  count:byte;
  fileofs:longint;
  port,iq:word;
begin
  if detectfm then soundok:=true else soundok:=false;

  if (par1<>'nosound') and (par2<>'nosound') and (par3<>'nosound')
     and isfile('soundfx.dat') and soundok
  then begin
  count:=0;
  fileofs:=0;
  stopbanner;
  soundcard:='soundfx.dat';
  repeat
  inc(count);
  base:=$FFFF;
  irq:=$FF;
  dma:=$FF;
  if count<=maxdrivers then fileofs:=baseofs+soundofs[count]
  else fileofs:=baseofs;

  if count>1 then freemse;
  if count<=maxdrivers then
  guf:=LoadMSE(soundcard,fileofs,45,4096,Base,IRQ,DMA);
  until (count>maxdrivers) or (guf=0);
  if count<=maxdrivers then
  begin
   If EmsExist Then Flags := 1  Else Flags := 0;
  Assign(F,'soundfx.dat');
  Reset(F,1);
  if filesize(f)<>soundsize then soundok:=false;
  if soundok then
  begin
    if LoadGDM(F, 0, Flags, ModHeader)<>0 then soundok:=false;
  end;
  Close(f);
  NumberOfChannels := 0;
  For J := 1 to 32 do
  begin
    If ModHeader.PanMap[J] <> $FF
    Then NumberOfChannels := NumberOfChannels + 1;
  end;
  if soundok then StartOutput(NumberOfChannels+MaxChannels,0);
  end else soundok:=false;
  end else soundok:=false; {nosound commandline option}
  soundvolume:=64;
end;

Procedure StopSound;
begin
  if soundok then
  begin
    StopOutput;
    UnLoadModule;
    StopBanner;
    FreeMse;
  end;
end;




begin
  SoundOk:=False;
  CurrentChannel:=2;
end.
