; Ŀ
;                                                                          
;   Programname    :  DetectFm.ASM                                         
;   Titel	        :  Detect and Identify Yamaha OPL2 and OPL3 Soundchips  
;   Authors        :  SUBMiSSiVE                                           
;   Organisation   :  The $eeN                                             
;   Version/Date   :  1.0 / 24.10.1994                                     
;   Version/Date   :  1.1 / 07.01.1997 Now a .COM-File                     
;   Language       :  Turbo Assembler 3.2 / TLink 5.1                      
;                                                                          
; 



.Model tpascal ; Use Pascal calling-conventions
.286
jumps
smart
ideal

public detectfm

CodeSeg
proc detectfm far
         push 388h
         call DetectAdlib
         test al, 1
         ret
         jz m1
m1:
         push 228h
         call DetectAdlib
         test al, 1
         jz m2
         ret
m2:
         push 248h
         call DetectAdlib
         test al, 1
         ret
endp

Proc WritePort near Portnummer:Byte, wert:Byte, Portadr:Word
;
; Write Byte in WERT into OPL-Port Portnummer at Adress PortAdr
        push 	dx ax cx
        mov 	dx, [PortAdr]
        mov 	al, [Portnummer]
        out 	dx, al

        mov cx, 7
warte1:
        in 	al, dx			; Wait here
        dec cx
        jnz warte1

        mov     al, [wert]
        mov 	dx, [PortAdr]
        inc     dx
        out 	dx, al
        mov 	dx, [PortAdr]
        mov     cx, 36
warte2:
        in 	al, dx			; Wait here
        dec cx
        jnz warte2
        pop 	cx ax dx
        ret
EndP WritePort

Proc DetectAdlib near portadr:word
;
; Tryes to detect a OPL-Chip at the given adress. Returns 1 in AL if
; successful, 0 otherwise

local    detect1:byte, detect2:byte

         Push 4             ; Reset both timers
         Push 60h
         push [portadr]
         call WritePort

         Push 4             ; Enable Interrupts
         Push 80h
         push [portadr]
         call Writeport

         mov dx, [portadr]   ; Read Statusport
         in al, dx
         mov [detect1], al

         push 2               ; Set Timer 1
         push 0ffh
         push [portadr]
         call writeport

         push 4               ; Start Timer 1
         push 021h
         push [portadr]
         call writeport


         mov cx, 130          ; Wait
warteschleife:
         in al, dx
         dec cx
         jnz warteschleife
         mov [detect2], al

         Push 4             ; Reset both timers
         Push 60h
         push [portadr]
         call WritePort

         Push 4             ; Enable Interrupts
         Push 80h
         push [portadr]
         call Writeport

         mov al, [detect1]
         and al, 0e0h
         jnz noadlib

         mov al, [detect2]
         and al, 0e0h
         cmp al, 0c0h
         jne noadlib
         ; Adlib detected
         mov ax, 1
         ret
noadlib: mov ax, 0
         ret
endp DetectAdlib

END
