unit fastdraw;
{A FAST mode 13h library
 written by kre Christiansen (Gnome) and Martin Knudsen (Zaifrun)
 uses the files graphasm.asm and advfont.fnt
 (advfont.font) is not included in this source release since NetMaze
 only uses the system font for text output - if you want this file
 then you can download it at my web site.
   49 routines - 20 in 100 % assembler
 font size = 6*11
 }

InterFace

const
  vgamem = $A000;

type
 buftype = array[1..65535] of byte;
 paltype = array[0..255] of
  record
  red : byte;
  green : byte;
  blue : byte;
  end;


procedure drawpix(x,y : word; col : byte;where : word);
procedure settext;
procedure setvga256;
procedure movemem(source,dest : word);
procedure cls(col:byte;where : word);

procedure waittrace;
procedure setrgb(col,red,green,blue : byte);
procedure getrgb(col:byte;var red,green,blue : byte);
procedure drawbox(x:word;y:byte;x1:word;y1:byte;color:byte;where :word);
function  getpix(x,y,where : word) : byte;

procedure drawcircle(centerx : word;centery,radius,color : byte;screen : word);
procedure drawrectangle(x1:word;y1:byte;x2:word;y2,color:byte;where:word);
procedure CopyMem(Source,dest,x : word;y : byte;x1 :word;y1 : byte;NewX:word;NewY:byte;black :boolean);
Procedure getPal(var buffer : paltype);
Procedure setPal(var buffer : paltype);

procedure Put(writeblack:boolean;x:word;y :byte;var Size : word;var Point : pointer; free : boolean;where:word);
procedure Get(x:word;y:byte;xend:word;yend : byte;var Size : word; var Point : pointer;where :word);
procedure destroyvirtual(var p: pointer);
function  createvirtual(var P : pointer): word;
procedure Viewpcx(FileName : string;NewPalette : boolean;where : word);

procedure Viewpcx256(FileName : string;NewPalette : boolean;where : word);
procedure drawline(x1,y1,x2,y2:word;color:byte;screen:word);
FUNCTION  TextSize(strnew : string) : word;
function  detectvga:boolean;
procedure PrintString(x,y : word; strt : string;color: byte;where : word);

function NearColor(color :byte) : byte;
procedure movemem_notblack(source,dest : word);
procedure getpal_frompcx(filename : string;var pal : paltype);
procedure getpal_fromgif(filename:string;var pal:paltype);
procedure playfli(filename:string;changepal : boolean;where : word;black:boolean);

{these routines can be optimized some I think }
Procedure FadeDown(wait1 : word);
Procedure Fadeup(wait1 : word;pal : paltype);
procedure initfli(filename:string;var point : pointer;var size : word);
function  getflispeed(var point : pointer) : word;
procedure fillcircle(Xcenter : word;YCenter :byte; Radius : word;Color : byte;where :word);

procedure drawpoly(x1,y1,x2,y2,x3,y3,x4,y4:integer;color:byte;where:word);
procedure viewgif(filename:string;changepal:boolean;where:word);
procedure destroyfont;
procedure createfont;{krver 10564 bytes af konventionel mem}
procedure resetpal;

procedure drawstring(x,y:word;st : string;color:byte;where:word);
function  Stringsize(st : string):word;
function  getflispeed_fromfile(filename:string) : word;
procedure olddrawpoly(x1,y1,x2,y2,x3,y3,x4,y4:integer;color:byte;where:word);
Function  CollisionWhilePut(x:word;y :byte;var Size : word;var Point : pointer; where:word):Boolean;

Procedure Show256(color : byte);
procedure loadraw(filename:string;where:word);
procedure loadpal(filename:string;var p:paltype);
procedure drawcolorcircle(centerx : word;centery,radius,
                          color1,color2:byte;screen : word);

Implementation

var
bufseg,bufofs:word;
screenx:word;
fontsize:word;
fontpointer:pointer;

procedure loadpal(filename:string;var p:paltype);
var
  f:file;
begin
  assign(f,filename);
  reset(f,1);
  blockread(f,p,768);
  close(f);
end;


procedure loadraw(filename:string;where:word);
var
  f:file;
begin
  assign(f,filename);
  reset(f,1);
  if filesize(f)>64000 then
  begin
  blockread(f,mem[where:0],64000);
  blockread(f,mem[where:64000],filesize(f)-64000);
  end else
  begin
  blockread(f,mem[where:0],filesize(f));
  end;
  close(f);
end;


Procedure Show256(color : byte);
var
  i : byte;
  q,codee : integer;
  si : string;
begin
  createfont;
  for i:=0 to 255 do
  begin
    str(i,si);
case i of
0..20 : begin
drawbox(i*15,0,(i*15)+15,15,i,vgamem);
drawstring(i*15,0,si,color,vgamem);
end;
21..41 : begin
drawbox((i-21)*15,16,((i-21)*15)+15,31,i,vgamem);
drawstring((i-21)*15,16,si,color,vgamem);
end;
42..62 : begin
drawbox((i-42)*15,32,((i-42)*15)+15,47,i,vgamem);
drawstring((i-42)*15,32,si,color,vgamem);
end;
63..83 : begin
drawbox((i-63)*15,48,((i-63)*15)+15,63,i,vgamem);
drawstring((i-63)*15,48,si,color,vgamem);
end;
84..104 : begin
drawbox((i-84)*15,64,((i-84)*15)+15,79,i,vgamem);
drawstring((i-84)*15,64,si,color,vgamem);
end;
105..125 : begin
drawbox((i-105)*15,80,((i-105)*15)+15,95,i,vgamem);
drawstring((i-105)*15,80,si,color,vgamem);
end;
126..146 : begin
drawbox((i-126)*15,96,((i-126)*15)+15,111,i,vgamem);
drawstring((i-126)*15,96,si,color,vgamem);
end;
147..167 : begin
drawbox((i-147)*15,112,((i-147)*15)+15,127,i,vgamem);
drawstring((i-147)*15,112,si,color,vgamem);
end;
168..188 : begin
drawbox((i-168)*15,128,((i-168)*15)+15,143,i,vgamem);
drawstring((i-168)*15,128,si,color,vgamem);
end;
189..209 : begin
drawbox((i-189)*15,144,((i-189)*15)+15,159,i,vgamem);
drawstring((i-189)*15,144,si,color,vgamem);
end;
210..230 : begin
drawbox((i-210)*15,160,((i-210)*15)+15,175,i,vgamem);
drawstring((i-210)*15,160,si,color,vgamem);
end;
231..251 : begin
drawbox((i-231)*15,176,((i-213)*15)+15,191,i,vgamem);
drawstring((i-231)*15,176,si,color,vgamem);
end;
252..255 : begin
drawbox((i-252)*75,192,((i-252)*15)+75,199,i,vgamem);
drawstring((i-252)*75,192,si,color,vgamem);
end;
end;
end;

asm
  mov ah,0h
  int 16h
end;
destroyfont;
end;




{$L graphasm.obj}
{$F+}
procedure drawpix(x,y : word; col : byte;where : word); external;
procedure settext; external;
procedure setvga256; external;
procedure movemem(source,dest : word);external;
procedure cls(col:byte;where : word); external;

procedure waittrace; external;
procedure setrgb(col,red,green,blue : byte); external;
procedure getrgb(col:byte;var red,green,blue : byte); external;
procedure drawbox(x:word;y:byte;x1:word;y1:byte;color:byte;where :word); external;
function  getpix(x,y,where : word) : byte;external;

procedure drawcircle(centerx : word;centery,radius,color : byte;screen : word);external;
procedure drawrectangle(x1:word;y1:byte;x2:word;y2,color:byte;where:word);external;
procedure CopyMem(Source,dest,x : word;y : byte;x1 :word;y1 : byte;NewX:word;NewY:byte;black :boolean);external;
Procedure getPal(var buffer : paltype); external;
Procedure setPal(var buffer : paltype); external;

procedure drawline(x1,y1,x2,y2:word;color:byte;screen:word); external;
function  detectvga:boolean; external;
procedure movemem_notblack(source,dest : word); external;
procedure drawpoly(x1,y1,x2,y2,x3,y3,x4,y4:integer;color:byte;where:word);external;
procedure drawcolorcircle(centerx : word;centery,radius,
                          color1,color2:byte;screen : word); external;
{$F-}

procedure destroyfont;
begin
  freemem(fontpointer,fontsize);
end;

procedure drawstring(x,y:word;st : string;color:byte;where:word);
var
segstr,ofsstr : word;
nr :byte;
last : byte;
screenofs:word;
memofs : word;

procedure drawchr(ch:byte);
var
  xcor,ycor : byte;
begin
  last:=0;
  screenofs:=(y shl 6)+(y shl 8)+x;
  case ch of
  32..71 : memofs:=(ch-32) shl 3;
  72..111: memofs:=(ch-72) shl 3 + (11 shl 6)+(11 shl 8);
  112..125:memofs:=(ch-112) shl 3 + (22 shl 6) +(22 shl 8);
  end;
  memofs:=memofs+ofsstr;
  for ycor:=0 to 10 do
  begin
  for xcor:=0 to 4 do
  begin
    if mem[segstr:memofs]<>0
    then begin
    mem[where:screenofs]:=color;
    if xcor>last then last:=xcor;
    end;
    memofs:=memofs+1;
    screenofs:=screenofs+1;
  end;
    memofs:=memofs+315;
    screenofs:=screenofs+315;
  end;
  if ch=32 then last:=4;
end;
begin
segstr:=seg(fontpointer^);
ofsstr:=ofs(fontpointer^)+4;
for nr:=1 to ord(st[0]) do begin
drawchr(ord(st[nr]));
x:=x+last+2;
end;
end;


function Stringsize(st : string):word;
var
segstr,ofsstr : word;
nr :byte;
last : byte;
memofs : word;
x,y:word;

procedure drawchr(ch:byte);
var
  xcor,ycor : byte;
begin
  last:=0;
  case ch of
  32..71 : memofs:=(ch-32) shl 3;
  72..111: memofs:=(ch-72) shl 3 + (11 shl 6)+(11 shl 8);
  112..125:memofs:=(ch-112) shl 3 + (22 shl 6) +(22 shl 8);
  end;
  memofs:=memofs+ofsstr;
  for ycor:=0 to 10 do
  begin
  for xcor:=0 to 4 do
  begin
    if mem[segstr:memofs]<>0
    then begin
    if xcor>last then last:=xcor;
    end;
    memofs:=memofs+1;
  end;
    memofs:=memofs+315;
  end;
  if ch=32 then last:=4;
end;
begin
segstr:=seg(fontpointer^);
ofsstr:=ofs(fontpointer^)+4;
x:=0;
y:=0;
for nr:=1 to ord(st[0]) do begin
drawchr(ord(st[nr]));
x:=x+last+2;
end;
stringsize:=x;
end;



procedure createfont;
var
f : file;
begin
  assign(f,'advfont.fnt');
  reset(f,1);
  fontsize:=10564;
  getmem(fontpointer,fontsize);
  blockread(f,mem[seg(fontpointer^):ofs(fontpointer^)],10564);
  close(f);
end;

procedure getpal_fromgif(filename:string;var pal:paltype);
var
sizeoffile : longint;
giffile : file;
start,i : word;
segpal,ofspal:word;
bitsperpix:byte;
begin
Assign(giffile,filename);
reset(giffile,1);
segpal:=seg(pal);
ofspal:=ofs(pal);
start:=13;
seek(giffile,start);
BlockRead(giffile,mem[segpal:ofspal],768);
for i:=0 to 767 do mem[segpal:ofspal+i]:=mem[segpal:ofspal+i] shr 2;
close(giffile);
end;

procedure resetpal; assembler;
asm
  xor   cx,cx
  xor   al,al
  cli
  mov  dx,3c8h
  out  dx,al
  inc  dx
 @loop:
  out dx,al
  inc cx
  cmp cx,768d
  jbe @loop
  sti
end;

procedure olddrawpoly(x1,y1,x2,y2,x3,y3,x4,y4:integer;color:byte;where:word);
var
  Ymin,Ymax : integer;
  x : integer;
  y : integer;
  bigX,litX :integer;
  mul1,div1,
  mul2,div2,
  mul3,div3,
  mul4,div4:integer;
  i,w:word;

begin
 Ymin:=200;
 ymax:=0;
 if y1>ymax then ymax:=y1;
 if y1<ymin then ymin:=y1;
 if y2>ymax then ymax:=y2;
 if y2<ymin then ymin:=y2;
 if y3>ymax then ymax:=y3;
 if y3<ymin then ymin:=y3;
 if y4>ymax then ymax:=y4;
 if y4<ymin then ymin:=y4;
 mul1:=x1-x4; div1:=y1-y4;
 mul2:=x2-x1; div2:=y2-y1;
 mul3:=x3-x2; div3:=y3-y2;
 mul4:=x4-x3; div4:=y4-y3;
 if ymin<0 then ymin:=0;
 if ymax>199 then ymax:=199;

for y:=ymin to ymax do begin
  bigx:=-1;
  litx:=320;
        if (y4>=y) or (y1>=y) then
        if (y4<=y) or (y1<=y) then
          if not(y4=y1) then
            begin
              x:=(y-y4)*mul1 div div1+x4;
              if x<litx then litx:=x;
              if x>bigx then bigx:=x;
            end;
      if (y1>=y) or (y2>=y) then
        if (y1<=y) or (y2<=y) then
          if not(y1=y2) then
            begin
              x:=(y-y1)*mul2 div div2+x1;
              if x<litx then litx:=x;
              if x>bigx then bigx:=x;
            end;
      if (y2>=y) or (y3>=y) then
        if (y2<=y) or (y3<=y) then
          if not(y2=y3) then
            begin
              x:=(y-y2)*mul3 div div3+x2;
              if x<litx then litx:=x;
              if x>bigx then bigx:=x;
            end;
      if (y3>=y) or (y4>=y) then
        if (y3<=y) or (y4<=y) then
          if not(y3=y4) then
            begin
              x:=(y-y3)*mul4 div div4+x3;
              if x<litx then litx:=x;
              if x>bigx then bigx:=x;
            end;

if (litx<=bigx) and (bigx>=0) then
begin
  if litx<0 then litx:=0;
  if bigx>319 then bigx:=319;
 {pascal code - kan bruges i stedet for asm blokken
  w:=y;
  for I:=litx to bigx do mem[where:(w shl 6)+(w shl 8)+i];
 }

 asm
   mov cx,[bigx]
   sub cx,[litx]
   inc cx
   mov ax,[where]
   mov es,ax
   mov di,[y]
   mov si,di
   shl di,8
   shl si,6
   add di,si
   add di,[litx]
   mov al,[color]
   mov ah,al
   mov dx,cx
   and dx,00000001b
   or dx,0
   je @vid
   stosb
   dec cx
   @vid:
   shr cx,1
   rep stosw
 end;
 end;
end;  {y loop}

end; {procedure drawit}


procedure fillcircle(Xcenter : word;YCenter :byte; Radius : word;Color : byte;where :word);
var
p: integer;
x,y : word;
yar : array [-100..100] of record
xstart : integer;
xend : integer;
end;

begin
  x:=0;
  y:=radius;
  p:=3-(radius shl 1);
  while x < y do begin
  yar[-x].xstart:=-y;
  yar[-x].xend:=y;
  yar[x].xstart:=-y;
  yar[x].xend:=y;
    if p < 0 then p:=p+(x shl 2)+6
    else begin
    p:=p+((x-y) shl 2)+10;
    {her skal ske noget}
    yar[-y].xstart:=-x;
    yar[-y].xend:=x;
    yar[y].xstart:=-x;
    yar[y].xend:=x;
    y:=y-1;
    end;
    x:=x+1;
  end;
 if x=y then begin
 yar[-x].xstart:=-y;
 yar[-x].xend:=y;
 yar[x].xstart:=-y;
 yar[x].xend:=y;
 end;
for p:=-radius to radius do
begin
drawline(xcenter+yar[p].xstart,ycenter+p,xcenter+yar[p].xend,ycenter+p,color,where);
end;

end;



procedure wait(milsek : word);
var
  i : longint;
  w : word;
begin
  w:=round(milsek*(70/1000));
  for I:=1 to w do begin
  asm
    mov dx,3DAh
@l1:
    in al,dx
    and al,08h
    jnz @l1
@l2:
    in al,dx
    and al,08h
    jz  @l2
end;
end;
end;

procedure getpal_frompcx(filename : string;var pal : paltype);
var
 sizeoffile : longint;
 pcxfile : file;
 i : word;
 segpal,ofspal:word;
begin
Assign(pcxfile,filename);
reset(pcxfile,1);
sizeoffile:=filesize(pcxfile);
seek(pcxfile,sizeoffile-768);
segpal:=seg(pal);
ofspal:=ofs(pal);
BlockRead(pcxfile,mem[segpal:ofspal],768);
for i:=0 to 767 do mem[segpal:ofspal+i]:=mem[segpal:ofspal+i] shr 2;
close(pcxfile);
end;


function NearColor(color :byte) : byte;
var
thecol : byte;
i : word;
h : real;
r,r1,g,g1,b,b1:byte;
begin
h:=50000;
thecol:=color;
getrgb(color,r,g,b);
for I:=0 to 255 do
begin
if i<>color then
begin
getrgb(i,r1,g1,b1);
if sqrt((g1-g)*(g1-g)+sqrt((r1-r)*(r1-r)+(b1-b)*(b1-b)))<h then
begin
thecol:=i;
h:=sqrt((g1-g)*(g1-g)+sqrt((r1-r)*(r1-r)+(b1-b)*(b1-b)));
end;
end;
end;
NearColor:=thecol;
end;

procedure PrintString(x,y : word; strt : string;color: byte;where : word);

var
  BMask : byte;
  newofs :word;
  segstr,ofsstr : word;

const
   segfont : word = 0;
   ofsfont : word = 0;

begin
  segstr:=seg(strt);
  ofsstr:=ofs(strt);
 asm
  mov   ax,[segstr]
  mov   es,ax
  mov   di,[ofsstr]
  mov   al,es:[di]
  xor   ah,ah
  mov   si,ax
  push  bp
  mov   ax,1130h
  mov   bh,3h
  int   10h
  mov   [segfont],es
  mov   [ofsfont],bp
  pop   bp
  mov   dx,1
@dxloop:
  xor   cx,cx
@cxloop:
  mov   ax,[segstr]
  mov   es,ax
  mov   di,[ofsstr]
  add   di,dx
  xor   ax,ax
  mov   al,es:[di]
  shl   ax,3
  add   ax,cx
  mov   di,[ofsfont]
  add   di,ax
  mov   ax,[segfont]
  mov   es,ax
  mov   al,es:[di]
  mov   [bmask],al
  xor   bx,bx
@bxloop:
  mov   al,[bmask]
  and   al,128
  or    al,0
  je    @nopix
  mov   ax,[y]
  add   ax,cx
  mov   di,ax
  rol   ax,8
  shl   di,6
  add   di,ax
  add   di,[x]
  add   di,bx
  mov   ax,[where]
  mov   es,ax
  mov   al,[color]
  mov   es:[di],al
@nopix:
  shl   [bmask],1
  inc   bx
  cmp   bx,7
  jbe   @bxloop
  inc   cx
  cmp   cx,7
  jbe   @cxloop
  add   [x],8
  inc   dx
  cmp   dx,si
  jbe   @dxloop
 end; {asm}
end;  {proc}

FUNCTION  TextSize(strnew : string) : word;
begin
 textsize:=mem[seg(strnew):ofs(strnew)] shl 3;
end;

procedure Viewpcx(FileName : string;NewPalette : boolean;where : word);

var
 BytesPerLine : word;
 sizeoffile   : word;
 pcxpointer : pointer;
 ofspcx,
 segpcx    :word;
 outbuf : array [0..319] of byte;
 count : word;
 j : word;
 mid,data : byte;
 bytessofar : word;
 farveofs,newoffset : word;
 bufseg,bufofs : word;
 handle : word;
 error  : byte;
 maxx  : word;
 maxy : byte;

begin
 asm
  lea  di,[filename]
  mov  [bufofs],di
  mov  [bufseg],ss
  mov   [error],0
  mov   es,[bufseg]
  xor   bx,bx
  mov   bl,es:[di]
  add   di,bx
  inc   di
  xor   al,al
  mov   es:[di],al
  inc   [bufofs]
  mov   ah,3dh
  mov   al,18d
  push  ds
  mov   dx,[bufofs]
  mov   bx,[bufseg]
  mov   ds,bx
  int   21h
  pop   ds
  jnc   @Noerror1
  inc   [error]
  jmp   @finish1
@NoError1:
  mov   [handle],ax
  mov   bx,ax
  mov   ah,42h
  mov   al,2
  xor   cx,cx
  xor   dx,dx
  int   21h
  mov   [sizeoffile],ax
  or    dx,0
  je    @noError2
  inc   [error]
  jmp   @finish1
@noError2:
  mov   ah,42h
  xor   al,al
  mov   bx,[handle]
  xor   cx,cx
  xor   dx,dx
  int   21h
@finish1:
end;
  if error=0 then GetMem(pcxpointer,sizeoffile);
asm
  mov  ax,seg [outbuf]
  mov  [bufseg],ax
  mov  ax,offset [outbuf]
  mov  [bufofs],ax
  or    [Error],0
  jne   @SomethingWrong
  les   di,[pcxpointer]
  mov   [segpcx],es
  mov   [ofspcx],di
  mov   ah,3fh
  mov   bx,[handle]
  mov   cx,[sizeoffile]
  push  ds
  mov   dx,[ofspcx]
  mov   si,[segpcx]
  mov   ds,si
  int   21h
  pop   ds
  mov   ax,[segpcx]
  mov   es,ax
  mov   di,[ofspcx]
  mov   al,es:[di]
  cmp   al,10d
  jne   @notpcxfile
  xor   ax,ax
  add   di,9
  mov   al,es:[di]
  rol   ax,8
  dec   di
  mov   al,es:[di]
  cmp   ax,319d
  mov   [maxx],ax
  ja   @notpcxfile
  add   di,3
  xor   ax,ax
  mov   al,es:[di]
  rol   ax,8
  dec   di
  mov   al,es:[di]
  cmp   ax,199d
  ja   @notpcxfile
  mov   [maxy],al
  mov   di,[ofspcx]
  add   di,67d
  xor   ax,ax
  mov   al,es:[di]
  rol   ax,8
  dec   di
  mov   al,es:[di]
  mov   [bytesperline],ax
  mov   cx,[ofspcx]
  mov   [newoffset],cx
  add   [newoffset],128
  add   cx,[sizeoffile]
  sub   cx,768d
  mov   [farveofs],cx
  or    [newpalette],0
  je    @do_not_change_pal
  xor   cx,cx
  mov   ax,[segpcx]
  mov   es,ax
  mov   di,[farveofs]
@loop:
  mov   al,es:[di]
  shr   al,2
  mov   es:[di],al
  inc   di
  inc   cx
  cmp   cx,767d
  jbe   @loop
  mov   ax,1012h
  xor   bx,bx
  mov   cx,256d
  mov   dx,[segpcx]
  mov   es,dx
  mov   dx,[ofspcx]
  add   dx,[sizeoffile]
  sub   dx,768
  int   10h
@do_not_change_pal:
  mov   [j],0
@loopj:
  mov   [bytessofar],0
@repeatit:
  mov   ax,[segpcx]
  mov   es,ax
  mov   di,[newoffset]
  mov   al,es:[di]
  mov   [mid],al
  and   al,192d
  cmp   al,192d
  jne   @noCount
  mov   ax,[segpcx]
  mov   es,ax
  mov   di,[newoffset]
  inc   di
  mov   al,es:[di]
  xor   dx,dx
  mov   dl,[mid]
  sub   dx,192d
  mov   bx,[bufseg]
  mov   es,bx
  mov   di,[bufofs]
  add   di,[bytessofar]
  mov   cx,dx
  rep   stosb
  add   [bytessofar],dx
  inc   [newoffset]
  jmp   @incoffset
@nocount:
  mov   al,[mid]
  mov   bx,[bufseg]
  mov   es,bx
  mov   di,[bufofs]
  add   di,[bytessofar]
  mov   es:[di],al
  inc   [bytessofar]
@incoffset:
  inc   [newoffset]
  mov   ax,[bytesperline]
  cmp   [bytessofar],ax
  jb    @repeatit
  push  ds
  mov   es,[where]
  mov   si,[bufofs]
  mov   di,[j]
  mov   dx,di
  shl   di,6
  shl   dx,8
  add   di,dx
  mov   cx,80d
  mov   bx,[bufseg]
  mov   ds,bx
  Db    66h
  rep   movsw
  pop   ds
  inc   [j]
  xor   ch,ch
  mov   cl,[maxy]
  cmp   [j],cx
  jbe   @loopj
@notPcxfile:
  mov   ah,3eh
  mov   bx,[handle]
  int   21h
@somethingWrong:
end;
  If error=0 then FreeMem(Pcxpointer,sizeoffile);
end;

{Special routines for 256x256 pcx pictures - normally just use ViewPcx}
procedure Viewpcx256(FileName : string;NewPalette : boolean;where : word);

var
 BytesPerLine : word;
 sizeoffile   : word;
 pcxpointer : pointer;
 ofspcx,
 segpcx    :word;
 outbuf : array [0..319] of byte;
 count : word;
 j : word;
 mid,data : byte;
 bytessofar : word;
 farveofs,newoffset : word;
 bufseg,bufofs : word;
 handle : word;
 error  : byte;
 maxx  : word;
 maxy : byte;

begin
 asm
  lea  di,[filename]
  mov  [bufofs],di
  mov  [bufseg],ss
  mov   [error],0
  mov   es,[bufseg]
  xor   bx,bx
  mov   bl,es:[di]
  add   di,bx
  inc   di
  xor   al,al
  mov   es:[di],al
  inc   [bufofs]
  mov   ah,3dh
  mov   al,18d
  push  ds
  mov   dx,[bufofs]
  mov   bx,[bufseg]
  mov   ds,bx
  int   21h
  pop   ds
  jnc   @Noerror1
  inc   [error]
  jmp   @finish1
@NoError1:
  mov   [handle],ax
  mov   bx,ax
  mov   ah,42h
  mov   al,2
  xor   cx,cx
  xor   dx,dx
  int   21h
  mov   [sizeoffile],ax
  or    dx,0
  je    @noError2
  inc   [error]
  jmp   @finish1
@noError2:
  mov   ah,42h
  xor   al,al
  mov   bx,[handle]
  xor   cx,cx
  xor   dx,dx
  int   21h
@finish1:
end;
  if error=0 then GetMem(pcxpointer,sizeoffile);
asm
  mov  ax,seg [outbuf]
  mov  [bufseg],ax
  mov  ax,offset [outbuf]
  mov  [bufofs],ax
  or    [Error],0
  jne   @SomethingWrong
  les   di,[pcxpointer]
  mov   [segpcx],es
  mov   [ofspcx],di
  mov   ah,3fh
  mov   bx,[handle]
  mov   cx,[sizeoffile]
  push  ds
  mov   dx,[ofspcx]
  mov   si,[segpcx]
  mov   ds,si
  int   21h
  pop   ds
  mov   ax,[segpcx]
  mov   es,ax
  mov   di,[ofspcx]
  mov   al,es:[di]
  cmp   al,10d
  jne   @notpcxfile
  xor   ax,ax
  add   di,9
  mov   al,es:[di]
  rol   ax,8
  dec   di
  mov   al,es:[di]
  cmp   ax,319d
  mov   [maxx],ax
{  ja   @notpcxfile}
  add   di,3
  xor   ax,ax
  mov   al,es:[di]
  rol   ax,8
  dec   di
  mov   al,es:[di]
  cmp   ax,199d
{  ja   @notpcxfile}
  mov   [maxy],al
  mov   di,[ofspcx]
  add   di,67d
  xor   ax,ax
  mov   al,es:[di]
  rol   ax,8
  dec   di
  mov   al,es:[di]
  mov   [bytesperline],ax
  mov   cx,[ofspcx]
  mov   [newoffset],cx
  add   [newoffset],128
  add   cx,[sizeoffile]
  sub   cx,768d
  mov   [farveofs],cx
  or    [newpalette],0
  je    @do_not_change_pal
  xor   cx,cx
  mov   ax,[segpcx]
  mov   es,ax
  mov   di,[farveofs]
@loop:
  mov   al,es:[di]
  shr   al,2
  mov   es:[di],al
  inc   di
  inc   cx
  cmp   cx,767d
  jbe   @loop
  mov   ax,1012h
  xor   bx,bx
  mov   cx,256d
  mov   dx,[segpcx]
  mov   es,dx
  mov   dx,[ofspcx]
  add   dx,[sizeoffile]
  sub   dx,768
  int   10h
@do_not_change_pal:
  mov   [j],0
@loopj:
  mov   [bytessofar],0
@repeatit:
  mov   ax,[segpcx]
  mov   es,ax
  mov   di,[newoffset]
  mov   al,es:[di]
  mov   [mid],al
  and   al,192d
  cmp   al,192d
  jne   @noCount
  mov   ax,[segpcx]
  mov   es,ax
  mov   di,[newoffset]
  inc   di
  mov   al,es:[di]
  xor   dx,dx
  mov   dl,[mid]
  sub   dx,192d
  mov   bx,[bufseg]
  mov   es,bx
  mov   di,[bufofs]
  add   di,[bytessofar]
  mov   cx,dx
  rep   stosb
  add   [bytessofar],dx
  inc   [newoffset]
  jmp   @incoffset
@nocount:
  mov   al,[mid]
  mov   bx,[bufseg]
  mov   es,bx
  mov   di,[bufofs]
  add   di,[bytessofar]
  mov   es:[di],al
  inc   [bytessofar]
@incoffset:
  inc   [newoffset]
  mov   ax,[bytesperline]
  cmp   [bytessofar],ax
  jb    @repeatit
  push  ds
  mov   es,[where]
  mov   si,[bufofs]
  mov   ax,[bytesperline]
 { mov   di,[j]}
  mul   [j]
  {res = dx:ax}
  mov   di,dx
  shl   di,8
  add   di,ax
  cmp   [maxy],200
  ja   @doneit
  mov   di,[j]
  mov   dx,di
  shl   dx,6
  shl   di,8
  add   di,dx

  @doneit:
  mov   cx,[maxx]
  inc   cx
  shr   cx,2

  mov   bx,[bufseg]
  mov   ds,bx
  Db    66h
  rep   movsw
  pop   ds
  inc   [j]
  xor   ch,ch
  mov   cl,[maxy]
  cmp   [j],cx
  jbe   @loopj
@notPcxfile:
  mov   ah,3eh
  mov   bx,[handle]
  int   21h
@somethingWrong:
end;
  If error=0 then FreeMem(Pcxpointer,sizeoffile);
end;


procedure Put(writeblack:boolean;x:word;y :byte;var Size : word;var Point : pointer; free : boolean;where:word);
var
count,xlen : word;
ylen : byte;
segp,ofsp : word;
wblack : byte;
begin
if writeblack then wblack:=1 else wblack:=0;
segp:=seg(point^);
ofsp:=ofs(point^);
ylen:=mem[segp:ofsp+2];
xlen:=mem[segp:ofsp]+mem[segp:ofsp+1];
asm
mov [count],4
push es
push ds
mov es,[segp]
mov ds,[where]
{ax = x
 bx = xlen
 dh = y
 dl = ylen}
mov si,[x]
mov bx,[xlen]
mov dh,[y]
mov dl,[ylen]
add dl,dh
mov cx,si
add si,bx
{free = di,bx,ax}
  @loopx:
  mov bx,[ofsp]
  mov di,[count]
  mov al,es:[bx+di]
  cmp al,0h
  je @sort1
  jmp @next
  @sort1:
  cmp [wblack],1
  jne @sort
  @next:
  xor bx,bx
  mov bl,dh
  mov di,bx
  shl bx,6
  shl di,8
  add bx,di
  add bx,cx
  mov ds:[bx],al
  @sort:
  inc [count]
  cmp cx,si
  inc cx
  jb @loopx
  mov cx,[x]
  inc [y]
  mov dh,[y]
  cmp dh,dl
  jbe @loopx
 @endit:
  pop ds
  pop es
  end;
if free then freemem(point,size);
end;



Function CollisionWhilePut(x:word;y :byte;var Size : word;var Point : pointer; where:word):Boolean;
var
count,xlen : word;
ylen : byte;
segp,ofsp : word;
wblack : byte;
resbol:boolean;
t:byte;
begin
wblack:=0;
segp:=seg(point^);
ofsp:=ofs(point^);
ylen:=mem[segp:ofsp+2];
xlen:=mem[segp:ofsp]+mem[segp:ofsp+1];
asm
mov [count],4
push es
push ds
mov es,[segp]
mov ds,[where]
{ax = x
 bx = xlen
 dh = y
 dl = ylen}
mov [resbol],0
mov si,[x]
mov bx,[xlen]
mov dh,[y]
mov dl,[ylen]
add dl,dh
mov cx,si
add si,bx
{free = di,bx,ax}
  @loopx:
  mov bx,[ofsp]
  mov di,[count]
  mov al,es:[bx+di]
  cmp al,0h
  je @sort1
  jmp @next
  @sort1:
  cmp [wblack],1
  jne @sort
  @next:
  xor bx,bx
  mov bl,dh
  mov di,bx
  shl bx,6
  shl di,8
  add bx,di
  add bx,cx
  mov ah,al
  mov al,ds:[bx]
  mov ds:[bx],ah
  cmp al,0
  je  @sort
  mov [resbol],1
  jmp @endit
  @sort:
  inc [count]
  cmp cx,si
  inc cx
  jb @loopx
  mov cx,[x]
  inc [y]
  mov dh,[y]
  cmp dh,dl
  jbe @loopx
 @endit:
  pop ds
  pop es
  end;
CollisionWhilePut:=resbol;
end;



procedure Get(x:word;y:byte;xend:word;yend : byte;var Size : word; var Point : pointer;where :word);
var
  buffer : ^buftype;
  count :word;
  ofsp,segp : word;
begin
Size:=(1+xend-x)*(1+yend-y)+4;
if (size mod 2 = 1) then inc(size);
getmem(buffer,size);
segp:=seg(buffer^);
ofsp:=ofs(buffer^);
asm
 mov [count],0
 push es
 push ds
 mov es,[segp]
 mov di,[ofsp]
 mov ds,[where]
 mov cx,[x]
 mov si,[xend]
 mov dh,[y]
 mov dl,[yend]
 cmp dh,dl
 jbe @vid1
 xchg dh,dl
@vid1:
 cmp cx,si
 jbe @loopx
 xchg cx,si
@loopx:
 xor ax,ax
 mov al,dh
 xor bx,bx
 mov bl,al
 shl bx,8
 shl ax,6
 add bx,ax
 add bx,cx
 {bx = ofset p grab screen}
 mov al,ds:[bx]
 mov bx,[count]
 add bx,4
 mov es:[bx+di],al
 inc [count]
 cmp cx,si
 inc cx
 jb @loopx
 mov cx,[x]
 cmp dh,dl
 inc dh
 jbe @loopx
 mov cx,[x]
 mov dh,[y]
 mov ax,si
 sub ax,cx
 cmp ax,255
  jbe @lille
  mov bx,255
  mov es:[di],bx
  sub ax,255
  mov es:[di+1],ax
  jmp @vid3
@lille:
  xor ax,ax
  mov es:[di],ax
  mov ax,si
  sub ax,cx
  mov es:[di+1],ax
@vid3:
  sub dl,dh
  mov es:[di+2],dl
pop ds
pop es
end;
point:=ptr(seg(Buffer^),ofs(Buffer^));
end;


procedure destroyvirtual(var p: pointer);
begin
cls(0,seg(P^));
freemem(p,65520);
end;

function createvirtual(var P : pointer): word;
var
 w : word;
begin
getmem(p,65520);
w:=seg(p^);
cls(0,w);
createvirtual:=w;
end;

procedure playfli(filename:string;changepal : boolean;where : word;black:boolean);
const
  StartFrame : byte = 1;
  EndFrame : byte = 20;
  Fli_color      =    11;  {lavet }
  Fli_LC         =    12; {lavet}
  Fli_black      =    13; {lavet - clear screen}
  Fli_brun       =    15;   {lavet}
  Fli_copy       =    16;  {lavet - kopiere 64000 bytes til skrmem}
  Fli_delta      =     7;    {mangler - fucking svr at lave}
  Fli_256_color  =     4;   {lavet}
  Fli_mini       =    18;   {lavet -nothing}
  Mainheader     =   128;
  Frameheader    =    16;
  chunkheader    =     6;
  FliVersion     = $AF11;
  FlcVersion     = $AF12;
  SpecialFrame   = 61696;
  MaxFrames      =    128;
  MaxChunks      =     5;

var
  databyte1,databyte2 :word;
  data : word;
  q,x,y,z : integer;
  pack : word;
  sizeoffile : word;
  flipointer : pointer;
  handle : file;
  fliseg,fliofs : word;
  i,j,k : longint;
  Tilnow : longint;
  skipline,chanline : word;
  sizecount : shortint;
  skipcount : byte;
  outbuf : array[0..319] of byte;
  ChunkNr,FrameNr,packnr : word;
  SkipOffset : word;
  curcol,colskip : byte;
  colchan : word;
  NrOfPack :word;
  LineNr:integer;
  offset : word;
  Packint : integer;
  CompLine : word;
  col : byte;

  {fli data}
Fli : record
  Filename : string;
  Speed   : word;
  Version : word;
  Colors  : word;
  NrOfFrames  : word;
  Framesize : array[1..maxframes] of word;
  Xsize   : word;
  Ysize   : word;
end;
 {end of fli data}
 CurFrame : record
 offset   : word;
 Size : word;
 NrofChunks : word;
 Chunk : array[1..maxchunks]
 of record
 typ  : word;
 size : word;
 Offset : word;
 end;
end;

label dontchange;


procedure decodeFrame(FrameNr : word);
var
 now : word;
 i1,j1 : word;

begin
now:=mainheader+fliofs;
for I1:=1 to FrameNr do
begin
if i1<>1 then now:=now+Fli.FrameSize[i1-1];
end;
with CurFrame do
begin
  size:=Fli.Framesize[frameNr];
  NrOfChunks:=memw[fliseg:now+6];
  Offset:=now;
  inc(now,frameheader);
  for I1:=1 to NrOfChunks do
  begin
    chunk[i1].size:=meml[fliseg:now];
    chunk[i1].typ:=memw[fliseg:now+4];
    chunk[i1].offset:=now;
    inc(now,chunk[i1].size);
  end;
end;
end; {decodeFrame}


label
  skipdecode;


begin
SkipOffset:=0;
fli.filename:=filename;
assign(handle,filename);
reset(handle,1);
sizeoffile:=filesize(handle);
getmem(flipointer,sizeoffile);
blockread(handle,flipointer^,sizeoffile);
fliseg:=seg(flipointer^);
fliofs:=ofs(flipointer^);
with fli do
begin
version:=memw[fliseg:fliofs+4];
NrOfFrames:=memw[fliseg:fliofs+6];
xsize:=memw[fliseg:fliofs+8];
ysize:=memw[fliseg:fliofs+10];
colors:=2 shl (memw[fliseg:fliofs+12]-1);
speed:=memw[fliseg:fliofs+16];
if version=Flcversion then speed:=round(speed*(70/1000));
If memw[fliseg:fliofs+132]=specialframe
then SkipOffset:=meml[fliseg:fliofs+mainheader];
fliofs:=fliofs+skipoffset;
framesize[1]:=meml[fliseg:fliofs+mainheader];
tilnow:=framesize[1];
for i:=2 to NrOfFrames do begin
framesize[i]:=meml[fliseg:fliofs+MainHeader+tilnow];
inc(tilnow,framesize[i]);
end;
end;
endframe:=fli.nrofframes;
startframe:=1;
For FrameNr:=StartFrame to Endframe do
begin
 DecodeFrame(framenr);
  For ChunkNr:=1 to curframe.NrOfChunks do
  begin   {chunk loop begin}
      Case curframe.chunk[chunknr].typ of
      Fli_delta : begin
                    tilnow:=chunkheader+curframe.chunk[chunknr].offset;
                    Compline:=memw[fliseg:tilnow];
                    inc(tilnow,2);
                    Y:=0;
                    x:=0;
                    For lineNr:=0 to compline-1 do
                    begin
                      x:=0;
                      Packint:=memw[fliseg:tilnow];
                      inc(tilnow,2);
                      if packint<0 then
                      begin
                      packint:=packint*-1;
                      inc(y,packint);
                      dec(linenr);
                      goto skipdecode;
                      end;
                      For packnr:=1 to packint do
                      begin
                        skipcount:=mem[fliseg:tilnow];
                        inc(tilnow);
                        inc(x,skipcount);
                        sizecount:=mem[fliseg:tilnow];
                        inc(tilnow);
                        if sizecount<0 then
                        begin
                          databyte1:=mem[fliseg:tilnow];
                          databyte2:=mem[fliseg:tilnow+1];
                          inc(tilnow,2);
                          sizecount:=sizecount*-1;
                          for K:=0 to (sizecount)-1 do
                          begin
                          if black=false then
                          begin
                           if databyte1<>0 then mem[where:y*320+x+k*2]:=databyte1;
                          if databyte2<>0 then mem[where:y*320+x+k*2+1]:=databyte2;
                          end
                          else begin
                          mem[where:y*320+x+k*2]:=databyte1;
                          mem[where:y*320+x+k*2+1]:=databyte2;
                          end;
                          end;
                          inc(x,sizecount*2);
                        end  {sizecount<0}
                      else
                         begin
                         for K:=0 to (sizecount*2)-1 do
                          begin
                            if black then
                            mem[where:y*320+x+k]:=mem[fliseg:tilnow+k]
                            else
                            begin
                            if mem[fliseg:tilnow+k]<>0 then
                            mem[where:y*320+x+k]:=mem[fliseg:tilnow+k]
                            end;
                          end;
                          inc(tilnow,sizecount*2);
                          inc(x,sizecount*2);
                        end;  {sizecount>0}
                      end; {packs}
                     inc(y,1);
                     skipdecode:
                   end; {lines}
                 {for q:=1 to fli.speed do waittrace;}
                end; {fli_delta}


      Fli_copy  : begin
          move(mem[fliseg:curframe.chunk[chunknr].offset+chunkheader],mem[where:0],64000);
                  end;
      Fli_LC    : begin
                    tilnow:=chunkheader+curframe.chunk[chunknr].offset;
                    skipline:=memw[fliseg:tilnow];
                    inc(tilnow,2);
                    chanline:=memw[fliseg:tilnow];
                    inc(tilnow,2);
                    for I:=skipline to skipline+chanline-1 do
                    begin
                      pack:=mem[fliseg:tilnow];
                      inc(tilnow);
                      x:=0;
                      if pack=0 then goto dontchange;
                      for J:=1 to pack do
                      begin
                        skipcount:=mem[fliseg:tilnow];
                        inc(tilnow);
                        inc(x,skipcount);
                        sizecount:=mem[fliseg:tilnow];
                        inc(tilnow);
                        if sizecount<0 then
                        begin
                          sizecount:=sizecount*-1;
                          for k:=0 to sizecount-1 do
                          begin
                            if black then
                            mem[where:(i*320)+x+k]:=mem[fliseg:tilnow]
                            else begin
                            if mem[fliseg:tilnow]<>0 then
                            mem[where:(i*320)+x+k]:=mem[fliseg:tilnow]
                            end;
                          end;
                          inc(tilnow);
                          inc(x,sizecount);
                        end
                      else
                        begin
                          for k:=0 to sizecount-1 do
                          begin
                            if black then
                            mem[where:(i*320)+x+k]:=mem[fliseg:tilnow+k]
                            else begin
                            if mem[fliseg:tilnow+k]<>0 then
                            mem[where:(i*320)+x+k]:=mem[fliseg:tilnow+k]
                            end;
                          end;
                          inc(tilnow,sizecount);
                          inc(x,sizecount);
                        end;  {yep, sizecount is positive  - (slutning af)}
                      end;  {packets loop}
                    dontchange:
                    end;  {line loop}
                  {for q:=1 to fli.speed do waittrace;}
                  end; {fli_lc}
      FLi_black :begin
                   cls(0,where);
                 end;
      Fli_Color,Fli_256_color :
        begin
          if changepal then begin
          NrOfPack:=memw[fliseg:curframe.chunk[chunknr].offset+chunkheader];
          tilnow:=curframe.chunk[chunknr].offset+chunkheader+2;
          curcol:=0;
          for I:=1 to NrOfpack do
          begin
            colskip:=mem[fliseg:tilnow];
            inc(tilnow);
            inc(curcol,colskip);
            colchan:=mem[fliseg:tilnow];
            inc(tilnow);
            if colchan=0 then colchan:=256;
            if curframe.chunk[chunknr].typ=fli_256_color then
            begin
              for z:=curcol to curcol+colchan-1 do
              begin
              setrgb(z,mem[fliseg:tilnow] shr 2,mem[fliseg:tilnow+1] shr 2,mem[fliseg:tilnow+2] shr 2);
              inc(tilnow,3);
              end;
            end
           else
            begin
            for z:=curcol to curcol+colchan-1 do
            begin
              setrgb(z,mem[fliseg:tilnow],mem[fliseg:tilnow+1],mem[fliseg:tilnow+2]);
              inc(tilnow,3);
            end;
           end;
            inc(curcol,colchan);
          end; {packets loop}
        end; {changepal = false}
         end; {fli_color,fli_256_color}
     Fli_Brun :
        begin
          tilnow:=curframe.chunk[chunknr].offset+chunkheader;
         for LineNr:=0 to (fli.Ysize-1) do
          begin
            pack:=mem[fliseg:tilnow];
            inc(tilnow);
            data:=0;
            for J:=1 to pack do
            begin
              sizecount:=memw[fliseg:tilnow];
              inc(tilnow);
              if sizecount>0 then
              begin
                col:=mem[fliseg:tilnow];
                inc(tilnow);
                for k:=data to data+sizecount-1 do outbuf[k]:=col;
                inc(data,sizecount);
              end
            else
              begin
                sizecount:=sizecount*-1;
                for k:=0 to (sizecount-1) do outbuf[data+k]:=mem[fliseg:tilnow+k];
                inc(tilnow,sizecount);
                inc(data,sizecount);
              end;
            end; {packet loop}
            if black then
             move(mem[seg(outbuf):ofs(outbuf)],mem[where:(linenr*320)],320)
             else
             begin
             for K:=0 to 319 do
            begin
              if mem[seg(outbuf):ofs(outbuf)+k]<>0 then
              mem[where:(linenr*320)+k]:=mem[seg(outbuf):ofs(outbuf)+k];
             end;
            end;

            end; {yloop}
         {for q:=1 to fli.speed do waittrace;}
        end; {Fli_brun loop}

     end; {case stning}
  end; {ChunkNr loop}
  for q:=1 to fli.speed do waittrace;
end;  {FrameNr loop}
close(handle);
freemem(flipointer,sizeoffile);
end;


Procedure Fadeup(wait1 : word;pal : paltype);
VAR loop1,col:integer;
    r,g,b : byte;
    w :word;
    i : longint;
BEGIN
  For loop1:=1 to 64 do BEGIN
  w:=round(wait1*(70/1000));
  for I:=1 to w do begin
  asm
    mov dx,3DAh
@l1:
    in al,dx
    and al,08h
    jnz @l1
@l2:
    in al,dx
    and al,08h
    jz  @l2
end;
end;
    For col:=0 to 255 do BEGIN
      getrgb(col,r,g,b);
      If r<Pal[col].red then r:=r+1;
      If g<Pal[col].green then g:=g+1;
      If b<Pal[col].blue then b:=b+1;
      setrgb(col,r,g,b);
    END;
  END;
END;



Procedure FadeDown(wait1 : word);

VAR loop1,loop2:integer;
    Tmp : Array [1..3] of byte;
    w : word;
    i : longint;
BEGIN
  For loop1:=1 to 64 do BEGIN
  w:=round(wait1*(70/1000));
  for I:=1 to w do begin
  asm
    mov dx,3DAh
@l1:
    in al,dx
    and al,08h
    jnz @l1
@l2:
    in al,dx
    and al,08h
    jz  @l2
end;
end;
      For loop2:=0 to 255 do BEGIN
      Getrgb(loop2,Tmp[1],Tmp[2],Tmp[3]);
      If Tmp[1]>0 then Tmp[1]:=tmp[1]-1;
      If Tmp[2]>0 then Tmp[2]:=tmp[2]-1;
      If Tmp[3]>0 then Tmp[3]:=tmp[3]-1;
      setrgb(loop2,Tmp[1],Tmp[2],Tmp[3]);
       END;
   END;
END;

function getflispeed(var point : pointer) : word;
const
  FliVersion     = $AF11;
  FlcVersion     = $AF12;

var
s,version,fliseg,fliofs : word;

begin
fliseg:=seg(point^);
fliofs:=ofs(point^);
version:=memw[fliseg:fliofs+4];
s:=memw[fliseg:fliofs+16];
if version=FlCversion then s:=round((s/1000)*70);
getflispeed:=s;
end;


function getflispeed_fromfile(filename:string) : word;
const
  FliVersion     = $AF11;
  FlcVersion     = $AF12;

var
  s,version,fliseg,fliofs : word;
  f:file;
  buf : array[0..19] of byte;
{returns in video ticks}
begin
assign(f,filename);
reset(f,1);
blockread(f,buf[0],20);
close(f);
version:=memw[seg(buf):ofs(buf)+4];
s:=memw[seg(buf):ofs(buf)+16];
if version=FlCversion then s:=round((s/1000)*70);
getflispeed_fromfile:=s;
end;



procedure initfli(filename:string;var point : pointer;var size : word);
var
handle :file;
begin
assign(handle,filename);
reset(handle,1);
size:=filesize(handle);
if (size mod 2 = 1) then begin
inc(size);
getmem(point,size);
blockread(handle,point^,size-1);
end
else
begin
getmem(point,size);
blockread(handle,point^,size);
end;
close(handle);
end;

procedure viewgif(filename:string;changepal:boolean;where:word);

const
back : word = 0;
bufrow : word = 0;
firstcode : boolean = true;

var
i : integer;
outbuf : array[0..1023] of byte;
clearcode : word;
endcode : word;
codetable : array[0..4096] of
record
 first : byte;
 new   : byte;
 refer : word;
end;
row : (r8th0,r8th4,r4th2,r2nd1);
giffile : file;
gifseg,gifofs : word;
gifpointer : pointer;
sizeoffile : longint;
screeny : word;
backcolor : byte;
extension:Boolean;
localmap,globalmap : boolean;
bitsperpix : byte;
totalcolors : word;
pal : paltype;
fromleft : word;
fromtop : word;
imagex : word;
imagey : word;
what : word;
w1:word;
sequen : boolean;
add : word;
codesize : byte;
curstring : array[0..500] of byte;
count : word;
bufcount : word;
bytecount : byte;
svgaon:boolean;
 bytesleft : word;
 bytesread : word;
 hicode : word;
 oldcode : word;
 newcode : word;
 ofsfile :word;
 blokbyte : byte;
 bitpos  : byte;
 out : word;
 n,number : integer;
label
endit,incblock,next;

procedure buf2screen;
var
place:word;
begin
  place:=where;
  bufcount:=0;
    asm
      cld
      mov cx,[screenx]
      mov si,[bufofs]
      mov ax,[place]
      mov es,ax
      mov di,[bufrow]
      mov dx,di
      shl di,8
      shl dx,6
      add di,dx
      mov ax,[bufseg]
      push ds
      mov ds,ax
      mov ax,cx
      and ax,1
      cmp ax,1
      jne  @vid
      movsb
      dec cx
      @vid:
      shr cx,1
      rep movsw
      pop ds
      inc [bufrow]
    end;
end;

procedure translate(out : word);
var
n,number : word;
what : word;
begin
  what:=out;
  number:=0;
  repeat
  curstring[number]:=codetable[what].new;
  out:=what;
  what:=codetable[what].refer;
  number:=number+1;
  until codetable[out].refer=5000;
 for n:=0 to (number-1) do
 begin
  outbuf[bufcount]:=curstring[number-1-n];
  bufcount:=bufcount+1;
  if bufcount=screenx then buf2screen;
 end;
end;

procedure interlac(out : word);
{ row : (r8th0,r8th4,r4th2,r2nd1);}
var
n,number : word;
what : word;
label
endcase;

begin
  what:=out;
  number:=0;
  repeat
  curstring[number]:=codetable[what].new;
  out:=what;
  what:=codetable[what].refer;
  number:=number+1;
  until codetable[out].refer=5000;
 for n:=0 to (number-1) do
 begin
   outbuf[bufcount]:=curstring[number-1-n];
    bufcount:=bufcount+1;
   if bufcount=screenx then
   begin
     buf2screen;
     dec(bufrow);
     case row of
     r8th0:inc(bufrow,8);
     r8th4:inc(bufrow,8);
     r4th2:inc(bufrow,4);
     r2nd1:inc(bufrow,2);
     end;{case}
   if bufrow>(screeny-1) then begin
   case row of
     r8th0: begin
            row:=r8th4;
            bufrow:=4;
            goto endcase;
            end;
     r8th4:begin
            bufrow:=2;
            row:=r4th2;
            goto endcase;
            end;
     r4th2:begin
           row:=r2nd1;
           bufrow:=1;
           goto endcase;
           end;
    end;
    endcase:
   end;
   end;
 end;
end;

procedure init;
var
q : word;
begin
for q:=0 to (totalcolors-1) do
begin
  codetable[q].refer:=5000;
  codetable[q].new:=q;
  codetable[q].first:=q;
end;
  clearcode:=totalcolors;
  endcode:=totalcolors+1;
  hicode:=endcode;
end;

begin
bufseg:=seg(outbuf[0]);
bufofs:=ofs(outbuf[0]);
bufcount:=0;
assign(giffile,filename);
reset(giffile,1);
sizeoffile:=filesize(giffile);
GetMem(gifpointer,sizeoffile);
BlockRead(giffile,gifpointer^,sizeoffile);
gifseg:=seg(gifpointer^);
gifofs:=ofs(gifpointer^);
screenx:=memw[gifseg:gifofs+6];
screeny:=memw[gifseg:gifofs+8];
backcolor:=mem[gifseg:gifofs+11];
bitsperpix:=(mem[gifseg:gifofs+10] and 7) +1;
totalcolors:=1 shl bitsperpix;
if (mem[gifseg:gifofs+10] and 128)=128 then globalmap:=true else globalmap:=false;
add:=13;
if globalmap then
begin
  {add:=782;}
  add:=add+(totalcolors*3);
  for I:=0 to (totalcolors-1) do
  begin
    pal[i].red:=mem[gifseg:gifofs+13+i*3] shr 2;
    pal[i].green:=mem[gifseg:gifofs+14+i*3] shr 2;
    pal[i].blue:=mem[gifseg:gifofs+15+i*3] shr 2;
  end;
end;
{gif extension block check }
extension:=false;
if mem[gifseg:gifofs+add]=33 then
begin
extension:=true;
inc(add,2);
repeat
bytecount:=mem[gifseg:gifofs+add];
inc(add,bytecount+1);
until bytecount=0;
inc(add);
end
else inc(add); {if no gif extension}
imagex:=memw[gifseg:gifofs+add+4];
imagey:=memw[gifseg:gifofs+add+6];
inc(add,8);
{add = 790}
if (mem[gifseg:gifofs+add] and 64)=0 then sequen:=true else sequen:=false;
if (mem[gifseg:gifofs+add] and 128)=1 then localmap:=true else localmap:=false;
inc(add);
if localmap=false then
begin
codesize:=mem[gifseg:gifofs+add]+1;
inc(add);
end
else
begin
{add = 791}
bitsperpix:=(mem[gifseg:gifofs+add-1] and 7)+1;
totalcolors:=1 shl bitsperpix;
  for I:=0 to (totalcolors-1) do
  begin
    pal[i].red:=mem[gifseg:gifofs+add+i*3] shr 2;
    pal[i].green:=mem[gifseg:gifofs+add+1+i*3] shr 2;
    pal[i].blue:=mem[gifseg:gifofs+add+2+i*3] shr 2;
  end;
inc(add,3*totalcolors);
codesize:=mem[gifseg:gifofs+add]+1;
inc(add);
end;



bufrow:=0;
if changepal then
begin
setrgb(backcolor,0,0,0);
cls(backcolor,where);
setpal(pal);
end;
init;
row:=r8th0;
  ofsfile:=add;
  clearcode:=1 shl (codesize-1);
  endcode:=clearcode+1;
  blokbyte:=mem[gifseg:gifofs+ofsfile];
  ofsfile:=ofsfile+1;
  bytesread:=0;
  bitpos:=0;
  repeat
  {ls bits}
  asm
    mov  es,[gifseg]
    mov  di,[gifofs]
    add  di,[ofsfile]
    xor  dl,dl
    mov  [newcode],0
    @mainloop:
    mov  bl,es:[di]
    mov  ax,1
    mov  cl,[bitpos]
    shl  ax,cl
    and  bl,al
    cmp  bl,al
    jne  @bit0
    mov  cl,dl
    mov  al,1
    shl  ax,cl
    add [newcode],ax
    @bit0:
    inc  [bitpos]
    cmp  [bitpos],7
    jbe  @dont
    inc  [ofsfile]
    inc  di
    inc  [bytesread]
    mov  [bitpos],0
    mov  al,[blokbyte]
    xor  ah,ah
    cmp  ax,[bytesread]
    jne  @dont
    mov  al,es:[di]
    mov  [blokbyte],al
    mov  [bytesread],0
    inc  [ofsfile]
    inc  di
    @dont:
    inc  dl
    cmp  dl,[codesize]
    jb  @mainloop
   end;
  if newcode=endcode then goto next;
  if newcode=clearcode then
  begin
  init;
  codesize:=bitsperpix+1;
  firstcode:=true;
  goto next;
  end;
  if sequen and firstcode then begin
    outbuf[bufcount]:=newcode;
    bufcount:=bufcount+1;
    if bufcount=screenx then buf2screen;
    oldcode:=newcode;
    firstcode:=false;
    goto next;
   end; {firstcode check - sequence}
  if (sequen=false) and firstcode then
  begin
    outbuf[bufcount]:=newcode;
    bufcount:=bufcount+1;
    oldcode:=newcode;
    firstcode:=false;
   if bufcount=screenx then
   begin
     buf2screen;
     bufrow:=bufrow-1;
     case row of
     r8th0:inc(bufrow,8);
     r8th4:inc(bufrow,8);
     r4th2:inc(bufrow,4);
     r2nd1:inc(bufrow,2);
     end;{case}
   if bufrow>(screeny-1) then begin
   case row of
     r8th0: begin
            row:=r8th4;
            bufrow:=4;
            goto next;
            end;
     r8th4:begin
            bufrow:=2;
            row:=r4th2;
            goto next;
            end;
     r4th2:begin
           row:=r2nd1;
           bufrow:=1;
           goto next;
           end;
       end; {case stning}
   end; {xvalue check}
   end; {currow check}
    goto next;
  end;  {firstcode check - interlaced}
   {its a new code in the stringtable}
    if (newcode>hicode) then
    begin
    hicode:=hicode+1;
    codetable[hicode].new:=codetable[oldcode].first;
    codetable[hicode].first:=codetable[oldcode].first;
    codetable[hicode].refer:=oldcode;
    if sequen then translate(hicode)
    else interlac(hicode);
    oldcode:=newcode;
    end
    else
    {code already exits in stringtable}
    begin
    hicode:=hicode+1;
    codetable[hicode].refer:=oldcode;
    codetable[hicode].new:=codetable[newcode].first;  {frst af newcode;}
    codetable[hicode].first:=codetable[oldcode].first;{frst af oldcode;}
    if sequen then translate(newcode)
    else interlac(newcode);
    oldcode:=newcode;
    end;
     if hicode=((1 shl codesize)-1)
   then codesize:=codesize+1;
   if codesize>12 then codesize:=12;
   next:
  until newcode=endcode;
freemem(gifpointer,sizeoffile);
close(giffile);
end;





end.
