UNIT FASTTEXT;
{ A FAST TEXT MODE  (80x25x16C - textmode) LIBRARY BY ZAIFRUN}

INTERFACE

PROCEDURE WRITECHAR(X,Y:BYTE;ASCII:CHAR;FORGROUND,BACKGROUND : BYTE);
PROCEDURE SET50LINES;
PROCEDURE SET25LINES;
PROCEDURE SETTEXT;
PROCEDURE FILLSCREEN(COLOR :BYTE);
PROCEDURE FILLLINE(LINE,COLOR:BYTE);
PROCEDURE BLINKON;
PROCEDURE BLINKOFF;
PROCEDURE CURSOROFF;
PROCEDURE CURSORON;
PROCEDURE WRITESTRING(X,Y:BYTE;WHAT : STRING;FORGROUND,BACKGROUND:BYTE);
PROCEDURE MAKEWINDOW(X,Y,XEND,YEND,COLOR,FRAMECOLOR:BYTE;Shadow : Boolean;Headline : string);
PROCEDURE MAKEBACKGROUND(COLOR:BYTE);
PROCEDURE Getpic(X,Y,XEND,YEND : BYTE;var Size : word; var Point : pointer);
PROCEDURE PutPic(X,Y :byte;var Size : word;var Point : pointer; free : boolean);
PROCEDURE SHOWPAL;
PROCEDURE MOVECURSOR(X,Y:BYTE);
PROCEDURE MOVECOLOR(SOURCE,DEST:BYTE);
procedure waittrace;
Function  GetCursorx:byte;
Function  GetCursory:byte;
Procedure MakeHBorder(line,x1,x2,forcolor,backcolor:byte);
Procedure MakeVBorder(x,y1,y2,forcolor,backcolor:byte);
PROCEDURE WRITEBACKCOL(X,Y,COL:BYTE);

IMPLEMENTATION


{ ascii 178 = turbo pascal background }
TYPE
  buftype = array[1..4000] of byte;

CONST
   TEXTSEG : Word = $B800;

var
   YSIZE   : byte;


PROCEDURE SET50LINES; assembler;
asm
  mov  ax,1112h
  xor  bl,bl
  int  10h
  mov  [Ysize],50
end;

PROCEDURE SET25LINES; assembler;
asm
  mov  ax,1114h
  xor  bl,bl
  int  10h
  mov  [Ysize],25
end;

Procedure MakeHBorder(line,x1,x2,forcolor,backcolor:byte);
var
  j:integer;
begin
  writechar(x1,line,#204,forcolor,backcolor);
  writechar(x2,line,#185,forcolor,backcolor);
  for j:=x1+1 to x2-1 do writechar(j,line,#205,forcolor,backcolor);
end;

Procedure MakeVBorder(x,y1,y2,forcolor,backcolor:byte);
var
  j:integer;
begin
  writechar(x,y1,#203,forcolor,backcolor);
  writechar(x,y2,#202,forcolor,backcolor);
  for j:=y1+1 to y2-1 do writechar(x,j,#186,forcolor,backcolor);
end;


PROCEDURE MOVECOLOR(SOURCE,DEST:BYTE); ASSEMBLER;
asm
  mov ax,1000h
  mov bl,[DEST]
  mov bh,[SOURCE]
  int 10h
end;

Function  GetCursorx:byte; assembler;
asm
  mov  ah,3h
  xor  bh,bh
  int  10h
  mov  al,dl
end;


Function  GetCursory:byte; assembler;
asm
  mov  ah,3h
  xor  bh,bh
  int  10h
  mov  al,dh
end;


PROCEDURE SETTEXT; ASSEMBLER;
ASM
  mov  ax,3h
  int  10h
  mov  [Ysize],25
END;

PROCEDURE FILLSCREEN(COLOR :BYTE);ASSEMBLER;
ASM
  cld
  mov  cx,2000
  cmp  [ysize],25
  je   @25
  mov  cx,4000
  @25:
  mov  ax,[textseg]
  mov  es,ax
  xor  di,di
  mov  al,219
  mov  ah,[color]
  rep  stosw
END;

PROCEDURE MAKEBACKGROUND(COLOR:BYTE);ASSEMBLER;
ASM
  cld
  mov  di,160
  mov  cx,1840
  mov  ax,[textseg]
  mov  es,ax
  mov  al,178
  mov  ah,[color]
  rep  stosw
END;

PROCEDURE FILLLINE(LINE,COLOR:BYTE);ASSEMBLER;
ASM
  cld
  mov  cx,80
  mov  ax,[textseg]
  mov  es,ax
  xor  dh,dh
  mov  dl,[line]
  mov  di,dx
  shl  di,7
  shl  dx,5
  add  di,dx
  mov  al,219
  mov  ah,[color]
  rep  stosw
END;

PROCEDURE BLINKON; ASSEMBLER;
ASM
  mov  ax,1003h
  mov  bl,1
  int  10h
END;

PROCEDURE BLINKOFF; ASSEMBLER;
ASM
  mov  ax,1003h
  xor  bl,bl
  int  10h
END;

PROCEDURE CURSOROFF;ASSEMBLER;
ASM
  mov  dx,03D4h
  mov  al,0Ah
  out  dx,al
  inc  dx
  in   al,dx
  mov  bl,al
  or   bl,00100000b
  mov  al,0Ah
  dec  dx
  out  dx,al
  inc  dx
  mov  al,bl
  out  dx,al
END;

PROCEDURE CURSORON;ASSEMBLER;
ASM
  mov  dx,03D4h
  mov  al,0Ah
  out  dx,al
  inc  dx
  in   al,dx
  mov  bl,al
  and  bl,11011111b
  mov  al,0Ah
  dec  dx
  out  dx,al
  inc  dx
  mov  al,bl
  out  dx,al
END;


PROCEDURE WRITECHAR(X,Y:BYTE;ASCII:CHAR;FORGROUND,BACKGROUND : BYTE); ASSEMBLER;
ASM
  mov  ax,[textseg]
  mov  es,ax
  xor  ch,ch
  mov  cl,[y]
  mov  di,cx
  shl  di,5
  shl  cx,7
  add  di,cx
  xor  ah,ah
  mov  al,[x]
  shl  ax,1
  add  di,ax
  mov  dl,[ascii]
  { di = offset
    dl = ascii code
    dh = attribute }
  mov  dh,[forground]
  mov  al,[background]
  shl  al,4
  or   dh,al
  mov  es:[di],dx
END;

PROCEDURE WRITEBACKCOL(X,Y,COL:BYTE); ASSEMBLER;
ASM
  mov  ax,[textseg]
  mov  es,ax
  xor  ch,ch
  mov  cl,[y]
  mov  di,cx
  shl  di,5
  shl  cx,7
  add  di,cx            {multiply y with 160}
  xor  ah,ah
  mov  al,[x]
  shl  ax,1
  add  di,ax            {add 2*xvalue}
  inc  di
  mov  cl,es:[di]       {get old attribute}
  { di = offset
    dl = ascii code
    dh = attribute }
  and  cl,00001111b     {filter out old background}
  mov  al,[col]
  shl  al,4
  or   cl,al            {do new background}
  mov  es:[di],cl
END;

PROCEDURE WRITESTRING(X,Y:BYTE;WHAT : STRING;FORGROUND,BACKGROUND:BYTE);
VAR
  I: BYTE;
BEGIN
FOR I:=1 TO ORD(WHAT[0]) DO WRITECHAR(X+I-1,Y,WHAT[I],FORGROUND,BACKGROUND);
END;

PROCEDURE MAKEWINDOW(X,Y,XEND,YEND,COLOR,FRAMECOLOR:BYTE;SHADOW:BOOLEAN;HeadLine:string);
VAR
  l,I,J : BYTE;
BEGIN
  WRITECHAR(X,Y,'',FRAMECOLOR,COLOR);
  WRITECHAR(X,YEND,'',FRAMECOLOR,COLOR);
  WRITECHAR(XEND,Y,'',FRAMECOLOR,COLOR);
  WRITECHAR(XEND,YEND,'',FRAMECOLOR,COLOR);
  FOR I:=X+1 TO XEND-1 DO WRITECHAR(I,Y,'',FRAMECOLOR,COLOR);
  FOR I:=X+1 TO XEND-1 DO WRITECHAR(I,YEND,'',FRAMECOLOR,COLOR);
  FOR I:=Y+1 TO YEND-1 DO WRITECHAR(X,I,'',FRAMECOLOR,COLOR);
  FOR I:=Y+1 TO YEND-1 DO WRITECHAR(XEND,I,'',FRAMECOLOR,COLOR);
  FOR I:=X+1 TO XEND-1 DO
    FOR J:=Y+1 TO YEND-1 DO
      WRITECHAR(I,J,' ',COLOR,COLOR);
  IF SHADOW THEN BEGIN
    FOR i:=X+1 TO XEND+1 DO WRITECHAR(I,YEND+1,'',0,0);
    FOR i:=Y+1 TO YEND+1 DO WRITECHAR(XEND+1,I,'',0,0);
    FOR i:=Y+1 TO YEND+1 DO WRITECHAR(XEND+2,I,'',0,0);
  END;
  If Headline<>'' then
  begin
    l:=length(headline);
    j:=X+((Xend-X-l)div 2);
    writestring(j,Y,HeadLine,FrameColor,Color);
  end;

END;



procedure PutPic(X,Y :byte;var Size : word;var Point : pointer; free : boolean);
var
count,xlen : word;
ylen : byte;
segp,ofsp : word;
begin
segp:=seg(point^);
ofsp:=ofs(point^);
ylen:=mem[segp:ofsp+1];
xlen:=mem[segp:ofsp];
asm
  mov  ax,[textseg]
  mov  es,ax
  mov  dl,[y]
  xor  dh,dh
  mov  di,dx
  shl  di,7
  shl  dx,5
  add  di,dx
  mov  al,[x]
  xor  ah,ah
  shl  ax,1
  add  di,ax
 {di = screen offset}
  mov  si,[ofsp]
  inc  si
  inc  si

  mov  bx,[xlen]
  xor  dl,dl
  mov  dh,[ylen]
  mov  ax,[segp]
  push ds
  mov  ds,ax
@yloop:
  mov  cx,bx
  rep  movsw
  add  di,160
  sub  di,bx
  sub  di,bx
  inc  dl
  cmp  dl,dh
  jb   @yloop
  pop  ds
end;
if free then freemem(point,size);
end;

Procedure Getpic(X,Y,XEND,YEND : BYTE;var Size : word; var Point : pointer);
var
  buffer : ^buftype;
  count :word;
  ofsp,segp : word;
begin
Size:=2*(1+xend-x)*(1+yend-y)+2;
getmem(buffer,size);
segp:=seg(buffer^);
ofsp:=ofs(buffer^);
point:=ptr(seg(Buffer^),ofs(Buffer^));
asm
  cld
  mov  ax,[segp]
  mov  es,ax
  mov  di,[ofsp]
  mov  ah,[xend]
  mov  al,[x]
  cmp  ah,al
  jae  @vid
  xchg ah,al
 @vid:
  mov  dh,[yend]
  mov  dl,[y]
  cmp  dh,dl
  jae  @vid1
  xchg dh,dl
 @vid1:
  mov  bl,ah
  sub  bl,al
  inc  bl
  mov  es:[di],bl
  inc  di
  mov  bh,dh
  sub  bh,dl
  inc  bh
  mov  es:[di],bh
  inc  di
 {cal startoffset
  dh = yend
  dl = y
  ah = xend
  al = x
  es = segp
  di = ofsp
  bl = xlen
  bh = ylen
 }
  mov  cl,dl
  xor  ch,ch
  mov  si,cx
  shl  si,5
  shl  cx,7
  add  si,cx
  mov  cl,al
  xor  ch,ch
  shl  cx,1
  add  si,cx
 {si = startoffset   }
  xor  bh,bh
 {frie = ax,cx}
  push ds
  mov  cx,[textseg]
  mov  ds,cx
  xor  ch,ch
@yloop:
  mov  cl,bl
  rep  movsw
  add  si,160
  sub  si,bx
  sub  si,bx
  inc  dl
  cmp  dl,dh
  jbe  @yloop
  pop  ds
end;

end;

procedure waittrace; assembler;
asm
  mov dx,3DAh
@l1:
  in  al,dx
  and al,08h
  jnz @l1
@l2:
  in al,dx
  and al,08h
  jz  @l2
end;


PROCEDURE SHOWPAL;
VAR
  i : BYTE;
BEGIN
  FOR I:=0 TO 15 DO WRITECHAR(I,0,'',I,0);
  Writestring(0,1,'0 2 4 6 8 0 2 4',15,0);
END;

PROCEDURE MOVECURSOR(X,Y:BYTE); ASSEMBLER;
ASM
  mov  ah,2h
  xor  bh,bh
  mov  dh,[y]
  mov  dl,[x]
  int  10h
END;


BEGIN
  Ysize:=25;
END.