Unit NetFame;

InterFace

const
  hallfamefile = 'netmaze.dat';
  maxFame=8;
  OldFameSize = 112; {size of hallfame file  -  old value}
  NewFameSize = 152; {size of hallfame file  -  new value}

Type
  TankType = (GreenTank,BlueTank,RedTank,YellowTank,whitetank,
              VioletTank,OrangeTank,browntank);

  HallFameType = array[1..maxFame] of
                   record
                     Score  : integer;
                     Kills  : integer;
                     {Death = kills-score}
                     Name   : string[8];
                     Tank   : TankType;
                     Hits   : byte; { hits in percent}
                     reserved : longint; {not used yet}
                   end;
var
 I,j:integer;
 GreatFame,HallFame:HallFameType;
 FameFile:file of hallfametype;
 NewFameNr:integer;
 NewhiScore:Boolean;
 OwnKills:integer;
 OwnScore:integer;
 ownhits:byte;
 ownhandle:string[8];
 SendFameData:Boolean;
 TotalDeaths:integer;
 TotalShots:longint;
 par1,par2,par3  : string;
 terminated:boolean;

Procedure LoadFame(var Fame:HallFametype);
Procedure SaveFame(var TheFame:HallFameType);
Procedure DisplayFame(var TheFame:HallFameType);
Procedure CreateNewFame;
Procedure SortFameData;
Procedure CheckHallFameFile;

Implementation

Uses
  FastText,FastDraw,util;


Procedure CheckHallFameFile;
var
 f:file;
 l,s:longint;
 arpointer:word;
 tbyte:byte;
 ar:array[0..160] of byte;
begin
  assign(f,hallfamefile);
  reset(f,1);
  if (filesize(f)<>sizeof(HallFameType)) and (filesize(f)<>oldfamesize) then
  begin
    writeln('The file "'+hallfamefile+'" is corrupt');
    Endprogram;
  end;
  s:=filesize(f);
  if s=oldfamesize then  {convert}
  begin
    reset(f,1);
    blockread(f,ar[0],oldfamesize);
    reset(f,1);
    arpointer:=0;
    l:=0;
    for s:=1 to maxfame do
    begin
      blockwrite(f,ar[arpointer],14);
      inc(arpointer,14);
      tbyte:=150; {150 = n/a not defined - pertange}
      blockwrite(f,tbyte,1);
      blockwrite(f,l,4);
    end;
  end;
  close(f);
end;

Procedure SortFameData;
{merge hallfame and greatfame into greatfame}
var
  k:integer;
  resbol:boolean;

Procedure CheckNewFame(var thefame:hallfametype;index:byte);
var
  found:boolean;
  q,t:integer;

begin
    found:=false;
    t:=1;
    while (t<=maxfame) and (found=false) do
    begin
      if thefame[index].score>greatfame[t].score then
      begin
        for q:=(maxfame-1) downto i do
          GreatFame[q+1]:=Greatfame[q];
        GreatFame[t].score:=TheFame[index].score;
        GreatFame[t].kills:=Thefame[index].kills;
        GreatFame[t].name:=TheFame[index].name;
        GreatFame[t].Tank:=TheFame[index].tank;
        GreatFame[t].hits:=TheFame[index].hits;
        found:=true; {skip loop}
      end;
      inc(t);
    end;
end;


begin
  for I:=1 to maxfame do
  begin
    k:=1;
    resbol:=false;
    while (k<=maxfame) and (resbol=false) do
    begin
      if (hallfame[i].name=greatfame[k].name)
      and (hallfame[i].score=greatfame[k].score)
      and (hallfame[i].tank=greatfame[k].tank)
      and (hallfame[i].kills=greatfame[k].kills)
      and (hallfame[i].hits=greatfame[k].hits) then resbol:=true;
      inc(k);
    end;
    if (resbol=false) and (hallfame[i].score>greatfame[maxfame].score) then
    {it's not already in greatfame}
    begin
      CheckNewFame(hallfame,i);
    end;
  end; {for i....}
 {GreatFame er opdateret}
end; {sortfamedata}

Procedure LoadFame(var Fame:HallFametype);
begin
  assign(FameFile,Hallfamefile);
  reset(famefile);
  read(famefile,Fame);
  close(famefile);
  for I:=1 to maxfame do
  begin
    for j:=1 to length(Fame[i].name) do
      Fame[i].name[j]:=chr(255-ord(Fame[i].name[j]));
  end;
end;

Procedure SaveFame(var TheFame:HallFameType);
begin
  assign(FameFile,Hallfamefile);
  rewrite(famefile);
  for I:=1 to maxfame do
  begin
    for j:=1 to length(thefame[i].name) do
      thefame[i].name[j]:=chr(255-ord(thefame[i].name[j]));
  end;
  write(famefile,thefame);
  close(famefile);
end;

Procedure DisplayFame(var TheFame:HallFameType);
 {start to write highscore list at x,10 }
const
  startx = 4;
  starty = 11;
var
  outcolor:byte;
  tempstr:string[10];
  r,r1:single;
  g:integer;
begin
 setrgb(22,63,40,0);
 movecolor(22,13); {rank   name  kills   deaths  hits score}
 writestring(18,starty,'Netmaze masters of all times',7,0);
 writestring(startx,starty+2,'Rank',7,0);
 writestring(startx+9,starty+2,'Name',7,0);
 writestring(startx+18,starty+2,'Kills',7,0);
 writestring(startx+27,starty+2,'Deaths',7,0);
 writestring(startx+35,starty+2,'Hits',7,0);
 writestring(startx+42,starty+2,'Score',7,0);
 for I:=1 to maxfame do
 begin
{  case thefame[i].tank of
     Greentank  :  OutColor:=10;
     BlueTank   :  OutColor:=9;
     RedTank    :  OutColor:=12;
     YellowTank :  OutColor:=14;
     WhiteTank  :  OutColor:=15;
     VioletTank :  OutColor:=5;
     OrangeTank :  OutColor:=13;
     BrownTank  :  OutColor:=6;
   end; {case}
  case  i  of
     1  :  OutColor:=10;
     2  :  OutColor:=9;
     3  :  OutColor:=12;
     4  :  OutColor:=14;
     5  :  OutColor:=15;
     6  :  OutColor:=5;
     7  :  OutColor:=13;
     8  :  OutColor:=6;
  end; {case}
   str(i,tempstr);
   writestring(startx+1,starty+3+i,tempstr+'.',outcolor,0);
   writestring(startx+8,starty+3+i,thefame[i].name,outcolor,0);
   str(thefame[i].kills,tempstr);
   writestring(startx+19,starty+3+i,tempstr,outcolor,0);
   str(thefame[i].kills-thefame[i].score,tempstr);
   writestring(startx+28,starty+3+i,tempstr,outcolor,0);
   if thefame[i].hits<>150 then
   begin
     str(thefame[i].hits,tempstr);
     writestring(startx+36,starty+3+i,tempstr+'%',outcolor,0);
   end else writestring(startx+36,starty+3+i,'---',outcolor,0);
   str(thefame[i].score,tempstr);
   writestring(startx+43,starty+3+i,tempstr,outcolor,0);
 if newfamenr=i then
   writestring(startx+49,starty+3+i,'<-- You got a new hiscore!',outcolor+128,0);
 end;

  if (par1<>'viewfame') then
    begin
     {you}
     i:=9;
     outcolor:=7;
     writestring(startx+1,starty+3+i,'You',outcolor,0);
     writestring(startx+8,starty+3+i,ownhandle,outcolor,0);
     str(ownkills,tempstr);
     writestring(startx+19,starty+3+i,tempstr,outcolor,0);
     str(totaldeaths,tempstr);
     writestring(startx+28,starty+3+i,tempstr,outcolor,0);
     str(ownhits,tempstr);
     writestring(startx+36,starty+3+i,tempstr+'%',outcolor,0);
     str(ownscore,tempstr);
     writestring(startx+43,starty+3+i,tempstr,outcolor,0);
     str(totalshots,tempstr);
     writestring(startx+50,starty+3+i,'Shots : '+tempstr,outcolor,0);
   end;
  if terminated then
  begin
    writestring(startx+1,starty+4+i,'Sorry, but you were terminated due to a bad connection - try again',7,0);  end;
end;

Procedure CreateNewFame;
begin
  assign(FameFile,Hallfamefile);
  rewrite(famefile);
  for I:=1 to maxfame do
  begin
    HallFame[i].Score:=(maxfame*3+3)-(i*3);
    HallFame[i].Name:='Zaifrun';
    for j:=1 to length(hallfame[i].name) do
      hallfame[i].name[j]:=chr(255-ord(hallfame[i].name[j]));
    HallFame[i].Tank:=TankType(i-1);
    Hallfame[i].kills:=Hallfame[i].score*2;
    HallFame[i].hits:=150;
  end;
  write(famefile,HallFame);
  close(famefile);
end;

begin
end.
