;----------------------------------------------
; Cpu detection code - file is used in util.pas
;----------------------------------------------

.model small
  jumps
  local @@


.data
  control dw 0


.code

.586

public detectfpu
public detectmmx
public detectcpu    ; Note - this routine is not 100% made by me
                    ; - I don't know the author



DetectCpu proc far
;--------------
; Returns in al
; 0 = 286 or below
; 1 = 386
; 2 = 486
; 3 = 586 (pentium or pentium pro) without mmx
; 4 = 586 with MMX
;--------------

  PUSHF
  MOV    AX,7000h
  PUSH   AX
  POPF
  PUSHF
  POP    AX
  AND    AX,7000h
  JZ     @@ok
  MOV    AX,1
@@ok:
  POPF
  cmp  ax,0     ; is it below a 386?
  je   @@finish ; It is below a 386
 ; Lets see if its a 386 or 486 or 586
 ; Distinguish an 80386 from an 80486. Bit 18 (40000H) of EFLAGS register
 ; is used only in the 486. This code flips it and tests if anything happened
   mov     edx,esp         ; Save stack pointer
   and     esp,not 3       ; Align stack pointer to prevent a fault
                           ;  when we set the AC flag on a 486
   pushfd                  ; Copy the EFLAGS register
   pop     eax            ;   into register eax
   mov     ecx,eax         ; Save the original EFLAGS value
   xor     eax,40000H      ; Flip the AC flag bit
   push    eax             ; Try to put the modified value back
   popfd                   ;   into the EFLAGS register
   pushfd                  ; Copy the EFLAGS register again
   pop     eax             ;   into eax
   xor     eax,ecx         ; Compare the old and new AC bits
   shr     eax,18          ; Shift and mask to get the AC comparison bit
   and     eax,1           ;   in the low order position of eax
   push    ecx
   popfd                   ; Restore EFLAGS that were saved on entry
   mov     esp,edx         ; And restore stack pointer to saved value
   mov     bx,ax           ; and move into bx
; At this point ax = 0 for a 386, or ax = 1 for a 486
   cmp     ax,0
   jne     @@pentiumcheck
   mov     ax,1
   jmp     @@finish
@@pentiumcheck:
; Distinguish between the i486 and Pentium by the ability to set the ID flag
; in the EFLAGS register. If the ID flag is set, then we can use the CPUID
; instruction to determine the final version of the chip. Otherwise we
; simply have an 80486.
; debugged so far
   pushfd                  ; push original EFLAGS
   pop     eax             ; get original EFLAGS in eax
   mov     ecx,eax         ; save original EFLAGS in ecx
   or      eax,200000h     ; flip ID bit in EFLAGS
   push    eax             ; save for EFLAGS
   popfd                   ; copy to EFLAGS
   pushfd                  ; push EFLAGS
   pop     eax             ; get new EFLAGS value
   push    ecx
   popfd                   ; Restore EFLAGS that were saved on entry
   xor     eax,ecx
   jnz     @@nexttest      ; We have an old i486 (flag would not set)
   mov     ax,2
   jmp     @@finish
@@nexttest:
; Now execute the CPUID instruction to determine the vendor, family, model
; and stepping (some new 486's answer to the CPUID test also).
	mov     eax,1           ; set up for CPUID instruction
        cpuid
	and     eax,0F00H       ; mask everything but family
	shr     eax,8
	cmp     al,5
	jl      @@486
        ; okay we have a pentium
        ; now check if mmx is available
        mov  eax,1
        cpuid
        xor  al,al
        test edx,00800000h
        jz  @@nommx
        mov  ax,4    ; yes mmx is there
        jmp  @@finish
      @@nommx:
        mov   ax,3    ; no mmx this time
        jmp     @@finish
        @@486:
        mov     ax,2             ; We have an i486
@@finish:
  ret
DetectCpu endp

; Returns al = 0 if no fpu is installed
; al = 1 if there is a fpu installed

detectfpu proc far
  FINIT
  FSTCW Control
  xor   al,al
  cmp   byte ptr [control+1],3
  jne   @not
  inc   al
@not:
  ret
detectfpu endp

; Returns al = 0 if mmx is NOT supported
; al = 1 if there is support for mmx

detectmmx proc far
   mov  eax,1
   cpuid
   xor  al,al
   test edx,00800000h
   jz  @@endit
   mov  al,1
@@endit:
   ret
detectmmx endp


end
