program netmaze;
{$N-,E+}
{version 3.7 - copyrights belong to Martin Knudsen}
{$M 30000,0,160000}

uses
  util,fastdraw,newipx,fasttext,netfame,
  cputype,netsound, crt; {new in v.37}

{Speed values so far
 NetSpeed :
 486dx2   66MHz = 34 ticks
 386sx    16MHz = 84 ticks
 486sx3   75MHz = 34 ticks
 486dx    33MHz = 34 ticks
 pentium  75MHz = 34 ticks
 pentium 133MHz = 34 ticks

 CpuSpeed :
 486dx2   66MHz = 30 ticks
 386sx    16MHz = 189 ticks
 486sx3   75MHz = 23 ticks
 486dx    33MHz = 63 ticks
 pentium  75MHz = 25 ticks
 pentium 133MHz = 14 ticks
}

const
  gotit:word = 0;
  sentfirstinfo:Boolean=false;
  gotfirstinfo:boolean=false;
  {debug & test consts}
  EnableTerrain : boolean = true;
  {other const}
  betaversion  = 'a';
  picturename  = 'netmaze.pcx';
  ReleaseDate  = '23/10 1997';
  coinwait      = 0;  {1/1000 sec to waiT with coin}
  timeout        = 10; {clock ticks before a computer is considered dead}
  waitsallowed   = 5; {number of timeouts allowed before dead}
  timeoutmaster  = 108; {clock ticks before a master is considered dead}
  netversion  : word = $0308;  {3.7}
  maxplayer   = 8;
  minx        = 2;  {2}
  maxx        = 227; {227}
  miny        = 2; {2}
  maxy        = 187; {187}
  shotlen     = 6; {normal weapons}
  Smissilelen = 17; {smissile}
  SmissileWid = 2;  {smissile extra pixels to each side}
  playerlen   = 10;
  playerlen2  = 5;
  shotspeed   :  byte = 3;
  playerspeed :  byte = 1;
  smissilespeed = 4;
  spacex      = 11; {vrdi fra maxx til kanten}
  spacey      = 11; {vrdi fra maxy til kanten}
  treeadd     = 13;
  rockaddx    = 11;
  rockaddy    = 12;
  keyboardint = $09;
  timerint    = $08;
  maxweapon   = 3;
  nrofpacks   = 12;
  whitecol    = 215;
  bluecol     = 230;
  coinxlen    = 9;
  coinylen    = 8;
  maxterrain  = 9; {max number of terrains in game}
  MaxGround   = 4;  {max number of different terrains}
  minterrain  = 3;  {min number of terrains in game}
  multilen    = 4;  {multishot extra pixels to each side}
  TimeSinceBonus = 240;{450; {clock ticks = 30 sekunder}
  Shieldduration = 18;{54;  {clock ticks - equals about 3 secs}
  LargeShieldDuration = 110;  {+shieldduration}
  ShieldShift    = 8;  {9;ticks before shifting shield color}
 {farver som jeg bruger - 230-250}
  shieldcol : array[1..maxplayer] of byte = (32,41,35,36,46,42,39,217);
type
  artype = array[1..nrofpacks] of byte;
  dirtype = (up,down,left,right,none,quit);
  specialtype = (nothing,multishot,smissile,shield);
  playertype = record
                 Alive:Boolean;
                 ingame:Boolean;
                 ShieldOn:Boolean;
                 ShieldEnergy:integer;
                 master:Boolean;
                 Speed:word;
                 NetmazeVersion:word;
                 x,y:integer;
                 Node:
                 Nodetype;
                 handle : string[8];
                 color:byte;
                 dir:dirtype;
                 kills:word;
                 Notinyet:boolean;
                 PseudoSpecial,curspecial:specialtype;
                 Movement:Boolean;
                 shot : record
                          x,y:integer;
                          active:boolean;
                          dir:dirtype;
                        end;
               end;
      BonusType = record
                    SpecialOn: Boolean;
                    SpecialItem:SpecialType;
                    Specialx:integer;
                    Specialy:integer;
                    SpecialTime:longint;
                    Difference : longint;
                  end;
      GroundType = (rock,tree1,tree2,tree3);

      TerrainType = array[1..maxterrain] of
                    record
                      x,y:integer;
                      Ground:GroundType;
                    end;



var
  othershot : array[1..8] of boolean;
  PlayedGetReady:Boolean;
  KillsBefore:Word;
  bonusbefore:boolean;
  shotbefore:boolean;
  olddir : dirtype;
  ArrowkeyHit : boolean;
  Terrain       : TerrainType;
  CurrentTerrainNr : Byte;
  cheat         : array[1..6] of byte;
  cheatnr       : byte;
  Bonus         : BonusType;
  GroundBitMap : array[GroundType] of
                 record
                   bitpointer:pointer;
                   bitsize:word;
                 end;
  playerbitmap  : array[1..maxplayer] of array[dirtype] of
                  record
                    bitpointer:pointer;
                    bitsize:word;
                  end;
  tempplayer:playertype;
  OldTimerInt,oldkeyboardvec : pointer;
  CurrentTime:longint;
  players : array[1..maxplayer] of playertype;
  masternr,Ownnr:byte;
  TotalPlayers:shortint;
  ch:char;
  cha:byte;
  vir : word;
  collisionvir:word;
  vir1point : pointer;
  collisionpoint:pointer;
  I:longint;
  s:string;
  res:byte;
  OwnChangepos:boolean;
  Send:Packet;
  receive:array[1..nrofpacks] of packet;
  starttime,curtime:longint;
  oldtime:longint;
  InfoSent,IamMaster:boolean;
  GotOwnNumber:Boolean;
  talknr:integer;
  NewPlayer:boolean;
  quitok,quitok2:boolean;
  taken  : set of 1..8;
  k,l:longint;
  cpuspeed:word;
  whatsignal:artype;
  tempword:word;
  tempbyte:byte;
  tempdword:longint;
  tempstr:string;
  deathstart,deathcur : longint;
  alivelasttime:boolean;
  newnode:nodetype;
  newnr:byte;
  SMissilePointer: array[dirtype] of pointer;
  SMissileSize:    array[dirtype] of word;
  CoinPointer:pointer;
  CoinSize:word;
  masterinnerloop,guestinnerloop,updateallloop:boolean;
  stra,strb : string[10];
  ChangeMaster,masterlasttime:boolean;
  ctrlon : boolean;
  makec,breakc:longint;
  NewDirection:Dirtype;
  lastkey:word;
{  killmaster,}killplayer:boolean;
  gamenr:word;
  firsttime:boolean;
  ShieldTime:longint;
  LastDrawTime:Longint;
  ShieldLastColor:Boolean;
  Shieldbefore : boolean;
  PlayerWaits: array[1..maxplayer] of byte;
  nonetwork : boolean;

procedure handleshot;forward;
procedure quitcode;forward;
procedure doendstuff;forward;
Function TerrainCollision(x1,y1,x2,y2:integer):Boolean; forward;
Function TerrainCollisionBitmap(x1,y1,x2,y2:integer):Boolean; forward;

{$F+}
procedure calloldint(sub : pointer);
begin
  inline($9C/
      $FF/$5E/$06);
    end;
{$F-}

procedure checkctrl;
var
  curlen:word;
begin
  if (players[ownnr].shot.active=false) and (players[ownnr].ingame)
              and (players[ownnr].dir<>quit) and
                 (players[ownnr].dir<>none) then
               begin
                 players[ownnr].curspecial:=players[ownnr].PseudoSpecial;
               case players[ownnr].curspecial of
               multishot,nothing:curlen:=shotlen;
               Smissile: curlen:=Smissilelen;

               end;
               players[ownnr].shot.active:=true;

               if players[ownnr].dir=none then players[ownnr].shot.dir:=up
               else
               players[ownnr].shot.dir:=players[ownnr].dir;
               {x,y start cor}
                with players[ownnr].shot do
                begin
                  case players[ownnr].dir of
                    none,up    : begin
                              x:=playerlen div 2 + players[ownnr].x-1;
                              y:=players[ownnr].y-curlen;
                            end;
                    down  : begin
                              x:=playerlen div 2 + players[ownnr].x-1;
                              y:=players[ownnr].y+curlen+playerlen;
                            end;
                    left  : begin
                              x:=players[ownnr].x-curlen;
                              y:=players[ownnr].y+playerlen div 2-1;
                            end;
                    right : begin
                              x:=players[ownnr].x+curlen+playerlen;
                              y:=players[ownnr].y+playerlen div 2-1;
                            end;
                  end; {case}
                end; {with}
               end;  {if ctrl}
end;

{$F+}
procedure timer(flags,cs,ip,ax,bx,cx,dx,si,di,ds,es,bp : word); interrupt;
begin
  calloldint(oldtimerint);
  inc(CurrentTime);
end;

procedure keyboard(flags,cs,ip,ax,bx,cx,dx,si,di,ds,es,bp : word); interrupt;
begin
{calloldint(oldkeyboardvec);}
cha:=port[$60];
      case cha of
        {change sound volume - grey plus and minus }
        74 : if (soundvolume>0) and soundok then dec(soundvolume);
        78 : if (soundvolume<64) and soundok then inc(soundvolume);
        {movememnt}
        72 : begin ArrowkeyHit:=true;NewDirection:=up;end;
        80 : begin ArrowkeyHit:=true;NewDirection:=down; end;
        75 : begin ArrowkeyHit:=true;NewDirection:=left; end;
        77 : begin ArrowkeyHit:=true;NewDirection:=right; end;
        42,54 : Arrowkeyhit:=false; {left & right shift}
        1  : NewDirection:=quit;
        29 : begin ctrlon:=true; inc(makec); end;
        157: begin ctrlon:=false; inc(breakc); end;
        67 : if IamMaster=false then
             begin  {f9}
               asm
                 mov  al,20h
                 mov  dx,20h
                 out  dx,al
               end;
               settext;
               quitcode;
               writeln('errortype : Synchronization error');
               writeln('dir = ',byte(players[ownnr].dir));
               writeln('dirtype = (up,down,left,right,none,quit)');
               writeln('last key = ',lastkey);
               writeln('IamMaster = ',iammaster);
               writeln('killplayer = ',killplayer);
            {   writeln('killmaster = ',killmaster);}
               writeln('masterinnerloop = ',masterinnerloop);
               writeln('guestinnerloop = ',guestinnerloop);
               writeln('updatealloop = ',updateallloop);
               writeln('bonuson    = ',bonus.specialon);
               writeln('bonustime  = ',bonus.specialtime);
               writeln('bounustype = ',byte(bonus.specialitem));
               writeln('current time = ',CurrentTime);
               writeln('makecodes = ',makec);
               writeln('breakcodes = ',breakc);
               totalplayers:=0;
               for I:=1 to maxplayer do if players[i].alive
               then inc(totalplayers);
               writeln('totalplayers  = ',totalplayers+1);
               endprogram;
            end;

      end;
 if cha<128 then
 lastkey:=cha;
asm
  mov  al,20h
  mov  dx,20h
  out  dx,al
end;
end;
{$F-}



Function NewMaster:Boolean;
var
  t:integer;
  resbol:boolean;
begin
  resbol:=true;
  t:=1;
  while (t<=maxplayer) and resbol do
  begin
    if (t<>ownnr) and (players[t].alive) and
       (players[t].speed<players[ownnr].speed) then resbol:=false;
    inc(t);
  end;
  NewMaster:=resbol;
end;

procedure updateownpos;
var
 xadd,yadd:integer;
 oldy,oldx:integer;
 out:boolean;
 curdir:dirtype;
 times:byte;
begin

 if players[ownnr].shieldon and (CurrentTime>ShieldTime+ShieldDuration)
 and (players[ownnr].ingame)
 then players[ownnr].shieldon:=false;

 if players[ownnr].ingame and players[ownnr].movement then
 begin
 oldx:=players[ownnr].x;
 oldy:=players[ownnr].y;
 if (players[ownnr].dir=up) and (players[ownnr].y+2>miny) then dec(oldy,playerspeed);
 if (players[ownnr].dir=down) and (players[ownnr].y<maxy+2) then inc(oldy,playerspeed);
 if (players[ownnr].dir=left) and (players[ownnr].x+2>minx) then dec(oldx,playerspeed);
 if (players[ownnr].dir=right) and (players[ownnr].x<maxx+2) then inc(oldx,playerspeed);
 out:=false;
 times:=0;
 {if not oldx,oldy is in terrain then opdate}
 repeat
 if terraincollisionBitmap(oldx,oldy,oldx+playerlen,oldy+playerlen)=false
   then begin
     if (oldx+2>minx) and (oldx<maxx+2) then players[ownnr].x:=oldx;
     if (oldy+2>miny) and (oldy<maxy+2) then players[ownnr].y:=oldy;
     out:=true;
   end  else
   begin
     if (olddir<>players[ownnr].dir)
       and (players[ownnr].dir<>none) and
       (players[ownnr].dir<>quit) then
       begin
       {move piece until no more collisions}
       curdir:=players[ownnr].dir;
       case olddir of
       up :  case curdir of {inc(oldy,1);}
              down:   inc(oldy);
              left:   begin  inc(oldy); dec(oldx); end;
              right:  begin  inc(oldy); inc(oldx); end;
             end;
       down : case curdir of
              up:   dec(oldy);
              left:   begin  dec(oldy); dec(oldx); end;
              right:  begin  dec(oldy); inc(oldx); end;
             end;
       left :  case curdir of
              down :  begin inc(oldx); inc(oldy); end;
              up   :  begin inc(oldx); dec(oldy); end;
              right : inc(oldx);
             end;
       right : case curdir of
              down:   begin dec(oldx); inc(oldy); end;
              left:   dec(oldx);
              up:     begin dec(oldx); dec(oldy); end;
             end;{dec(oldx,1);}
      end;
       {players[ownnr].dir:=olddir;}
      end else out:=true;
   end;
   inc(times);
   until out or (times=4);
 end;
 HandleShot;
end;

procedure InitBitmaps;

const
   coinstartx  = 150;
   coinstarty  = 0;
   horizxstart = 100;
   horizystart = 0;
   vertysize=11;
   vertxsize=9;
   horizxsize=11;
   horizysize=9;
var
   t:integer;
   x,y:integer;
   b:byte;
begin
  cls(0,vir);
  viewpcx(picturename,true,vir);
  for t:=1 to maxplayer do
  begin
    get((t-1)*(vertxsize+1),0,(t-1)*(vertxsize+1)+vertxsize-1,vertysize-1
        ,playerbitmap[t,up].bitsize,playerbitmap[t,up].bitpointer,vir);
    get((t-1)*(vertxsize+1),0,(t-1)*(vertxsize+1)+vertxsize-1,vertysize-1
        ,playerbitmap[t,none].bitsize,playerbitmap[t,none].bitpointer,vir);
  end;
  {spejlvend i aksen Y=vertysize }
  for y:=0 to vertysize-1 do
  for x:=0 to (vertxsize+1)*maxplayer do
  begin
      b:=getpix(x,y,vir);
      drawpix(x,2*vertysize-1-y,b,vir);
  end;
  for t:=1 to maxplayer do
  begin
    get((t-1)*(vertxsize+1),vertysize,(t-1)*(vertxsize+1)+vertxsize-1,2*vertysize-1
        ,playerbitmap[t,down].bitsize,playerbitmap[t,down].bitpointer,vir);
  end;
  for t:=1 to maxplayer do
  begin
    get(horizxstart,horizystart+(t-1)*(horizysize+1),horizxstart+horizxsize-1
        ,horizystart+(t-1)*(horizysize+1)+horizysize-1
        ,playerbitmap[t,right].bitsize,playerbitmap[t,right].bitpointer,vir);
  end;
  {mirror in the axes x=horizxstart+horizxsize}
  for y:=horizystart to (horizysize+1)*maxplayer do
  for x:=horizxstart to horizxstart+horizxsize-1 do
  begin
      b:=getpix(x,y,vir);
      drawpix(horizxstart+horizxsize+((horizxstart+horizxsize-1)-x)+1,y,b,vir);
  end;
  for t:=1 to maxplayer do
  begin
    get(horizxstart+horizxsize+1,horizystart+(t-1)*(horizysize+1),horizxstart+2*horizxsize
        ,horizystart+(t-1)*(horizysize+1)+horizysize-1
        ,playerbitmap[t,left].bitsize,playerbitmap[t,left].bitpointer,vir);
  end;
  {get coin}
  get(coinstartx,coinstarty,Coinstartx+8,Coinstarty+7,coinsize,coinpointer,vir);
  {get small missile}
  get(160,0,176,4,smissilesize[right],smissilepointer[right],vir);
  get(179,0,194,4,smissilesize[left],smissilepointer[left],vir);
  get(160,6,164,22,smissilesize[down],smissilepointer[down],vir);
  get(166,6,170,22,smissilesize[up],smissilepointer[up],vir);
  get(166,6,170,22,smissilesize[none],smissilepointer[none],vir);
  {get ground}
get(200,0,211,12,groundbitmap[rock].bitsize,groundbitmap[rock].bitpointer,vir);
get(220,0,233,13,groundbitmap[tree1].bitsize,groundbitmap[tree1].bitpointer,vir);
get(200,20,213,33,groundbitmap[tree2].bitsize,groundbitmap[tree2].bitpointer,vir);
get(220,20,233,33,groundbitmap[tree3].bitsize,groundbitmap[tree3].bitpointer,vir);
end;


Procedure DrawPlayerInfo;
var
 y:integer;
 st:string;
 winnr:integer;
 maxkills:integer;
 sort : array[1..maxplayer] of record
          nr : byte;
          kills : integer;
        end;
  t,j :integer;

begin
  printstring(maxx+25,0,'NetMaze',whitecol,vir);
  printstring(maxx+25,10,'Ver '+stra+'.'+strb+betaversion,whitecol,vir);
  {sort players after score}
  for I:=1 to maxplayer do sort[i].nr:=0;
  for I:=1 to maxplayer do sort[i].kills:=-1;
  for i:=1 to maxplayer do
  begin
    if players[i].alive then
    begin
      for j:=1 to maxplayer do
      begin
        if players[i].kills>sort[j].kills then
        begin
          for t:=7 downto j do
          begin
            sort[t+1]:=sort[t];
          end;
          sort[j].kills:=players[i].kills;
          sort[j].nr:=i;
          j:=maxplayer;
        end;
      end;
    end;
 end;
  for I:=1 to maxplayer do
  begin
    If sort[i].nr<>0 then
    begin
    str(players[sort[i].nr].kills,st);
    put(false,maxx+15,20+(i-1)*20,playerbitmap[sort[i].nr,up].bitsize,
    playerbitmap[sort[i].nr,up].bitpointer,false,vir);
    printstring(maxx+30,21+(i-1)*20,players[sort[i].nr].handle
                ,players[sort[i].nr].color,vir);
    if players[sort[i].nr].ingame or
      players[sort[i].nr].notinyet then printstring(maxx+50,31+(i-1)*20,st,players[sort[i].nr].color,vir)
    else printstring(maxx+30,31+(i-1)*20,'Healing!',players[sort[i].nr].color,vir);

    end;
  end;
  printstring(maxx+25,180,'Leader:',whitecol,vir);
  if sort[1].nr<>0 then
 printstring(maxx+25,190,players[sort[1].nr].handle,players[sort[1].nr].color,vir);

end;

Procedure DrawTerrain;
var
  n:integer;
begin
   for n:=1 to CurrentTerrainNr do
   put(false,Terrain[n].x,Terrain[n].y,GroundBitmap[Terrain[n].ground].bitsize,
       GroundBitmap[Terrain[n].ground].bitpointer,false,vir);


end;


procedure drawcolorcirclenet(xcenter,ycenter,radius:integer;col1,col2:byte;screen:word);
var
  x,y,p:integer;
begin
  x:=0;
  y:=radius;
  p:=2-(radius shl 1);
  while x<y do
  begin
    drawpix(xcenter+x,ycenter+y,col2,screen);
    drawpix(xcenter-x,ycenter+y,col1,screen);
    if ycenter-y>=0 then drawpix(xcenter+x,ycenter-y,col1,screen);
    if ycenter-y>=0 then drawpix(xcenter-x,ycenter-y,col2,screen);
    if xcenter-y>=0 then drawpix(xcenter-y,ycenter-x,col1,screen);
    if xcenter-y>=0 then drawpix(xcenter-y,ycenter+x,col2,screen);
    drawpix(xcenter+y,ycenter-x,col2,screen);
    drawpix(xcenter+y,ycenter+x,col1,screen);
    if p<0 then p:=p +(x shl 2)+6 else
    begin
      p:=p+(x-y) shl 2 +10;
      y:=y-1;
    end;
    x:=x+1;
  end; {while}
    if x=y then
    begin
      drawpix(xcenter+x,ycenter+y,col1,screen);
      drawpix(xcenter-x,ycenter+y,col2,screen);
      drawpix(xcenter+x,ycenter-y,col2,screen);
      drawpix(xcenter-x,ycenter-y,col1,screen);
      if xcenter-y>=0 then drawpix(xcenter-y,ycenter-x,col1,screen);
      if xcenter-y>=0 then drawpix(xcenter-y,ycenter+x,col2,screen);
      drawpix(xcenter+y,ycenter-x,col2,screen);
      drawpix(xcenter+y,ycenter+x,col1,screen);
    end;
end;


Procedure DrawPlayers;
var
 yval:word;
 col1,col2:byte;
begin
   if CurrentTime>(LastDrawTime+ShieldShift) then
   begin
     if shieldLastColor then shieldlastcolor:=false
     else shieldlastcolor:=true;
     {shieldlastcolor:=boolean(byte(shieldlastcolor) xor 1);}
     LastDrawTime:=CurrentTime;
   end;
   if players[ownnr].ingame
   then begin
   cls(0,vir);
   drawrectangle(minx-2,miny-2,maxx+12,maxy+12,bluecol,vir);
   If EnableTerrain then DrawTerrain;
   {draw coin}
   if bonus.specialon then
   begin
     put(false,bonus.specialx,bonus.specialy,coinsize,coinpointer,false,vir);
   end;
  for i:=1 to maxplayer do
  begin
    if players[i].alive then
    begin
    if players[i].ingame then
   if players[i].dir<>quit then
   begin
   put(false,players[i].x,players[i].y,playerbitmap[i,players[i].dir].bitsize,
      playerbitmap[i,players[i].dir].bitpointer,false,vir);
   if players[i].shieldon then
   begin
     if shieldlastcolor then
     begin
       col1:=239+i;
       col2:=shieldcol[i];
     end else
     begin
       col1:=shieldcol[i];
       col2:=239+i;
     end;
     if (players[i].dir=down) or (players[i].dir=right) then
     drawcolorcirclenet(players[i].x+4,players[i].y+4,7,col1,col2,vir)
     else if players[i].dir=left then
     drawcolorcirclenet(players[i].x+6,players[i].y+4,7,col1,col2,vir)
     else if players[i].dir=up then
     drawcolorcirclenet(players[i].x+4,players[i].y+6,7,col1,col2,vir)

   end; {shield}
   end; {not quitting}
   if players[i].shot.active then
    begin
      with players[i].shot do
     begin
     case players[i].curspecial of

     nothing : begin
      case players[i].shot.dir of
      up   : drawline(x,y,x,y+shotlen,players[i].color,vir);
      down : drawline(x,y,x,y-shotlen,players[i].color,vir);
      left : drawline(x,y,x+shotlen,y,players[i].color,vir);
      right : drawline(x,y,x-shotlen,y,players[i].color,vir);
    end; {minor case}
              end;
      Smissile : begin
      case players[i].shot.dir of
      up   : put(false,x-2,y,smissilesize[up],smissilepointer[up],false,vir);
      down : put(false,x-2,y-Smissilelen,smissilesize[down],smissilepointer[down],false,vir);
      left : put(false,x,y-2,smissilesize[left],smissilepointer[left],false,vir);
      right: put(false,x-Smissilelen,y-2,smissilesize[right],smissilepointer[right],false,vir);
    end; {minor case}
          end;  {smissile}
     multishot: begin
         case players[i].shot.dir of
          up   : begin
                   drawline(x,y,x,y+shotlen,players[i].color,vir);
                   drawline(x-multilen,y,x-multilen,y+shotlen,players[i].color,vir);
                   drawline(x+multilen,y,x+multilen,y+shotlen,players[i].color,vir);
                 end;
          down : begin
                   drawline(x,y,x,y-shotlen,players[i].color,vir);
                   drawline(x-multilen,y,x-multilen,y-shotlen,players[i].color,vir);
                   drawline(x+multilen,y,x+multilen,y-shotlen,players[i].color,vir);
                 end;
          left : begin
                   drawline(x,y,x+shotlen,y,players[i].color,vir);
                   drawline(x,y+multilen,x+shotlen,y+multilen,players[i].color,vir);
                   drawline(x,y-multilen,x+shotlen,y-multilen,players[i].color,vir);
                 end;
          right: begin
                   drawline(x,y,x-shotlen,y,players[i].color,vir);
                   drawline(x,y+multilen,x-shotlen,y+multilen,players[i].color,vir);
                   drawline(x,y-multilen,x-shotlen,y-multilen,players[i].color,vir);
                 end;
         end; {minor case}
               end;
     end; {major case}
     end; {with stning}
    end; {shot}
    end; {alive}
  end; {for i....}
    DrawPlayerInfo;
  end else
  begin {you are dead!}
    deathcur:=CurrentTime;
    if deathcur<deathstart+40 then
    begin {still death}
      if (deathcur<deathstart+2) then
      begin
        cls(0,vir);
        printstring(90,90,'You are dead!! ',players[ownnr].color,vir);
        printstring(70,100,'Prepare to reenter game!',players[ownnr].color,vir);
      end;
      yval:=50;
     if (deathcur-deathstart>26) and (playedgetready=false) then
     begin
       playfx(getready,0);
       playedgetready:=true;
     end;
     for i:=1 to deathcur-deathstart do
      begin
        printstring(yval,110,'.',players[ownnr].color,vir);
        inc(yval,5);
      end;
    end else
    begin {alive again}
      playedgetready:=false;
      players[ownnr].PseudoSpecial:=nothing;  {no weapons}
      players[ownnr].ingame:=true;
      players[ownnr].shieldon:=true; {start with a shield}
      players[ownnr].shieldenergy:=1; {start with 1 shield energy}
      shieldtime:=CurrentTime;
      alivelasttime:=true;
      repeat
       players[ownnr].y:=rnd(maxy-miny-20)+5+miny;
       players[ownnr].x:=rnd(maxx-minx-20)+5+minx;
      {check om man starter p noget terrain}
      until TerrainCollision(players[ownnr].x,players[ownnr].y,
                            players[ownnr].x+playerlen,
                            players[ownnr].y+playerlen)=false;
      players[ownnr].ingame:=true;
      NewDirection:=up;
      players[ownnr].dir:=up;
      ArrowKeyHit:=false;
    end;
  end;
    waittrace;
    movemem(vir,vgamem);
end;

Procedure Gethandle;
begin
  writeln;
  write('Please type in your handle (max. 8 chars) : ');
  read(s);
  if length(s)>8 then
  begin
    writeln('I told you - max 8 chars');
    endprogram;
  end;
  if length(s)<1 then
  begin
    writeln('I told you - you need to enter a HANDLE');
    endprogram;
  end;
end;

Procedure QuitCode;
var
  n:integer;
  g:groundtype;
begin
  setintvector(keyboardint,oldkeyboardvec);
  setintvector(timerint,oldtimerint);
  players[ownnr].alive:=false;
  players[ownnr].ingame:=false;
  players[ownnr].shot.active:=false;
  for i:=1 to maxplayer do
  freemem(playerbitmap[i,up].bitpointer,playerbitmap[i,up].bitsize);
  for i:=1 to maxplayer do
  freemem(playerbitmap[i,down].bitpointer,playerbitmap[i,down].bitsize);
  for i:=1 to maxplayer do
  freemem(playerbitmap[i,left].bitpointer,playerbitmap[i,left].bitsize);
  for i:=1 to maxplayer do
  freemem(playerbitmap[i,right].bitpointer,playerbitmap[i,right].bitsize);
  if nonetwork=false then CloseSocket(MainSocket);
  for g:=rock to tree3 do
  freemem(groundbitmap[g].bitpointer,groundbitmap[g].bitsize);
end;

Procedure SendInfo(sig:byte);
begin
  {send alt info}
  for I:=1 to 3 do
    send.data[i]:=$EE;
    send.data[4]:=sig;
    send.data[5]:=ownnr;
    move(players[ownnr],send.data[6],sizeof(playertype));
  repeat
  until send.ecb.inuse=0;
  IPXsendPacket(send.ecb);
end;

Function NotOwnNode(n1,n2:nodetype):boolean;
var
  n:integer;
begin
  notownnode:=false;
  for n:=1 to 6 do if n1[n]<>n2[n] then NotOwnNode:=true;
end;

procedure checkInfo(var back:artype);
begin
  for K:=1 to nrofpacks do
  begin
    back[k]:=0;
  if (receive[k].ecb.inuse=0) then
     begin
       if NotOwnNode(receive[k].ipx.src.node,localaddr.node) then
       begin
         if checksignal(receive[k].data) then
         begin
           back[k]:=signal;
           case signal of
            Signal_Addplayer :
              begin
                inc(TotalPlayers);
                move(receive[k].data[6],players[receive[k].data[5]],sizeof(playertype));
              end;
            Signal_TerminatedByMaster :
              begin
                Terminated:=true;
                destroyvirtual(vir1point);
                destroyvirtual(collisionpoint);
                QuitCode;
                DoEndStuff;
              end;
            Signal_subPlayer :
              begin
                if players[receive[k].data[5]].alive then dec(totalplayers);
                move(receive[k].data[6],players[receive[k].data[5]],sizeof(playertype));
              end;
            Signal_UpdatePlayer :
              begin
                if players[receive[k].data[5]].alive=false then inc(totalplayers);
                move(receive[k].data[6],players[receive[k].data[5]],sizeof(playertype));
              end;
           Signal_UpdateAllPlayers:
              begin
             move(receive[k].data[6],players,sizeof(playertype)*maxplayer);
             move(receive[k].data[6+sizeof(playertype)*maxplayer],bonus,sizeof(bonustype));
                for tempbyte:=1 to maxplayer do
                begin
                  if players[tempbyte].master then masternr:=tempbyte;
                end;
              end;
           Signal_MasterChange:  {modtages kun i ndstilflde}
              begin
                ChangeMaster:=true;
             move(receive[k].data[6],players,sizeof(playertype)*maxplayer);
             move(receive[k].data[6+sizeof(playertype)*maxplayer],bonus,sizeof(bonustype));
                for tempbyte:=1 to maxplayer do
                begin
                  if players[tempbyte].master then masternr:=tempbyte;
                end;
              end;
           Signal_UpdateAllPlayersScore:
              begin
             move(receive[k].data[6],players,sizeof(playertype)*maxplayer);
             move(receive[k].data[6+sizeof(playertype)*maxplayer],bonus,sizeof(bonustype));
             move(receive[k].data[6+sizeof(playertype)*maxplayer+
                  sizeof(bonustype)],greatfame,sizeof(hallfametype));
             move(receive[k].data[6+sizeof(playertype)*maxplayer+
                  sizeof(bonustype)+sizeof(hallfametype)]
                  ,terrain,sizeof(terraintype));
                for tempbyte:=1 to maxplayer do
                begin
                  if players[tempbyte].master then masternr:=tempbyte;
                end;
                CurrentTerrainnr:=0;
                tempbyte:=1;
                while (tempbyte<=maxterrain)
                do begin
                  if terrain[tempbyte].x<>0 then
                  inc(CurrentTerrainNr);
                  inc(tempbyte);
                end;
              if players[ownnr].notinyet then
              begin
                repeat
                  players[ownnr].x:=rnd(maxx-minx-20)+5+minx;
                  players[ownnr].y:=rnd(maxy-miny-20)+5+miny;
                until TerrainCollision(players[ownnr].x,players[ownnr].y,
                          players[ownnr].x+playerlen,players[ownnr].y+
                           playerlen)=false;
                players[ownnr].notinyet:=false;
                players[ownnr].ingame:=true;
              end; {firsttime}
                  gotfirstinfo:=true;
              end;
           Signal_WantInfo:
              begin
              end;
           Signal_NewPlayerJoins:
              begin
                newplayer:=true;
                newnr:=k;
                newnode:=receive[k].ipx.src.node;
                move(receive[k].data[6+sizeof(playertype)],hallfame,sizeof(hallfametype));
              end;
           Signal_PlayerAccepted:
              begin
                 ownnr:=receive[k].data[6];
                 masternr:=receive[k].data[5];
              end;
            Signal_ImDead:
              begin
                {if players[ownnr].lastkill=receive[k].data[5] then
                   players[ownnr].lastkill:=0;}
                move(receive[k].data[6],players[receive[k].data[5]],sizeof(playertype));
              end;
           end; {case}
         end;
       end;
         if IPXlistenForPacket(receive[k].ecb)<>0 then
          begin
            settext;
            writeln(#7,'ERROR TRYING TO receive[k] A PACKET!');
            halt(5);
          end;
   end;
  end;
end;

Function RectangleCollision(l1,t1,r1,b1,l2,t2,r2,b2:integer):Boolean;
begin
  if (l1>r2) or (r1<l2) or (t1>b2) or (b1<t2)
     then RectangleCollision:=false else
          RectangleCollision:=true;
end;

Function BitMapCollision(map1x,map1y:integer;map1size:word;map1pointer:
                         pointer;map2x,map2y:integer;map2size:word;
                         map2pointer:pointer):boolean;
begin
  drawbox(50,50,120,120,0,collisionvir);
  put(false,80,80,map1size,map1pointer,false,collisionvir);
  BitmapCollision:=
 collisionwhileput(80+map2x-map1x,80+map2y-map1y,map2size,map2pointer,collisionvir);
end;


procedure handleshot;
var
 xadd,yadd:integer;
 speed:word;
 t,x1,x2,y1,y2:integer;


procedure calccords;
begin
      with players[ownnr].shot do
      begin
        case players[ownnr].curspecial of
    nothing :
      begin
        x1:=x;
        y1:=y;
        x2:=x;
        y2:=y;
        case dir of
        up    : y2:=y2+shotlen;
        down  : y2:=y2-shotlen;
        left  : x2:=x2+shotlen;
        right : x2:=x2-shotlen;
        end;
     end;  {nothing}
   multishot : begin
        case dir of
        up    : begin
                  x1:=x-multilen;
                  y1:=y;
                  x2:=x+multilen;
                  y2:=y+shotlen;
                end;
        down  : begin
                  x1:=x-multilen;
                  y1:=y-shotlen;
                  x2:=x+multilen;
                  y2:=y;
                end;
        left  : begin
                  x1:=x;
                  y1:=y-multilen;
                  x2:=x+shotlen;
                  y2:=y+multilen;
                end;
        right : begin
                  x1:=x-shotlen;
                  y1:=y-multilen;
                  x2:=x;
                  y2:=y+multilen;
                end;
        end; {case}
       end;  {multishot}
      smissile : begin
        case dir of
        up    : begin
                 x1:=x-smissilewid;
                  y1:=y;
                  x2:=x+smissilewid;
                  y2:=y+smissilelen;
                end;
        down  : begin
                  x1:=x-smissilewid;
                  y1:=y-smissilelen;
                  x2:=x+smissilewid;
                  y2:=y;
                end;
        left  : begin
                  x1:=x;
                  y1:=y-smissilewid;
                  x2:=x+smissilelen;
                  y2:=y+smissilewid;
                end;
        right : begin
                  x1:=x-smissilelen;
                  y1:=y-smissilewid;
                  x2:=x;
                  y2:=y+smissilewid;
                end;
        end; {case}
       end; {smissile}
       end; {huge case}
       end; {with pl....}
end; {calc cords}

begin
 if players[ownnr].shot.active then
    begin
      calccords;
      if x2<x1 then
      begin
        t:=x1;
        x1:=x2;
        x2:=t;
      end;
      if y2<y1 then
      begin
        t:=y1;
        y1:=y2;
        y2:=t;
      end;
      If TerrainCollision(x1,y1,x2,y2) then
      players[ownnr].shot.active:=false;
    {check if the shot's coordinates is in some terrain - if then shot=nope}
    case players[ownnr].curspecial of
    nothing   : speed:=shotspeed;
    multishot : speed:=shotspeed;
    Smissile  : Speed:=SmissileSpeed;
    end;
    case players[ownnr].shot.dir of
    up   : dec(players[ownnr].shot.y,speed);
    down : inc(players[ownnr].shot.y,speed);
    left   : dec(players[ownnr].shot.x,speed);
    right : inc(players[ownnr].shot.x,speed);
    end; {case}
    with players[ownnr].shot do
    begin
      if (x<minx) or (x>maxx+spacex) or (y<miny) or (y>maxy+spacey)
      then begin
        active:=false;
        dir:=none;
      end;
    end;
   end;
end;


Function TerrainCollision(x1,y1,x2,y2:integer):Boolean;
var
  v:integer;
  resbol:boolean;
  add:integer;
begin
  resbol:=false;
  v:=1;
  while (v<=CurrentTerrainNr) and (resbol=false) do
  begin
    case Terrain[v].ground of
    rock : if RectangleCollision(x1,y1,x2,y2,
                                 Terrain[v].x,Terrain[v].y,
                                 Terrain[v].x+rockaddx,Terrain[v].y+rockaddy)
                                  then resbol:=true;
    tree1..tree3: if RectangleCollision(x1,y1,x2,y2,Terrain[v].x,
                                 Terrain[v].y,Terrain[v].x+treeadd,
                                 Terrain[v].y+treeadd)
                                 then resbol:=true;
    end;
    inc(v);
  end;
  TerrainCollision:=resbol;
end;


Function TerrainCollisionBitmap(x1,y1,x2,y2:integer):Boolean;
var
  v:integer;
  resbol:boolean;
  add:integer;
begin
  resbol:=false;
  v:=1;
  while (v<=CurrentTerrainNr) and (resbol=false) do
  begin
    case Terrain[v].ground of
    rock : if RectangleCollision(x1,y1,x2,y2,
                                 Terrain[v].x,Terrain[v].y,
                                 Terrain[v].x+rockaddx,Terrain[v].y+rockaddy)
                                 then begin
                                 if bitmapcollision(x1,y1,playerbitmap[ownnr,
                                   players[ownnr].dir].bitsize,
                                   playerbitmap[ownnr,players[ownnr].dir].bitpointer,
                                   terrain[v].x,terrain[v].y,
                                   groundbitmap[terrain[v].ground].bitsize,
                                   groundbitmap[terrain[v].ground].bitpointer)
                                   then resbol:=true;
                                 end;
    tree1..tree3: if RectangleCollision(x1,y1,x2,y2,Terrain[v].x,
                                 Terrain[v].y,Terrain[v].x+treeadd,
                                 Terrain[v].y+treeadd)
                                 then begin
                                   if bitmapcollision(x1,y1,playerbitmap[ownnr,
                                   players[ownnr].dir].bitsize,
                                   playerbitmap[ownnr,players[ownnr].dir].bitpointer,
                                   terrain[v].x,terrain[v].y,
                                   groundbitmap[terrain[v].ground].bitsize,
                                   groundbitmap[terrain[v].ground].bitpointer)
                                   then resbol:=true;
    end;                         end;
    inc(v);
  end;
  TerrainCollisionBitmap:=resbol;
end;



Procedure NewHandleAllInfo;
{check who is killed by whom}
var
  xadd,yadd:integer;
  j:longint;
  found:boolean;
  least:word;
  leastnr:byte;
  playerset : array[1..maxplayer] of byte;
  resbol:boolean;
  x1,x2,y1,y2:integer;
begin
  for i:=1 to maxplayer do
  begin
   if players[i].alive=false then
   begin
      if i=ownnr then
      begin
        least:=10000;
        leastnr:=ownnr;
        for J:=1 to maxplayer do
        begin
          if (j<>i) and (players[j].alive) and (players[j].speed<least)
          then
          begin
            least:=players[j].speed;
            leastnr:=j;
          end;
        end;
        players[leastnr].master:=true;
        players[ownnr].master:=false;
        masternr:=j;
        IamMaster:=false;
      end; {pick another master - choose the fastest}
    end;
  end;
  least:=players[ownnr].speed;
  leastnr:=ownnr;
  for I:=1 to maxplayer do  {is there a faster computer logged in??}
  begin
    if (players[i].alive) and (i<>ownnr) and
    (players[i].speed<least) then
    begin
      least:=players[i].speed;
      leastnr:=i;
    end;
  end;
  if leastnr<>ownnr then
  begin
    players[leastnr].master:=true;
    players[ownnr].master:=false;
    IamMaster:=false;
    Masternr:=leastnr;
  end;
  for I:=1 to maxplayer do
  begin
    if (players[i].alive) and (players[i].shot.active) then
    begin
      with players[i].shot do
      begin
        case players[i].curspecial of
    nothing :
      begin
        x1:=x;
        y1:=y;
        x2:=x;
        y2:=y;
        case dir of
        up    : y2:=y2+shotlen;
        down  : y2:=y2-shotlen;
        left  : x2:=x2+shotlen;
        right : x2:=x2-shotlen;
        end;
     end;  {nothing}
   multishot : begin
        case dir of
        up    : begin
                  x1:=x-multilen;
                  y1:=y;
                  x2:=x+multilen;
                  y2:=y+shotlen;
                end;
        down  : begin
                  x1:=x-multilen;
                  y1:=y-shotlen;
                  x2:=x+multilen;
                  y2:=y;
                end;
        left  : begin
                  x1:=x;
                  y1:=y-multilen;
                  x2:=x+shotlen;
                  y2:=y+multilen;
                end;
        right : begin
                  x1:=x-shotlen;
                  y1:=y-multilen;
                  x2:=x;
                  y2:=y+multilen;
                end;
        end; {case}
       end;  {multishot}
      smissile : begin
        case dir of
        up    : begin
                 x1:=x-smissilewid;
                  y1:=y;
                  x2:=x+smissilewid;
                  y2:=y+smissilelen;
                end;
        down  : begin
                  x1:=x-smissilewid;
                  y1:=y-smissilelen;
                  x2:=x+smissilewid;
                  y2:=y;
                end;
        left  : begin
                  x1:=x;
                  y1:=y-smissilewid;
                  x2:=x+smissilelen;
                  y2:=y+smissilewid;
                end;
        right : begin
                  x1:=x-smissilelen;
                  y1:=y-smissilewid;
                  x2:=x;
                  y2:=y+smissilewid;
                end;
        end; {case}
       end; {smissile}
       end; {huge case}
       {check if the shot will hit any players}
       for J:=1 to maxplayer do
        begin
        if (j<>i) and (players[j].alive) and (players[j].ingame)
           then begin
           case players[j].dir of
            {hvordan vender spilleren}
             up,none,down : begin
                              xadd:=playerlen-2;
                              yadd:=playerlen;
                            end;
             left,right   : begin
                              xadd:=playerlen;
                              yadd:=playerlen-2;
                            end;
           end; {case}
           if RectangleCollision(x1,y1,x2,y2,players[j].x,
                                 players[j].y,players[j].x+xadd,
                                 players[j].y+yadd)
           then begin  {hit}

             if players[j].shieldon=false then
             begin
               inc(players[i].kills);
               players[i].shot.active:=false;
               players[j].ingame:=false;
             end else
             players[i].shot.active:=false;  {shield is on}

             case players[i].curspecial of
              nothing : dec(players[j].shieldenergy,1);
              multishot : dec(players[j].shieldenergy,3);
              smissile : dec(players[j].shieldenergy,5);
             end;
             if players[j].shieldenergy<=0 then players[j].shieldon:=false;


           end;  {hit}
        end;
       end; {for j...}
      end; {with}
    end;  {alive}
  end;  {for i...}
 {update coin}
 if bonus.Specialon=false then
 begin
   tempdword:=timesincebonus+rnd(100);
   tempdword:=tempdword+bonus.specialtime;
   if CurrentTime>tempdword then
   begin  {st den}
     bonus.Specialon:=true;
     bonus.specialtime:=CurrentTime;
     repeat
     {wait(coinwait);}
     bonus.specialx:=rnd(maxx-minx-5)+minx;
     bonus.specialy:=rnd(maxy-miny-20)+5+miny;
     until TerrainCollision(bonus.specialx,bonus.specialy,
            bonus.specialx+coinxlen,bonus.specialy+coinylen)=false;
     {check if the coin starts on some terrain}
   end;
 end else
 begin  {see if anybody takes the coing}
   tempbyte:=0;
   for I:=1 to maxplayer do
   begin
     if players[i].ingame and players[i].alive then
     begin

        case players[i].dir of

             up,none,down : begin
                              xadd:=playerlen-2;
                              yadd:=playerlen;
                            end;
             left,right   : begin
                              xadd:=playerlen;
                              yadd:=playerlen-2;
                            end;
          end; {case}
       if RectangleCollision(players[i].x,players[i].y,
                             players[i].x+xadd,players[i].y+yadd,
                             bonus.specialx,bonus.specialy,
                             bonus.specialx+coinxlen,
                             bonus.specialy+coinylen)
            then
          begin
            inc(tempbyte);
            playerset[tempbyte]:=i;
          end;
     end;  {if alive and ingame}
   end; {for i....}
   if tempbyte>0 then
   begin
     bonus.specialitem:=specialtype(rnd(maxweapon)+1);
     tempword:=rnd(tempbyte)+1;
     if bonus.specialitem<>shield then
     players[playerset[tempword]].pseudospecial:=bonus.specialitem
     else
     begin
       players[playerset[tempword]].shieldon:=true;
       players[playerset[tempword]].shieldenergy:=5;
       if playerset[tempword]=ownnr then shieldtime:=currenttime+LargeShieldDuration;
     end;
     bonus.specialon:=false;
     bonus.specialtime:=CurrentTime;
   end;
 end;
  Bonus.difference:=CurrentTime-bonus.specialtime;
end;


Function GetCpuSpeed:word;
{very primitive way of testing cpu speed}
var
 size:word;
 start,cur:longint;
 j:longint;
 n:nodetype;
begin
  start:=getclockcount;
  for J:=1 to 2000000 do
  begin
    asm
      mov bx,2
      mov ax,2
      imul bx
      idiv bx
     end;
  end;
  cur:=getclockcount;
  j:=cur-start;
  GetCpuSpeed:=j;
end;


function someone(what:artype;sig:byte):boolean;
var
 h:integer;
begin
  someone:=false;
  for H:=1 to nrofpacks do
  begin
    if (what[h]=sig) then someone:=true;
  end;
end;

function whichone(what:artype;sig:byte):byte;
var
 h:integer;
begin
  tempbyte:=0;
  h:=1;
  while (tempbyte=0) and (h<=nrofpacks) do
  begin
    if what[h]=sig then tempbyte:=h;
    inc(h);
  end;
  whichone:=tempbyte;
end;

Function NewVersion:Boolean;
begin
  newversion:=false;
  for I:=1 to maxplayer do
  if players[i].netmazeversion>players[ownnr].netmazeversion
  then newversion:=true;
end;

Function OtherVersion:Boolean;
begin
  otherversion:=false;
  for I:=1 to maxplayer do
  if players[i].alive then
  begin
    if netversion<>players[i].netmazeversion
    then otherversion:=true;
  end;
end;

Function NewFame(var Thefame:hallfametype):Boolean;
var
  found:boolean;
begin
  NewFame:=false;
  NewFameNr:=0;
  found:=false;
  if ownscore>thefame[maxfame].score then
  begin
    NewFame:=true;
    i:=1;
    while (I<=maxfame) and (found=false) do
    begin
      if ownscore>thefame[i].score then
      begin
        for J:=(maxfame-1) downto i do
          thefame[j+1]:=thefame[j];
        NewFameNr:=i;
        thefame[i].score:=ownscore;
        thefame[i].kills:=players[ownnr].kills;
        thefame[i].name:=players[ownnr].handle;
        thefame[i].Tank:=TankType(players[ownnr].color-240);
        Thefame[i].hits:=ownhits;
        found:=true; {skip loop}
      end;
      inc(i);
    end;
  end; {there is a new hiscore}
end;

procedure DoEndStuff;
var
  r,r1:real;
begin
  setrgb(0,0,0,0);
  cls(0,vgamem);
  settext;
  makeendlogo;
  movecursor(3,22);
  str(hi(netversion),stra);
  str(lo(netversion),strb);
  writestring(0,0,'NetMaze(tm) V. '+stra+'.'+strb+betaversion+' made by Martin Knudsen',7,0);
  writestring(42,0,#212#213#214,15,4);
  writestring(46,0,'- (Zaifrun of Immaculate) in 1997',7,0);
  writestring(0,1,'Graphics made by Peter Vang',7,0);
  writestring(28,1,#212#213#214,15,4);
  writestring(0,2,'Net-Info obtained from Daniel Parnell (Australia)',7,0);
  writestring(0,3,'Thanks to H.C. Lysgaard for loan of a netcard',7,0);
  writestring(0,4,'Netmaze is dedicated to those who believes that funny games',2,0);
  writestring(0,5,'don''t have to fill up 100MB and require a pentium 200MHz',2,0);
  WriteString(0,6,'NetMaze is FREEware - a Free world with Free software',7,0);
  writestring(0,7,'Updates at : http://www.geocities.com/SiliconValley/Heights/2188',2,0);
  if par1<>'viewfame' then
  begin
    OwnKills:=players[ownnr].kills;
    OwnScore:=Ownkills-TotalDeaths;
    ownhandle:=players[ownnr].handle;
    r:=ownkills;
    r1:=totalshots;
    if r1=0 then r:=0 else
    r:=r/r1*100;
    ownhits:=round(r);
  end;
  {LoadFame(HallFame);}
  NewHiScore:=NewFame(GreatFame);
  DisplayFame(GreatFame);
  SaveFame(GreatFame);
  if par1<>'viewfame' then StopSound;
  endprogram;
end;

procedure plantterrain(nr:longint);
begin
        Terrain[nr].x:=rnd(maxx-minx-20)+minx+5;
        Terrain[nr].y:=rnd(maxy-miny-20)+miny+5;
        Terrain[nr].ground:=GroundType(rnd(maxground));
end;

{$F+}
procedure esr; far; assembler;
{es:si =  pointer to the ecb that caused the routine to be called}
{The routine is called from the ipx-driver}
asm
  push es
  pop  ds
  { assume that the ECB is inside the data segment - otherwize save ds in mem}
  {inc gotit}
  cli {just to make sure}
end;
{$F-}

procedure DoRose;
var
  p:paltype;
  k:integer;
begin
  setvga256;
  resetpal;
  viewpcx('rosen.pcx',false,vgamem);
  getpal_frompcx('rosen.pcx',p);
  fadeup(20,p);
  k:=0;
  clearkeyboardbuffer;
  repeat
   waittrace;
   inc(k);
  until (k>5*70) or (anykey);
  fadedown(10);
  clearkeyboardbuffer;
  settext;
end;

var
 adr:address;
 searchtime : integer;
{
 netsocket = $8895 - The Official NetMaze Socket Number
}
{startpoint}
{max transfer = 544 so far}
begin {main program}
  par1:=paramstr(1);
  par2:=paramstr(2);
  par3:=paramstr(3);
  {if isfile('rosen.pcx') then DoRose;}
  r250init;  {Do only once}
  terminated:=false;
  CurrentTerrainNr:=0;
  makec:=0;
  breakc:=0;
  if windowsactive and (hi(msdosversion)<7) then
  begin
  writeln('You are running NetMaze from Windows 3.11 or below');
  writeln('This is not a good idea');
  writeln('NetMaze should be run from Dos (best) or Windows 95');
  writeln('Are you really really really sure you want to run it now? (y/n)');
  repeat
    ch:=getkey;
  until (ch='y') or (ch='Y') or (ch='n') or (ch='N');
  if (ch='n') or (ch='N') then endprogram;
  end;
  if not Isfile(picturename) then
  begin
    writeln('The file "'+picturename+'" was NOT found in the current directory!');
    endprogram;
  end;
  if par1='reset' then
  begin
    CreateNewFame;
    Writeln('The highscore list is now back to default.');
    endprogram;
  end;
  if isfile(Hallfamefile) then
  CheckHallFameFile else CreateNewFame;
  LoadFame(GreatFame);
  if (par1='?') or (par1='/h') or (par1='/?') then
  begin
    writeln;
    writeln('Command line options for netmaze : ');
    writeln('"?"        : this screen');
    writeln('"viewfame" : displays the hiscore list');
    writeln('"whoison"  : shows which players are currently playing netmaze');
    writeln('"game=n"   : where n is from 0 to 9, this option can used with');
    writeln('             the "whoison" and "noterrain" option as well. Default is 0.');
    writeln('             Fx. "netmaze3 game=4" or "netmaze3 whoison game=2".');
    writeln('             Allows up to 10 different games on the same network');
    writeln('"noterrain": Disables the terrain. This is only effectful when');
    writeln('             you are the first one to enter the game.');
    writeln('"reset"    : Resets the highscore list back to the default.');
    writeln('"nosound"  : Disables sound FX.');
    writeln('"master"   : Makes this computer the Netmaze server. You should only ');
    writeln('             use this if many players will start netmaze at the');
    writeln('             same time and you have trouble starting the game - only ');
    writeln('             use this on one of the computers (the fastest).');
    writeln;
    Endprogram;
  end;
  if par1='viewfame' then
  begin
    ownnr:=1;
    players[ownnr].kills:=0;
    DoEndStuff;
  end;
  gamenr:=0;
  if (copy(par1,1,5)='game=')
  then begin
    if (ord(par1[6])>=48) and (ord(par1[6])<=57) then
    gamenr:=ord(par1[6])-48;
  end else if
  (copy(par2,1,5)='game=') then
  begin
    if (ord(par2[6])>=48) and (ord(par2[6])<=57) then
    gamenr:=ord(par2[6])-48;
  end else if
  (copy(par3,1,5)='game=') then
  begin
    if (ord(par3[6])>=48) and (ord(par3[6])<=57) then
    gamenr:=ord(par3[6])-48;
  end;
  if par1<>'test' then
  MainSocket:=$8895+gamenr else mainsocket:=$9999; {testsoc}
  if par1='nonetwork' then nonetwork:=true else nonetwork:=false;
  IamMaster:=false;
  settext;
  for i:=1 to 8 do players[i].curspecial:=nothing;
  Bonus.SpecialOn:=false;
  Bonus.Specialx:=0;
  Bonus.Specialy:=0;
  bonus.specialitem:=specialtype(rnd(maxweapon)+1);
  MasterLasttime:=false;
  Ownnr:=0;
  TotalPlayers:=0;
  if detect386=false then
  begin
    writeln('NetMaze needs at least a 80386 processor');
    endprogram;
  end;
  if detectvga=false then
  begin
    writeln('NetMaze needs at least a VGA graphics card');
    endprogram;
  end;
 if nonetwork=false then
 begin
  if detectipx=false then
  begin
    writeln('IPX driver is NOT loaded');
    endprogram;
  end;
  {Make some init}
  res:=opensocket(mainsocket);
  if res=$FF then
  begin
    closesocket(mainsocket);
    res:=opensocket(mainsocket);
  end;
  if (res<>0) then
    begin
      writeln('Could not open socket');
      endprogram;
    end;
  getownaddress;
  getipxinfo;
 {do some init here}
   adr[0]:=0;{ofs(esr);}
   adr[1]:=0;{seg(esr);}
   with send do
      InitSendPacket(ecb,ipx,sizeof(playertype)+5,broadcast);
   for k:=1 to nrofpacks do
   begin
   with receive[k] do
      InitReceivePacket(ecb,ipx,adr);
  end;
 end;
 {listen for 3 secs and get own number}
  for I:=1 to maxplayer do players[i].alive:=false;
  totalplayers:=0;
  cpuspeed:=5;
  if (par1<>'whoison') and (par2<>'whoison') then
  begin
  str(hi(netversion),stra);
  str(lo(netversion),strb);
  Writeln('           Welcome to Netmaze(tm) V.'
           +stra+'.'+strb+betaversion{+' -  released '+releasedate});
  writeln;
  writeln('Use arrow keys to move, control to fire, shift to stop, escape to quit ');
  writeln;
  writeln('checking cpuspeed - please wait.......');
  writeln;
  if par1<>'test' then
  begin
    if (par1='master') or (par2='master') or (par3='master') then
    cpuspeed:=0 else
    cpuspeed:=getcpuspeed;
  end;
  tempbyte:=DetectCpu;
  case tempbyte of
  1: tempstr:='80386';
  2: tempstr:='80486';
  3: tempstr:='Pentium';
  4: tempstr:='Pentium with MMX';
  end;
 {Old way of doing it - changed in v. 3.7}
{  writeln('cpuspeed = ',2000 div cpuspeed,' MHz '+tempstr);}
  CPU_TypeStr;
  writeln('cpuspeed = ',intcpuspeed,' MHz '+tempstr);
  GetHandle;
  initsound;
  if soundok then
  begin
    writeln;
    writeln('Sound initialized...');
  end;
  end;
  writeln;
  if nonetwork=false then write('Searching for players');
  {init terrain}
    for I:=1 to maxterrain do terrain[i].x:=0;
    CurrentTerrainNr:=rnd(maxterrain-minterrain+1)+minterrain;
    if (par1='noterrain') or (par2='noterrain') or (par3='noterrain') then
    EnableTerrain:=false else EnableTerrain:=true;
    if enableTerrain=false then CurrentTerrainNr:=0;
  starttime:=getclockcount;
  oldtime:=starttime;
  for tempbyte:=1 to currentterrainnr do
  plantterrain(tempbyte);
  if nonetwork=false then
  begin
  searchtime:=40;
  if (par1='master') or (par2='master') or (par3='master')
  then searchtime:=25;
  repeat
    curtime:=getclockcount;
    if curtime>oldtime then
    begin
      {if tempbyte<=currentterrainnr then
      begin
        plantterrain(tempbyte);
        inc(tempbyte);
      end;}
      write('.');
      oldtime:=curtime;
    end;
    checkinfo(whatsignal);
    totalplayers:=0;
    for I:=1 to maxplayer do if players[i].alive then inc(totalplayers);
    if (totalplayers>=maxplayer) and (par1<>'whoison')
       and (par2<>'whoison') then
    begin
      writeln;
      writeln('Sorry, but there is already 8 players involved...');
      CloseSocket(MainSocket);
      stopsound;
      endprogram;
    end;
  until curtime>starttime+searchtime;
  if (par1='whoison') or (par2='whoison') then
  begin
    CloseSocket(MainSocket);
    str(totalplayers,tempstr);
    writeln;
    writeln('There are currently '+tempstr+' player(s) using netmaze');
    if totalplayers>0 then writeln('Playerlist : ');
    for I:=1 to maxplayer do
    begin
      if players[i].alive then
      begin
        str(hi(players[i].NetMazeVersion),stra);
        str(lo(players[i].NetMazeversion),strb);
        write(players[i].handle);
        movecursor(10,getcursory);
        str(players[i].kills,tempstr);
        write(tempstr);
        writeln(' kills - using Netmaze version '+stra+'.'+strb);
      end;
    end;
    str(hi(NetVersion),stra);
    str(lo(Netversion),strb);
    writeln;
    writeln('You are using Netmaze version '+stra+'.'+strb+betaversion);
    writeln;
    endprogram;
  end;
  end; {if nonetwork=false}

  if totalplayers=0 then IamMaster:=true;
  inc(totalplayers);  {du er jo selv med!}
  if IamMaster=false then
  begin
    if otherversion then
    begin
      writeln;
      writeln;
      writeln('You are using another version of NetMaze than the other players');
      CloseSocket(MainSocket);
      stopsound;
      endprogram;
    end;
  end;
  vir:=createvirtual(vir1point);
  collisionvir:=createvirtual(collisionpoint);
  tempplayer.y:=rnd(maxy-miny-20)+5+miny;
  tempplayer.x:=rnd(maxx-minx-20)+5+minx;
  tempplayer.handle:=s;
  tempplayer.alive:=false;
  tempplayer.shot.dir:=none;
  tempplayer.kills:=0;
  tempplayer.ingame:=true;
  tempplayer.notinyet:=true;
  tempplayer.node:=localaddr.node;
  tempplayer.speed:=cpuspeed;
  tempplayer.master:=false;
  OldDir:=None;
  i:=rnd(4);
  case i of
  0:tempplayer.dir:=up;
  1:tempplayer.dir:=down;
  2:tempplayer.dir:=left;
  3:tempplayer.dir:=right;
  end;
  NewDirection:=tempplayer.dir;
  If IamMaster=false then
  begin {Tell the master, that you want to join}
    SetTargetNode(send.ecb,send.ipx,players[masternr].node);
    writeln;
    write('Synchronizing network');
    starttime:=getclockcount;
    oldtime:=starttime;
    GotOwnNumber:=false;
    SetPacketSize(send.ecb,sizeof(playertype)+5+sizeof(HallFameType));
  repeat
    curtime:=getclockcount;
    if curtime>oldtime then
    begin
      write('.');
      oldtime:=curtime;
     end;
        {send alt info}
    checkinfo(whatsignal);
    if someone(whatsignal,Signal_UpdateAllPlayers) then
    begin

    for I:=1 to 3 do
     send.data[i]:=$EE;
     send.data[4]:=Signal_NewPlayerJoins;
     send.data[5]:=0;
     move(tempplayer,send.data[6],sizeof(playertype));
     move(GreatFame,send.data[6+sizeof(playertype)],sizeof(hallfametype));
     repeat
     until send.ecb.inuse=0;
     IPXsendPacket(send.ecb);
    end;
    if someone(whatsignal,signal_PlayerAccepted) then gotOwnNumber:=true;
  until (curtime>starttime+40) or GotOwnnumber;
  SetPacketSize(send.ecb,sizeof(playertype)+5);
  if GotOwnNumber=false then
  begin
    writeln;
    writeln('Sorry, but the master computer does not respond...');
    CloseSocket(MainSocket);
    stopsound;
    endprogram;
  end;
 end else
 begin {I am the master computer myself}
   ownnr:=1;
   players[ownnr].master:=true;
   IamMaster:=true;
   MasterLastTime:=true;
 end;
  players[ownnr]:=tempplayer;
  players[ownnr].alive:=true;
  if IamMaster then
  begin
    masternr:=ownnr;
    players[ownnr].master:=true;
  end;
  for I:=1 to 8 do players[i].color:=239+i;
  ClearKeyBoardBuffer;
{  soundok:=false;}

{  InitSound;
  if soundok then
  begin
    writeln;
    writeln;
    writeln('Sound initialized...');
    wait(600);
  end;}
  {Infosent:=false;}
  setvga256;
  InitBitmaps;
  setrgb(bluecol,0,0,63);
  setrgb(240,0,63,0); {green}
  setrgb(241,0,0,63);  {blue}
  setrgb(242,63,0,0);  {red}
  setrgb(243,63,62,3);   {gul}
  setrgb(244,60,60,60); {white}
  setrgb(245,38,0,38);   {lilla}
  setrgb(246,63,40,0);  {orange}
  setrgb(247,35,27,0);   {brun}

  getintvector(keyboardint,oldkeyboardvec);
  setintvector(keyboardint,@keyboard);
  getintvector(timerint,oldtimerint);
  setintvector(timerint,@timer);
  quitok:=false;
  quitok2:=false;
  alivelasttime:=true;
  newplayer:=false;
{  for I:=1 to maxweapon do players[ownnr].special[i]:=nothing;}
  for I:=1 to maxplayer do playerwaits[i]:=0;
  players[ownnr].curspecial:=nothing;
  players[ownnr].pseudospecial:=nothing;
  players[ownnr].Netmazeversion:=netversion;
  CurrentTime:=1000;
  ctrlon:=false;
  cheatnr:=0;
  TotalShots:=0;
  TotalDeaths:=0;
  PlayedGetReady:=false;
  SendFameData:=false;
  KillPlayer:=false;
  Bonus.SpecialTime:=CurrentTime;
  ChangeMaster:=false;

  If IamMaster Then
  begin
    players[ownnr].notinyet:=false;
    repeat
      players[ownnr].x:=rnd(maxx-minx-20)+5+minx;
      players[ownnr].y:=rnd(maxy-miny-20)+5+miny;
    until TerrainCollision(players[ownnr].x,players[ownnr].y,
                        players[ownnr].x+playerlen,players[ownnr].y+
                        playerlen)=false;
  end else
  begin
    players[ownnr].notinyet:=true;
    players[ownnr].ingame:=false;
  end;
  players[ownnr].shot.active:=false;
  players[ownnr].curspecial:=nothing;
  players[ownnr].pseudospecial:=nothing;
  players[ownnr].movement:=false;
  players[ownnr].shieldon:=false;
  shieldtime:=CurrentTime;
  LastDrawTime:=ShieldTime;
  shieldLastColor:=false;
  ArrowKeyHit:=false;
  repeat  {mainloop}
    Olddir:=players[ownnr].dir;
    Players[ownnr].dir:=NewDirection; {update owndir}
    players[ownnr].movement:=Arrowkeyhit;
    shotbefore:=players[ownnr].shot.active;
    ShieldBefore:=players[ownnr].Shieldon;
    KillsBefore:=players[ownnr].kills;


    if ctrlon then checkctrl;  {ctrlhold}
    UpdateOwnPos;
    for i:=1 to maxplayer do othershot[i]:=players[i].shot.active;
    if (shotbefore=false) and (players[ownnr].shot.active) then
    begin
      playFX(FX(players[ownnr].curspecial),0);
      inc(TotalShots);
    end;


    if (masterlasttime=false) and IamMaster then
    begin {er blevet ny master}
      for I:=1 to maxplayer do playerwaits[i]:=0;
      MasterLastTime:=true;
      bonus.specialtime:=CurrentTime-bonus.difference;
    end;
    BonusBefore:=bonus.specialon;

    If IamMaster then
    begin {do stuff}
     if nonetwork=false then
     begin
      for talknr:=1 to maxplayer do
      begin
        if (talknr<>ownnr) and (players[talknr].alive) then
        begin
          setpacketsize(send.ecb,4);
          settargetnode(send.ecb,send.ipx,players[talknr].node);
          masterinnerloop:=true;
          KillPlayer:=false;
          StartTime:=CurrentTime;
          sendinfo(Signal_wantinfo);
          repeat
            checkinfo(whatsignal);
            if someone(whatsignal,signal_synchronize) then
            begin
              sendinfo(Signal_wantinfo);
            end;
            if CurrentTime>(starttime+timeout) then killplayer:=true;
          until someone(whatsignal,signal_updateplayer) or killplayer;
          if killplayer then
          begin
            inc(playerwaits[talknr]);
            if playerWaits[talknr]>=WaitsAllowed then
            begin
              players[talknr].alive:=false;
              sendinfo(Signal_TerminatedByMaster);
            end;
            {send terminatedbyMaster }
          end else PlayerWaits[talknr]:=0;
          {should never reach this place -for debug purpose only}
          masterinnerloop:=false;
        end;  {den eksisterer virkelig}
      end;  {for talknr ....}
     end; {if nonetwork=false}
      if (players[ownnr].dir=quit) then
      begin
        quitok2:=true;
        players[ownnr].alive:=false;
      end;
      NewHandleAllInfo;
      if nonetwork=false then
      begin
      settargetnode(send.ecb,send.ipx,broadcast);
      for I:=1 to 3 do send.data[i]:=$EE;
      send.data[5]:=ownnr;
      move(players,send.data[6],sizeof(playertype)*maxplayer);
      move(bonus,send.data[6+sizeof(playertype)*maxplayer],sizeof(bonustype));
      if sendfamedata=false then
      begin
        setpacketsize(send.ecb,5+sizeof(playertype)*maxplayer+sizeof(bonustype));
        send.data[4]:=signal_updateallplayers;
      end else
      begin
        setpacketsize(send.ecb,5+sizeof(playertype)*maxplayer
                      +sizeof(bonustype)+sizeof(hallfametype)
                      +sizeof(terraintype));
        send.data[4]:=signal_updateallplayersScore;
        move(greatfame,send.data[6+sizeof(playertype)*maxplayer+
             sizeof(bonustype)],sizeof(hallfametype));
        move(terrain,send.data[6+sizeof(playertype)*maxplayer+
             sizeof(bonustype)+sizeof(hallfametype)]
             ,sizeof(terraintype));
        SendFameData:=false;
        sentfirstinfo:=true;
      end;
      repeat
      until send.ecb.inuse=0;
      IPXsendPacket(send.ecb);
      end; {if nonetwork=false}
      if (players[ownnr].ingame=false) and alivelasttime then
      begin
        alivelasttime:=false;
        deathstart:=CurrentTime;
        inc(TotalDeaths);
        playfx(owndeath,0);
      end;
     if (players[ownnr].dir=quit) and (quitok=false) and quitok2
     then begin
        quitok:=true;
     end;

      if nonetwork=false then checkinfo(whatsignal);
    end else
    begin {wait until infowanted}  {i am NOT master}
     MasterLastTime:=false;
     settargetnode(send.ecb,send.ipx,players[masternr].node);
     setpacketsize(send.ecb,4);
     sendinfo(Signal_synchronize);
     guestinnerloop:=true;
     {killmaster:=false;}
     starttime:=CurrentTime;
     repeat
       checkinfo(whatsignal);
       {if Currentime>(starttime+timeoutmaster) then killmaster:=true;}
     until someone(whatsignal,Signal_wantinfo){ or killmaster};
     guestinnerloop:=false;
      if (players[ownnr].dir=quit) then
      begin
        quitok2:=true;
        players[ownnr].alive:=false;
      end;
     settargetnode(send.ecb,send.ipx,players[masternr].node);
     setpacketsize(send.ecb,sizeof(playertype)+5);
     SendInfo(Signal_updatePlayer);
     updateallloop:=true;
     repeat
       checkinfo(whatsignal);
       {if CurrentTime>(starttime+timeoutmaster) then killmaster:=true;}
     until {killmaster or} someone(whatsignal,Signal_updateAllPlayers) or
           someone(whatsignal,Signal_updateAllPlayersScore);
     if (players[ownnr].dir=quit) and (quitok=false) and quitok2
     then begin
        quitok:=true;
     end;
     updateallloop:=false;
    {updater masternr}
{    if (quitok=false) and killmaster then
    begin
      players[masternr].alive:=false;
      if newmaster then
      begin
        masternr:=ownnr;
        IamMaster:=true;
        players[ownnr].master:=true;
      end;
      Hvis du ikke er ny master s vent indtil at
      du modtager en signalmasterchange fra den nye master eller changemaster
      =true
      {eller s send Signal_MasterChange (mangen til updateallplayers)
      to other players (broadcast)
      changemaster=false;
    end;}
    if players[ownnr].master then
    begin
      IamMaster:=true;
      masternr:=ownnr;
    end;
    if (shieldbefore=false) and (players[ownnr].shieldon) then
    begin
      ShieldTime:=currenttime+LargeShieldDuration;
      {playfx(hugeshield,0);}
    end;
    if (players[ownnr].ingame=false) and alivelasttime then
    begin
      alivelasttime:=false;
      deathstart:=CurrentTime;
      inc(TotalDeaths);
      playfx(owndeath,0);
    end;
    end; { i am not master}
    DrawPlayers;
    {Update the Sound}
    if (bonusbefore=false) and (bonus.specialon)
      and (players[ownnr].ingame) then playFx(coin,0);
    if players[ownnr].kills>KillsBefore then PlayFx(OtherDeath,0);
    if (shieldbefore=false) and (players[ownnr].shieldon)
      and (shieldtime-currenttime>Shieldduration+2) then
      playfx(hugeshield,0);
    {test code}
{    for I:=1 to maxplayer do
    begin
      if (othershot[i]=false) and (players[i].shot.active) and
        (players[i].alive) and (players[i].ingame)
        and (i<>ownnr) then
      begin
        playFX(FX(players[i].curspecial),maxchannels+i);
      end;
    end;}

    {check for new players }
       if nonetwork=false then
        If IamMaster then
        begin
        checkinfo(whatsignal);
        if someone(whatsignal,Signal_NewPlayerJoins) or newplayer then
            begin
              if newplayer=false
              then tempbyte:=whichone(whatsignal,Signal_NewplayerJoins)
              else tempbyte:=newnr;

              newplayer:=false;
              settargetnode(send.ecb,send.ipx,newnode);
              setpacketsize(send.ecb,6);
              for I:=1 to 3 do
              send.data[i]:=$EE;
              send.data[4]:=Signal_PlayerAccepted;
              send.data[5]:=ownnr;
              send.data[6]:=0;
              I:=1;
              while (i<9) and (send.data[6]=0) do
               begin
                 if players[i].alive=false then send.data[6]:=i;
                 inc(i);
               end;
              SendFameData:=true;
              move(receive[tempbyte].data[6],players[send.data[6]],sizeof(playertype));
              players[send.data[6]].alive:=true;
              repeat
              until send.ecb.inuse=0;
              IPXsendPacket(send.ecb);
              SortFameData;
            end;
          end; {i am master and checking for new players}
  until quitok;
  destroyvirtual(vir1point);
  destroyvirtual(collisionpoint);
  QuitCode;
  DoEndStuff;
end.
