#include <stdio.h>
#include "ff7head.h"


int readheader(char header[4], int slot)
{
    switch (slot)
	{
	case 1:
		return header[1]&0x01;
	case 2:
		return header[1]&0x02;
	case 3:
		return header[1]&0x04;
	case 4:
		return header[1]&0x08;
	case 5:
		return header[1]&0x10;
	case 6:
		return header[1]&0x20;
	case 7:
		return header[1]&0x40;
	case 8:
		return header[1]&0x80;
	case 9:
		return header[2]&0x01;
	case 10:
		return header[2]&0x02;
	case 11:
		return header[2]&0x04;
	case 12:
		return header[2]&0x08;
	case 13:
		return header[2]&0x10;
	case 14:
		return header[2]&0x20;
	case 15:
		return header[2]&0x40;
	default:
		return -1;
	}
	return 0;
}

int writeheader(unsigned char header[4], int slot)
{
	switch (slot)
	{
	case 1:
		header[1]|=0x01;
		if (header[0]< 0x00)
			header[0]=0x00;
		break;
	case 2:
		header[1]|=0x02;
		if (header[0]< 0x01)
			header[0]=0x01;
		break;
	case 3:
		header[1]|=0x04;
		if (header[0]< 0x02)
			header[0]=0x02;
		break;
	case 4:
		header[1]|=0x08;
		if (header[0]< 0x12)
			header[0]=0x12;
		break;
	case 5:
		header[1]|=0x10;
		if (header[0]< 0x22)
			header[0]=0x22;
		break;
	case 6:
		header[1]|=0x20;
		if (header[0]< 0x32)
			header[0]=0x32;
		break;
	case 7:
		header[1]|=0x40;
		if (header[0]< 0x42)
			header[0]=0x42;
		break;
	case 8:
		header[1]|=0x80;
		if (header[0]< 0x52)
			header[0]=0x52;
		break;
	case 9:
		header[2]|=0x01;
		if (header[0]< 0x62)
			header[0]=0x62;
		break;
	case 10:
		header[2]|=0x02;
		if (header[0]< 0x72)
			header[0]=0x72;
		break;
	case 11:
		header[2]|=0x04;
		if (header[0]< 0x82)
			header[0]=0x82;
		break;
	case 12:
		header[2]|=0x08;
		if (header[0]< 0x92)
			header[0]=0x92;
		break;
	case 13:
		header[2]|=0x10;
		if (header[0]< 0xA2)
			header[0]=0xA2;
		break;
	case 14:
		header[2]|=0x20;
		if (header[0]< 0xB2)
			header[0]=0xB2;
		break;
	case 15:
		header[2]|=0x40;
		if (header[0]< 0xC2)
			header[0]=0xC2;
		break;
	default:
		return -1;
	}
	return 0;
}