#include <stdio.h>
#include "ff7read.h"
#include "ff7head.h"

extern unsigned char ff7save[4340];

/*********************************************************************
Reads FF7 Data from a slot containing data from the raw memory card
data like the one used with bleem or most homemade memory card 
copiers!

  In: Filename,  Memory Card Slot

  Out: Error level

  Destroys: Nothing

*********************************************************************/
int rawmemcard(char fn[14], int slot, int cardtype)

	{
	   FILE *f;

            
        f=fopen(fn,"rb");
        if(f==NULL)
        {
                printf("Cannot open filename specified!\n");
                return(1);
        }
		fseek(f,((8192 * slot) + 512 + cardtype),SEEK_SET);
        fread(ff7save,4340,1,f);

             
        fclose(f);
        printf("PSX Memory card File Read Successfully!\n\n");

             gets(fn);
			 
      
        return(0);

}
/*********************************************************************
Reads FF7 Save Data from A PC save!

  In: Filename,  Memory Card Slot

  Out: Error level

  Destroys: Nothing

*********************************************************************/
int PCsave(char fn[14], int slot)

	{
	   FILE *f;
	   char header[4];
	   int result;
        f=fopen(fn,"rb");
        if(f==NULL)
        {
                printf("Cannot open filename specified!\n");
                return(1);
        }
		fgetc(f);fgetc(f);fgetc(f);fgetc(f);  //Throw away the first 4 bytes
		fread(header, 4, 1, f);
		result = readheader(header, slot);
		if (result == 0) 
		{printf("There is not a valid save in slot %d", slot);
		return 2;}

		fseek(f,((4340 * slot) + 9 - 4340),SEEK_SET);
        fread(ff7save,4340,1,f);

             
        fclose(f);
        printf("FF7 PC save File Read Successfully!\n\n");

             gets(fn);
			 
      
        return(0);

}



