/* Copyright by Cait Sith 2
Not responsible for any Damages that arise from use of software or source code

If you make an improvement to the source,
Please email the modified source file or files to dgood@kermode.net
*/


#include <stdio.h>
#include "ff7read.h"
#include "ff7write.h"


unsigned char ff7save[4340];


int main(int argc, char *argv[])
{
	unsigned int slot, slot1;
	unsigned int select, error;
	char filename[14];


		printf("Select the FF7Save format to read from!\n");
		printf("1. Raw PSX Memory Card - *.mc *.mcd *.ddf\n");
		printf("2. Dex Drive Save - *.gme\n");
		printf("3. VGS save - *.mem *.vgs\n");
		printf("4. FF7 PC save - save0?.ff7\n");
		printf("5. Quit\n");
		scanf("%d", &select);
		if (select == 5)
			return 0;
		gets(filename); //Throw away a return!  need to do this 
				  //after a scanf or 
				  //else it won't prompt for filename later on!
		printf("Please Enter the name of File to be opened for reading!\n");
		gets(filename);
		printf("Select a slot between 1 and 15\n");
		scanf("%d", &slot);
		switch (select)
		{
		case 1:
			error = rawmemcard(filename, slot, 0);
			break;
		case 2:
			error = rawmemcard(filename, slot, 3904);
			break;
		case 3:
			error = rawmemcard(filename, slot, 64);
			break;
		case 4:
			error = PCsave(filename, slot);
			break;
		default:
			printf("Invalid Selection");
		    return -1;
			break;
		}
		if (error != 0)
			return error;

		printf("Select the FF7Save format to write to!\n");
		printf("1. Raw PSX Memory Card - *.mc *.mcd *.ddf\n");
		printf("2. Dex Drive Save - *.gme\n");
		printf("3. VGS save - *.mem *.vgs\n");
		printf("4. FF7 PC save - save0?.ff7\n");
		printf("5. Quit\n");
		scanf("%d", &select);
		if (select == 5)
			return 0;
		gets(filename); //Throw away a return
		printf("Please Enter the name of File to be opened for writing!\n");
		gets(filename);
		printf("Select a slot between 1 and 15\n");
		scanf("%d", &slot);
		switch (select)
		{
		case 1:
			printf("Now Select which slot FF7 PSX would read it as\n");
			scanf("%d", &slot1);
			error = PSXCardwrite(filename, slot, slot1, 0);
			break;
		case 2:
			printf("Now Select which slot FF7 PSX would read it as\n");
			scanf("%d", &slot1);
			error = PSXCardwrite(filename, slot, slot1, 3904);
			break;
		case 3:
			printf("Now Select which slot FF7 PSX would read it as\n");
			scanf("%d", &slot1);
			error = PSXCardwrite(filename, slot, slot1, 64);
			break;
		case 4:
			error = PCsavewrite(filename, slot);
			break;
		default:
			printf("Invalid Selection");
		    return -1;
			break;
		}
		if (error != 0)
			return error;
    

        
        return(0);
}

