#include <stdio.h>
#include "ff7write.h"
#include "ff7head.h"

extern unsigned char ff7save[4340];

/*********************************************************************
writes FF7 save data to an existing FF7 save slot on a PC FF7 save!

  In: Filename,  Memory Card Slot

  Out: Error level

  Destroys: Nothing

*********************************************************************/
int PCsavewrite(char fn[14], int slot)

	{
	   FILE *f;
	   char header[4];
	   int result;
        f=fopen(fn,"rb+");
        if(f==NULL)
        {
                printf("Cannot open filename specified!\n");
                return(1);
        }
		fgetc(f);fgetc(f);fgetc(f);fgetc(f);
		fread(header, 4, 1, f);
		result = readheader(header, slot);
		if (result != 0)
		{
			printf("Slot %d already contains save data\n", slot);
			printf("Overwrite it?\n");
			printf("1. Yes\n2. No\n");
			
			scanf("%d", &result);

			if (result == 2)
			{
				return 1;
			}
		}
		fseek(f,((4340 * slot) + 9 - 4340),SEEK_SET);
        fwrite(ff7save,4340,1,f);
		writeheader(header, slot);
		fseek(f,4,SEEK_SET);
		fwrite(header,4,1,f);
             
        fclose(f);
        printf("FF7 PC save File written Successfully!\n\n");

             gets(fn);
			 
      
        return(0);

}

/*********************************************************************
Creates an FF7 PSX compatible save, and writes it to the memory card
image

     IN: File name, slot in card, slot FF7 sees, Memcard offset

     OUT: ERROR LEVEL

     Destroys: Nothing

*********************************************************************/


int PSXCardwrite(char fn[14], int slot, int ff7slot, int cardtype)
{
    FILE *f; //The main file to be opened
    FILE *ff7data; //FF7 Icon Data
	unsigned int timer, timer1, timer2;
	unsigned char fn2[13] = "ff7icon.dat";
	unsigned char ff7ident[18] = "BASCUS-94163FF7-S";  //Country Code: BA
							   //product ID: SCUS-94163
							   //Identifier: FF7-Sxx
	unsigned char ff7ident2[18] = ".e.e.V.^.r.`.u.d."; // FF7/SAVExx in JIS
	unsigned char ff7ident3[13] = ".^.U.V.F.P.R";      // /xx:xx in JIS
	unsigned char ff7iconpal[33];			   // Icon 16 color palette data
        unsigned char ff7icondat[129];
		int slot1, slot2, i;
	unsigned char j;
		for (i=0;i<9;i++)
			ff7ident2[i*2] = 0x82;
		ff7ident2[6] = 0x81;
		for (i=0;i<7;i++)
			ff7ident3[i*2] = 0x82;
		ff7ident3[0] = 0x81;
		ff7ident3[6] = 0x81;

		timer = ff7save[0x24] + (ff7save[0x25]<<8) + (ff7save[0x26]<<16) + (ff7save[0x27]<<24);
		timer1 = timer / 60;
		timer2 = timer1 % 60;
		timer1 = timer1 / 60;
	//	ff7ident3[3] = ((timer1 / 100) + 'O');
		timer1 %= 100;
		ff7ident3[3] = ((timer1 / 10) + 'O');
		ff7ident3[5] = ((timer1 % 10) + 'O');
		
		ff7ident3[9] = ((timer2 / 10) + 'O');
		ff7ident3[11] = ((timer2 % 10) + 'O');


        f=fopen(fn,"rb+");
        ff7data=fopen(fn2,"rb+");
        
        if((f==NULL)||(ff7data==NULL))
        {
                printf("Cannot open filename specified!\n");
                return(1);
        }
	fseek(ff7data,(0x80 * ff7slot), SEEK_SET);
        fread(ff7icondat, 128, 1, ff7data);
	fseek(ff7data,(0x20 * ff7slot) + 2048, SEEK_SET);
        fread(ff7iconpal, 32, 1, ff7data);
	fclose(ff7data);
	if (cardtype==3904) // Checking to see if it is a dex drive save
	{
		fseek(f,(slot + 21), SEEK_SET);
		fputc(0x51, f); //Set a byte in the GME File header to indicate that slot is present
		fseek(f,(slot + 37), SEEK_SET);
		fputc(0xFF, f); //Set a byte in GME File header, to prevent Dexplorer from crashing.
	}

		fseek(f,((128 * slot) + cardtype),SEEK_SET);    // Skip to the Directory Frame specified in slot
		fputc(0x51, f);					// Puts the block in use
		fputc(0x00, f); fputc(0x00, f); fputc(0x00, f); // Has to be 0x000000
		fputc(0x00, f); fputc(0x20, f);	fputc(0x00, f);	// Indicates only one save block to be used.
	        fputc(0x00, f);		 	
		fputc(0xFF, f); fputc(0xFF, f);			// Block is not a link block
		fwrite(ff7ident, 17, 1, f);			// Write BASCUS-94163FF7-S
		slot1 = ((ff7slot / 10) + '0');			// Calculate tens digit of slot
		slot2 = ((ff7slot % 10) + '0');			// Calculate ones digit of slot
		fputc(slot1, f);				// Write 10's digit
		fputc(slot2, f);				// Write 1's digit
		
		fclose(f);					// Attempting bug fix
		f=fopen(fn,"rb+");
		if(f==NULL)
       		{
                    printf("Cannot open filename specified!\n");
                    return(1);
        	}
		fseek(f,((128 * slot) + cardtype),SEEK_SET);
		j = fgetc(f);
		for (i=0;i<0x7E;i++)   
			j = j ^ fgetc(f);			// Calculate Checksum using XOR
		fseek(f,((128 * slot) + cardtype + 127),SEEK_SET);
		fputc(j, f);					// And write it to end of frame

/*********************************************************************/
/* Now writing onto actual Memory card block			     */
/*********************************************************************/


		fseek(f,((8192 * slot) + cardtype),SEEK_SET);	// Find the offset, using slot
		fputc('S', f);					// Write SC
		fputc('C', f);
		fputc(0x11, f);					// Tell playstation Icon has 1 frame
		fputc(0x01, f);					// Block #
		fwrite(ff7ident2, 17, 1, f);			// Write JIS Title: FF7/S-xx
		slot1 = ((ff7slot / 10) + 'O');
		slot2 = ((ff7slot % 10) + 'O');
		fputc(slot1, f);
		fputc(0x82, f);
		fputc(slot2, f);
		fwrite(ff7ident3, 12, 1, f);			// Finish the title with: /xx:xx
		for (i=0;i<0x3C;i++)				// Writing 0 as this
			fputc(0, f);				// space is reserved
		fwrite(ff7iconpal, 32, 1, f);			// Icon 16 color palette data
		fwrite(ff7icondat, 128, 1, f);			// Icon Data
		for (i=0;i<256;i++)				// Make frames 2 & 3
			fputc(0x00, f);				// of icon space null
						// I plan to make it put proper palette and Icon
						// Data for the slot in the future.


		fseek(f,((8192 * slot) + 512 + cardtype),SEEK_SET); // Skip to frame 4 of block
		fwrite(ff7save, 4340, 1, f);			    // And write the FF7 Save data there
             
        fclose(f);
        printf("PSX Memory card File written Successfully!\n\n");

             gets(fn);
			 
      
        return(0);

}