/********************************************************
 * Unnamed RPG project                                  *
 * (c) Haakon Lorentzen 1999                            *
 *                                                      *
 * RPG using Allegro and ???                            *
 *                                                      *
 *******************************************************/

#include <allegro.h>        //gfx, input, sfx...
#include <stdio.h>
#include <stdlib.h>
#include <tilemap.h>        //map functions
#include <jgmod.h>          //music (mod) functions
#include "base.h"           //graphics
#include "sfx.h"            //sound

#define  UP        1
#define  DOWN      2
#define  LEFT      3
#define  RIGHT     4

#define SCR_WIDTH 640      //screen width
#define SCR_HEIGHT 480     //screen height
#define COL_DEPTH 16       //colour depth

#define COL_LAYER 3        //collition detection layer

#define SPEED 2            //Player speed in pixels/frame
#define T_SPEED 32/SPEED   //To keep player aligned with the tiles

BITMAP     *buffer;        //memory bitmap for double buffering
TILEMAP    *level2;        //the map
DATAFILE   *base;          //graphics
DATAFILE   *sfx;           //sound & music
RLE_SPRITE *character;     //the player sprite
JGMOD      *music;         //mod music

int x = 32*10, y = 32*10;  //player position
int wanttoexit = FALSE;    //changes to TRUE if 'escape' is pressed
int pause_flag = FALSE;
int mx=0,my=0;             //map position
int tile_type;             //determines what kind of tile the player is on
int layer;

//prototypes
void launch_allegro(void);
void update_screen(void);
void move_player();
void input(void);
void game(void);
int main(void);

/************************************************************
function: launch_allegro
use:      Starts allegro, loads data, creates a buffer and
          sets graphics and sound mode
************************************************************/
void launch_allegro(void)
{
    printf("\nStarting game\n");    //start allegro
    allegro_init();
    printf("Starting timer...\n");       //start timer
    install_timer();
    printf("reserving voices...\n");     //reserve voices
    reserve_voices(16, -1);
    printf("Initializing keyboard...\n");  //start keyboard
    install_keyboard();

    set_color_depth(COL_DEPTH);   //chooses colour depth

    printf("Loading map...\n");          //loads tilemap
    level2=load_tilemap("level2.map");

    printf("Setting up sound...\n");    //sound setup
    if(install_sound(DIGI_AUTODETECT,MIDI_NONE,NULL) !=0) //if it doesn't work
    {
        allegro_exit();        //quit allegro
        printf("Can't set sound\n%s\n\n", allegro_error);
        exit(1);
    }

    if(install_mod (4) < 0)
    {
        allegro_exit();
        printf("\nCan't set up mod music\n");
        exit(1);
    }

    printf("Setting up graphics...\n");   //graphics setup
    if(set_gfx_mode(GFX_AUTODETECT,SCR_WIDTH,SCR_HEIGHT,0,0) !=0)
    {
        allegro_exit();
        printf("can't set up graphics\n%s\n\n", allegro_error);
        exit(1);
    }

    if((base = load_datafile("base.dat"))==NULL) //load base.dat
    {
        allegro_exit();
        printf("Can't find \"base.dat\".\n%s\n\n", allegro_error);
        exit(1);
    }

    if((sfx = load_datafile("sfx.dat"))==NULL)  //load sfx.dat
    {
        allegro_exit();
        printf("Can't find \"sfx.dat\".\n%s\n\n", allegro_error);
        exit(1);
    }

    music = load_mod("music1.mod");            //load music
    set_mod_volume(128);                       //set volume

    buffer = create_bitmap(SCREEN_W,SCREEN_H); //create buffer
    clear(buffer);                             //clear buffer

    correct_tilemap(level2, base);
}

/************************************************************
function: update_screen
use:      draws the graphics to memory and blits it to the
          screen
************************************************************/
void update_screen(void)
{
    clear(buffer);    //empties the buffer
    
    for(layer=0;layer < level2->layers-1; layer++)
    draw_tilemap_layer(buffer, base, level2, layer, mx, my); //draw tilemap

    draw_rle_sprite(buffer, character, mx+x, my+y); //draw player

    vsync();                         //wait for vertical retrace
    blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H); //copy contents of the buffer to the screen
}

/************************************************************
function: input
use:      reads the control devices
************************************************************/
void input()
{

    if(key[KEY_UP])
    move_player(UP);

    if(key[KEY_DOWN])
    move_player(DOWN);

    if(key[KEY_LEFT])
    move_player(LEFT);

    if(key[KEY_RIGHT])
    move_player(RIGHT);

    if(key[KEY_F3])
    set_mod_volume(get_mod_volume() - 2);

    if(key[KEY_F4])
    set_mod_volume(get_mod_volume() + 2);

    if(key[KEY_ESC])
    wanttoexit = TRUE;
}

/************************************************************
function: move_player
use:      moves player(duh)
************************************************************/
void move_player(int direction)
{
  int frame=0;
  
  // bounds checking
  switch(direction)
  {
    case UP:
      if(y <= 0) return;
    break;
    case DOWN:
      if(y+character->w >= level2->ysize*level2->ygrid) return;
    break;
    case LEFT:
      if(x <= 0) return;
    break;
    case RIGHT:
      if(x+character->h >= level2->xsize*level2->xgrid) return;
    break;
  }

  // what tile type will we be stepping on?
  switch(direction)
  {
    case UP:
      tile_type = get_sprite_number(level2,COL_LAYER,x/level2->xgrid,y/level2->ygrid-1);
    break;
    case DOWN:
      tile_type = get_sprite_number(level2,COL_LAYER,x/level2->xgrid,y/level2->ygrid+1);
    break;
    case LEFT:
      tile_type = get_sprite_number(level2,COL_LAYER,x/level2->xgrid-1,y/level2->ygrid);
    break;
    case RIGHT:
      tile_type = get_sprite_number(level2,COL_LAYER,x/level2->xgrid+1,y/level2->ygrid);
    break;
  }
    
  // stops the player from walking on "stop"-tiles, eg. the tiles marked as impassable
  switch(tile_type)
  {
    case stop:
    return;
    break;
  }

  // move player
  switch(direction)
  {
    case UP:     //if 'up'-key is pressed
      for(frame=0;frame<T_SPEED; frame++)
      {
        character=base[hero_up].dat;   //selects sprite
        y-=SPEED;                   //moves player
        if(my+y<160) my+=SPEED;     //moves map if player is < 192 pixels from the edge
        update_screen();            //starts the update_screen function
      }
    break;
    case DOWN:
      for(frame=0; frame<T_SPEED; frame++)
      {
        character=base[hero_down].dat;
        y+=SPEED;
        if(my+y>SCREEN_H-160) my-=SPEED;
        update_screen();
      }
    break;
    case LEFT:
      for(frame=0; frame<T_SPEED; frame++)
      {
        character=base[hero_left].dat;
        x-=SPEED;
        if(mx+x<192) mx+=SPEED;
        update_screen();
      }
    break;
    case RIGHT:
      for(frame=0; frame<T_SPEED; frame++)
      {
        character=base[hero_right].dat;
        x+=SPEED;
        if(mx+x>SCREEN_W-192) mx-=SPEED;
        update_screen();
      }
    break;
  }
}

/************************************************************
function: game
use: runs the ingame functions
************************************************************/
void game(void)
{
    update_screen();
    input();
}

/************************************************************
function: main
use: executes the whole damn thing
************************************************************/
int main()
{
    launch_allegro();

    character = base[hero_down].dat;
    play_mod(music, TRUE);
  
    while(!wanttoexit)
    {
        game();
    }
  
    // flush keyboard buffer
    clear_keybuf();
  
    // unload map and sprites
    destroy_tilemap(level2);
    destroy_bitmap(buffer);
    unload_datafile(base);
    unload_datafile(sfx);
    allegro_exit();

    return 0;
}
END_OF_MAIN();
