/*
 * Space force
 * (c) Haakon Lorentzen 1999
 *
 * simple arcade shoot'em up
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <conio.h>
//#include <math.h>
#include <allegro.h>

#include "main.h"

RGB_MAP rgb_table;
COLOR_MAP light_table;
DATAFILE *data;
BITMAP *buffer;

int width=640;
int height=480;
int textcol=4;

char highscorebuf[20];
FILE *hscore;

int frame_number;
int finished=0;
volatile int fps;
volatile int last_frame;
//char intro_logo[80];
//char intro_name[80];
char finalscore[30];
char fpstxt[20];
char msg[20];
char healthtxt[20];
char pausetxt[10];
char pausetxt2[30];
int health=10;
int x_pos=300;
int speed=6;
int x_alien;
int y_alien=10;
int x_bullet;
int y_bullet=430;
int skyt;
int x_abullet=0;
int y_abullet=0;
int skyt2;
int score=0;
/*       variabler for stjernene.        */
/*        stars=antall stjerner          */
/*    d=en dummy for for-looper etc      */
/* sx & sy=stjernenes x- og y-posisjoner */
/*       ssp=farta p stjernene         */
int ns;
int d;
int sx[2000];
int sy[2000];
int ssp[2000];

int resolution(void)
{
 int q;
 printf("\nChoose your resolution: ");
 printf("\n640x480: Press 1");
 printf("\n800x600: Press 2");
 printf("\n1024x768: Press 3");
 printf("\n1280x1024: Press 4\n");
 scanf("%i", &q);
 if(q==1)
 {
  width=640;
  height=480;
 }
 if(q==2)
 {
  width=800;
  height=600;
 }
 if(q==3)
 {
  width=1024;
  height=768;
 }
 if(q==4)
 {
  width=1280;
  height=1024;
 }
}

int movie()
{
 if(width==640)
 { draw_sprite(screen,data[intro640].dat, 0, 0); }
 if(width==800)
 { draw_sprite(screen,data[intro800].dat, 0, 0); }
 if(width==1024)
 { draw_sprite(screen,data[intro1024].dat, 0, 0); }
 if(width==1280)
 { draw_sprite(screen,data[intro1024].dat, 128, 128); }

 textout(screen, font, "You are a member of Space Force, a peacekeeping policeforce in the 21st century.",1,10,textcol);
 rest(4000);
 clear(screen);

 if(width==640)
 { draw_sprite(screen,data[intro640].dat, 0, 0); }
 if(width==800)
 { draw_sprite(screen,data[intro800].dat, 0, 0); }
 if(width==1024)
 { draw_sprite(screen,data[intro1024].dat, 0, 0); }
 if(width==1280)
 { draw_sprite(screen,data[intro1024].dat, 128, 128); }

 textout(screen, font, "Your mission: To blow the alien pirates to smithereens!",1,10,textcol);
 rest(4000);
 ns=1000;
 clear(screen);
}

int intro(void)
{
  fade_in(data[pal].dat, 10);
  textout_centre(screen, data[stor1].dat, "Space Force", SCREEN_W/2, 50, textcol);
  rest(1000);
  textout_centre(screen, data[liten1].dat, "(c) Haakon Lorentzen", SCREEN_W/2, 100, textcol);
  rest(1000);
  textout_centre(screen, data[liten1].dat, "press any key...", SCREEN_W/2, 150, textcol);
  readkey();
  fade_out(1);
  clear(screen);
  fade_in(data[pal].dat, 64);
  return;
}

int highscore(void)
{
 hscore=fopen("high.hsl","a");
 fprintf(hscore, "%d\n", score);
 fclose(hscore);
}
END_OF_FUNCTION(highscore);

int lyd(void)
{
 play_sample(data[rakettlyd].dat,255,120,1000,0);
 return;
}

int musikk(void)
{
 play_midi(data[musikk1].dat, TRUE);
 return;
}

void frames(void)
{
 last_frame=fps;
 fps=0;
}
END_OF_FUNCTION(frames);

int screenshot(char *filename)
{
  BITMAP *vis;
  int ret;

  get_pallete(pal);
  vis=create_sub_bitmap(screen, 0, 0, SCREEN_W, SCREEN_H);
  textout(buffer, data[liten1].dat, "Screenshot taken", 1, SCREEN_H-20, textcol);
  if(vis==NULL)
  {
   ret=save_bitmap(filename,screen,pal);
  }
  else
  {
   ret=save_bitmap(filename,vis,pal);
   destroy_bitmap(vis);
  }
  return ret==0;
}
END_OF_FUNCTION(screenshot);

void flytt_spiller(void)
{
 if((key[KEY_LEFT]) && (x_pos>0))
 {
  x_pos=x_pos-speed;
 }
 if((key[KEY_RIGHT]) && (x_pos<SCREEN_W-50))
 {
  x_pos=x_pos+speed;
 }

 for (d=1; d<ns; d++)
 {
  sy[d] = sy[d] + ssp[d];

  if (sy[d] >= SCREEN_H)
  sy[d] = 0;

  _putpixel(buffer, sx[d], sy[d], 215);
 }

 draw_rle_sprite(buffer,data[skip1].dat,x_pos,SCREEN_H-60);

 if((y_alien<=SCREEN_H) && (y_alien+50>=SCREEN_H-10))
 {
  if((x_alien+50>=x_pos) && (x_alien<=x_pos+50))
   {
    health-=2;
    y_alien=0;
    x_alien=rand()%SCREEN_W-25;
   }
 }

 if((key[KEY_SPACE]) && (skyt!=TRUE))
 {
  skyt = TRUE;
  skyt2 = TRUE;
  lyd();
  x_bullet=x_pos+20;
  x_abullet=x_alien+20;
  y_abullet=y_alien+50;
 }

if (skyt!=FALSE)
{
  draw_rle_sprite(buffer,data[rakett].dat,x_bullet,y_bullet);
  y_bullet-=4;
}

if(y_bullet<0)
{
 x_bullet=0;
 y_bullet=SCREEN_H-60;
 skyt=FALSE;
}

if(skyt!=FALSE)
{
if((y_bullet>=y_alien) && (y_bullet+20<=y_alien+50))
{
 if((x_bullet>=x_alien) && (x_bullet+10<=x_alien+50))
 {
  skyt=FALSE;
  play_sample(data[eksplosjon].dat,255,120,1000,0);
  y_bullet=SCREEN_H-60;
  y_alien=0;
  x_alien=rand()%SCREEN_W-25;
  score++;
 }
}
}
 return;
}

void flytt_alien()
{
 draw_rle_sprite(buffer,data[skip].dat,x_alien,y_alien);
 y_alien+=4;

 if (skyt2!=FALSE)
 {
  draw_rle_sprite(buffer,data[rakett2].dat,x_abullet,y_abullet);
  y_abullet+=6;
 }

 if(y_abullet>SCREEN_H)
 {
 skyt2=FALSE;
 }

 if(skyt2!=FALSE)
 {
  if((y_abullet>=SCREEN_H-60) && (y_abullet+20<=SCREEN_H-60+50))
  {
   if((x_abullet>=x_pos) && (x_abullet+10<=x_pos+50))
   {
    skyt2=FALSE;
    health--;
   }
  }
 }
 if (y_alien >=SCREEN_H)
 {
 y_alien=0;
 x_alien=rand()%SCREEN_W-25;
 score--;
 }
 if(x_alien+25>x_pos+50)
 {
  x_alien--;
 }
 if(x_alien+25<x_pos)
 {
  x_alien++;
 }
}

int spill(void)
{
 while(!key[KEY_ESC])
 {
  flytt_spiller();
  flytt_alien();
  while(key[KEY_S])
  {
   screenshot("screenshot.pcx");
   break;
  }
  if(health<=0)
  return;
  sprintf(msg, "score = %-5d", score);
  textout(buffer, data[liten1].dat, msg, 1, 1, textcol);
  sprintf(healthtxt, "health = %-5d", health);
  textout_centre(buffer, data[liten1].dat, healthtxt, SCREEN_W/2 ,1, textcol);
  sprintf(fpstxt, "fps = %-5d",last_frame);
  textout(buffer, data[liten1].dat, fpstxt, SCREEN_W-150, 1, textcol);
  if(!key[KEY_F])
  {
  vsync();
  }
  if(key[KEY_P])
  {
   sprintf(pausetxt, "Pause");
   sprintf(pausetxt2, "Press 'up' to continue...");
   while(!key[KEY_UP])
   {
    textout_centre(screen, data[stor1].dat, pausetxt, SCREEN_W/2, SCREEN_H/2, textcol);
    textout_centre(screen, data[liten1].dat, pausetxt2, SCREEN_W/2, SCREEN_H/2+40, textcol);
   }
  }
  blit(buffer,screen,0,0,0,0,SCREEN_W,SCREEN_H);
  fps++;
  clear(buffer);
 }
}

int main(void)
{
 x_pos=SCREEN_W/2;
 y_bullet=SCREEN_H-60;

 srand((unsigned)time(NULL));

 resolution();

 allegro_init();
 install_keyboard();
 install_timer();
 install_int(frames, 1000);
 if((data=load_datafile("main.dat"))==NULL)
 {
  allegro_exit();
  printf("Hey! Are you stupid, or what? You can't start the game without \"main.dat\". Duh!\n%s\n\n", allegro_error);
  exit(1);
}

printf("Initializing sound...\n");
if(install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,NULL) !=0)
{
 allegro_exit();
 printf("Can't set up the sound\n%s\n\n", allegro_error);
 exit(1);
}

set_color_depth(8);

if(set_gfx_mode(GFX_AUTODETECT,width,height,0,0) !=0)
{
 allegro_exit();
 printf("can't set up graphics\n%s\n\n", allegro_error);
 exit(1);
}

set_pallete(data[pal].dat);
buffer=create_bitmap(width,height);
clear(buffer);

create_rgb_table(&rgb_table, pal, NULL);
rgb_map = &rgb_table;

create_light_table(&light_table, pal, 0, 0, 0, NULL);
color_map = &light_table;

fade_in(data[pal].dat,5);

movie();

intro();

for(d=0; d<ns; d++)
{
sx[d] = rand() % SCREEN_W;
sy[d] = rand() % SCREEN_H;
ssp[d] = rand() % 3 + 1;
}
musikk();
spill();
fade_out(5);
clear(buffer);
clear(screen);
fade_in(data[pal].dat,5);
textout_centre(screen, data[stor1].dat, "Game over", SCREEN_W/2, 50, textcol);
sprintf(finalscore, "You got %-5d points!", score);
textout_centre(screen, data[liten1].dat, finalscore, SCREEN_W/2, 100, textcol);
rest(1000);
readkey();
fade_out(1);
allegro_exit();
highscore();
}
