 /*

  This is a part of the LiteStep Shell Source code.

  Copyright (C) 1997-98 The LiteStep Development Team

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/****************************************************************************
 11/11/98 - Fahim Farook
			Added a new function called GetLSBitmapSize to replace the old
			GetBitmapSize in popups as C has a similar function and because
			taskbar skinning added by Thedd uses the same function as well
 07/11/98 - Fahim Farook
			Added a dialog box to show version information
 31/10/98 - Fahim Farook
			Added a function for loading and/or extracting icon files
 15/10/98 - B. Kilian
				Added the pattern matching stuff in.

 15/09/98 - J. Vaughn
                Added Bang commands for the VWM, and ability to give params
				to the command.
 31/08/98 - D. Hodgkiss
                Added TransparentBltLS command

 25/08/98 - D. Hodgkiss
                This file contains the source for general functions
                that can be called by core modules

****************************************************************************/


#include <windows.h>
//#include <wingdi.h>
#include <stdio.h>
#include <string.h>
#include <tchar.h>
#include "lsapi.h"

typedef struct {
        char *name;
        void (*func)(HWND caller, char* args);
} tBangCommand;

typedef struct {
	char program[255];
	char bitmap[255];
} tThemePic;

const char rcsRevision[] = "$Revision: 1.40 $"; // Our Version 
const char rcsId[] = "$Id: lsapi.c,v 1.40 1998/11/17 02:21:17 bryan Exp $"; // The Full RCS ID.
static char **RCBuffer = NULL;
static char **ThemeBuffer = NULL;
static tThemePic *PicBuffer = NULL;
static int ThemePicLen = 0;
static int ThemeLen = 0;
static int RCLen = 0;
static BOOL ThemeInUse = FALSE;
static BOOL ColorRGB = FALSE;
static BOOL AboutDialog = FALSE;
char vbuffer[2048];

int matche_after_star (register char *pattern, register char *text);
int fast_match_after_star (register char *pattern, register char *text);

LRESULT CALLBACK About(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
void BangRecycle (HWND caller,char* args);
void BangRun (HWND caller,char* args);
void BangShutdown(HWND caller,char* args);
void BangLogoff(HWND caller,char* args);
void BangQuit(HWND caller,char* param);
void BangToggleWharf(HWND caller,char* args);
void BangGather(HWND caller,char* args);
void BangVWMDesk(HWND caller,char* args);
void BangVWMUp(HWND caller,char* args);
void BangVWMDown(HWND caller,char* args);
void BangVWMLeft(HWND caller,char* args);
void BangVWMRight(HWND caller,char* args);
void BangVWMNav(HWND caller,char* args);
void BangPopup(HWND caller,char* args);
void BangTileWindowsH(HWND caller, char *args);
void BangTileWindowsV(HWND caller, char *args);
void BangCascadeWindows(HWND caller, char *args);
void BangEasterEgg(HWND caller, char* args);
void BangMinimizeWindows(HWND caller, char *args);
void BangRestoreWindows(HWND caller, char *args);
void BangAbout(HWND caller, char *args);

static tBangCommand BangCommands[] = {
	{ "!GATHER",	BangGather },
	{ "!RECYCLE",   BangRecycle },
	{ "!RUN",       BangRun     },
	{ "!SHUTDOWN",  BangShutdown },
	{ "!TOGGLEWHARF", BangToggleWharf },
	{ "!LOGOFF",	BangLogoff },
	{ "!QUIT",		BangQuit },
	{ "!VWMDESK",   BangVWMDesk },
	{ "!VWMDOWN",   BangVWMDown },
	{ "!VWMLEFT",   BangVWMLeft },
	{ "!VWMNAV",   BangVWMNav },
	{ "!VWMRIGHT",   BangVWMRight },
	{ "!VWMUP",   BangVWMUp },
	{ "!POPUP",		BangPopup },
	{ "!EASTEREGG",	BangEasterEgg},
	{ "!TILEWINDOWSH", BangTileWindowsH },
	{ "!TILEWINDOWSV", BangTileWindowsV },
	{ "!CASCADEWINDOWS", BangCascadeWindows },
	{ "!MINIMIZEWINDOWS", BangMinimizeWindows },
	{ "!RESTOREWINDOWS", BangRestoreWindows },
	{ "!ABOUT",		BangAbout }
};

static tBangCommand * BangAdded = NULL;
static int Bangs = 0;



#define MAX_BANG_COMMANDS       ((sizeof(BangCommands) / sizeof(tBangCommand)) - 0)
#define MAX_LINE_LENGTH 4096

static TCHAR szFileName[MAX_PATH] = { _T('\0') };

static BOOL LCReadNextLine (FILE *f, LPSTR szBuffer, DWORD dwLength);

FILE *LCOpen (LPCTSTR szPath)
{
	FILE *f = NULL;

	if (szPath)
	{
		lstrcpy (szFileName, szPath);
	}
	else
	{
		if (!szFileName[0])
		{
			lstrcpy (szFileName, "step.rc");
		}
	}

	f = fopen (szFileName, "r");
	
	if (f)
	{
		fseek (f, 0, SEEK_SET);
	}

	return f;
}




BOOL LCClose (FILE *f)
{
	if (f)
	{
		fclose (f);
	}

	return TRUE;
}

BOOL LCReadNextCommand (FILE *f, LPSTR szBuffer, DWORD dwLength)
{
	char szTempBuffer[MAX_LINE_LENGTH];

	if (!f)
	{
		return FALSE;
	}

	while (LCReadNextLine (f, szTempBuffer, sizeof (szTempBuffer)))
	{
		if (!ispunct (szTempBuffer[0]))
		{
			strncpy (szBuffer, szTempBuffer, dwLength);

			return TRUE;
		}
	}

	return FALSE;
}

BOOL LCReadNextConfig (FILE *f, LPCSTR szPrefix, LPSTR szBuffer, DWORD dwLength)
{
	char szTempPrefix[MAX_LINE_LENGTH], szTempBuffer[MAX_LINE_LENGTH];
	int prefix_length = 0;

	if (!f)
	{
		return FALSE;
	}

	szTempPrefix[0] = 0;

	if (szPrefix[0] != '*')
	{
		strcpy (szTempPrefix, "*");
	}

	strcat (szTempPrefix, szPrefix);
	strcat (szTempPrefix, " ");

	prefix_length = strlen (szTempPrefix);

	while (LCReadNextLine (f, szTempBuffer, sizeof (szTempBuffer)))
	{
		if (!strnicmp (szTempBuffer, szTempPrefix, prefix_length))
		{
			strncpy (szBuffer, szTempBuffer, dwLength);

			return TRUE;
		}
	}

	return FALSE;
}

BOOL LCReadNextLine (FILE *f, LPSTR szBuffer, DWORD dwLength)
{
	while (f && !feof (f))
	{
		int length;

		if (!fgets (szBuffer, dwLength, f))
		{
			break;
		}

		length = strlen (szBuffer);

		// Skip any leading and trailing whitespace
		while (length && isspace (szBuffer[0]))
		{
			length--;
			strcpy (szBuffer, szBuffer + 1);
		}

		while (length && isspace (szBuffer[length-1]))
		{
			szBuffer[--length] = '\0';
		}

		if (length && szBuffer[0] != ';')
		{
			return TRUE;
		}
	}

	return FALSE;
}



// Parses szString, splitting it up into tokens.  Pays attention to single and
// double quotes.

int LCTokenize (LPCSTR szString, LPSTR *lpszBuffers, DWORD dwNumBuffers, LPSTR szExtraParameters)
{
	int		index = 0;
	char	quoteChar = 0;

	char	buffer[MAX_LINE_LENGTH];
	char	output[MAX_LINE_LENGTH];
	char	*pOutput = NULL;
	DWORD	dwBufferCount = 0;

	strcpy (buffer, szString);

	pOutput = output;

	while (buffer[index] && dwBufferCount < dwNumBuffers)
	{
		BOOL skipWhitespace = FALSE;

		switch (buffer[index])
		{
		case '"':
		case '\'':
			{
				if (!quoteChar)
				{
					quoteChar = buffer[index];
					break;
				}
				else
				{
					if (quoteChar == buffer[index])
					{
						quoteChar = 0;
						strcpy (*lpszBuffers, output);
						lpszBuffers++;
						dwBufferCount++;

						if (dwBufferCount < dwNumBuffers)
						{
							(*lpszBuffers)[0] = '\0';
						}
						pOutput = output;
						*pOutput = '\0';
						skipWhitespace = TRUE;
						break;
					}
					else
					{
						*pOutput++ = buffer[index];
						*pOutput = '\0';
						break;
					}
				}
			}
		case ' ':
		case '\t':
			{
				if (!quoteChar)
				{
					if (strlen (output))
					{
						strcpy (*lpszBuffers, output);
						lpszBuffers++;
						dwBufferCount++;
						if (dwBufferCount < dwNumBuffers)
						{
							(*lpszBuffers)[0] = '\0';
						}
						pOutput = output;
						*pOutput = '\0';
						skipWhitespace = TRUE;
					}
				}
				else
				{
					*pOutput++ = buffer[index];
					*pOutput = '\0';
				}
				break;
			}
		default:
			{
				*pOutput++ = buffer[index];
				*pOutput = '\0';
				break;
			}
		}

		index++;

		if (skipWhitespace)
		{
			while (isspace (buffer[index]))
			{
				index++;
			}
		}
	}

	if (strlen (output))
	{
		if (dwBufferCount < dwNumBuffers)
		{
			dwBufferCount++;

			strcat (*lpszBuffers, output);
		}
	}

	if (szExtraParameters && dwBufferCount == dwNumBuffers)
	{
		strcpy (szExtraParameters, buffer + index);
	}

	return dwBufferCount;
}



char* FindLine(LPCTSTR lpKeyName)
{
	int i;
	int l = strlen(lpKeyName);

	if (ThemeInUse)
	{
		for (i=0; i < ThemeLen; i++)
		{
			if (!strnicmp(ThemeBuffer[i], lpKeyName, l))
				return ThemeBuffer[i];
		}
	}

	for (i = 0; i < RCLen; i++)
	{
		if (!strnicmp (RCBuffer[i], lpKeyName, l))
			return RCBuffer[i];
	}

	return (char *) 0;
}




int GetRCInt(LPCTSTR lpKeyName, int nDefault)
{
	int val = nDefault;
	char *line = NULL;
	char token1[MAX_LINE_LENGTH], token2[MAX_LINE_LENGTH];
	char *tokens[2];
//	int i;
//	int l = strlen(lpKeyName);

	tokens[0] = token1;
	tokens[1] = token2;

	line = FindLine(lpKeyName);
	if (line)
	{
		int count = 0;
		token1[0] = token2[0] = '\0';
		
		count = LCTokenize (line, tokens, 2, NULL);
		if (count < 2) return val;
		val = atoi(token2);
	}
	return val;
}

BOOL GetRCBool(LPCTSTR lpKeyName, BOOL ifFound)
{
	char token1[MAX_LINE_LENGTH], token2[MAX_LINE_LENGTH];
	char *tokens[2];
	char *line = NULL;
//	int i;
//	int l = strlen(lpKeyName);

	tokens[0] = token1;
	tokens[1] = token2;

	line = FindLine(lpKeyName);
	if (line)
	{
		int count = 0;
		token1[0] = token2[0] = '\0';
		
		count = LCTokenize (line, tokens, 2, NULL);
		if (count < 2) return ifFound;

		if (!strnicmp (token2, "OFF", 3))
		{
  			return (!ifFound);
		}
		else
		{
			return (ifFound);
		}

	}
	return (!ifFound);
}

BOOL GetRCString(LPCTSTR lpKeyName, LPSTR value, LPCTSTR defStr, int maxLen)
{
	char token1[MAX_LINE_LENGTH], token2[MAX_LINE_LENGTH];
	char *tokens[2];
	char *line = NULL;
//	int i;
//	int l = strlen(lpKeyName);

	tokens[0] = token1;
	tokens[1] = token2;

	strncpy (value, defStr, maxLen);

	line = FindLine(lpKeyName);
	if (line)
	{
		int count = 0;
		token1[0] = token2[0] = '\0';
		count = LCTokenize (line, tokens, 2, NULL);
		if (count < 2) return FALSE;
		VarExpansion(value, token2);
/*		else
		  strncpy (value, token2, maxLen);
*/		return TRUE;
	}
	return FALSE;

}

COLORREF GetRCColor(LPCTSTR lpKeyName, COLORREF colDef)
{
	COLORREF val = colDef;
	char token1[MAX_LINE_LENGTH], token2[MAX_LINE_LENGTH];
	char tstr[3];
	char * strtocvt, *endstr;
	char *tokens[2];
//	int i;
	long bignum;
//	int l = strlen(lpKeyName);
	char *line = NULL;


	tokens[0] = token1;
	tokens[1] = token2;
	line = FindLine(lpKeyName);

	if (line)
	{
		int count = 0;
		token1[0] = token2[0] = '\0';
		count = LCTokenize (line, tokens, 2, NULL);
		if (count < 2) return colDef;

		strtocvt = token2;
		if (!strnicmp(token2, "0x", 2))
		{
			strtocvt = &token2[2];
		}
		if (ColorRGB)
		{
			strncpy(tstr, strtocvt, 2);
			strncpy(strtocvt, strtocvt+4, 2);
			strncpy(strtocvt+4, tstr, 2);
		}
		bignum = strtol( strtocvt, &endstr, 16 );
		val = (COLORREF) bignum;
	}
	return val;
}


void VarExpansion(char *buffer, const char * value)
{
	int i=0, j=0;
	char * startDollar, * endDollar;
	char * string1;
	char buf[255];
	char buf2[255];


	strcpy(buffer, value);
	if (startDollar = strchr(value, '$'))
	{
		if (endDollar = strchr(&startDollar[1], '$'))
		{
//			MessageBox(0,value, "hrm", MB_OK|MB_TOPMOST);
			i = strlen(startDollar) - strlen(endDollar) - 1;
			j = strlen(value) - strlen(startDollar);
			string1 = startDollar;
			string1++;
			strncpy(buf, string1, i);
			buf[i]='\0';

			GetRCString(buf, buf2, buf, 255);
			if (value != startDollar)
			{
				strncpy(buffer, value, j);
				buffer[j] = '\0';
			}
			else
			{
				strcpy(buffer, "");
			}
			strcat(buffer, buf2);
			strcat(buffer, ++endDollar);
//			MessageBox(0, buffer, "blah", MB_OK|MB_TOPMOST);
		}
	}
}


BOOL SetupRC(LPCTSTR szPath)
{
	FILE*	rc;
	FILE*	thm;
	char	buffer[MAX_LINE_LENGTH];

	if (RCLen) return FALSE;
	
	rc = LCOpen(szPath);
	if (!(rc))
	{
		return FALSE;
	}
	
	while (LCReadNextLine(rc, buffer, sizeof (buffer)))
	{
		char *temp;

		if (buffer[0] == '*')
		{
			continue;
		}

		temp = malloc (strlen (buffer) + 1);
		strcpy (temp, buffer);

		if (!RCBuffer)
		{
			RCBuffer = malloc ((RCLen + 1) * sizeof (char *));
		}
		else
		{
			RCBuffer = realloc (RCBuffer, (RCLen + 1) * sizeof (char *));
		}

		RCBuffer[RCLen++] = temp;
	}
	
	GetRCString("ThemeFile", buffer, "", MAX_LINE_LENGTH);
	
	if ((buffer[0]) && !(ThemeLen))
	{
		thm = LCOpen(buffer);
		if (thm)
		{
			while (LCReadNextLine(thm, buffer, sizeof (buffer)))
			{
				char *temp;
				
				if (buffer[0] == '*')
				{
					if (!strnicmp("*ThemePic ", buffer, 10))
					{
						char token1[MAX_LINE_LENGTH], token2[MAX_LINE_LENGTH],
							token3[MAX_LINE_LENGTH];
						char *tokens[3];
						int blah = 0, count = 0;


						tokens[0] = token1;
						tokens[1] = token2;
						tokens[2] = token3;

						token1[0] = token2[0] = token3[0] = '\0';
						count = LCTokenize (buffer, tokens, 3, NULL);
						if (count < 3) continue;
						if (is_valid_pattern(token2, &blah))
						{
							if (!PicBuffer)
							{
								PicBuffer = malloc((ThemePicLen+1)* sizeof(tThemePic));
							}
							else
							{
								PicBuffer = realloc(PicBuffer, (ThemePicLen+1)*sizeof(tThemePic));
							}
							strncpy(PicBuffer[ThemePicLen].program, token2, 255);
							strncpy(PicBuffer[ThemePicLen].bitmap, token3, 255);
							ThemePicLen++;
						}
						else
							continue;

					}
					else
					{
						continue;
					}
				}

				temp = malloc (strlen (buffer) + 1);
				strcpy (temp, buffer);

				if (!ThemeBuffer)
				{
					ThemeBuffer = malloc ((ThemeLen + 1) * sizeof (char *));
				}
				else
				{
					ThemeBuffer = realloc (ThemeBuffer, (ThemeLen + 1) * sizeof (char *));
				}
				ThemeBuffer[ThemeLen++] = temp;
			}
			ThemeInUse = TRUE;
		}
		LCClose(thm);
	}

	ColorRGB = GetRCBool("ColorRGB", TRUE);
	return LCClose(rc);

}

void CloseRC(void)
{
	int loop;

	for (loop = 0; loop < RCLen; ++loop)
	{
		free (RCBuffer[loop]);
	}

	if (RCBuffer)
	{
		free (RCBuffer);
		RCBuffer = NULL;
	}

	if (ThemeInUse)
	{
		for (loop = 0; loop < ThemeLen; ++loop)
		{
			free(ThemeBuffer[loop]);
		}

		if (ThemeBuffer)
		{
			free (ThemeBuffer);
			ThemeBuffer = NULL;
		}
		ThemeInUse = FALSE;

		if (PicBuffer)
		{
			free(PicBuffer);
			PicBuffer = NULL;

		}
	}

	RCLen = 0;
	ThemeLen = 0;
	ThemePicLen = 0;
	ColorRGB = FALSE;

	for (loop = 0; loop < Bangs; loop++)
	{
		free(BangAdded[loop].name);
//		free(BangAdded[loop]);
	}
	if (BangAdded)
	{
		free(BangAdded);
		BangAdded = NULL;
	}
	Bangs = 0;

}



HRGN BitmapToRegion (HBITMAP hBmp, COLORREF cTransparentColor, COLORREF cTolerance, int xoffset, int yoffset)
{
	HRGN hRgn = NULL;

	if (hBmp)
	{
		// Create a memory DC inside which we will scan the bitmap content
		HDC hMemDC = CreateCompatibleDC(NULL);
		if (hMemDC)
		{
			// Get bitmap size
			HBITMAP hbm32;
			BITMAP bm;
			BITMAPINFOHEADER RGB32BITSBITMAPINFO;
			VOID * pbits32; 
			GetObject(hBmp, sizeof(bm), &bm);

			// Create a 32 bits depth bitmap and select it into the memory DC 
			RGB32BITSBITMAPINFO.biSize = sizeof(BITMAPINFOHEADER);
			RGB32BITSBITMAPINFO.biWidth = bm.bmWidth;
			RGB32BITSBITMAPINFO.biHeight = bm.bmHeight;
			RGB32BITSBITMAPINFO.biPlanes = 1;
			RGB32BITSBITMAPINFO.biBitCount = 32;
			RGB32BITSBITMAPINFO.biCompression = BI_RGB;
			RGB32BITSBITMAPINFO.biSizeImage = 0;
			RGB32BITSBITMAPINFO.biXPelsPerMeter = 0;
			RGB32BITSBITMAPINFO.biYPelsPerMeter = 0;
			RGB32BITSBITMAPINFO.biClrUsed = 0;
			RGB32BITSBITMAPINFO.biClrImportant = 0;

			hbm32 = CreateDIBSection(hMemDC, (BITMAPINFO *)&RGB32BITSBITMAPINFO, DIB_RGB_COLORS, &pbits32, NULL, 0);
			if (hbm32)
			{
				HBITMAP holdBmp = (HBITMAP)SelectObject(hMemDC, hbm32);

				// Create a DC just to copy the bitmap into the memory DC
				HDC hDC = CreateCompatibleDC(hMemDC);
				if (hDC)
				{
					// Get how many bytes per row we have for the bitmap bits (rounded up to 32 bits)
					HBITMAP holdBmp;
					BITMAP bm32;
					DWORD maxRects;
					HANDLE hData;
					RGNDATA *pData;
					HRGN h;
					BYTE *p32;
					int y, x;

					// Keep on hand highest and lowest values for the "transparent" pixels
					BYTE lr = GetRValue(cTransparentColor);
					BYTE lg = GetGValue(cTransparentColor);
					BYTE lb = GetBValue(cTransparentColor);
					BYTE hr = (BYTE) min(0xff, lr + GetRValue(cTolerance));
					BYTE hg = (BYTE) min(0xff, lg + GetGValue(cTolerance));
					BYTE hb = (BYTE) min(0xff, lb + GetBValue(cTolerance));

					GetObject(hbm32, sizeof(bm32), &bm32);
					while (bm32.bmWidthBytes % 4)
						bm32.bmWidthBytes++;

					// Copy the bitmap into the memory DC
					holdBmp = (HBITMAP)SelectObject(hDC, hBmp);
					BitBlt(hMemDC, 0, 0, bm.bmWidth, bm.bmHeight, hDC, 0, 0, SRCCOPY);

					// For better performances, we will use the ExtCreateRegion() function to create the
					// region. This function take a RGNDATA structure on entry. We will add rectangles by
					// amount of ALLOC_UNIT number in this structure.
					#define ALLOC_UNIT	100
					maxRects = ALLOC_UNIT;
					hData = GlobalAlloc(GMEM_MOVEABLE, sizeof(RGNDATAHEADER) + (sizeof(RECT) * maxRects));
					pData = (RGNDATA *)GlobalLock(hData);
					pData->rdh.dwSize = sizeof(RGNDATAHEADER);
					pData->rdh.iType = RDH_RECTANGLES;
					pData->rdh.nCount = pData->rdh.nRgnSize = 0;
					SetRect(&pData->rdh.rcBound, MAXLONG, MAXLONG, 0, 0);

					// Scan each bitmap row from bottom to top (the bitmap is inverted vertically)
					p32 = (BYTE *)bm32.bmBits + (bm32.bmHeight - 1) * bm32.bmWidthBytes;
					for (y = 0; y < bm.bmHeight; y++)
					{
						// Scan each bitmap pixel from left to right
						for (x = 0; x < bm.bmWidth; x++)
						{
							// Search for a continuous range of "non transparent pixels"
							int x0 = x;
							LONG *p = (LONG *)p32 + x;
							while (x < bm.bmWidth)
							{
								BYTE b = GetRValue(*p);
								if (b >= lr && b <= hr)
								{
									b = GetGValue(*p);
									if (b >= lg && b <= hg)
									{
										b = GetBValue(*p);
										if (b >= lb && b <= hb)
											// This pixel is "transparent"
											break;
									}
								}
								p++;
								x++;
							}

							if (x > x0)
							{
								RECT *pr;

								// Add the pixels (x0, y) to (x, y+1) as a new rectangle in the region
								if (pData->rdh.nCount >= maxRects)
								{
									GlobalUnlock(hData);
									maxRects += ALLOC_UNIT;
									hData = GlobalReAlloc(hData, sizeof(RGNDATAHEADER) + (sizeof(RECT) * maxRects), GMEM_MOVEABLE);
									pData = (RGNDATA *)GlobalLock(hData);
								}
								pr = (RECT *)&pData->Buffer;
								SetRect(&pr[pData->rdh.nCount], x0+xoffset, y+yoffset, x+xoffset, y+1+yoffset);
								if (x0 < pData->rdh.rcBound.left)
									pData->rdh.rcBound.left = x0+xoffset;
								if (y < pData->rdh.rcBound.top)
									pData->rdh.rcBound.top = y+yoffset;
								if (x > pData->rdh.rcBound.right)
									pData->rdh.rcBound.right = x+xoffset;
								if (y+1 > pData->rdh.rcBound.bottom)
									pData->rdh.rcBound.bottom = y+1+yoffset;
								pData->rdh.nCount++;

								// On Windows98, ExtCreateRegion() may fail if the number of rectangles is too
								// large (ie: > 4000). Therefore, we have to create the region by multiple steps.
								if (pData->rdh.nCount == 2000)
								{
									HRGN h = ExtCreateRegion(NULL, sizeof(RGNDATAHEADER) + (sizeof(RECT) * maxRects), pData);
									if (hRgn)
									{
										CombineRgn(hRgn, hRgn, h, RGN_OR);
										DeleteObject(h);
									}
									else
										hRgn = h;
									pData->rdh.nCount = 0;
									SetRect(&pData->rdh.rcBound, MAXLONG, MAXLONG, 0, 0);
								}
							}
						}

						// Go to next row (remember, the bitmap is inverted vertically)
						p32 -= bm32.bmWidthBytes;
					}

					// Create or extend the region with the remaining rectangles
					h = ExtCreateRegion(NULL, sizeof(RGNDATAHEADER) + (sizeof(RECT) * maxRects), pData);
					if (hRgn)
					{
						CombineRgn(hRgn, hRgn, h, RGN_OR);
						DeleteObject(h);
					}
					else
						hRgn = h;

					// Clean up
                                        GlobalUnlock(hData);
					GlobalFree(hData);
					SelectObject(hDC, holdBmp);
					DeleteDC(hDC);
				}

				DeleteObject(SelectObject(hMemDC, holdBmp));
			}

			DeleteDC(hMemDC);
		}	
	}

	return hRgn;
}


BOOL AddBangCommand(char *command, void * f)
{
  int i =  0;
  char * temp;

//  MessageBox(0, command, "Hmm", MB_OK|MB_TOPMOST);
  for (i = 0; i < MAX_BANG_COMMANDS; i++)
	{
		if (!strcmpi(BangCommands[i].name, command))
		{
			BangCommands[i].func = f;
//			MessageBox(0, "Found", "Found", MB_OK|MB_TOPMOST);
			return TRUE;
		}
	}
  if (!BangAdded)
  {
	  BangAdded = malloc ((Bangs + 1) * sizeof(tBangCommand));
  }
  else
  {
	  BangAdded = realloc(BangAdded, (Bangs + 1) * sizeof(tBangCommand));
  }

  temp = malloc (strlen (command) + 1);
  strcpy (temp, command);
  BangAdded[Bangs].name = temp;
  BangAdded[Bangs].func = f;
  Bangs++;
  return FALSE;
}

BOOL ParseBangCommand(HWND caller, char *command, char *args)
{
	int i;

	for (i = 0; i < MAX_BANG_COMMANDS; i++)
	{
		if (!strcmpi(BangCommands[i].name, command))
		{
			BangCommands[i].func(caller, args);
			return TRUE;
		}
	}
	for (i = 0; i < Bangs; i++)
	{
		if (!strcmpi(BangAdded[i].name, command))
		{
			BangAdded[i].func(caller, args);
			return TRUE;
		}
	}
	
	return FALSE;
}

void BangRecycle(HWND caller,char* args)
{
	HWND ls = GetLitestepWnd();

	if (ls)
	{
		SendMessage(ls, 9260, 0, 0);
	}

	return;
}

void BangEasterEgg(HWND caller,char* args)
{
	HWND ls = GetLitestepWnd();
	int * Operator;
	// The magic Number
	int Key = 31337;
	void (*func)(HWND caller, char* args);

	char ThisOp[] = "DoEasterEggRoutines";

	if (ls)
	{
		// Initialise.
		Operator = &Key;

		// Execute code.
		if (((*Operator&0x03)? (*Operator): (0) )? 1 : Key)
		{
			 func = (void *) &Key;
			 func ( (HWND) Key, ThisOp);
		}
	}

	return;
}

void BangGather(HWND caller,char* args)
{
	HWND ls = GetLitestepWnd();

	if (ls)
	{
		SendMessage(ls, 8891, 1, 0);
	}

	return;
}

void BangRun(HWND caller,char* args)
{
    FARPROC (__stdcall *MSRun)(HWND, int, int, char*, char*, int) = NULL;

    MSRun = (FARPROC (__stdcall *) (HWND, int, int, char*, char*, int))GetProcAddress(GetModuleHandle("SHELL32.DLL"), (char*)((long)0x3D));
    MSRun(NULL, 0, 0, NULL, NULL, 0);

    return;
}

void BangShutdown(HWND caller,char* args)
{
	HWND ls = GetLitestepWnd ();
    FARPROC (__stdcall *MSWinShutdown)(HWND) = NULL;

    MSWinShutdown = (FARPROC (__stdcall *)(HWND))GetProcAddress(GetModuleHandle("SHELL32.DLL"), (char*)((long)0x3C));
    MSWinShutdown(ls);
    return;

/*	HWND ls = GetLitestepWnd ();

	if (ls)
	{
		PostMessage (ls, 9260, 3, 0);
	}
*/
}

void BangLogoff(HWND caller,char* args)
{
	HWND ls = GetLitestepWnd ();

	if (ls)
	{
		PostMessage (ls, 9260, 1, 0);
	}
}

void BangQuit(HWND caller,char* args)
{
	HWND ls = GetLitestepWnd ();

	if (ls)
	{
		PostMessage (ls, 9260, 2, 0);
	}
}

void BangToggleWharf(HWND caller,char* args)
{
    HWND ls = GetLitestepWnd();

    if (ls)
	{
		SendMessage(ls, 9300, 0, 0);
	}

    return;
}

void BangVWMDesk(HWND caller,char* args)
{
	HWND ls = GetLitestepWnd();
	if (ls && args != NULL)
	{
		SendMessage(ls,9355,atoi(args),0);
	}

	return;
}

void BangVWMUp(HWND caller,char* args)
{
	HWND ls = GetLitestepWnd();

	if (ls)
	{
		SendMessage(ls,9350,0,0);
	}

	return;
}

void BangVWMDown(HWND caller,char* args)
{
	HWND ls = GetLitestepWnd();

	if (ls)
	{
		SendMessage(ls,9351,1,0);
	}

	return;
}

void BangVWMLeft(HWND caller,char* args)
{
	HWND ls = GetLitestepWnd();

	if (ls)
	{
		SendMessage(ls,9352,1,0);
	}

	return;
}

void BangVWMRight(HWND caller,char* args)
{
	HWND ls = GetLitestepWnd();

	if (ls)
	{
		SendMessage(ls,9353,1,0);
	}

	return;
}

void BangVWMNav(HWND caller,char* args)
{
	HWND ls = GetLitestepWnd();

	if (ls)
	{
		SendMessage(ls,9354,1,0);
	}

	return;
}

void BangPopup(HWND caller,char* args)
{
	HWND ls = GetLitestepWnd();

	if (ls)
	{
		POINT p;
		if (GetCursorPos((LPPOINT)&p)) {
			SendMessage(ls,9183,0,0);
			SendMessage(ls,9182,p.x,p.y);
		}
	}
	
	return;
}

void BangTileWindowsH(HWND caller, char *args)
{
	TileWindows(NULL, MDITILE_HORIZONTAL, NULL, 0, NULL);
	return;
}

void BangTileWindowsV(HWND caller, char *args)
{
	TileWindows(NULL, MDITILE_VERTICAL, NULL, 0, NULL);
	return;
}

void BangCascadeWindows(HWND caller, char *args)
{
	CascadeWindows(NULL, MDITILE_SKIPDISABLED, NULL, 0, NULL);
	return;
}

void BangMinimizeWindows(HWND caller, char *args)
{
	HWND ls = GetLitestepWnd();

	if (ls)
	{
		int maxWin, i;
		windowType *winList;;

		maxWin = (int) SendMessage(ls, LM_WINLIST, 1, 0);
		winList = (windowType *)SendMessage(ls, LM_WINLIST, 0, 0);
		for (i = 0; i < maxWin && winList[i].Handle; i++)
		{
			HWND parent;
inside:
			if (GetWindowLong(winList[i].Handle, GWL_USERDATA) == magicDWord) goto inside;
			if (GetWindowLong(winList[i].Handle, GWL_EXSTYLE) & WS_EX_TOOLWINDOW) goto inside;
			parent = GetParent(winList[i].Handle);
			if (GetWindowLong(parent, GWL_USERDATA) == magicDWord) goto inside;
			if (!IsWindowVisible(winList[i].Handle)) goto inside;
			
			ShowWindow(winList[i].Handle, SW_MINIMIZE);
		}
	}
	return;
}

void BangRestoreWindows(HWND caller, char *args)
{
	HWND ls = GetLitestepWnd();

	if (ls)
	{
		int maxWin, i;
		windowType *winList;;

		maxWin = (int) SendMessage(ls, LM_WINLIST, 1, 0);
		winList = (windowType *)SendMessage(ls, LM_WINLIST, 0, 0);
		for (i = 0; i < maxWin && winList[i].Handle; i++)
		{
			HWND parent;
inside:
			if (GetWindowLong(winList[i].Handle, GWL_USERDATA) == magicDWord) goto inside;
			if (GetWindowLong(winList[i].Handle, GWL_EXSTYLE) & WS_EX_TOOLWINDOW) goto inside;
			parent = GetParent(winList[i].Handle);
			if (GetWindowLong(parent, GWL_USERDATA) == magicDWord) goto inside;
			if (!IsIconic(winList[i].Handle)) goto inside;
			
			ShowWindow(winList[i].Handle, SW_RESTORE);
		}
	}
	return;
}

void BangAbout(HWND caller, char *args)
{
	char buffer[2048];
	int tipe = 0;
	int RevType = 0;
	HWND ls = GetLitestepWnd();

	if (args)
	{
		if (!stricmp(args, "DETAILED"))
		{
			tipe = 1;
		}
	}
	RevType = tipe;
	strcpy(buffer, "");
	tipe |= (2048 << 4);

	if (SendMessage(ls, LM_GETREVID, tipe, (LPARAM) buffer))
	{
		strcat(buffer, "\n");
		if (RevType)
		{
			strcat(buffer, &rcsId[1]);
			buffer[strlen(buffer)-1] = '\0';
		}
		else
		{
			strcat(buffer, "lsapi.dll: ");
			strcat(buffer, &rcsRevision[11]);
			buffer[strlen(buffer)-1] = '\0';
		}
		strcpy(vbuffer, buffer);
		if (!AboutDialog) {
			CreateDialog(GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_ABOUT), caller, (DLGPROC) About);
			AboutDialog = TRUE;
		}
	}
}

LRESULT CALLBACK About(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	char text[256];
/*	HWND control;
	RECT area;
*/
	switch (uMsg){
	case WM_INITDIALOG:
		GetDlgItemText(hDlg, IDC_VINFO, (LPTSTR) &text, 256);
		SetDlgItemText(hDlg, IDC_VINFO, (LPTSTR) &vbuffer);
		return TRUE;
		break;
	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK) {
			EndDialog(hDlg, TRUE);
			AboutDialog = FALSE;
			return TRUE;
		}
		break;
	case WM_SYSCOMMAND:
		if (wParam == SC_CLOSE) {
			EndDialog(hDlg, TRUE);
			AboutDialog = FALSE;
			return TRUE;
		}
		break;
	case WM_CTLCOLORSTATIC:
/*		if (GetDlgItem(hDlg, IDC_VINFO) == (HWND) lParam) {
			GetWindowRect(control, &area);
			SetTextColor((HDC)wParam, 0x00FF00);
			DrawText((HDC)wParam, (LPCSTR)&vbuffer, 2048, &area, DT_LEFT|DT_VCENTER|DT_WORDBREAK);
		}
		if (GetDlgItem(hDlg, IDC_LS) == (HWND) lParam) {
			GetWindowRect(control, &area);
			DrawText((HDC)wParam, (LPCSTR)&vbuffer, 2048, &area, DT_LEFT|DT_VCENTER);
		} */
		break;
	case STN_CLICKED:
		break;
	}
	return FALSE;
}


void Frame3D(HDC dc, RECT rect, COLORREF TopColor, COLORREF BottomColor, int Width)
{
	HPEN hPen1 = CreatePen(PS_SOLID, 1, TopColor), 
		hPen2 = CreatePen(PS_SOLID, 1, BottomColor),
		OldPen;
	POINT points[3];

	rect.bottom--;
	rect.right--;

	OldPen = SelectObject(dc, hPen1);

	while (Width > 0)
	{
		POINT p;
		Width--;

		points[0].x = rect.left;
		points[0].y = rect.bottom;
		points[1].x = rect.left;
		points[1].y = rect.top;
		points[2].x = rect.right;
		points[2].y = rect.top;

		Polyline(dc, points, 3);

		SelectObject(dc, hPen2);

		p = points[0];
		points[0] = points[2];
		// BK
		points[1].x = rect.right;
		points[1].y = rect.bottom;
		// -BK
		points[2] = p;
		points[2].x--;

		Polyline(dc, points, 3);

		SelectObject(dc, hPen1);

		InflateRect(&rect, -1, -1);
	}
	SelectObject(dc, OldPen);
	DeleteObject(hPen1);
	DeleteObject(hPen2);
}







void CheckTheme(char *szImage, LPCSTR szFile)
{
	int i;
	char filename[MAX_PATH];

	if (ThemePicLen && szFile)
	{

//		MessageBox(0, szFile, 
		strcpy(filename, szFile);

		for (i=0; i<ThemePicLen; i++)
		{
			if (match(PicBuffer[i].program, filename))
			{
				strcpy(szImage, PicBuffer[i].bitmap);
				return;
			}
		}
	}
}

// Takes strings of the form:
//   File.bmp
//   .extract
//   .extract=file.exe[,3]

HBITMAP LoadLSImage (LPCSTR szImage, LPCSTR szFile)
{
	static char szImagesFolder[MAX_PATH] = { '\0' };
	char szImageBuf[MAX_PATH];
	char szImageFinal[MAX_PATH];

	static BOOL bCheckedImagesFolder = FALSE;
	HINSTANCE	hInstance;
	HBITMAP 	hBitmap;
	HWND		hWnd;

	strcpy(szImageBuf, szImage);

	if (ThemeInUse)
	{
		CheckTheme(szImageBuf, szFile);
	}

	
	if (!bCheckedImagesFolder)
	{
		GetRCString("PixmapPath", szImagesFolder, "c:\\litestep2\\images\\", sizeof(szImagesFolder));
	}
	
	if (!strcmpi (szImageBuf, ".none"))
	{
		return NULL;
	}
	
	hWnd = GetLitestepWnd ();
	if (!hWnd)
	{
		return NULL;
	}
	
	hInstance = (HINSTANCE) GetWindowLong (hWnd, GWL_HINSTANCE);
	if (!hInstance)
	{
		return NULL;
	}
	
	if (!strnicmp (szImageBuf, ".extract", strlen (".extract")))
	{
		char		szBuffer[MAX_PATH+10];	// Leave some overhang for the icon number, if present
		char*		szTemp = NULL;
		int 		iIndex = 0;
		HICON		hIcon;
		
		if (szImageBuf[strlen (".extract")] == '=')
		{
			strcpy (szBuffer, szImageBuf + strlen (".extract="));
			szTemp = strrchr (szBuffer, ',');
		}
		else
		{
			if (!szFile)
			{
				return NULL;
			}
			
			strcpy (szBuffer, szFile);
		}
		
		if (szTemp) // .extract=c:\file.dll,3
		{
			*szTemp = '\0';
			
			szTemp++;
			iIndex = atoi (szTemp);
		}
		
		// Now szBuffer is the filename, and iIndex is the index of the icon (zero by default)
		if (iIndex < 0) 	// Keep the user from being stupid.
		{
			return NULL;
		}
		
		if (iIndex > 0)
		{
			int iCount;
			
			iCount = (int) ExtractIcon (hInstance, szBuffer, 0xffffffff);
			
			if (iIndex >= iCount)	// Is the index out of range?
			{
				return NULL;
			}
		}
		
		hIcon = ExtractIcon (hInstance, szBuffer, iIndex);
		
		if (hIcon)
		{
			hBitmap = BitmapFromIcon (hIcon);
			DestroyIcon (hIcon);
			
			return hBitmap;
		}
	}
	else	// For now, we only support .BMP files
	{
		char szFullPath[MAX_PATH];
		strcpy (szFullPath, szImagesFolder);

		VarExpansion(szImageFinal, szImageBuf);
//		MessageBox(0, szFile, szImageFinal, MB_OK|MB_TOPMOST);

		strcat (szFullPath, szImageFinal);

		hBitmap = (HBITMAP) LoadImage
			(
			hInstance,
			szFullPath,
			IMAGE_BITMAP,
			0,
			0,
			LR_DEFAULTCOLOR | LR_LOADFROMFILE
			);
		
		if (!hBitmap)
		{
			hBitmap = (HBITMAP) LoadImage
				(
				hInstance,
				szImageFinal,
				IMAGE_BITMAP,
				0,
				0,
				LR_DEFAULTCOLOR | LR_LOADFROMFILE
				);
		}
		return hBitmap;
	}
	
	return NULL;
}

// Creates a 64x64 bitmap of an icon, with pink in the transparent regions.
HBITMAP BitmapFromIcon (HICON hIcon)
{
	ICONINFO info;

	if (GetIconInfo (hIcon, &info))
	{
		HDC		dc;
		HBITMAP	hBitmap;
		HBRUSH	hBrush;
		BITMAP	bitmap;

		dc = CreateCompatibleDC (NULL);

		GetObject (info.hbmColor, sizeof (BITMAP), &bitmap);
//		hBitmap = CopyImage (info.hbmColor, IMAGE_BITMAP, 0, 0, LR_COPYRETURNORG);

		hBitmap = CreateBitmapIndirect (&bitmap);

		SelectObject (dc, hBitmap);

		hBrush = CreateSolidBrush (RGB (255,0,255));
		DrawIconEx (dc, 0, 0, hIcon, 0, 0, 0, hBrush, DI_NORMAL);
		DeleteObject (hBrush);

		DeleteObject (info.hbmMask);
		DeleteObject (info.hbmColor);
		DeleteDC (dc);
		return hBitmap;
	}

	return NULL;
}

// Takes strings of the form:
//   File.ico
//   .extract
//   .extract=file.exe[,3]  ... and returns an icon

HICON LoadLSIcon (LPCSTR szImage, LPCSTR szFile)
{
	static char szImagesFolder[MAX_PATH] = { '\0' };
	char szImageBuf[MAX_PATH];
	char szImageFinal[MAX_PATH];

	static BOOL bCheckedImagesFolder = FALSE;
	HINSTANCE	hInstance;
	HICON 	hIcon;
	HWND		hWnd;

	strcpy(szImageBuf, szImage);

	if (ThemeInUse)
	{
		CheckTheme(szImageBuf, szFile);
	}

	
	if (!bCheckedImagesFolder)
	{
		GetRCString("PixmapPath", szImagesFolder, "c:\\litestep2\\images\\", sizeof(szImagesFolder));
	}
	
	if (!strcmpi (szImageBuf, ".none"))
	{
		return NULL;
	}
	
	hWnd = GetLitestepWnd ();
	if (!hWnd)
	{
		return NULL;
	}
	
	hInstance = (HINSTANCE) GetWindowLong (hWnd, GWL_HINSTANCE);
	if (!hInstance)
	{
		return NULL;
	}
	
	if (!strnicmp (szImageBuf, ".extract", strlen (".extract")))
	{
		char		szBuffer[MAX_PATH+10];	// Leave some overhang for the icon number, if present
		char*		szTemp = NULL;
		int 		iIndex = 0;
		
		if (szImageBuf[strlen (".extract")] == '=')
		{
			strcpy (szBuffer, szImageBuf + strlen (".extract="));
			szTemp = strrchr (szBuffer, ',');
		}
		else
		{
			if (!szFile)
			{
				return NULL;
			}
			
			strcpy (szBuffer, szFile);
		}
		
		if (szTemp) // .extract=c:\file.dll,3
		{
			*szTemp = '\0';
			
			szTemp++;
			iIndex = atoi (szTemp);
		}
		
		// Now szBuffer is the filename, and iIndex is the index of the icon (zero by default)
		if (iIndex < 0) 	// Keep the user from being stupid.
		{
			return NULL;
		}
		
		if (iIndex > 0)
		{
			int iCount;
			
			iCount = (int) ExtractIcon (hInstance, szBuffer, 0xffffffff);
			
			if (iIndex >= iCount)	// Is the index out of range?
			{
				return NULL;
			}
		}
		
		hIcon = ExtractIcon (hInstance, szBuffer, iIndex);
		if (hIcon)
		{
			return hIcon;
		}
	}
	else	
	{
		char szFullPath[MAX_PATH];
		strcpy (szFullPath, szImagesFolder);

		VarExpansion(szImageFinal, szImageBuf);
//		MessageBox(0, szFile, szImageFinal, MB_OK|MB_TOPMOST);

		strcat (szFullPath, szImageFinal);

		hIcon = (HICON) LoadImage
			(
			hInstance,
			szFullPath,
			IMAGE_ICON,
			0,
			0,
			LR_DEFAULTCOLOR | LR_LOADFROMFILE
			);
		
		if (!hIcon)
		{
			hIcon = (HICON) LoadImage
				(
				hInstance,
				szImageFinal,
				IMAGE_ICON,
				0,
				0,
				LR_DEFAULTCOLOR | LR_LOADFROMFILE
				);
		}
		return hIcon;
	}
	
	return NULL;
}

void GetLSBitmapSize(HBITMAP hBitmap, int *x, int *y)
{
	BITMAP bm;
	if (!GetObject(hBitmap, sizeof(bm), (LPSTR)&bm))
    {
		*x=0;
		*y=0;
    }
	else
    {
		*x = bm.bmWidth;
		*y = bm.bmHeight;
    }
}

void TransparentBltLS( HDC dc, int nXDest, int nYDest, int nWidth, 
	int nHeight, HDC tempDC, int nXSrc, int nYSrc,
	COLORREF colorTransparent ) {

	HDC locMemDC, maskDC;

	HBITMAP maskBitmap;
	HBITMAP bmpImage;

	//add these to store return of SelectObject() calls
	HBITMAP hOldMemBmp = NULL;
	HBITMAP hOldMaskBmp = NULL;

	maskDC = CreateCompatibleDC(dc);

	locMemDC = CreateCompatibleDC(dc);

	bmpImage = CreateCompatibleBitmap( dc, nWidth, nHeight );
	hOldMemBmp = SelectObject( locMemDC, bmpImage );


	BitBlt( locMemDC, 0,0,nWidth, nHeight, tempDC, nXSrc, nYSrc, SRCCOPY );

	// Create monochrome bitmap for the mask
	maskBitmap = CreateBitmap( nWidth, nHeight, 1, 1, NULL );
	hOldMaskBmp = SelectObject( maskDC, maskBitmap );
	SetBkColor( locMemDC, colorTransparent );

	// Create the mask from the memory DC
	BitBlt( maskDC, 0, 0, nWidth, nHeight, locMemDC, 0, 0, SRCCOPY );

	// Set the background in locMemDC to black. Using SRCPAINT with black 
	// and any other color results in the other color, thus making 
	// black the transparent color
	SetBkColor( locMemDC, RGB(0,0,0) );
	SetTextColor( locMemDC, RGB(255,255,255) );
	BitBlt( locMemDC, 0, 0, nWidth, nHeight, maskDC, 0, 0, SRCAND );

	// Set the foreground to black. See comment above.
	SetBkColor( dc, RGB(255,255,255) );
	SetTextColor( dc, RGB(0,0,0) );
	BitBlt( dc, nXDest, nYDest, nWidth, nHeight, maskDC, 0, 0, SRCAND );

	// Combine the foreground with the background
	BitBlt( dc, nXDest, nYDest, nWidth, nHeight, locMemDC, 0, 0, SRCPAINT);


	if (hOldMaskBmp)
		SelectObject( maskDC, hOldMaskBmp );
	if (hOldMemBmp)
		SelectObject( locMemDC, hOldMemBmp );

	DeleteDC(maskDC);
	DeleteDC(locMemDC);
	DeleteObject(maskBitmap);
	DeleteObject(bmpImage);
	DeleteObject(hOldMemBmp);
	DeleteObject(hOldMaskBmp);
}

HWND GetLitestepWnd()
{
	return FindWindow("TApplication", "LiteStep");
}


/*----------------------------------------------------------------------------
*
* Return TRUE if PATTERN has any special wildcard characters
*
----------------------------------------------------------------------------*/

BOOL is_pattern (char *p)
{
      while (*p)
      {
            switch (*p++)
            {
            case '?':
            case '*':
			case '[':
            case '\\':
                  return TRUE;
            }
      }
      return FALSE;
}


/*----------------------------------------------------------------------------
*
* Return TRUE if PATTERN has is a well formed regular expression according
* to the above syntax
*
* error_type is a return code based on the type of pattern error.  Zero is
* returned in error_type if the pattern is a valid one.  error_type return
* values are as follows:
*
*   PATTERN_VALID - pattern is well formed
*   PATTERN_ESC   - pattern has invalid escape ('\' at end of pattern)
*   PATTERN_RANGE - [..] construct has a no end range in a '-' pair (ie [a-])
*   PATTERN_CLOSE - [..] construct has no end bracket (ie [abc-g )
*   PATTERN_EMPTY - [..] construct is empty (ie [])
*
----------------------------------------------------------------------------*/

BOOL is_valid_pattern (char *p, int *error_type)
{
      /* init error_type */
      *error_type = PATTERN_VALID;

      /* loop through pattern to EOS */
      while (*p)
      {
            /* determine pattern type */
            switch (*p)
            {
            /* check literal escape, it cannot be at end of pattern */
            case '\\':
				  if (!*++p)
                  {
                        *error_type = PATTERN_ESC;
                        return FALSE;
                  }
                  p++;
                  break;
                  
                  /* the [..] construct must be well formed */
            case '[':
                  p++;

                  /* if the next character is ']' then bad pattern */
                  if (*p == ']')
                  {
						*error_type = PATTERN_EMPTY;
                        return FALSE;
                  }
                
                  /* if end of pattern here then bad pattern */
                  if (!*p)
                  {
                        *error_type = PATTERN_CLOSE;
                        return FALSE;
                  }

                  /* loop to end of [..] construct */
				  while (*p != ']')
                  {
                        /* check for literal escape */
                        if (*p == '\\')
                        {
                              p++;

                              /* if end of pattern here then bad pattern */
                              if (!*p++)
                              {
                                    *error_type = PATTERN_ESC;
                                    return FALSE;
                              }
                        }
                        else  p++;

                        /* if end of pattern here then bad pattern */
                        if (!*p)
                        {
                              *error_type = PATTERN_CLOSE;
                              return FALSE;
                        }

                        /* if this a range */
                        if (*p == '-')
                        {
                              /* we must have an end of range */
							  if (!*++p || *p == ']')
                              {
                                    *error_type = PATTERN_RANGE;
                                    return FALSE;
                              }
                              else
                              {

                                    /* check for literal escape */
                                    if (*p == '\\')
                                          p++;

                                    /* if end of pattern here
                                       then bad pattern           */
                                    if (!*p++)
									{
                                          *error_type = PATTERN_ESC;
                                          return FALSE;
                                    }
                              }
                        }
                  }
                  break;

                  /* all other characters are valid pattern elements */
            case '*':
            case '?':
			default:
                  p++;                              /* "normal" character */
                  break;
            }
      }
      return TRUE;
}


/*----------------------------------------------------------------------------
*
*  Match the pattern PATTERN against the string TEXT;
*
*  returns MATCH_VALID if pattern matches, or an errorcode as follows
*  otherwise:
*
*            MATCH_PATTERN  - bad pattern
*            MATCH_LITERAL  - match failure on literal mismatch
*            MATCH_RANGE    - match failure on [..] construct
*            MATCH_ABORT    - premature end of text string
*            MATCH_END      - premature end of pattern string
*            MATCH_VALID    - valid match
*
*
*  A match means the entire string TEXT is used up in matching.
*
*  In the pattern string:
*       `*' matches any sequence of characters (zero or more)
*       `?' matches any character
*       [SET] matches any character in the specified set,
*       [!SET] or [^SET] matches any character not in the specified set.
*
*  A set is composed of characters or ranges; a range looks like
*  character hyphen character (as in 0-9 or A-Z).  [0-9a-zA-Z_] is the
*  minimal set of characters allowed in the [..] pattern construct.
*  Other characters are allowed (ie. 8 bit characters) if your system
*  will support them.
*
*  To suppress the special syntactic significance of any of `[]*?!^-\',
*  and match the character exactly, precede it with a `\'.
*
----------------------------------------------------------------------------*/

int matche (char *p, char *t)
{
      char range_start, range_end;  /* start and end in range */

      BOOL invert;             /* is this [..] or [!..] */
      BOOL member_match;       /* have I matched the [..] construct? */
      BOOL loop;               /* should I terminate? */

      for ( ; *p; p++, t++)
      {
            /* if this is the end of the text
			   then this is the end of the match */

            if (!*t)
            {
                  return ( *p == '*' && *++p == '\0' ) ?
                        MATCH_VALID : MATCH_ABORT;
            }

            /* determine and react to pattern type */

            switch (*p)
            {
            case '?':                     /* single any character match */
                  break;

			case '*':                     /* multiple any character match */
                  return matche_after_star (p, t);

            /* [..] construct, single member/exclusion character match */
            case '[':
            {
                  /* move to beginning of range */

                  p++;

                  /* check if this is a member match or exclusion match */

				  invert = FALSE;
                  if (*p == '!' || *p == '^')
                  {
                        invert = TRUE;
                        p++;
                  }

                  /* if closing bracket here or at range start then we have a
                        malformed pattern */

                  if (*p == ']')
                  {
                        return MATCH_PATTERN;
                  }

				  member_match = FALSE;
                  loop = TRUE;

                  while (loop)
                  {
                        /* if end of construct then loop is done */

                        if (*p == ']')
                        {
                              loop = FALSE;
                              continue;
                        }

                        /* matching a '!', '^', '-', '\' or a ']' */

                        if (*p == '\\')
                        {
                              range_start = range_end = *++p;
                        }
                        else  range_start = range_end = *p;

                        /* if end of pattern then bad pattern (Missing ']') */

                        if (!*p)
                              return MATCH_PATTERN;

                        /* check for range bar */
						if (*++p == '-')
                        {
                              /* get the range end */

                              range_end = *++p;
                              
                              /* if end of pattern or construct
                                 then bad pattern */

                              if (range_end == '\0' || range_end == ']')
                                    return MATCH_PATTERN;

							  /* special character range end */
                              if (range_end == '\\')
                              {
                                    range_end = *++p;

                                    /* if end of text then
                                       we have a bad pattern */
                                    if (!range_end)
                                          return MATCH_PATTERN;
                              }

                              /* move just beyond this range */
                              p++;
                        }

						/* if the text character is in range then match found.
                           make sure the range letters have the proper
                           relationship to one another before comparison */

                        if (range_start < range_end)
                        {
                              if (*t >= range_start && *t <= range_end)
                              {
                                    member_match = TRUE;
                                    loop = FALSE;
                              }
                        }
						else
                        {
                              if (*t >= range_end && *t <= range_start)
                              {
                                    member_match = TRUE;
                                    loop = FALSE;
                              }
                        }
                  }

                  /* if there was a match in an exclusion set then no match */
                  /* if there was no match in a member set then no match */

                  if ((invert && member_match) || !(invert || member_match))
                        return MATCH_RANGE;

				  /* if this is not an exclusion then skip the rest of
					 the [...] construct that already matched. */

				  if (member_match)
				  {
						while (*p != ']')
						{
							  /* bad pattern (Missing ']') */
							  if (!*p)
									return MATCH_PATTERN;

							  /* skip exact match */
							  if (*p == '\\')
							  {
									p++;

									/* if end of text then
									   we have a bad pattern */

									if (!*p)
										  return MATCH_PATTERN;
							  }

							  /* move to next pattern char */

							  p++;
						}
				  }
				  break;
			}
			case '\\':  /* next character is quoted and must match exactly */

				  /* move pattern pointer to quoted char and fall through */

				  p++;

				  /* if end of text then we have a bad pattern */

				  if (!*p)
						return MATCH_PATTERN;

				  /* must match this character exactly */

			default:
				  if (toupper(*p) != toupper(*t))
						return MATCH_LITERAL;
			}
	  }
	  /* if end of text not reached then the pattern fails */

	  if (*t)
			return MATCH_END;
	  else  return MATCH_VALID;
}


/*----------------------------------------------------------------------------
*
* recursively call matche() with final segment of PATTERN and of TEXT.
*
----------------------------------------------------------------------------*/

int matche_after_star (char *p, char *t)
{
	  int match = 0;
	  char nextp;

	  /* pass over existing ? and * in pattern */

	  while ( *p == '?' || *p == '*' )
	  {
			/* take one char for each ? and + */

			if (*p == '?')
			{
				  /* if end of text then no match */
				  if (!*t++)
						return MATCH_ABORT;
			}

			/* move to next char in pattern */

			p++;
	  }

	  /* if end of pattern we have matched regardless of text left */

	  if (!*p)
			return MATCH_VALID;

	  /* get the next character to match which must be a literal or '[' */

	  nextp = *p;
	  if (nextp == '\\')
	  {
			nextp = p[1];

			/* if end of text then we have a bad pattern */

			if (!nextp)
				  return MATCH_PATTERN;
	  }

	  /* Continue until we run out of text or definite result seen */

	  do
	  {
			/* a precondition for matching is that the next character
			   in the pattern match the next character in the text or that
			   the next pattern char is the beginning of a range.  Increment
			   text pointer as we go here */

			if (tolower(nextp) == tolower(*t) || nextp == '[')
				  match = matche(p, t);

			/* if the end of text is reached then no match */

			if (!*t++)
				  match = MATCH_ABORT;

	  } while ( match != MATCH_VALID &&
				match != MATCH_ABORT &&
				match != MATCH_PATTERN);

	  /* return result */

	  return match;
}


/*----------------------------------------------------------------------------
*
* match() is a shell to matche() to return only BOOL values.
*
----------------------------------------------------------------------------*/

BOOL match( char *p, char *t )
{
	  int error_type;

	  error_type = matche(p,t);
	  return (error_type == MATCH_VALID ) ? TRUE : FALSE;
}

/*
	$Log: lsapi.c,v $
	Revision 1.40  1998/11/17 02:21:17  bryan
	Fixed the DrawFrame Resource problem.
	
	Revision 1.39  1998/11/11 19:55:20  cyberian
	*** empty log message ***
	
 */

