/*

  This is a part of the LiteStep Shell Source code.

  Copyright (C) 1997-98 The LiteStep Development Team

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/****************************************************************************
 11/16/98 - Bug*Killer added by Fahim
			Added facility for popup menu to open when right clicked on wharf
			Divided the title bar in two parts : drag the left one to move the 
			bar, click on the right one to shade/unshade the bar. When the wharf
			bar is not shaded, a double click on the left part puts it in shaded
			mode & then moves it to a special position : 
			ScreenWidth - "WharfDblClickXPosition",0. When the wharf bar is 
			shaded, a double click on the left part unshades the bar, then docks
			it on the right, or on the left if the "WharfDblClickDockOnLeft" 
			step.rc entry is specified.
 11/15/98 - cael
			Added checks in SetWorkArea() to not change the work area if
			SetDesktopArea is true
 11/03/98 - W. Konkel
				Added the better wharf movement as well as sound to !WharfTasks
 11/02/98 - W. Konkel
				Added wharf open/close/min/max sounds (with the help/request 
					of snowchyld)
 11/01/98 - T. Engel
	 			Added back WharfTitleFont, WharfTitleFontSize, and a new
 				option WharfTitleFontWeight
 11/01/98 - W. Konkel
				Added better wharf movement (fixed a few small bugs)
				Made WharfCloseOnSwitch work much much better
 10/31/98 - Cyberian
				Fixed crashing on recycle when WharfCloseOnSwitch is enabled
 10/29/98 - Cyberian (Fahim Farook)
				Added WharfCloseOnSwitch to step.rc so that you can have the 
				subwharf folders auto-close when focus is lost if you desire
				Added support for wharf hints

 10/10/98 - W. Konkel
				Added snap-to-edge wharf and the ability to not include the
					default.bmp and 3dots.bmp in wharf layer.
 10/09/98 - C. Boyda
				Made the trans titlebar much more efficent in speed

 10/03/98 - J. Vaughn
				Added fully functional, working transparency to the wharf
				titlebar (why was it left out to begin with?? :P)

 09/03/98 - C. Boyda
                Added fully functional, working transparency to the wharf
            D. Hodgkiss
                Folders support is now in

 08/31/98 - D. Hodgkiss
                Added ability to move the wharf anywhere on the screen
                Added a titlebar to the wharf
                Added hide/unhide support

 08/25/98 - D. Hodgkiss
                This file contains the source for the wharf bar
 
****************************************************************************/

#include <windows.h>
#include <mmsystem.h>
#include <malloc.h>
#include <stdio.h>
#include <tchar.h>
#include <commctrl.h>

#include "lsapi.h"
#include "wharf.h"

// -------------------------------------------------------------------------------------------------------

const LPCTSTR   szMainWindowClass = _T("TWharfGlobalContainer");
const LPCTSTR   szHiddenWindowClass = _T("LineDownSide");
const char rcsRevision[] = "$Revision: 1.93 $"; // Our Version 
const char rcsId[] = "$Id: wharf.c,v 1.93 1998/11/27 09:00:52 bryan Exp $"; // The Full RCS ID.


FARPROC (__stdcall *SwitchToThisWindow)(HWND, int);

// our window procedures
LRESULT CALLBACK MainWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK HiddenWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

// -------------------------------------------------------------------------------------------------------

void CloseAllFolders();
void ExecuteWharfTasks(int i);
void ExecuteSubWharf(int i, int x);
BOOL CreateSubWharf(int i, int x, LPCSTR);

// BK
BOOL CreateWharf(int, LPCSTR);
int GetWharfPosition(int nWharf);
// Following should be an inline function if we were using C++ :-)
#define GetWharfBarHeight() GetWharfPosition(numWharfs)
// -BK

BOOL PartOfWharf(HWND myWnd);
void ReadConfig(void);
int GetWharfByWnd(HWND hwnd);
void ExecuteWharf(int i);
void SetWorkArea(void);
void togglePressOffset(int i, BOOL bToggle);
void ShowWharf(void);
void HideWharf(void);
void CreateWharfhints(HWND hWnd, char *txt, RECT *r);
void RemoveWharfhints(HWND hWnd);
void SoundOpen(void);
void SoundClose(void);
void SoundMin(void);
void SoundMax(void);

char szLitestepPath[256];
char lsPath[256];
char wharfOpenSound[256];
char wharfCloseSound[256];
char wharfMinSound[256];
char wharfMaxSound[256];

char szImagePath[256];
char szDefPixmap[256];
char szFolderPixmap[256];
HBITMAP titlebarImage = NULL;
HBITMAP defaultBackImage = NULL;
HBITMAP folderImage = NULL;
HBITMAP defaultFolderImage = NULL;
HINSTANCE dll;
HWND hMainWnd;
HWND HiddenWnd;
HWND parent;
HWND oldCapt = NULL;
HWND wharfHints = NULL;
HRGN hMainRgn;
int ScreenWidth, ScreenHeight, wharfBaseX = -64, wharfBaseY = 0;
wharfType *wharfs = NULL;
int numWharfs = 0;
int wharfDirection = WHARF_DOWN;
int titleSize;
//Wharf mods
int wharfShadeButton = 32;
int wharfDblClickXPosition = 120;
BOOL wharfDblClickDockOnLeft = FALSE;
//Wharf mods
int wharfClosingPos;
int wharfAnimTime;
int wharfDocked = 0;
int wharfStep = 64;
int autoHideDelay = 300;
int autoShowDelay = 300;
int hiddenWidth = 1;
int OpenFolders = 0;
int wharfPressOffset = 1;
BOOL wharfClosing = FALSE;
BOOL wharfHide = FALSE;
BOOL wharfTitlebar = TRUE;
BOOL wharfNoAnim = FALSE;
BOOL wharfAutoClose = TRUE;
BOOL wharfTitles = FALSE;
BOOL wharfCloseOnSwitch = FALSE; 
BOOL showbg = TRUE;
BOOL snapTo = FALSE;
BOOL wharfAutoHide = FALSE;
BOOL hideTimerActive = FALSE;
BOOL showTimerActive = FALSE;
BOOL wharfHidden = FALSE;
BOOL wharfAutoUnpress = FALSE;
BOOL wharfNoHints = TRUE;
int snapToSensitivity = 16;
int bevelWidth;
COLORREF titleFore, titleBack;
char szTitleFont[256] = "Arial";
int iTitleFontSize = 8, iTitleFontWeight = 400;
BOOL setDesktopArea = TRUE;
// -------------------------------------------------------------------------------------------------------
int initModule(HWND ParentWnd, HINSTANCE dllInst, wharfDataType* wd)
{
	return initModuleEx (ParentWnd, dllInst, wd->lsPath);
}

int initModuleEx(HWND ParentWnd, HINSTANCE dllInst, LPCSTR szPath)
{
	UINT Msgs[10];
	RECT r;
	int i;
	
	dll = dllInst;
	parent = ParentWnd;
	
	GetClientRect(GetDesktopWindow(),&r);
//	ScreenWidth = r.right;
//	ScreenHeight = r.bottom;
	ScreenWidth = GetSystemMetrics(SM_CXSCREEN);
	ScreenHeight = GetSystemMetrics(SM_CYSCREEN);
	
	strcpy(szLitestepPath, szPath);
	ReadConfig();
	if (!wharfNoHints) {
		wharfHints = CreateWindow
			(TOOLTIPS_CLASS,
			(LPSTR) NULL,
			TTS_ALWAYSTIP,
			CW_USEDEFAULT,
			CW_USEDEFAULT,
			CW_USEDEFAULT,
			CW_USEDEFAULT,
			NULL,
			(HMENU) NULL,
			dll,
			NULL
			);
		if (!wharfHints) {
			MessageBox(parent, "Error creating hints window", "Wharf Hints Error", MB_OK);
			return 1;
		}
		SetWindowPos(wharfHints, HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_NOACTIVATE);
	}

	if (wharfTitlebar)
		titleSize = 16;
	else
		titleSize = 0;
	
	{	// Register our window class
		WNDCLASS wc;
		
		memset(&wc,0,sizeof(wc));
		wc.lpfnWndProc = MainWndProc;				  // our window procedure
		wc.hInstance = dllInst; 				// hInstance of DLL
		wc.lpszClassName = szMainWindowClass;	   // our window class name
		wc.style = CS_DBLCLKS;
		
		if (!RegisterClass(&wc)) 
		{
			MessageBox(parent,"Error registering window class", "Wharf", MB_OK);
			return 1;
		}

		if (wharfAutoHide)
		{
			WNDCLASS wc;
			memset(&wc,0,sizeof(wc));
			wc.lpfnWndProc = HiddenWndProc;				  // our window procedure
			wc.hInstance = dllInst; 				// hInstance of DLL
			wc.lpszClassName = szHiddenWindowClass;	   // our window class name
			wc.style = 0;
			
			if (!RegisterClass(&wc)) 
			{
				MessageBox(parent,"Error registering window class", "Wharf", MB_OK);
				return 1;
			}
		}



	}
	
	hMainWnd = CreateWindowEx(
		WS_EX_TOPMOST | WS_EX_TOOLWINDOW,
		szMainWindowClass,
		"",
		WS_CLIPCHILDREN | WS_POPUP,
		wharfBaseX,
		wharfBaseY,
		0,
		0,
		parent,
		NULL,
		dllInst,
		NULL
		);
	
	if (!hMainWnd)
	{
		MessageBox(parent, "Error creating wharf", "Wharf", MB_OK);
		return 1;
	}

	
	SetWindowLong (hMainWnd, GWL_USERDATA, magicDWord);
	
	if (wharfAutoHide)
	{
		HiddenWnd = CreateWindowEx(
			WS_EX_TOPMOST | WS_EX_TOOLWINDOW,
			szHiddenWindowClass,
			"",
			WS_POPUP,
			(wharfBaseX == 0) ? 0 : wharfBaseX+64 - hiddenWidth,
			wharfBaseY,
			hiddenWidth,
			ScreenHeight,
			parent,
			NULL,
			dllInst,
			NULL
			);
		
		if (!HiddenWnd)
		{
			MessageBox(parent, "Error creating wharf", "Wharf", MB_OK);
			return 1;
		}

		
		SetWindowLong (HiddenWnd, GWL_USERDATA, magicDWord);
	}


	SwitchToThisWindow = (FARPROC (__stdcall *)(HWND, int))GetProcAddress(GetModuleHandle("USER32.DLL"), "SwitchToThisWindow");

	{
		FILE *f;
		
		f = LCOpen (NULL);
		if (f)
		{
			char	buffer[4096];
			// BK
			char	token1[4096], token2[4096], token3[4096], token4[4096], token5[4096], extra_text[4096];
			char*	tokens[5];
			BOOL	inFolder = FALSE;

			tokens[0] = token1;
			tokens[1] = token2;
			tokens[2] = token3;
			tokens[3] = token4;
			tokens[4] = token5;
			// -BK

			buffer[0] = 0;

			while (LCReadNextConfig (f, "*Wharf", buffer, sizeof (buffer)))
			{
				int count;
				int wharfHeight=64;
				
				// BK
				token1[0] = token2[0] = token3[0] = token4[0] = token5[0] = extra_text[0] = '\0';
				count = LCTokenize (buffer, tokens, 5, extra_text);
				// -BK
				
				switch (count)
				{
				case 2:
					if (!strcmpi(token2, "~Folder"))
					{
						inFolder = FALSE;
						numWharfs++;
						break;
					}
				// BK
				case 5:
					{
					// Is token 2 the wharf height ?
						if (token2[0]=='!')
						{// Yes
							int TokenNum;

						// Read height
							wharfHeight=atoi(&token2[1]);

						// Shift tokens to comply with the 4 tokens syntax
							for(TokenNum=2;TokenNum<5;TokenNum++)
								strcpy(tokens[TokenNum-1],tokens[TokenNum]);

						}
						else
						{// No, then we must add token5 to the beginning of extra_text
							strcat(token5," ");
							strcat(token5,extra_text);
							strcpy(extra_text,token5);
						}
					}
				// Continue with case 4: (no 'break;' !)
				// -BK

				case 4:
					{
						// token 1 is "*Wharf", token 2 is the name, token 3 is the
						// graphic, token 4 is the executable, and the extra_text are
						// the program arguments.
						char windowName[256];

						windowName[0] = '\0';

						if ((token4[0] == '%') && (strrchr(token4, '%') == token4))
						{
							char szTempToken[4096];
							char*	tokens2[5];
							tokens2[0] = token1;
							tokens2[1] = token2;
							tokens2[2] = token3;
							tokens2[3] = szTempToken;
							tokens2[4] = token4;


							strcpy (windowName, token4 + 1);

							extra_text[0] = token4[0] = '\0';
							count = LCTokenize (buffer, tokens2, 5, extra_text);
						}

						if (inFolder)
						{
							char szTT[1024];
							int w = numWharfs;
							int x = wharfs[w].numSubwharfs;
							
							if (!wharfs[w].subwharfs)
							{
								wharfs[w].subwharfs = (subwharfType *)malloc(sizeof(subwharfType));
							}
							else
							{
								wharfs[w].subwharfs = (subwharfType *)realloc(wharfs[w].subwharfs, (x+1)*sizeof(subwharfType));
							}
							memset(&wharfs[w].subwharfs[x], 0, sizeof(wharfs[w].subwharfs[x]));
							
							if (token3[0] == '*')
							{
								char *temptoken3;
								temptoken3 = token3;
								if (*temptoken3 == '*')
										temptoken3++;
								strcpy(token3,temptoken3);
								wharfs[numWharfs].subwharfs[x].showbg = FALSE;
							} else {
								wharfs[numWharfs].subwharfs[x].showbg = TRUE;
							}
							
							strcpy (wharfs[w].subwharfs[x].szName, token2);
							strcpy (wharfs[w].subwharfs[x].szCommand, token4);
							strcpy (wharfs[w].subwharfs[x].szParameters, extra_text);
							strcpy (szTT, token4);
							if (strnicmp(".extract", token3, 8) && extra_text && strlen(extra_text))
							{
//								MessageBox(0, extra_text, "Got Here", MB_OK|MB_TOPMOST);
								strcat (szTT, " ");
								strcat (szTT, extra_text);
							}

							wharfs[w].subwharfs[x].frontImage = LoadLSImage (token3, szTT);

							CreateSubWharf(numWharfs, wharfs[w].numSubwharfs, windowName);
							wharfs[w].numSubwharfs++;
						} else {
							//char *szTemp;
							char szTT[1024];

							if (!wharfs)
							{
								wharfs = (wharfType *)malloc(sizeof(wharfType));
							}
							else
							{
								wharfs = (wharfType *)realloc(wharfs, (numWharfs+1)*sizeof(wharfType));
							}
							memset(&wharfs[numWharfs], 0, sizeof(wharfs[numWharfs]));

						// BK
							wharfs[numWharfs].wharfHeight=wharfHeight;
						// -BK

							if (token3[0] == '*')
							{
								char *temptoken3;
								temptoken3 = token3;
								if (*temptoken3 == '*')
										temptoken3++;
								strcpy(token3,temptoken3);
								wharfs[numWharfs].showbg = FALSE;
							} else {
								wharfs[numWharfs].showbg = TRUE;
							}
							
							strcpy(wharfs[numWharfs].szName, token2);
							strcpy(wharfs[numWharfs].szCommand, token4);
							strcpy(wharfs[numWharfs].szParameters, extra_text);
							
							if (!strcmpi (token4, "Folder"))
							{
								strcpy(szTT, token2);
							}
							else
							{
								strcpy(szTT, token4);
								if (strnicmp(".extract", token3, 8) && extra_text && strlen(extra_text))
								{
									strcat (szTT, " ");
									strcat (szTT, extra_text);
								}
							}
							wharfs[numWharfs].frontImage = LoadLSImage(token3, szTT);
							
							// BK
							CreateWharf(numWharfs, windowName);
							// -BK
							
							if (!strcmpi(token4, "Folder"))
							{
								inFolder = TRUE;
								wharfs[numWharfs].subwharfs = NULL;
								wharfs[numWharfs].numSubwharfs = 0;
								wharfs[numWharfs].subwharfOpen = FALSE;
								wharfs[numWharfs].bPressed = FALSE;
								wharfs[numWharfs].bTogglePressed = FALSE;
								wharfs[numWharfs].hsubwharfWnd = CreateWindowEx(
									WS_EX_TOPMOST | WS_EX_TOOLWINDOW,
									szMainWindowClass,
									"",
									WS_CLIPCHILDREN | WS_POPUP,
									0, 0,
									0, 0,
									parent,
									NULL,
									dll,
									NULL
									);
								
								SetWindowLong(wharfs[numWharfs].hsubwharfWnd, GWL_USERDATA, magicDWord);
								ShowWindow(wharfs[numWharfs].hsubwharfWnd, SW_SHOWNORMAL);
							}
							else
							{
								numWharfs++;
							}
						}
					}
				}
			}
			LCClose(f);
		}
	}
	
	Msgs[0] = LM_SHADETOGGLE;
	Msgs[1] = LM_GETREVID;
	Msgs[2] = 0;
	SendMessage(parent, LM_REGISTERMESSAGE, (WPARAM) hMainWnd, (LPARAM) Msgs);

	/* transparent titlebar */
	if (wharfTitlebar && titlebarImage)
	{
		HRGN hClipRgn, hTitlebarRgn;

		hClipRgn = CreateRectRgn(0, 0, 64, 16);
		hTitlebarRgn = BitmapToRegion(titlebarImage, RGB(255,0,255), 0x101010, 0, 0);
	
		if (hMainRgn)
		{
			CombineRgn(hTitlebarRgn, hClipRgn, hTitlebarRgn, RGN_DIFF);
			CombineRgn(hMainRgn, hMainRgn, hTitlebarRgn, RGN_DIFF);
		}

		DeleteObject(hClipRgn);
		DeleteObject(hTitlebarRgn);
	}
	
	/* set our region for hMainWnd now, this sets the wharf into our transparency mode     */
	/* after we compiled the full region for the parent window of the child, tile, windows */
	/* C. Boyda                                                                            */

	SetWindowRgn(hMainWnd, hMainRgn, TRUE);
	hMainRgn = NULL;

	for (i = 0; i < numWharfs; i++)
	{
		if (wharfs[i].hsubwharfWnd)
		{
			SetWindowRgn(wharfs[i].hsubwharfWnd, wharfs[i].subRgn, TRUE);
			wharfs[i].subRgn = NULL;
		}
	}
	
	ShowWindow(hMainWnd, SW_SHOWNORMAL);
	// If we are autohiding, set the autohide delay. 
	if (wharfAutoHide)
	{
		RECT r;
		GetClientRect(hMainWnd, &r);

		SetWindowPos(HiddenWnd, 0, 0, 0, hiddenWidth, r.bottom - r.top, SWP_NOZORDER | SWP_NOMOVE);

		SetTimer(HiddenWnd, 1, 50, NULL);
	}
	SetWorkArea();
	
	return 0;
}

// -------------------------------------------------------------------------------------------------------

LRESULT CALLBACK HiddenWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch(message)
	{
	case WM_ENDSESSION:
	case WM_QUERYENDSESSION:
		return SendMessage(parent,message,wParam,lParam);
	case WM_SYSCOMMAND:
		{
			switch (wParam)
			{
			case SC_CLOSE:
				PostMessage(parent,WM_KEYDOWN,LM_SHUTDOWN,0);
				return 0;
			default:
				break;
			}
		}
		break;
	case WM_PAINT:
		{
			PAINTSTRUCT ps;
			RECT r;
			HDC hdc = BeginPaint(hwnd,&ps);
			HBRUSH hb = CreateSolidBrush(0xFFFFFF);

			GetClientRect(hwnd, &r);
			r.right += 1;
			r.bottom += 1;

			FillRect(hdc, &r, hb);

			DeleteObject(hb);
			EndPaint(hwnd, &ps);
		}
		return 0;
	case WM_TIMER:
		{
			if (wharfDocked)
			{
				switch (wParam)
				{
				case 0:
					if (wharfAutoHide) HideWharf();
					KillTimer(HiddenWnd, 0);
					hideTimerActive = FALSE;
					break;
				case 1:
					if (wharfAutoHide && !wharfHidden && !hideTimerActive)
					{
						POINT pt;
						RECT r;
						GetCursorPos(&pt);
						GetWindowRect(hMainWnd, &r);
						if ((pt.x < r.left || pt.x > r.right || pt.y < r.top || pt.y > r.bottom) && !OpenFolders)
						{
							SetTimer(HiddenWnd, 0, autoHideDelay, NULL);
							hideTimerActive = TRUE;
						}
					}
					else
					{
						if (wharfAutoHide && wharfHidden && !showTimerActive)
						{
							POINT pt;
							RECT r;
							GetCursorPos(&pt);
							GetWindowRect(HiddenWnd, &r);
							if (pt.x >= r.left && pt.x <= r.right && pt.y >= r.top && pt.y <= r.bottom)
							{
								SetTimer(HiddenWnd, 2, autoShowDelay, NULL);
								showTimerActive = TRUE;
							}

						}
						else if (wharfHidden && showTimerActive)
						{
							POINT pt;
							RECT r;
							GetCursorPos(&pt);
							GetWindowRect(HiddenWnd, &r);
							if (pt.x < r.left || pt.x > r.right || pt.y < r.top || pt.y > r.bottom)
							{
								KillTimer(HiddenWnd, 2);
								showTimerActive = FALSE;
							}
						}
					}
					break;
				case 2:
					if (wharfAutoHide) ShowWharf();
					KillTimer(HiddenWnd, 2);
					showTimerActive = FALSE;
					break;

				}
			}
			else
			{
				if (hideTimerActive)
				{
					KillTimer(HiddenWnd, 0);
					hideTimerActive = FALSE;
				}
			}
			return 0;
		}

	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}

LRESULT CALLBACK MainWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	WORD fActive;
	HWND hwndGetFocus;

	switch(message)
	{
	case LM_GETREVID:
		{
			char *buf = (char *) lParam;

			if (wParam == 0)
			{
					strcpy(buf, "wharf.dll: ");
					strcat(buf, &rcsRevision[11]);
					buf[strlen(buf)-1] = '\0';
			}
			else if (wParam == 1)
			{
				strcpy(buf, &rcsId[1]);
				buf[strlen(buf)-1] = '\0';
			} else
			{
				strcpy(buf, "");
			}
			return strlen(buf);

		}
	case WM_ENDSESSION:
	case WM_QUERYENDSESSION:
		return SendMessage(parent,message,wParam,lParam);
	case WM_SYSCOMMAND:
		{
			switch (wParam)
			{
			case SC_CLOSE:
				PostMessage(parent,WM_KEYDOWN,LM_SHUTDOWN,0);
				return 0;
			default:
				break;
			}
		}
		break;;

	case LM_RECYCLE:
		SendMessage(parent, message, wParam, lParam);
		return 0;
		
	case LM_SHADETOGGLE:
		if (wharfClosing) return 0;
		CloseAllFolders();
		if (!wharfHide)
		{
			if (wharfMinSound) SoundMin();
			if (wharfNoAnim)
			{
				SetWindowPos(hMainWnd, 0, wharfBaseX, wharfBaseY, 64, titleSize, SWP_NOZORDER);
				wharfHide = TRUE;
				return 0;
			}
			wharfClosing = TRUE;
			// BK
			wharfClosingPos = GetWharfBarHeight();
			// -BK
			SetTimer(hMainWnd, 1, wharfAnimTime, NULL);
		} else {
			if (wharfMaxSound) SoundMax();
			if (wharfNoAnim)
			{
				// BK
				SetWindowPos(hMainWnd, 0, wharfBaseX, wharfBaseY, 64, GetWharfBarHeight(), SWP_NOZORDER);
				// -BK
				wharfHide = FALSE;
				return 0;
			}
			wharfClosing = TRUE;
			wharfClosingPos = titleSize;
			SetTimer(hMainWnd, 0, wharfAnimTime, NULL);
		}
		return 0;

	case WM_TIMER:
		if (wharfClosing && wParam == 0)
		{
			wharfClosingPos += wharfStep;
			SetWindowPos(hMainWnd, 0, wharfBaseX, wharfBaseY, 64, wharfClosingPos, SWP_NOZORDER);
			// BK
			if (wharfClosingPos >= GetWharfBarHeight())
			// -BK
			{
				wharfHide = FALSE;
				wharfClosing = FALSE;
				KillTimer(hMainWnd, 0);
			}
		}
		if (wharfClosing && wParam == 1)
		{
			if (wharfClosingPos - wharfStep <= titleSize ) wharfClosingPos = titleSize;
			else wharfClosingPos -= wharfStep;
//			wharfClosingPos -= wharfStep;
			SetWindowPos(hMainWnd, 0, wharfBaseX, wharfBaseY, 64, wharfClosingPos, SWP_NOZORDER);
			if (wharfClosingPos <= titleSize)
			{
				wharfHide = TRUE;
				wharfClosing = FALSE;
				KillTimer(hMainWnd, 1);
			}
		}
		if (wParam == 2)   //sub wharf opening
		{
			int x, i = -1;

			for (x = 0; x < numWharfs; x++)
			{
				if (wharfs[x].hsubwharfWnd == hwnd)
				{
					i = x;
					break;
				}
			}
			if (i != -1) // subwharf positions
			{
				if (wharfs[i].closing) {
					KillTimer(wharfs[i].hsubwharfWnd, 2);
					SetTimer(wharfs[i].hsubwharfWnd, 3, wharfAnimTime, NULL);
				}
				else {
					if (wharfs[i].movingPos + wharfStep >= wharfs[i].numSubwharfs*64 )
							wharfs[i].movingPos = wharfs[i].numSubwharfs*64;
					else wharfs[i].movingPos += wharfStep;
	//				wharfs[i].movingPos += wharfStep;

	/*				togglePressOffset(i, TRUE);
					wharfs[i].bPressed = TRUE;
	*/				KillTimer(wharfs[i].hWnd, 4);

					if ((wharfBaseX+32) > ScreenWidth/2)
					{
						// BK
						SetWindowPos(wharfs[i].hsubwharfWnd, 0, wharfBaseX-wharfs[i].movingPos, wharfBaseY+GetWharfPosition(i), wharfs[i].movingPos, 64, SWP_NOZORDER);
						// -BK
						if (wharfs[i].movingPos >= wharfs[i].numSubwharfs*64)
						{
							wharfs[i].subwharfOpen = TRUE;
							wharfs[i].moving = FALSE;
							wharfs[i].closing = TRUE;
							KillTimer(wharfs[i].hsubwharfWnd, 2);
						}
					}
					else
					{
						// BK
						SetWindowPos(wharfs[i].hsubwharfWnd, 0, wharfBaseX+64, wharfBaseY+GetWharfPosition(i), wharfs[i].movingPos, 64, SWP_NOZORDER);
						// -BK
						if (wharfs[i].movingPos >= wharfs[i].numSubwharfs*64)
						{
							wharfs[i].subwharfOpen = TRUE;
							wharfs[i].moving = FALSE;
							wharfs[i].closing = TRUE;
							KillTimer(wharfs[i].hsubwharfWnd, 2);
						}
					}
				}
			}
		}
		if (wParam == 3)  // sub wharf closing
		{
			int i;

			for (i = 0; i < numWharfs; i++)
			{
				if (wharfs[i].hsubwharfWnd == hwnd)
				{
					if (!wharfs[i].closing) {
						KillTimer(wharfs[i].hsubwharfWnd, 3);
						SetTimer(wharfs[i].hsubwharfWnd, 2, wharfAnimTime, NULL);
					}
					else {

						wharfs[i].movingPos -= wharfStep;

	//					wharfs[i].bPressed = FALSE;
	//					togglePressOffset(i, FALSE);
						KillTimer(wharfs[i].hWnd, 4);

						if ((wharfBaseX+32) > ScreenWidth/2)
						{
							// BK
							SetWindowPos(wharfs[i].hsubwharfWnd, 0, wharfBaseX-wharfs[i].movingPos, wharfBaseY+GetWharfPosition(i), wharfs[i].movingPos, 64, SWP_NOZORDER);
							// -BK
							if (wharfs[i].movingPos <= 0)
							{
								wharfs[i].subwharfOpen = FALSE;
								wharfs[i].bPressed = FALSE;
								togglePressOffset(i, FALSE);
								wharfs[i].moving = FALSE;
								wharfs[i].closing = FALSE;
								KillTimer(wharfs[i].hsubwharfWnd, 3);
							}
						}
						else
						{
							// BK
							SetWindowPos(wharfs[i].hsubwharfWnd, 0, wharfBaseX+64, wharfBaseY+GetWharfPosition(i), wharfs[i].movingPos, 64, SWP_NOZORDER);
							// -BK
							if (wharfs[i].movingPos <= 0)
							{
								wharfs[i].subwharfOpen = FALSE;
								wharfs[i].moving = FALSE;
								wharfs[i].closing = FALSE;
								wharfs[i].bPressed = FALSE;
								togglePressOffset(i, FALSE);
								KillTimer(wharfs[i].hsubwharfWnd, 3);
							}
						}
					}
				}
			}
		}
		if (wParam == 4)
		{
			int i;
			for (i = 0; i < numWharfs; i++)
			{
				POINT pt;
				GetCursorPos(&pt);
				if (wharfs[i].bPressed && !wharfs[i].subwharfOpen && !PtInRegion(hMainRgn, pt.x, pt.y))
					togglePressOffset(i, FALSE);
			}

		}
		return 0;

	case WM_NCLBUTTONDOWN:
		if (LOWORD(lParam)-wharfBaseX>=wharfShadeButton)
		{
			SendMessage(hwnd, LM_SHADETOGGLE, 0, 0);
			return 0;
		}
		break;
		
	case WM_NCLBUTTONDBLCLK:
		if ((hwnd==hMainWnd) && wharfTitlebar)
		{
			if(wharfHide)
			{
				wharfBaseX= wharfDblClickDockOnLeft ? 0 : ScreenWidth-64;
			}
			else
			{
				wharfBaseX=ScreenWidth-wharfDblClickXPosition;
				if (wharfBaseX >= ScreenWidth - 64)
					wharfBaseX=ScreenWidth - 64;
			}
			wharfBaseY=0;
			SetWorkArea();
			SendMessage(hwnd, LM_SHADETOGGLE, 0, 0);
		}
		return 0;

	case WM_WINDOWPOSCHANGING:
		if ((hwnd == hMainWnd) && wharfTitlebar)
		{
			LPWINDOWPOS lpwp = (LPWINDOWPOS) lParam;

			if (lpwp->y <= 0)
			{
				lpwp->y = 0;
			}
			else
			if (lpwp->y >= ScreenHeight - 16)
			{
				lpwp->y = ScreenHeight - 16;
			}
			
			if (lpwp->x >= ScreenWidth - 64)
			{
				lpwp->x = ScreenWidth - 64;
			}
			else
			if (lpwp->x <= 0)
			{
				lpwp->x = 0;
			}

			if (snapTo)
			{
				if (lpwp->y <= snapToSensitivity)
				{
					lpwp->y = 0;
				}

				if (lpwp->x >= ScreenWidth - 64 - snapToSensitivity)
				{
					lpwp->x = ScreenWidth - 64;
				}
				else
				if (lpwp->x <= snapToSensitivity)
				{
					lpwp->x = 0;
				}

			} 

			
			return 0;
		}
		break;

	
	case WM_NCHITTEST:
		if (hwnd == hMainWnd && wharfTitlebar)
			return HTCAPTION;
		break;

	case WM_MOVE:
		if (hwnd == hMainWnd)
		{
			char szIni[256], szBuf[256];
			
			wharfBaseX = LOWORD(lParam);
			wharfBaseY = HIWORD(lParam);

			SetWorkArea();

			sprintf(szIni, "%s\\MODULES.INI", szLitestepPath);
			sprintf(szBuf, "%d,%d", wharfBaseX, wharfBaseY);
			WritePrivateProfileString("Wharf", "Position", szBuf, szIni);
		}
		return 0;
					
	case WM_CREATE: return 0;
	case WM_ERASEBKGND: return 0;
		
	case WM_PAINT:
		{
			int i = GetWharfByWnd(hwnd);
			PAINTSTRUCT ps;
			HDC src = CreateCompatibleDC(NULL);
			HDC hdc = BeginPaint(hwnd,&ps);
			
			if (hwnd == hMainWnd && wharfTitlebar && titlebarImage)
			{
				SelectObject(src, titlebarImage);
				BitBlt(hdc, 0, 0, 64, titleSize, src, 0, 0, SRCCOPY);
			}

			if (i != -1)
			{
				if (wharfs[i].backImage)
				{
					SelectObject(src, wharfs[i].backImage);
					// BK
					if (wharfs[i].bPressed)
					{
						TransparentBltLS(hdc, 0, 0, 64, wharfs[i].wharfHeight, src, 0, 0, RGB(255,0,255));
					}
					else
						BitBlt(hdc, 0, 0, 64, wharfs[i].wharfHeight, src, 0, 0, SRCCOPY);
					// -BK
				}
				if (wharfTitles && !wharfs[i].hInst)
				{
					RECT r;
					HBRUSH back;
					HFONT titleFont, oldFont;
					int nHeight;
					int len = lstrlen(wharfs[i].szName);

					back = CreateSolidBrush(titleBack);
					GetClientRect(hwnd, &r);
//					r.bottom = 10;
//					FillRect(hdc, &r, back);
					nHeight = MulDiv(iTitleFontSize, GetDeviceCaps(hdc, LOGPIXELSY), 72);
					r.bottom = nHeight +2;
					FillRect(hdc, &r, back);
					titleFont = CreateFont(
							nHeight, // 8,
							0, // 6,
							0,
							0,
							iTitleFontWeight, // 0,
							FALSE,
							FALSE,
							FALSE,
							ANSI_CHARSET,
							OUT_DEFAULT_PRECIS,
							CLIP_DEFAULT_PRECIS,
							DEFAULT_QUALITY,
							DEFAULT_PITCH | FF_DONTCARE, // DEFAULT_PITCH,
							szTitleFont); // 0);
					oldFont = SelectObject(hdc, titleFont);
					SetBkMode(hdc, TRANSPARENT);
					SetTextColor(hdc, titleFore);
					TextOut(hdc, 2, 1, wharfs[i].szName, len);
					SelectObject(hdc, oldFont);
					DeleteObject(titleFont);
					DeleteObject(back);
				}
				if (bevelWidth)
				{
					RECT r = { 0, 0, 64, wharfs[i].wharfHeight };
/*					if (wharfs[i].bPressed)
					{
						Frame3D(hdc, r, RGB(0,0,0), RGB(255,255,255), bevelWidth);
					}
					else
					{
*/						Frame3D(hdc, r, RGB(255,255,255), RGB(0,0,0), bevelWidth);
//					}
				}
			} else {
				int x, y;
				
				for (x = 0; x < numWharfs; x++)
				{
					if (wharfs[x].subwharfs)
					{
						for (y = 0; y < wharfs[x].numSubwharfs; y++)
						{
							if (hwnd == wharfs[x].subwharfs[y].hWnd)
							{
								if (wharfs[x].subwharfs[y].backImage)
								{
									SelectObject(src, wharfs[x].subwharfs[y].backImage);
									BitBlt(hdc, 0, 0, 64, 64, src, 0, 0, SRCCOPY);
								}
								if ((wharfTitles && !wharfs[x].subwharfs[y].hInst)||(!strcmpi(wharfs[x].szCommand, "!WharfTasks")))
								{
									RECT r;
									HBRUSH back;
									HFONT titleFont, oldFont;
									int nHeight;
									int len = lstrlen(wharfs[x].subwharfs[y].szName);

									back = CreateSolidBrush(titleBack);
									GetClientRect(hwnd, &r);
								//	r.bottom = 10;
								//	FillRect(hdc, &r, back);
									nHeight = MulDiv(iTitleFontSize, GetDeviceCaps(hdc, LOGPIXELSY), 72);
									r.bottom = nHeight +2;
									FillRect(hdc, &r, back);
									titleFont = CreateFont(
											nHeight, // 8,
											0, // 6,
											0,
											0,
											iTitleFontWeight, // 0,
											FALSE,
											FALSE,
											FALSE,
											ANSI_CHARSET,
											OUT_DEFAULT_PRECIS,
											CLIP_DEFAULT_PRECIS,
											DEFAULT_QUALITY,
											DEFAULT_PITCH | FF_DONTCARE, // DEFAULT_PITCH,
											szTitleFont); // 0);
									oldFont = SelectObject(hdc, titleFont);
									SetBkMode(hdc, TRANSPARENT);
									SetTextColor(hdc, titleFore);
									TextOut(hdc, 2, 1, wharfs[x].subwharfs[y].szName, len);
									SelectObject(hdc, oldFont);
									DeleteObject(titleFont);
									DeleteObject(back);
								}
								if (bevelWidth)
								{
									RECT r = { 0, 0, 64, 64 };
									Frame3D(hdc, r, RGB(255,255,255), RGB(0,0,0), bevelWidth);
								}
							}
						}
					}
				}
			}
			EndPaint(hwnd,&ps);
			DeleteDC(src);
			
		}
		return 0;

	case WM_LBUTTONDOWN:
		{
			int i = GetWharfByWnd(hwnd);
			int x;

			for (x = 0; x < numWharfs; x++)
				wharfs[x].bPressed = FALSE;

			if (i != -1)
			{
				wharfs[i].bPressed = TRUE;
				togglePressOffset(i, TRUE);
				SetTimer(wharfs[i].hWnd, 4, 50, NULL);
			}
		}
		return 0;
	case WM_LBUTTONUP:
		{
			int i = GetWharfByWnd(hwnd);
			
			if (i != -1 && wharfs[i].bPressed)
			{
//				if (!(!strcmpi(wharfs[i].szCommand, "Folder") || !strcmpi(wharfs[i].szCommand, "!WharfTasks")) || 
//					wharfs[i].subwharfOpen || wharfAutoUnpress)
				if (wharfAutoUnpress)
				{
					wharfs[i].bPressed = FALSE;
					togglePressOffset(i, FALSE);
				}

				KillTimer(wharfs[i].hWnd, 4);
				ExecuteWharf(i);
			} else {
				int x, y;
				for (x = 0; x < numWharfs; x++)
				{
					if (wharfs[x].subwharfs)
					{
						for (y = 0; y < wharfs[x].numSubwharfs; y++)
						{
							if (hwnd == wharfs[x].subwharfs[y].hWnd)
							{
								ExecuteSubWharf(x, y);
								if (wharfAutoClose)
									CloseAllFolders();
								
								return 0;
							}
						}
					}
				}
			}
		}
		return 0;
	case WM_NCRBUTTONUP:
	case WM_RBUTTONUP: // Open popup menu
            SendMessage(parent, LM_POPUP, (int)HIWORD(lParam), (int)LOWORD(lParam));
            return 0;
	case WM_NCRBUTTONDOWN:
    case WM_RBUTTONDOWN: // Close popup menu
            SendMessage(parent, LM_HIDEPOPUP, (int)HIWORD(lParam), (int)LOWORD(lParam));
            return 0;

	case WM_MOUSEMOVE:
		{
			MSG TooltipMessage;

			int i = GetWharfByWnd(hwnd);
			if (wharfAutoHide && hideTimerActive) {
				KillTimer(HiddenWnd, 0);
				hideTimerActive=FALSE;
			}

			if (!wharfNoHints) {
				if (i >= 0) {
					TooltipMessage.hwnd=wharfs[i].hWnd;
					TooltipMessage.message=message;
					TooltipMessage.wParam=wParam;
					TooltipMessage.lParam=lParam;
					SendMessage(wharfHints,TTM_RELAYEVENT,0,(LPARAM)&TooltipMessage);
					SetWindowPos(wharfHints, HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_NOACTIVATE);
				}
			}

			if (wParam & MK_LBUTTON)
			{   int x;
				for (x = 0; x < numWharfs; x++)  // could be more efficent?
				{
					if ((x == i) && wharfs[x].bPressed)
						togglePressOffset(i, TRUE);
					else if (!wharfs[x].subwharfOpen)
						togglePressOffset(x, FALSE);
				}
			}			
		}
		return 0;
	case WM_ACTIVATE:
		if (wharfCloseOnSwitch) {
			fActive = LOWORD(wParam);
			hwndGetFocus = (HWND)lParam;
			
    		if(fActive == WA_INACTIVE)
    		{
				if (!PartOfWharf(hwndGetFocus))	CloseAllFolders();
			}
		}
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}


BOOL PartOfWharf(HWND myWnd)
{
	int i,j;
	if (myWnd == NULL) return FALSE;
	if (hMainWnd == myWnd) return TRUE;
	if (HiddenWnd == myWnd) return TRUE;
	if (parent == myWnd) return TRUE;
	
	for (i=0;i<numWharfs;i++) if (wharfs[i].hWnd == myWnd) return TRUE;
	for (i=0;i<numWharfs;i++) if (wharfs[i].hsubwharfWnd == myWnd) return TRUE;
		
	for (i = 0; i < numWharfs; i++) {
		for (j=0; j < wharfs[i].numSubwharfs; j++)
			if (myWnd == wharfs[i].subwharfs[j].hWnd || myWnd == wharfs[i].subwharfs[j].taskWnd)
				return TRUE;

	}
		
	return FALSE;

}

void ShowWharf(void)
{
	ShowWindow(HiddenWnd, SW_HIDE);
	ShowWindow(hMainWnd, SW_SHOWNORMAL);
	wharfHidden = FALSE;
}

void HideWharf(void)
{
	ShowWindow(HiddenWnd, SW_SHOWNORMAL);
	ShowWindow(hMainWnd, SW_HIDE);
	wharfHidden = TRUE;
}

void SetWorkArea(void)
{
	RECT deskRect;
	int oldDocked = wharfDocked;

	SystemParametersInfo(SPI_GETWORKAREA, 0, &deskRect, 0);

	if (wharfBaseX == 0) 
	{
		wharfDocked = 1;

		if (setDesktopArea == FALSE) {
		deskRect.left = (wharfAutoHide) ? hiddenWidth : 64;
		deskRect.right = ScreenWidth;
		}
	}
	else if (wharfBaseX+64 == ScreenWidth) 
	{
		wharfDocked = 2;

		if (setDesktopArea == FALSE) {
		deskRect.left = 0;
		deskRect.right = (wharfAutoHide) ? ScreenWidth - hiddenWidth : ScreenWidth - 64;
		}
	}
	else
	{
		wharfDocked = 0;

		if (setDesktopArea == FALSE) {
		deskRect.left = 0;
		deskRect.right = ScreenWidth;
		}
	}

	if (wharfDocked != oldDocked)
	{
		SystemParametersInfo(SPI_SETWORKAREA, 1, &deskRect, SPIF_SENDCHANGE);
	}

	if (wharfAutoHide && wharfDocked)
	{
		switch(wharfDocked)
		{
		case 1:
			SetWindowPos(HiddenWnd, 0, 0, wharfBaseY, 0, 0, SWP_NOACTIVATE | SWP_NOSENDCHANGING | SWP_NOSIZE | SWP_NOZORDER );
			break;
		case 2:
			SetWindowPos(HiddenWnd, 0, ScreenWidth - hiddenWidth, wharfBaseY, 0, 0, SWP_NOACTIVATE | SWP_NOSENDCHANGING | SWP_NOSIZE | SWP_NOZORDER );
			break;
		}
	}
}

void togglePressOffset(int i, BOOL bToggle)
{
// BK
	int WharfPosition=GetWharfPosition(i);

	if (wharfDirection == WHARF_DOWN)
	{
		if (wharfs[i].bTogglePressed != bToggle) // redundancy check...see below comment

			SetWindowPos(	wharfs[i].hWnd,							 
							0, 
							bToggle ? wharfPressOffset : 0, 
							bToggle ? WharfPosition + wharfPressOffset : WharfPosition, 
							64, 
							bToggle ? wharfs[i].wharfHeight-1 : wharfs[i].wharfHeight, 
							SWP_NOZORDER/*|SWP_NOSIZE*/);
	} 
	// -BK
	else if (wharfDirection == WHARF_RIGHT)
	{
		if (wharfs[i].bTogglePressed != bToggle) // redundancy check...see below comment
			SetWindowPos(	wharfs[i].hWnd, 
							0, 
							bToggle ? (64*i) + wharfPressOffset : (64*i), 
							bToggle ? wharfPressOffset : 0, 
							bToggle ? 63 : 64,
							64,
							SWP_NOZORDER/*|SWP_NOSIZE*/);
	}
	wharfs[i].bTogglePressed = bToggle; // could this be replaced by checking the windows current position for a 1, 1 offset?
}

// -------------------------------------------------------------------------------------------------------
// cleanup (opposite of init()). Destroys the window, unregisters the window class
void quitModule(HINSTANCE dllInst) {
	RECT deskRect;
	int i;
	
	if (oldCapt) {
		SetCapture(oldCapt);
		oldCapt = NULL;
	}
	if (!wharfNoHints) {
		if (wharfHints) {
			DestroyWindow (wharfHints);
			wharfHints = NULL;
		}
	}
	for (i = 0; i < numWharfs; i++) {

		if (wharfs[i].subwharfs) {
			int x;
			for (x = 0; x < wharfs[i].numSubwharfs; x++) {
				if (wharfs[i].subwharfs[x].hInst) {
					(*wharfs[i].subwharfs[x].quitWharfModule)(wharfs[i].subwharfs[x].hInst);
					FreeLibrary(wharfs[i].subwharfs[x].hInst);
				}
				DestroyWindow(wharfs[i].subwharfs[x].hWnd);
				if (wharfs[i].subwharfs[x].backImage)
					DeleteObject(wharfs[i].subwharfs[x].backImage);
				if (wharfs[i].subwharfs[x].frontImage)
					DeleteObject(wharfs[i].subwharfs[x].frontImage);
			}
			free(wharfs[i].subwharfs);
		}
		if (wharfs[i].hsubwharfWnd)
			DestroyWindow(wharfs[i].hsubwharfWnd);
		if (wharfs[i].subRgn)
			DeleteObject(wharfs[i].subRgn);
		if (wharfs[i].hInst) {
			(*wharfs[i].quitWharfModule)(wharfs[i].hInst);
			FreeLibrary(wharfs[i].hInst);
		}
		DestroyWindow(wharfs[i].hWnd);
		if (wharfs[i].backImage)
			DeleteObject(wharfs[i].backImage);
		if (wharfs[i].frontImage)
			DeleteObject(wharfs[i].frontImage);
	}
	free(wharfs);
	
	if (hMainRgn)
		DeleteObject(hMainRgn);
	DestroyWindow(hMainWnd);
	if (wharfAutoHide) DestroyWindow(HiddenWnd);

	if (defaultBackImage)
		DeleteObject(defaultBackImage);
	if (folderImage)
		DeleteObject(folderImage);
	if (defaultFolderImage)
		DeleteObject(defaultFolderImage);
	if (titlebarImage)
		DeleteObject(titlebarImage);
	
	// Reset the work area since we no longer have a docked wharf, or any wharf at all, hah!
	SystemParametersInfo(SPI_GETWORKAREA, 0, &deskRect, 0);
	deskRect.left = 0;
	deskRect.right = ScreenWidth;
	SystemParametersInfo(SPI_SETWORKAREA, 0, &deskRect, 0);

	UnregisterClass(szMainWindowClass,dllInst); // unregister window class
	if (wharfAutoHide)
		UnregisterClass(szHiddenWindowClass, dllInst);
}

void ReadConfig (void)
{
	char szBuf[256], *tmp;
	char szToken[256];


	setDesktopArea = GetRCBool("SetDesktopArea", TRUE);
	wharfAutoUnpress = GetRCBool("WharfAutoUnpress", TRUE);
	wharfAutoClose = GetRCBool("WharfNoAutoclose", FALSE);
	wharfTitlebar = GetRCBool("WharfNoTitleBar", FALSE);
	wharfNoAnim = GetRCBool("WharfNoAnim", TRUE);
	wharfTitles = GetRCBool("WharfAllTitles", TRUE);
	wharfShadeButton = GetRCInt("WharfShadeButton",32);
	wharfDblClickXPosition = GetRCInt("WharfDblClickXPosition",120);
	wharfDblClickDockOnLeft = GetRCBool("WharfDblClickDockOnLeft", TRUE);
	titleFore = GetRCColor("WharfTitleFore", 0xFFFFFF);
	titleBack = GetRCColor("WharfTitleBack", 0x802020);
	bevelWidth = GetRCInt("WharfBevelWidth", 1);
	if (bevelWidth < 0) bevelWidth = 0;
	wharfStep = GetRCInt("WharfAnimStep", 64);
	wharfAnimTime = GetRCInt("WharfAnimDelay", 10); 
	wharfAutoHide = GetRCBool("AutoHideWharf", TRUE);
	autoHideDelay = GetRCInt("AutoHideDelay", 300);
	autoShowDelay = GetRCInt("AutoShowDelay", autoHideDelay);
	hiddenWidth = GetRCInt("WharfHiddenWidth", 1);
	wharfPressOffset = GetRCInt("WharfPressOffset", 1);
	wharfNoHints = GetRCBool("WharfNoHints", TRUE);
	wharfCloseOnSwitch = GetRCBool("WharfCloseOnSwitch", TRUE);
	GetRCString("WharfOpenSound", wharfOpenSound, "c:\\blah.wav", 256);
	GetRCString("WharfCloseSound", wharfCloseSound, "c:\\blah.wav", 256);
	GetRCString("WharfMinSound", wharfMinSound, "c:\\blah.wav", 256);
	GetRCString("WharfMaxSound", wharfMaxSound, "c:\\blah.wav", 256);


	snapTo = GetRCBool("SnapToWharf", TRUE);
	snapToSensitivity = GetRCInt("SnapToSensitivity", 16);

	GetRCString("PixmapPath", szImagePath, "c:\\litestep\\images\\", 256);
	if (GetRCString("DefaultBackPix", szDefPixmap, "", 256))
	{
//		char szTemp[256];
//		wsprintf(szTemp, "%s%s", szImagePath, szDefPixmap);
//		defaultBackImage = LoadLSImage (szTemp, NULL);
		defaultBackImage = LoadLSImage (szDefPixmap, NULL);
	}

	if (GetRCString("FolderBackPix", szFolderPixmap, "", 256))
	{
//		char szTemp[256];
//		wsprintf(szTemp, "%s%s", szImagePath, szFolderPixmap);
//		defaultFolderImage = LoadLSImage (szTemp, NULL);
		defaultFolderImage = LoadLSImage (szFolderPixmap, NULL);
	}

	if (GetRCString("FolderPix", szToken, "", 256))
	{
//		char szTemp[256];
//		wsprintf(szTemp, "%s%s", szImagePath, szToken);
//		folderImage = LoadLSImage (szTemp, NULL);
		folderImage = LoadLSImage (szToken, NULL);
	}

	if (GetRCString("WharfTitlebarPix", szToken, "", 256))
	{
//		char szTemp[256];
//		wsprintf(szTemp, "%s%s", szImagePath, szToken);
//		titlebarImage = LoadLSImage (szTemp, NULL);
		titlebarImage = LoadLSImage (szToken, NULL);
	}
	
	
	sprintf (szBuf, "%s\\MODULES.INI", szLitestepPath);
//    wharfAnimTime = GetPrivateProfileInt("Wharf", "AnimDelay", wharfAnimTime, szBuf);
	GetPrivateProfileString("Wharf", "Position", "-64,0", (char *)&szBuf, sizeof(szBuf), szBuf);
	tmp = strtok(szBuf, ",");
	wharfBaseX = atoi(tmp);
	tmp = strtok(NULL, "");
	wharfBaseY = atoi(tmp);
	if (wharfBaseX < 0)
		wharfBaseX += ScreenWidth;
	if (wharfBaseY < 0)
		wharfBaseY += ScreenHeight;

	GetRCString("WharfTitleFont", szTitleFont, "Arial", 256);
	iTitleFontSize = GetRCInt("WharfTitleFontSize", 8);
	iTitleFontWeight = GetRCInt("WharfTitleFontWeight", 400);
}

void CloseAllFolders()
{
	__try {
		int i;
		
		for (i = 0; i < numWharfs; i++)
		{
			if (wharfs[i].subwharfOpen || wharfs[i].moving)
			{
				wharfs[i].bPressed = FALSE;
				togglePressOffset(i, FALSE);
				if (wharfNoAnim)
				{
					SetWindowPos(wharfs[i].hsubwharfWnd, 0, 0, 0, 0, 0, SWP_NOZORDER);
					wharfs[i].subwharfOpen = FALSE;
				} else{
					wharfs[i].moving = TRUE;
					wharfs[i].closing = TRUE;
					//wharfs[i].movingPos = wharfs[i].numSubwharfs*64;
					SetTimer(wharfs[i].hsubwharfWnd, 3, wharfAnimTime, NULL);
				}
				OpenFolders--;
			}
		}
	} __except(GetExceptionCode()==EXCEPTION_ACCESS_VIOLATION) {};
}

// BK
BOOL CreateWharf(int i, LPCSTR szWindowName)
{
	HWND hWnd = NULL;
	RECT r;
	int WharfPosition=GetWharfPosition(i);
// -BK

	hWnd = CreateWindowEx(
		WS_EX_TRANSPARENT,
		szMainWindowClass,
		szWindowName,
		WS_CHILD,
		0, 0,
// BK
		64, wharfs[i].wharfHeight,
// -BK
		hMainWnd,
		NULL,
		dll,
		NULL);
	
	if (!hWnd)
	{
		MessageBox(parent, "Error creating wharf tile", "Wharf", MB_OK);
		return FALSE;
	}
	wharfs[i].hWnd = hWnd;
	SetWindowLong(wharfs[i].hWnd, GWL_USERDATA, magicDWord);
//Wharf hints
	if (!wharfNoHints) {
		if (hWnd) {
			RECT r;
			GetClientRect (hWnd, &r);
			CreateWharfhints (hWnd, wharfs[i].szName, &r);
		}
	}
	
	if (wharfDirection == WHARF_DOWN)
	{
	// BK
	//	SetWindowPos(hMainWnd, 0, wharfBaseX, wharfBaseY, 64, ((i+1)*64)+titleSize, SWP_NOZORDER);
	//	SetWindowPos(wharfs[i].hWnd, 0, 0, (64*i)+titleSize, 0, 0, SWP_NOZORDER|SWP_NOSIZE);
		SetWindowPos(hMainWnd, 0, wharfBaseX, wharfBaseY, 64, WharfPosition+wharfs[i].wharfHeight, SWP_NOZORDER);
		SetWindowPos(wharfs[i].hWnd, 0, 0, WharfPosition, 0, 0, SWP_NOZORDER|SWP_NOSIZE);
	// -BK
	} else if (wharfDirection == WHARF_RIGHT)
	{
		SetWindowPos(hMainWnd, 0, wharfBaseX, wharfBaseY, (i+1)*64, 64, SWP_NOZORDER);
		SetWindowPos(wharfs[i].hWnd, 0, 64*i, 0, 0, 0, SWP_NOZORDER|SWP_NOSIZE);
	}
	
	if (wharfs[i].szCommand[0] == '@')
	{
		int (FAR *FinitWharfModule)(HWND, HINSTANCE, wharfDataType*);
		int (FAR *FquitWharfModule)(HINSTANCE);
		HRGN (FAR *FGetLSRegion)(int, int);

		char *module;
		HINSTANCE moduleInst;
		
		module = wharfs[i].szCommand;
		if (*module == '@')
			module++;
		moduleInst = LoadLibrary(module);
		if ((UINT)moduleInst > HINSTANCE_ERROR)
		{
			FinitWharfModule = (int (FAR *)(HWND, HINSTANCE, wharfDataType*))GetProcAddress(moduleInst, "initWharfModule");
			FquitWharfModule = (int (FAR *)(HINSTANCE))GetProcAddress(moduleInst, "quitWharfModule");
			FGetLSRegion = (HRGN (FAR *)(int, int))GetProcAddress(moduleInst, "GetLSRegion");

			if (!FinitWharfModule || !FquitWharfModule)
			{
				MessageBox(NULL, module, "Invalid Wharf module", MB_OK);
				FreeLibrary(moduleInst);
				wharfs[i].hInst = NULL;
			} else {
				wharfs[i].hInst = moduleInst;
				wharfs[i].initWharfModule = FinitWharfModule;
				wharfs[i].quitWharfModule = FquitWharfModule;
				wharfs[i].GetLSRegion = FGetLSRegion;
				ExecuteWharf(i);
			}
		} else {
			wharfs[i].hInst = NULL;
			MessageBox(NULL, module, "Error loading module", MB_OK);
		}
	}
	
	/* Combine our images into one */
	{
		HDC src = CreateCompatibleDC(NULL);
		HDC dst = CreateCompatibleDC(NULL);
		HBRUSH hb = CreateSolidBrush(RGB(255,0,255));
		HDC tempDC = GetDC(wharfs[i].hWnd);
		RECT r;
		
	// BK
		wharfs[i].backImage = CreateCompatibleBitmap(tempDC, 64, wharfs[i].wharfHeight);
		SelectObject(dst, wharfs[i].backImage);
		r.left = 0;
		r.top = 0;
		r.right = 64;
		r.bottom = wharfs[i].wharfHeight;
	// -BK
		FillRect(dst, &r, hb);
		if (wharfTitles && !wharfs[i].hInst)
		{
			HBRUSH hb2 = CreateSolidBrush(RGB(0,0,128));
			r.bottom = 10;
			FillRect(dst, &r, hb2);
			DeleteObject(hb2);
		}


		if (wharfs[i].hInst && !wharfs[i].GetLSRegion)
		{
			HDC ddc = GetDC(GetDesktopWindow());
			POINT p;

			p.x = 0;
			p.y = 0;
			ClientToScreen(wharfs[i].hWnd, &p);
	// BK
			BitBlt(dst, 0, 0, 64, wharfs[i].wharfHeight, ddc, p.x, p.y, SRCCOPY);
	// -BK

			ReleaseDC(GetDesktopWindow(), ddc);

		}
		if (defaultBackImage)
		{
		
			if ( wharfs[i].showbg == TRUE ) {
				SelectObject(src, defaultBackImage);
			// BK
				TransparentBltLS(dst, 0, 0, 64, wharfs[i].wharfHeight, src, 0, 0, RGB(255, 0, 255));
			// -BK
			}
		}
		// BK
		if (wharfs[i].frontImage)
		{
			BITMAP bmInfo;
			
			GetObject(wharfs[i].frontImage, sizeof(bmInfo), &bmInfo);
			if (bmInfo.bmWidth > 64) bmInfo.bmWidth = 64;
			if (bmInfo.bmHeight > wharfs[i].wharfHeight) bmInfo.bmHeight = wharfs[i].wharfHeight;
			SelectObject(src, wharfs[i].frontImage);
			// BK
			TransparentBltLS(dst, 32-(bmInfo.bmWidth/2), wharfs[i].wharfHeight/2-(bmInfo.bmHeight/2), bmInfo.bmWidth, bmInfo.bmHeight, src, 0, 0, RGB(255,0,255));
			// -BK
			DeleteObject(wharfs[i].frontImage);
		}
		if ((folderImage)&& ((!strcmpi(wharfs[i].szCommand, "Folder"))||(!strcmpi(wharfs[i].szCommand, "!WharfTasks"))))
		{
			if ( wharfs[i].showbg == TRUE ) {
				SelectObject(src, folderImage);
				TransparentBltLS(dst, 0, 0, 64, wharfs[i].wharfHeight, src, 0, 0, RGB(255,0,255));
			}
		}
		// -BK
		
		ReleaseDC(wharfs[i].hWnd, tempDC);
		DeleteDC(src);
		DeleteDC(dst);
		DeleteObject(hb);
	}
	
	/* Calculate transparent regions for hMainWnd here, compile regions per bitmap/tile and add together
	* for a full transparent parent window - <toasty@iav.com>  */
	
	if (wharfs[i].backImage && !wharfs[i].hInst)
	{
		HRGN wharfRgn;
		
		// BK
		wharfRgn = BitmapToRegion(wharfs[i].backImage, RGB(255,0,255), 0x101010, 0, WharfPosition);
		// -BK
		
		if (hMainRgn)
		{
			CombineRgn(hMainRgn, hMainRgn, wharfRgn, RGN_OR);
		}
		else
		{
			hMainRgn = CreateRectRgn(0, 0, 64, titleSize);
			CombineRgn(hMainRgn, hMainRgn, wharfRgn, RGN_OR);
		}
		DeleteObject(wharfRgn);
	}
	else
	{
		HRGN rgn;
		if (wharfs[i].GetLSRegion)
		{
		// BK
			HRGN bgRgn = BitmapToRegion(wharfs[i].backImage, RGB(255,0,255), 0x101010, 0, WharfPosition);
			if (rgn = wharfs[i].GetLSRegion(0, WharfPosition))
		// -BK
			{
				CombineRgn(rgn, rgn, bgRgn, RGN_OR);
				DeleteObject(bgRgn);
			}
			else
			{
				rgn = bgRgn;
			}
		}
		else
		{
		// BK
			rgn = CreateRectRgn(0, WharfPosition, 64, WharfPosition+wharfs[i].wharfHeight);
		// BK
		}
		
		if (hMainRgn)
		{
			CombineRgn(hMainRgn, hMainRgn, rgn, RGN_OR);
		}
		else
		{
			hMainRgn = rgn;
			
			rgn = CreateRectRgn(0, 0, 64, titleSize);
			CombineRgn(hMainRgn, hMainRgn, rgn, RGN_OR);
		}
		DeleteObject(rgn);
	}
	
	ShowWindow(wharfs[i].hWnd, SW_SHOWNORMAL);
	GetClientRect(wharfs[i].hWnd, &r);
	InvalidateRect(wharfs[i].hWnd, &r, TRUE);
	
	return TRUE;
}

BOOL CreateSubWharf(int i, int x, LPCSTR szWindowName)
{
	HWND hWnd = NULL;
	
	hWnd = CreateWindowEx(
		0,
		szMainWindowClass,
		szWindowName,
		WS_CHILD,
		0, 0,
		64, 64,
		wharfs[i].hsubwharfWnd,
		NULL,
		dll,
		NULL);
	
	wharfs[i].subwharfs[x].hWnd = hWnd;
	SetWindowLong(wharfs[i].subwharfs[x].hWnd, GWL_USERDATA, magicDWord);
//Wharf hints
	if (!wharfNoHints) {
		if (hWnd) {
			RECT r;
			GetClientRect (hWnd, &r);
			CreateWharfhints (hWnd, wharfs[i].subwharfs[x].szName, &r);
		}
	}

	if (wharfDirection == WHARF_DOWN)
	{
		SetWindowPos(wharfs[i].subwharfs[x].hWnd, 0, x*64, 0, 0, 0, SWP_NOZORDER|SWP_NOSIZE);
	}
	
	if (wharfs[i].subwharfs[x].szCommand[0] == '@')
	{
		int (FAR *FinitWharfModule)(HWND, HINSTANCE, wharfDataType*);
		int (FAR *FquitWharfModule)(HINSTANCE);
		HRGN (FAR *FGetLSRegion)(int, int);

		char *module;
		HINSTANCE moduleInst;
		
		module = wharfs[i].subwharfs[x].szCommand;
		if (*module == '@')
			module++;
		moduleInst = LoadLibrary(module);
		if ((UINT)moduleInst > HINSTANCE_ERROR)
		{
			FinitWharfModule = (int (FAR *)(HWND, HINSTANCE, wharfDataType*))GetProcAddress(moduleInst, "initWharfModule");
			FquitWharfModule = (int (FAR *)(HINSTANCE))GetProcAddress(moduleInst, "quitWharfModule");
			FGetLSRegion = (HRGN (FAR *)(int, int))GetProcAddress(moduleInst, "GetLSRegion");

			if (!FinitWharfModule || !FquitWharfModule)
			{
				MessageBox(NULL, module, "Invalid Wharf module", MB_OK);
				FreeLibrary(moduleInst);
				wharfs[i].subwharfs[x].hInst = NULL;
			} else {
				wharfs[i].subwharfs[x].hInst = moduleInst;
				wharfs[i].subwharfs[x].initWharfModule = FinitWharfModule;
				wharfs[i].subwharfs[x].quitWharfModule = FquitWharfModule;
				wharfs[i].subwharfs[x].GetLSRegion = FGetLSRegion;
				ExecuteSubWharf(i, x);
			}
		} else {
			wharfs[i].subwharfs[x].hInst = NULL;
			MessageBox(NULL, module, "Error loading module", MB_OK);
		}
	}
	
	/* Combine our images into one */
	{
		HDC src = CreateCompatibleDC(NULL);
		HDC dst = CreateCompatibleDC(NULL);
		HDC tempDC = GetDC(wharfs[i].subwharfs[x].hWnd);
		HBRUSH hb = CreateSolidBrush(RGB(255,0,255));
		RECT r;
		
		wharfs[i].subwharfs[x].backImage = CreateCompatibleBitmap(tempDC, 64, 64);
		SelectObject(dst, wharfs[i].subwharfs[x].backImage);
		r.left = 0;
		r.top = 0;
		r.right = 64;
		r.bottom = 64;
		FillRect(dst, &r, hb);
		if (wharfTitles && !wharfs[i].subwharfs[x].hInst)
		{
			HBRUSH hb2 = CreateSolidBrush(RGB(0,0,128));
			r.bottom = 10;
			FillRect(dst, &r, hb2);
			DeleteObject(hb2);
		}
		
		if (defaultFolderImage)
		{
			if ( wharfs[i].subwharfs[x].showbg == TRUE ) {
				SelectObject(src, defaultFolderImage);
				BitBlt(dst, 0, 0, 64, 64, src, 0, 0, SRCCOPY);
			}
		}
		if (wharfs[i].subwharfs[x].frontImage)
		{
			BITMAP bmInfo;
			
			GetObject(wharfs[i].subwharfs[x].frontImage, sizeof(bmInfo), &bmInfo);
			if (bmInfo.bmWidth > 64) bmInfo.bmWidth = 64;
			if (bmInfo.bmHeight > 64) bmInfo.bmHeight = 64;
			SelectObject(src, wharfs[i].subwharfs[x].frontImage);
			TransparentBltLS(dst, 32-(bmInfo.bmWidth/2), 32-(bmInfo.bmHeight/2), bmInfo.bmWidth, bmInfo.bmHeight, src, 0, 0, RGB(255,0,255));
			DeleteObject(wharfs[i].subwharfs[x].frontImage);
		}
		
		ReleaseDC(wharfs[i].subwharfs[x].hWnd, tempDC);
		DeleteDC(src);
		DeleteDC(dst);
		DeleteObject(hb);
	}
	
	if (wharfs[i].subwharfs[x].backImage && !wharfs[i].subwharfs[x].hInst)
	{
		HRGN wharfRgn;
		
		wharfRgn = BitmapToRegion(wharfs[i].subwharfs[x].backImage, RGB(255,0,255), 0x101010, (64*x), 0);
		
		if (CombineRgn(wharfs[i].subRgn, wharfs[i].subRgn, wharfRgn, RGN_OR) == ERROR)
			wharfs[i].subRgn = wharfRgn;
		else
			DeleteObject(wharfRgn);
	}
	else
	{
		HRGN rgn;
		if (wharfs[i].subwharfs[x].GetLSRegion)
		{
			HRGN bgRgn = BitmapToRegion(wharfs[i].subwharfs[x].backImage, RGB(255,0,255), 0x101010, (64*x), 0);
			if (rgn = wharfs[i].subwharfs[x].GetLSRegion(64*x, 0))
			{
				CombineRgn(rgn, rgn, bgRgn, RGN_OR);
				DeleteObject(bgRgn);
			}
			else
			{
				rgn = bgRgn;
			}

		}
		else
		{
			rgn = CreateRectRgn(64*x, 0, 64*(x+1), 64);
		}
		
		if (CombineRgn(wharfs[i].subRgn, wharfs[i].subRgn, rgn, RGN_OR) == ERROR)
			wharfs[i].subRgn = rgn;
		else
			DeleteObject(rgn);
	}
	
	ShowWindow(wharfs[i].subwharfs[x].hWnd, SW_SHOWNORMAL);
	
	return TRUE;
}

int GetWharfByWnd(HWND hwnd)
{
	int i;
	
	for (i=0;i<numWharfs;i++)
		if (wharfs[i].hWnd == hwnd)
			return i;
		return -1;
}

void GetWharfData(wharfDataType *wd)
{
		
	strcpy(lsPath, szLitestepPath);
	if (lsPath[strlen(lsPath)] != '\\')
		strcat(lsPath, "\\");

	wd->trayIconSize = GetRCInt("TrayIconSize", 16);
	wd->taskBarFore = GetRCColor("LSTaskBarFore", 0x000000);
	wd->taskBarBack = GetRCColor("LSTaskBarBack", 0x7f7f7f);
	wd->taskBarText = GetRCColor("LSTaskBarText", 0xffffff);
	wd->taskBarFore2 = GetRCColor("LSTaskBarFore2", 0x3f3f3f3f);
	wd->taskBar = GetRCBool("NoTaskBar", FALSE);
	wd->showBeta = GetRCBool("NoShowBeta", TRUE);;
	wd->usClock = GetRCBool("UsClock", TRUE);
	wd->vwmVelocity = GetRCInt("VWMVelocity", 300);
	wd->VWMDistance = GetRCInt("VWMSecurityDistance", 5);
	wd->VWMNoAuto = GetRCBool("VWMNoAuto", TRUE);
	wd->pixmapDir = szImagePath;
	wd->defaultBmp = szDefPixmap;
	wd->vwmBackColor = GetRCColor("VWMBackColor", 0x000000);
	wd->vwmSelBackColor = GetRCColor("VWMSelBackColor", 0x3f3f3f);
	wd->vwmForeColor = GetRCColor("VWMForeColor", 0x906090);
	wd->vwmBorderColor = GetRCColor("VWMBorderColor", 0xffffff);
	wd->lsPath = lsPath;
	wd->borderSize = bevelWidth;
}

void SoundOpen(void)
{
	sndPlaySound(wharfOpenSound, SND_ASYNC|SND_NODEFAULT);
}

void SoundClose(void)
{	
	sndPlaySound(wharfCloseSound, SND_ASYNC|SND_NODEFAULT);
}

void SoundMin(void)
{
	sndPlaySound(wharfMinSound, SND_ASYNC|SND_NODEFAULT);
}

void SoundMax(void)
{	
	sndPlaySound(wharfMaxSound, SND_ASYNC|SND_NODEFAULT);
}


void ExecuteWharf(int i)
{
// BK
	int WharfPosition=GetWharfPosition(i);
// -BK
	int q;
	if (!strcmpi(wharfs[i].szCommand, "Folder"))
	{
		if (wharfClosing) {
			CloseAllFolders();
			return;
		}
		// Below closes all folders if WharfAutoClose is actiavted...

		if (wharfAutoClose) {
			for (q = 0; q < numWharfs; q++)
			{
				if ((wharfs[q].subwharfOpen || wharfs[q].moving) && q != i)
				{
					wharfs[q].bPressed = FALSE;
					togglePressOffset(q, FALSE);
					if (wharfNoAnim)
					{
						SetWindowPos(wharfs[q].hsubwharfWnd, 0, 0, 0, 0, 0, SWP_NOZORDER);
					} else {
						wharfs[q].moving = TRUE;
						wharfs[q].closing = TRUE;
						//wharfs[q].movingPos = wharfs[q].numSubwharfs*64;
						SetTimer(wharfs[q].hsubwharfWnd, 3, wharfAnimTime, NULL);
					}
					wharfs[q].subwharfOpen = FALSE;
					OpenFolders--;
				}
			}
		}

		if (wharfs[i].moving) {
			if (wharfs[i].closing) {
				wharfs[i].closing = FALSE;
				if (wharfOpenSound) SoundOpen();
			}
			else {
				wharfs[i].closing = TRUE;
				if (wharfCloseSound) SoundClose();
			}
		} else if (wharfs[i].subwharfOpen == FALSE) {
			if (wharfOpenSound) SoundOpen();
			wharfs[i].subwharfOpen = TRUE;
			if (wharfNoAnim)
			{
				// BK
				if ((wharfBaseX+32) > ScreenWidth/2)
					SetWindowPos(wharfs[i].hsubwharfWnd, 0, wharfBaseX-(wharfs[i].numSubwharfs*64), wharfBaseY+WharfPosition, wharfs[i].numSubwharfs*64, 64, SWP_NOZORDER);
				else
					SetWindowPos(wharfs[i].hsubwharfWnd, 0, wharfBaseX+64, wharfBaseY+WharfPosition, wharfs[i].numSubwharfs*64, 64, SWP_NOZORDER);
				// -BK
			} else {
				wharfs[i].moving = TRUE;
				wharfs[i].closing = FALSE;
				SetTimer(wharfs[i].hsubwharfWnd, 2, wharfAnimTime, NULL);
				OpenFolders++;
			}
		} else if (wharfs[i].subwharfOpen) {
			if (wharfCloseSound) SoundClose();
			if (wharfNoAnim)
			{
				wharfs[i].subwharfOpen = FALSE;
				wharfs[i].bPressed = FALSE;
				togglePressOffset(i, FALSE);
				SetWindowPos(wharfs[i].hsubwharfWnd, 0, 0, 0, 0, 0, SWP_NOZORDER);
			} else {
				wharfs[i].moving = TRUE;
				wharfs[i].closing = TRUE;
				SetTimer(wharfs[i].hsubwharfWnd, 3, wharfAnimTime, NULL);
				OpenFolders--;
			}
		}
		return;
	}

	if (wharfs[i].szCommand[0] == '@')
	{
		wharfDataType wharfData;
		memset (&wharfData, 0, sizeof (wharfData));
		GetWharfData(&wharfData);
		
		(*wharfs[i].initWharfModule)(wharfs[i].hWnd, wharfs[i].hInst, &wharfData);
		return;
	}
	
	if (wharfs[i].szCommand[0] == '!')
	{
		if (!strcmpi(wharfs[i].szCommand, "!WharfTasks"))
		{
			ExecuteWharfTasks(i);
		} else
			ParseBangCommand(wharfs[i].hWnd, wharfs[i].szCommand, wharfs[i].szParameters);
		return;
	}
	
	{
		SHELLEXECUTEINFO si;

		if (!wharfAutoUnpress) {
			wharfs[i].bPressed = FALSE;
			togglePressOffset(i, FALSE);
		}
		
		memset(&si, 0, sizeof(si));
		si.cbSize = sizeof(SHELLEXECUTEINFO);
		si.lpDirectory = NULL;
		si.lpVerb = NULL;
		si.nShow = 1;
		si.fMask = SEE_MASK_DOENVSUBST;
		si.lpFile = wharfs[i].szCommand;
		si.lpParameters = wharfs[i].szParameters;
		ShellExecuteEx(&si);
		return;
	}
}


void ExecuteSubWharf(int i, int x)
{
	if (wharfs[i].subwharfs[x].szCommand[0] == '@')
	{
		wharfDataType wharfData;
		char lsPath[256];
		
		strcpy(lsPath, szLitestepPath);
		if (lsPath[strlen(lsPath)] != '\\')
			strcat(lsPath, "\\");
		memset (&wharfData, 0, sizeof (wharfData));
		GetWharfData(&wharfData);
		
		(*wharfs[i].subwharfs[x].initWharfModule)(wharfs[i].subwharfs[x].hWnd, wharfs[i].subwharfs[x].hInst, &wharfData);
		return;
	}
	
	if (wharfs[i].subwharfs[x].szCommand[0] == '!')
	{
		if (!strcmpi(wharfs[i].szCommand, "!WharfTasks"))
		{
			if (!SendMessage(parent, LM_BRINGTOFRONT, 0, (long)wharfs[i].subwharfs[x].taskWnd))
				SwitchToThisWindow(wharfs[i].subwharfs[x].taskWnd, 1);
		} else
		{
			ParseBangCommand(wharfs[i].hsubwharfWnd, wharfs[i].subwharfs[x].szCommand, wharfs[i].subwharfs[x].szParameters);
//			MessageBox(0, "So far so good", "Wharf", MB_OK);
		}
		return;
	}
	
	{
		SHELLEXECUTEINFO si;
		
		memset(&si, 0, sizeof(si));
		si.cbSize = sizeof(SHELLEXECUTEINFO);
		si.lpDirectory = NULL;
		si.lpVerb = NULL;
		si.nShow = 1;
		si.fMask = SEE_MASK_DOENVSUBST;
		si.lpFile = wharfs[i].subwharfs[x].szCommand;
		si.lpParameters = wharfs[i].subwharfs[x].szParameters;
		ShellExecuteEx(&si);
		return;
	}
}

void ExecuteWharfTasks(int i)
{
// BK
	int WharfPosition=GetWharfPosition(i);
// BK
	windowType *winList;
	char capt[256];
	int n, q, x, maxWin;

	if (wharfClosing) {
		CloseAllFolders();
		return;
	}


	if (wharfAutoClose) {
		for (q = 0; q < numWharfs; q++)
		{
			if ((wharfs[q].subwharfOpen || wharfs[q].moving) && q != i)
			{
				wharfs[q].bPressed = FALSE;
				togglePressOffset(q, FALSE);
				if (wharfNoAnim)
				{
					SetWindowPos(wharfs[q].hsubwharfWnd, 0, 0, 0, 0, 0, SWP_NOZORDER);
				} else {
					wharfs[q].moving = TRUE;
					wharfs[q].closing = TRUE;
					//wharfs[q].movingPos = wharfs[q].numSubwharfs*64;
					SetTimer(wharfs[q].hsubwharfWnd, 3, wharfAnimTime, NULL);
				}
				wharfs[q].subwharfOpen = FALSE;
				OpenFolders--;
			}
		}
	}

	if (wharfs[i].moving) {
		if (wharfs[i].closing) {
			wharfs[i].closing = FALSE;
			if (wharfOpenSound) SoundOpen();
		}
		else {
			wharfs[i].closing = TRUE;
			if (wharfCloseSound) SoundClose();
		}
	} else if (wharfs[i].subwharfOpen) {
		if (wharfCloseSound) SoundClose();
		if (wharfNoAnim)
		{
			wharfs[i].subwharfOpen = FALSE;
			wharfs[i].bPressed = FALSE;
			togglePressOffset(i, FALSE);
			SetWindowPos(wharfs[i].hsubwharfWnd, 0, 0, 0, 0, 0, SWP_NOZORDER);
		} else {
			wharfs[i].moving = TRUE;
			wharfs[i].closing = TRUE;
			SetTimer(wharfs[i].hsubwharfWnd, 3, wharfAnimTime, NULL);
			OpenFolders--;
		}
	} else {
		if (wharfs[i].subwharfs)
		{
			for (x = 0; x < wharfs[i].numSubwharfs; x++)
			{
				DeleteObject(wharfs[i].subwharfs[x].backImage);
				DeleteObject(wharfs[i].subwharfs[x].frontImage);
				DestroyWindow(wharfs[i].subwharfs[x].hWnd);
			}
			DestroyWindow(wharfs[i].hsubwharfWnd);
			free(wharfs[i].subwharfs);
		}

		wharfs[i].subwharfs = NULL;
		wharfs[i].numSubwharfs = 0;
		wharfs[i].subwharfOpen = FALSE;
		wharfs[i].hsubwharfWnd = CreateWindowEx(
			WS_EX_TOPMOST | WS_EX_TOOLWINDOW,
			szMainWindowClass,
			"",
			WS_CLIPCHILDREN | WS_POPUP,
			0, 0,
			0, 0,
			parent,
			NULL,
			dll,
			NULL
			);
							
		SetWindowLong(wharfs[i].hsubwharfWnd, GWL_USERDATA, magicDWord);
		ShowWindow(wharfs[i].hsubwharfWnd, SW_SHOWNORMAL);

		winList = (windowType *)SendMessage(parent, 9400, 0, 0);
		maxWin = (int) SendMessage(parent, LM_WINLIST, 1, 0);
		for (n = 0; n < maxWin && winList[n].Handle; n++)
		{
			HICON hIcon = NULL;
			HWND parent;
inside:
			if (GetWindowLong(winList[n].Handle, GWL_USERDATA) == magicDWord) goto inside;
			if (GetWindowLong(winList[n].Handle, GWL_EXSTYLE) & WS_EX_TOOLWINDOW) goto inside;
			parent = GetParent(winList[n].Handle);
			if (GetWindowLong(parent, GWL_USERDATA) == magicDWord) goto inside;

			x = wharfs[i].numSubwharfs;
			if (!wharfs[i].subwharfs)
			{				
				wharfs[i].subwharfs = (subwharfType *)malloc(sizeof(subwharfType));
			} else {
				wharfs[i].subwharfs = (subwharfType *)realloc(wharfs[i].subwharfs, (x+1)*sizeof(subwharfType));
			}
			memset(&wharfs[i].subwharfs[x], 0, sizeof(wharfs[i].subwharfs[x]));

			SendMessageTimeout(winList[n].Handle, WM_GETICON, 1, 0, 0, 250, (unsigned long *)&hIcon);
			if (!hIcon) SendMessageTimeout(winList[n].Handle, WM_QUERYDRAGICON, 0, 0, 0, 1000, (unsigned long *)&hIcon);
			if (!hIcon) hIcon = (void *)GetClassLong(winList[n].Handle, GCL_HICON);
			if (!hIcon) hIcon = (void *)GetClassLong(winList[n].Handle, GCL_HICONSM);
			if (hIcon) /* not working for some reason */
			{
				HDC dst = CreateCompatibleDC(NULL);
				HDC tempDC = GetDC(wharfs[i].hsubwharfWnd);
				HBRUSH hb = CreateSolidBrush(RGB(255,0,255));
				HBRUSH hb2 = CreateSolidBrush(RGB(0, 0, 128));
				RECT r;
				int nHeight;
		
				wharfs[i].subwharfs[x].frontImage = CreateCompatibleBitmap(tempDC, 64, 64);
				SelectObject(dst, wharfs[i].subwharfs[x].frontImage);
				r.left = 0;
				r.top = 0;
				r.right = 64;
				r.bottom = 64;
				FillRect(dst, &r, hb);
//				r.bottom = 10;
				nHeight = MulDiv(iTitleFontSize, GetDeviceCaps(dst, LOGPIXELSY), 72);
				r.bottom = nHeight +2;
				r.right = 64;
				FillRect(dst, &r, hb2);


				DrawIconEx(dst, 16, 16, hIcon, 32, 32, 0, NULL, DI_NORMAL);
				
				ReleaseDC(wharfs[i].hsubwharfWnd, tempDC);
				DeleteDC(dst);
				DeleteObject(hb);
				DeleteObject(hb2);
				DeleteObject(hIcon);
			}

			capt[0] = 0;
			if (winList[n].Handle != NULL)
			{
				GetWindowText(winList[n].Handle, (char *)&capt, sizeof(capt));
				strcpy(wharfs[i].subwharfs[x].szName, capt);
			}
			strcpy(wharfs[i].subwharfs[x].szCommand, "!none");
			wharfs[i].subwharfs[x].taskWnd = winList[n].Handle;
			CreateSubWharf(i, wharfs[i].numSubwharfs, "");
			wharfs[i].numSubwharfs++;
		}
        
		SetWindowRgn(wharfs[i].hsubwharfWnd, wharfs[i].subRgn, TRUE);

		if (wharfOpenSound) SoundOpen();
		wharfs[i].subwharfOpen = TRUE;

		if (wharfNoAnim)
		{
			// BK
			if ((wharfBaseX+32) > ScreenWidth/2)
				SetWindowPos(wharfs[i].hsubwharfWnd, 0, wharfBaseX-(wharfs[i].numSubwharfs*64), wharfBaseY+WharfPosition, wharfs[i].numSubwharfs*64, 64, SWP_NOZORDER);
			else
				SetWindowPos(wharfs[i].hsubwharfWnd, 0, wharfBaseX+64, wharfBaseY+WharfPosition, wharfs[i].numSubwharfs*64, 64, SWP_NOZORDER);
			// -BK
			wharfs[i].subwharfOpen = TRUE;
			return;
		} else {
			wharfs[i].moving = TRUE;
			wharfs[i].closing = FALSE;
			SetTimer(wharfs[i].hsubwharfWnd, 2, wharfAnimTime, NULL);
			OpenFolders++;
		}
	}

}

void CreateWharfhints(HWND hWnd, char *txt, RECT *r) {
	TOOLINFO ti;    // tool information

	if (wharfNoHints)
	{
		return;
	}

	ti.cbSize = sizeof(TOOLINFO);
	ti.uFlags = TTF_SUBCLASS;
	ti.hwnd = hWnd;
	ti.hinst = dll;
	ti.uId = 0;
	ti.lpszText = txt;
	ti.rect = *r;

	SendMessage(wharfHints, TTM_ADDTOOL, 0, (LPARAM) (LPTOOLINFO) &ti);
}

void RemoveWharfhints(HWND hWnd) {
	TOOLINFO ti;    // tool information
	RECT r={0,0,0,0};

	ti.cbSize = sizeof(TOOLINFO);
	ti.uFlags = 0;
	ti.hwnd = hWnd;
	ti.hinst = dll;
	ti.uId = 0;
	ti.lpszText = NULL;
	ti.rect = r;

	SendMessage(wharfHints, TTM_DELTOOL, 0, (LPARAM) (LPTOOLINFO) &ti);
}

// BK
int GetWharfPosition(int nWharf)
{
	int i,wharfPosition=titleSize;
	for (i=0;i<nWharf;i++)
		wharfPosition+=wharfs[i].wharfHeight;

	return wharfPosition;
}
// -BK
/*
	$Log: wharf.c,v $
	Revision 1.93  1998/11/27 09:00:52  bryan
	Pseudo Transparency for the wharf. eliminates those awful pink module backgrounds
	
	Revision 1.92  1998/11/17 19:27:39  bryan
	Some more mods and fixes.
	
	Revision 1.91  1998/11/17 15:13:28  cyberian
	*** empty log message ***
	
 */
