
REM Top Secret/S.I. Character Generator v1.1
REM Public Domain 1993 Jim Vassilakos (jimvassila@aol.com)
REM Last Updated, June 2000

DIM sk$(300)
DIM index(31)
DIM sname$(31)
DIM scost(31)
DIM slvl(31)
DIM e$(25)
RANDOMIZE INT(TIMER / 2)
DEF fnrup (x, y) = -INT(-((x + y) / 2))
DEF fnhlf (x) = -INT(-(x / 2))
DEF fnqtr (x) = -INT(-(x / 4))

FOR a = 1 TO 7
READ stn$(a)
NEXT a
FOR a = 1 TO 7
READ skill$(a)
NEXT a
DATA "STR","REF","INT","WIL","CON","MOV","DEX"
DATA "Mechanical","Combat","Specialty"
DATA "Education","General","Language"
DATA "Spare"
p = 1
opt$ = "N"
choose$ = "N"

OPEN "i", 1, "skills.dat"
a = 1
5 INPUT #1, sk$(a)
IF EOF(1) THEN 7
a = a + 1
GOTO 5
7 CLOSE #1
nsk = a

OPEN "i", 1, "careers.dat"
b = 0
DO UNTIL EOF(1)
b = b + 1
 INPUT #1, career$(b)
 FOR c = 1 TO 7
  INPUT #1, t$
  t$ = RTRIM$(t$)
  i = INSTR(t$, ":")
  l = LEN(t$)
  sklcat(b, c) = VAL(RIGHT$(t$, l - i))
 NEXT c
LOOP
CLOSE 1
ncar = b

CLS
FOR note = 1 TO 60
SOUND 50 * note, .1
SOUND 3100 - (50 * note), .1
NEXT note

8 t = 0
FOR a = 1 TO 5
GOSUB 100
sto(a) = r
st(a) = r
t = t + r
NEXT a

10 REM show stats
COLOR 14, 0
CLS
PRINT , "Top Secret/S.I. Character Generator v1.1"
PRINT , "By Jim Vassilakos"
PRINT , "Public Domain, January 1993 (Last Updated, June 2000)"
PRINT
COLOR 10, 0
PRINT , "Basic Statistics"
PRINT
PRINT , , "Current", "Original"
PRINT , "Attribute", "Rating", "Rating"
PRINT , STRING$(36, 196)
FOR a = 1 TO 5
PRINT , stn$(a), st(a), sto(a)
NEXT a
PRINT , , STRING$(5, 196)

13 LOCATE 16, 1
PRINT , , t; "Points Used   "
IF choose$ = "N" THEN GOTO 14
PRINT , , SPACE$(20)
GOTO 15
14 PRINT , ,
IF (275 - t) < 0 THEN PRINT 0;  ELSE PRINT 275 - t;
PRINT "Points Left   "

15 LOCATE 20, 1
COLOR 14, 0
PRINT , CHR$(27); CHR$(26); " = -/+ Points";
PRINT SPACE$(4);
PRINT CHR$(18); " = Move";
PRINT SPACE$(4);
PRINT "(C)hoose = "; choose$
PRINT , "(H)elp";
PRINT "    (R)oll again";
PRINT "    (Esc) = Exit"
PRINT , "(Enter) = Accept Current Ratings"

16 LOCATE 9 + p, 1
COLOR 12, 0
PRINT "         "; CHR$(196); CHR$(26)
COLOR 10, 0

20 GOSUB 60
IF k2 = 0 AND (k1 = 72 OR k1 = 104) THEN GOTO 40
IF k2 = 0 AND k1 = 27 THEN GOTO 1000
IF k2 = 0 AND (k1 = 67 OR k1 = 99) THEN GOTO 70
IF k2 = 0 AND k1 = 13 AND (t >= 275 OR choose$ = "Y") THEN GOTO 30
IF k2 = 0 AND k1 = 13 THEN GOTO 45
IF k2 = 0 AND (k1 = 114 OR k1 = 82) THEN GOTO 8
IF k2 = 1 AND (k1 = 72 OR k1 = 80) THEN GOTO 21
IF k2 = 1 AND (k1 = 75 OR k1 = 77) THEN GOTO 22
GOTO 20

21 REM up & down
LOCATE 9 + p, 1
PRINT "           "
IF k1 = 72 THEN p = p - 1
IF k1 = 80 THEN p = p + 1
IF p > 5 THEN p = 5
IF p < 1 THEN p = 1
GOTO 16

22 REM left & right
LOCATE 9 + p, 1
IF k1 = 77 GOTO 23
REM left
IF st(p) = sto(p) AND choose$ = "N" THEN GOTO 16
IF st(p) = 0 THEN GOTO 16
st(p) = st(p) - 1
t = t - 1
GOTO 24
23 REM right
IF choose$ = "N" AND (st(p) >= 70 OR t >= 275) THEN GOTO 16
st(p) = st(p) + 1
t = t + 1
24 REM re-merge
PRINT , stn$(p), st(p), sto(p)
GOTO 13

30 REM attribute chart
GOSUB 50
CLS
COLOR 11, 0
LOCATE 6, 1
PRINT , "Attribute Chart"
PRINT
COLOR 10, 0
PRINT , "Attribute", "Rating", CHR$(171), CHR$(172)
COLOR 11, 0
PRINT , STRING$(45, 196)
COLOR 10, 0
FOR a = 1 TO 7
PRINT , stn$(a), st(a), fnhlf(st(a)), fnqtr(st(a))
IF a MOD 5 <> 0 THEN GOTO 35
COLOR 11, 0
PRINT , STRING$(45, 196)
COLOR 10, 0
35 NEXT a
PRINT
PRINT
COLOR 14, 0
PRINT , "Hit any key to continue"
GOSUB 60
GOTO 200

40 REM help
CLS
COLOR 14, 0
PRINT "This program helps you generate stats and skills for Top"
PRINT "Secret/S.I. characters. In the stat section, which you"
PRINT "are in now, the computer starts off by rolling your five"
PRINT "basic stats, each with a range of 20 to 79. If the scores"
PRINT "total 275 or above, you're done. Just hit 'Enter' to"
PRINT "accept the rolls, 'r' to re-roll them, or 'Esc' to exit"
PRINT "the program. If your total is less than 275, then you can"
PRINT "add points to your stats until you reach the 275 point"
PRINT "total. There are two rules you may want to know."
PRINT
PRINT "1. You can't reduce a stat below the original roll."
PRINT "2. You can't raise a stat above 70."
PRINT
PRINT "If you would prefer to just choose your stats without"
PRINT "paying attention to any restrictions, you can do so by"
PRINT "hitting 'C' for 'Choose' at the stat-screen."
PRINT
PRINT
PRINT "Hit any key to continue"
GOSUB 60
COLOR 15, 0
GOTO 10

45 REM undistributed stat-points warning
CLS
LOCATE 10, 1
COLOR 11, 0
PRINT , "You still have"; 275 - t; "points that you can distribute."
PRINT , "Do you really want to accept the character without"
PRINT , "first distributing these points?  (Y/N)"
46 GOSUB 60
IF k1 = 89 OR k1 = 121 THEN GOTO 30
IF k1 = 78 OR k1 = 110 THEN GOTO 10
GOTO 46

50 REM recalc 2ndary stats
st(6) = fnrup(st(1), st(2))
st(7) = fnrup(st(2), st(3))
RETURN

60 REM read keyboard
k1 = 0: k2 = 0
62 k$ = INKEY$
IF k$ = "" THEN GOTO 62
SOUND 10000, .1
k1 = ASC(k$)
IF k1 <> 13 THEN GOTO 63
FOR note = 1 TO 10
SOUND note * 200, .1
NEXT note
63 IF k1 <> 0 THEN GOTO 64
k1 = ASC(RIGHT$(k$, 1))
k2 = 1
64 RETURN

70 REM Choose stats?
CLS
COLOR 14, 0
PRINT "As you know from the help section, there are two"
PRINT "restrictions on stat shuffling."
PRINT
PRINT "1. You can't reduce a stat below the original roll."
PRINT "2. You can't raise a stat above 70."
PRINT
PRINT "By now you should also realize that there is a third,"
PRINT "implicit restriction. You only have a certain number of"
PRINT "points that you can play with (275 less the total of your"
PRINT "five primary stats). For characters who total 275 or"
PRINT "greater on their initial rolls, there are no left over"
PRINT "points to play with."
PRINT
PRINT "Do you want to ignore these restrictions and just choose"
PRINT "your stats as you see fit without any inference from the"
PRINT "rules?  (Y/N)"
72 GOSUB 60
IF k2 = 0 AND (k1 = 89 OR k1 = 121) THEN choose$ = "Y"
IF k2 = 0 AND (k1 = 78 OR k1 = 110) THEN choose$ = "N"
IF choose$ = "Y" THEN GOTO 10
IF choose$ = "N" THEN GOTO 75
GOTO 72
75 REM Check character against restrictions
okay = 1
otot = 0
FOR a = 1 TO 5
IF st(a) < sto(a) THEN okay = 0
IF (st(a) > 70 AND st(a) > sto(a)) THEN okay = 0
otot = otot + st(a)
NEXT a
IF (tot > otot AND tot > 275) THEN okay = 0
IF okay = 1 THEN GOTO 10
REM Return character to initial rolls
t = 0
FOR a = 1 TO 5
st(a) = sto(a)
t = t + st(a)
NEXT a
GOTO 10

100 REM d60+19 routine
r = INT(60 * RND) + 20
RETURN

200 REM
CLS
COLOR 11, 0
PRINT , "Character Career"
PRINT
FOR a = 1 TO ncar
PRINT , ;
PRINT USING "#. "; a;
PRINT career$(a)
NEXT a
PRINT
COLOR 14, 0
PRINT , "Choose a Career: ";
COLOR 11, 0
210 c$ = INPUT$(1)
IF ASC(c$) < 49 OR ASC(c$) > 48 + ncar GOTO 210
SOUND 10000, .1
PRINT c$
c = VAL(c$)
IF career$(c) = "Other" GOTO 250
CLS
PRINT , "Skill Points for "; career$(c)
PRINT
FOR a = 1 TO 7
PRINT , skill$(a), sklcat(c, a)
NEXT a
PRINT
PRINT
COLOR 14, 0
PRINT , "Hit any key to continue"
GOSUB 60
GOTO 295

250 REM The "Other" Career
CLS
COLOR 11, 0
PRINT "The Player's Guide puts two constraints on the development"
PRINT "of this very unusual career type."
PRINT
PRINT "1. Your character gets 30 skill points maximum."
PRINT "2. You can't put more than 8 into any one category."
PRINT
COLOR 14, 0
PRINT "Do you want to play by these constraints?  (Y/N)  ";
COLOR 11, 0
othcon$ = ""
260 GOSUB 60
IF k2 = 0 AND (k1 = 89 OR k1 = 121) THEN othcon$ = "Y"
IF k2 = 0 AND (k1 = 78 OR k1 = 110) THEN othcon$ = "N"
IF othcon$ = "Y" THEN PRINT "Yes."
IF othcon$ = "N" THEN PRINT "No."
IF othcon$ = "Y" OR othcon$ = "N" THEN GOTO 270
GOTO 260
270 p = 1: t = 0
PRINT : PRINT
PRINT , "Skill Points for "; career$(c)
LOCATE 22, 1
COLOR 14, 0
PRINT SPACE$(10);
PRINT CHR$(27); CHR$(26); " = -/+ Points";
PRINT SPACE$(6); CHR$(18); " = Move"
PRINT SPACE$(10); "(Enter) = Accept Skill Points"
PRINT SPACE$(11); "(Esc)  = Exit Program";
271 LOCATE 12, 1
COLOR 11, 0
FOR a = 1 TO 7
PRINT , skill$(a), sklcat(c, a)
NEXT a
PRINT , "Total", t
275 LOCATE 11 + p, 1
COLOR 12, 0
PRINT "         "; CHR$(196); CHR$(26)
280 GOSUB 60
IF k2 = 0 AND k1 = 27 THEN GOTO 1000
IF k2 = 0 AND k1 = 13 THEN GOTO 295
IF k2 = 1 AND (k1 = 72 OR k1 = 80) THEN GOTO 282
IF k2 = 1 AND (k1 = 75 OR k1 = 77) THEN GOTO 285
GOTO 280
282 REM up & down
LOCATE 11 + p, 1
PRINT "           "
IF k1 = 72 THEN p = p - 1
IF k1 = 80 THEN p = p + 1
IF p > 7 THEN p = 7
IF p < 1 THEN p = 1
GOTO 275
285 REM left & right
LOCATE 11 + p, 1
IF k1 = 77 GOTO 290
REM left
IF sklcat(c, p) = 0 THEN GOTO 275
sklcat(c, p) = sklcat(c, p) - 1
t = t - 1
GOTO 271
290 REM right
IF othcon$ = "Y" AND (sklcat(c, p) >= 8 OR t >= 30) THEN GOTO 280
sklcat(c, p) = sklcat(c, p) + 1
t = t + 1
GOTO 271

295 FOR a = 1 TO 7
osklcat(a) = sklcat(c, a)
NEXT a

300 REM choose skills
COLOR 14, 0
CLS
301 LOCATE 1, 1
COLOR 14, 0
PRINT "#    Skill";
PRINT TAB(31); "Lvl";
PRINT TAB(35); "Pts";
COLOR 11, 0
PRINT TAB(39); CHR$(179);
COLOR 14, 0
PRINT TAB(41); "#    Skill";
PRINT TAB(71); "Lvl";
PRINT TAB(75); "Pts"
COLOR 11, 0
PRINT STRING$(77, 196)
LOCATE 2, 39
PRINT CHR$(197)
FOR a = 3 TO 17
LOCATE a, 39
PRINT CHR$(179)
NEXT a
LOCATE 18, 1
PRINT STRING$(77, 196)
LOCATE 18, 39
PRINT CHR$(193)

IF num = 0 GOTO 320
FOR cp = 1 TO num
GOSUB 410
GOSUB 485
IF unmet = 0 THEN COLOR 12, 0
IF unmet = 1 THEN COLOR 28, 0
GOSUB 335
NEXT cp

320 LOCATE 19, 1
COLOR 14, 0
PRINT "("; CHR$(27); CHR$(26); ") = -/+ Levels";
PRINT TAB(21); "("; CHR$(18); ") = Move";
PRINT TAB(41); "(V)iew Skill List";
PRINT TAB(61); "(H)elp"
PRINT "(C)ombat ="; sklcat(c, 2);
PRINT TAB(21); "(E)ducation ="; sklcat(c, 4);
PRINT TAB(41); "(G)eneral ="; sklcat(c, 5);
PRINT TAB(61); "Spare ="; sklcat(c, 7)
PRINT "(L)anguage ="; sklcat(c, 6);
PRINT TAB(21); "(M)echanical ="; sklcat(c, 1);
PRINT TAB(41); "(S)pecialty ="; sklcat(c, 3);
skltot = 0
FOR a = 1 TO 7
skltot = skltot + sklcat(c, a)
NEXT a
PRINT TAB(61); "Total ="; skltot
PRINT "(O)ptional Rule = "; opt$;
PRINT TAB(23); "(Enter) = Accept Character";
PRINT TAB(52); "(Esc) = Exit Program"
IF combak = 1 THEN RETURN

IF specify <> 0 THEN GOTO 600

cp = num + 1
GOSUB 410
IF num = 30 THEN GOTO 347
COLOR 0, 12
325 PRINT STRING$(37, 32);
COLOR 15, 0


330 GOSUB 60
IF k2 = 0 AND k1 = 27 GOTO 1000
IF k2 = 0 AND k1 = 13 THEN GOTO 400
IF k2 = 0 AND (k1 = 86 OR k1 = 118) THEN GOTO 420
IF k2 = 0 AND (k1 = 72 OR k1 = 104) THEN GOTO 440
IF k2 = 0 AND (k1 = 79 OR k1 = 111) THEN GOTO 450
IF k2 = 0 AND (k1 = 67 OR k1 = 99) THEN GOTO 500
IF k2 = 0 AND (k1 = 69 OR k1 = 101) THEN GOTO 500
IF k2 = 0 AND (k1 = 71 OR k1 = 103) THEN GOTO 500
IF k2 = 0 AND (k1 = 77 OR k1 = 109) THEN GOTO 500
IF k2 = 0 AND (k1 = 83 OR k1 = 115) THEN GOTO 500
IF k2 = 0 AND (k1 = 76 OR k1 = 108) THEN GOTO 650
IF k2 = 1 AND (k1 = 72 OR k1 = 80) THEN GOTO 340
IF k2 = 1 AND (k1 = 75 OR k1 = 77) THEN GOTO 350
GOTO 330

335 REM print skill info
PRINT LEFT$(sk$(index(cp)), 5);
PRINT sname$(cp);
PRINT " ";
PRINT slvl(cp);
IF scost(cp) < 10 THEN PRINT " ";
PRINT scost(cp);
RETURN

340 REM up&down
GOSUB 460
GOSUB 410
IF cp > num THEN GOTO 342
GOSUB 485
IF unmet = 0 THEN COLOR 12, 0
IF unmet = 1 THEN COLOR 28, 0
GOSUB 335
GOTO 345
342 COLOR 12, 0
PRINT STRING$(37, 32)
345 IF k1 = 72 THEN cp = cp - 1
IF k1 = 80 THEN cp = cp + 1
IF cp > num + 1 THEN cp = num + 1
IF cp > 30 THEN cp = 30
IF cp < 1 THEN cp = 1
GOSUB 410
COLOR 0, 12
IF cp > num THEN GOTO 325
347 GOSUB 485
IF unmet = 0 THEN COLOR 0, 12
IF unmet = 1 THEN COLOR 16, 12
GOSUB 335
GOTO 330

350 REM left&right
GOSUB 460
IF cp > num THEN GOTO 330
IF k1 = 77 GOTO 370
lang = 0
IF LEFT$(sk$(index(cp)), 1) = "L" THEN lang = 1
IF lang = 1 AND scost(cp) > 1 THEN GOTO 351
IF slvl(cp) = 0 THEN GOTO 360
351 REM Subtract Skill Point
s = index(cp)
l = slvl(cp)
GOSUB 470
IF lang = 0 GOTO 352
IF slvl(cp) = 0 THEN cost = 1
IF slvl(cp) > 0 THEN GOTO 352
GOTO 353
352 slvl(cp) = slvl(cp) - 1
353 scost(cp) = scost(cp) - cost
IF cost > (osklcat(catnum) - sklcat(c, catnum)) THEN GOTO 355
sklcat(c, catnum) = sklcat(c, catnum) + cost
GOTO 395
355 remain = cost - (osklcat(catnum) - sklcat(c, catnum))
sklcat(c, 7) = sklcat(c, 7) + remain
sklcat(c, catnum) = osklcat(catnum)
GOTO 395
360 REM Remove Skill
s = index(cp)
l = slvl(cp)
GOSUB 470
IF lang = 1 THEN cost = 1
IF cost > (osklcat(catnum) - sklcat(c, catnum)) THEN GOTO 365
sklcat(c, catnum) = sklcat(c, catnum) + cost
GOTO 368
365 remain = cost - (osklcat(catnum) - sklcat(c, catnum))
sklcat(c, 7) = sklcat(c, 7) + remain
sklcat(c, catnum) = osklcat(catnum)
368 FOR a = cp TO num
index(a) = index(a + 1)
sname$(a) = sname$(a + 1)
scost(a) = scost(a + 1)
slvl(a) = slvl(a + 1)
NEXT a
num = num - 1
GOTO 300
370 REM Add Skill Point
s = index(cp)
l = slvl(cp) + 1
IF l < 6 THEN GOTO 371
w = 2
GOTO 390
371 IF l = 1 OR l = 2 OR l = 3 THEN p = 43
IF l = 4 OR l = 5 THEN p = 45
IF lang = 1 AND l = 4 THEN p = 43
m$ = MID$(sk$(s), p, 1)
IF (ASC(m$) > 47 AND ASC(m$) < 58) THEN GOTO 372
w = 2
GOTO 390
372 GOSUB 470
IF lang = 1 AND scost(cp) < 4 THEN cost = 1
IF cost <= (sklcat(c, catnum) + sklcat(c, 7)) THEN GOTO 374
w = 1
GOTO 390
374 REM Skill level exists and is affordable
IF lang = 1 AND scost(cp) < 4 THEN GOTO 375
slvl(cp) = slvl(cp) + 1
375 scost(cp) = scost(cp) + cost
IF cost > sklcat(c, catnum) THEN GOTO 376
sklcat(c, catnum) = sklcat(c, catnum) - cost
GOTO 395
376 sklcat(c, 7) = sklcat(c, 7) - (cost - sklcat(c, catnum))
sklcat(c, catnum) = 0
GOTO 395
390 REM Warnings
LOCATE 23, 1
COLOR 12, 0
SOUND 100, 2
IF w = 1 THEN PRINT "Warning: You can't afford to move this skill up.";
IF w = 2 THEN PRINT "Warning: Skill already at highest level attainable.";
GOTO 330
395 REM Revise Skill Chart
GOSUB 485
IF unmet = 0 THEN COLOR 0, 12
IF unmet = 1 THEN COLOR 16, 12
GOSUB 410
GOSUB 335
combak = 1
GOSUB 320
combak = 0
GOTO 330

400 REM Undistributed skill-points warning
CLS
COLOR 11, 0
LOCATE 10, 1
bad = 0
FOR cp = 1 TO num
GOSUB 485
IF unmet = 1 THEN bad = bad + 1
NEXT cp
IF bad = 0 THEN GOTO 403
PRINT , "It seems that"; bad; "of your skills demand";
IF bad = 1 THEN PRINT "s a"
IF bad > 1 THEN PRINT
IF bad = 1 THEN PRINT , "prerequisite which has not been met."
IF bad > 1 THEN PRINT , "prerequisites which have not been met."
PRINT
PRINT , "You need to go back and amend the character"
PRINT , "so that all of the skill choices are legal."
PRINT : PRINT
COLOR 14, 0
PRINT , "Hit any key to continue"
GOSUB 60
GOTO 300
403 IF skltot = 0 THEN GOTO 700
PRINT , "You still have"; skltot; "skill-points which have not"
PRINT , "been allocated to skills. Do you really want to"
PRINT , "accept the character without first distributing"
PRINT , "these points?  (Y/N)"
405 GOSUB 60
IF k2 = 0 AND (k1 = 89 OR k1 = 121) THEN GOTO 700
IF k2 = 0 AND (k1 = 78 OR k1 = 110) THEN GOTO 300
GOTO 405

410 REM cursor placement
IF cp > 30 THEN cp = 30
IF cp < 16 THEN row = cp + 2
IF cp < 16 THEN col = 1
IF cp >= 16 THEN row = cp - 13
IF cp >= 16 THEN col = 41
LOCATE row, col
RETURN

420 REM view skills
CLS
COLOR 11, 0
LOCATE 5, 1
PRINT , "0. Return to Previous Screen"
FOR a = 1 TO 5
PRINT , ;
PRINT USING "#. "; a;
PRINT skill$(a)
NEXT a
PRINT
COLOR 14, 0
PRINT , "Enter a skill category: ";
422 r$ = INPUT$(1)
ss$ = ""
IF r$ = "0" THEN GOTO 300
IF r$ = "1" THEN ss$ = "M"
IF r$ = "2" THEN ss$ = "C"
IF r$ = "3" THEN ss$ = "S"
IF r$ = "4" THEN ss$ = "E"
IF r$ = "5" THEN ss$ = "G"
IF ss$ = "" THEN GOTO 422
b = 0
FOR a = 1 TO nsk
IF LEFT$(sk$(a), 1) <> ss$ THEN GOTO 430
b = b + 1
IF b MOD 15 <> 1 THEN GOTO 423
CLS
COLOR 11, 0
PRINT "#";
LOCATE 1, 6
PRINT "Skill";
LOCATE 1, 31
PRINT "Att";
LOCATE 1, 41
PRINT "Cost";
LOCATE 1, 51
PRINT "Prereq"
COLOR 10, 0
PRINT STRING$(59, 196)
COLOR 11, 0
423 PRINT LEFT$(sk$(a), 30);
IF MID$(sk$(a), 31, 1) <> "h" THEN GOTO 424
PRINT CHR$(171);
PRINT MID$(sk$(a), 32, 4);
GOTO 425
424 PRINT MID$(sk$(a), 31, 5);
425 IF MID$(sk$(a), 36, 1) <> "h" THEN GOTO 426
PRINT CHR$(171);
PRINT MID$(sk$(a), 37, 4);
GOTO 428
426 PRINT MID$(sk$(a), 36, 5);
428 PRINT MID$(sk$(a), 41, 19)
IF b MOD 15 <> 0 THEN GOTO 430
PRINT
COLOR 14, 0
PRINT "Hit any key to continue"
GOSUB 60
430 NEXT a
PRINT
COLOR 14, 0
PRINT "Hit any key to continue"
GOSUB 60
GOTO 420

440 REM help
CLS
COLOR 14, 0
PRINT "In this section of the program you can choose skills for"
PRINT "your character. In order to select a skill, type its"
PRINT "reference number. For example, the number for 'Carpentry'"
PRINT "is 'M2' (it's the 2nd 'Mechanical' skill). Note that when"
PRINT "you select a skill, it will cost you skill points. The"
PRINT "points you have available in each of the various skill"
PRINT "categories are displayed at the botton of selection screen."
PRINT "To get a complete list of skills and their corresponding"
PRINT "reference numbers, use 'V' to view the skill list. You can"
PRINT "modify this list by modifying the program's ascii data file."
PRINT "Initially, however, all the skills in the Player's Guide and"
PRINT "the Commando resource manual are represented."
PRINT
PRINT "When you select a skill, the program starts you at zero"
PRINT "level. You can modify the level or unselect the skill by"
PRINT "using the arrow keys. A few skills can be selected more than"
PRINT "once, however, for these the program will prompt you for"
PRINT "more infomation in order to clarify your skill choice."
PRINT
PRINT "Hit any key to continue"
GOSUB 60
CLS
PRINT "Some skills demand prerequisites. If you select such a skill"
PRINT "without have the appropriate prerequisite in your repertoire,"
PRINT "the program won't stop you, but the offending skill will"
PRINT "blink until its direct prerequisite is satisfied."
PRINT
PRINT "Because of the programmer's innate tendancy toward sloth,"
PRINT "your skill repertoire can only consist of a maximum of thirty"
PRINT "skills. This should be enough for any starting character"
PRINT "(since starting characters are restricted to thirty skill"
PRINT "points)."
PRINT
PRINT "If you accept the character at this stage, the program will"
PRINT "prompt you for a character name and a file name, and then it"
PRINT "will save your character in ascii format so you can import it"
PRINT "to your word-processor of choice. Be wary that if you select"
PRINT "a file name which already exists, you'll end up over-writing"
PRINT "the original file."
PRINT
PRINT "Hit any key to continue"
GOSUB 60
GOTO 300

450 REM optional rule
CLS
COLOR 10, 0
PRINT "There is an optional rule on page 34 of the Player's Guide."
PRINT "In short, it states that in order to raise a skill which"
PRINT "requires a prerequisite skill, your level in the prerequisite"
PRINT "skill must be at least as high as the level to which you are"
PRINT "raising the more advanced skill (unless the prerequisite"
PRINT "skill is already maxed-out). For example, since ";
COLOR 11, 0
PRINT "computer"
PRINT "technician ";
COLOR 10, 0
PRINT "requires ";
COLOR 11, 0
PRINT "electronics";
COLOR 10, 0
PRINT ", you couldn't have a"
PRINT "character with a higher level in ";
COLOR 11, 0
PRINT "computer technician";
COLOR 10, 0
PRINT " than"
COLOR 11, 0
PRINT "electonics";
COLOR 10, 0
PRINT "."
PRINT
PRINT "We assume at the start of the program that you don't want to"
PRINT "play by this optional rule, however, different people have"
PRINT "different tastes."
PRINT
PRINT "Do you want to play by this optional rule? (Y/N)"
452 GOSUB 60
IF k2 = 0 AND (k1 = 89 OR k1 = 121) THEN opt$ = "Y"
IF k2 = 0 AND (k1 = 78 OR k1 = 110) THEN opt$ = "N"
IF k2 = 0 AND (k1 = 89 OR k1 = 121 OR k1 = 78 OR k1 = 110) THEN GOTO 300
GOTO 452

460 REM Clear Warning Line
COLOR 13, 0
LOCATE 23, 1
PRINT SPACE$(70);
RETURN

470 REM Find skill cat# and cost of skill s at level l
letter$ = LEFT$(sk$(s), 1)
IF letter$ = "L" THEN GOTO 475
REM Non-Language Skill
IF l = 0 THEN p = 41
IF l = 1 OR l = 2 OR l = 3 THEN p = 43
IF l = 4 OR l = 5 THEN p = 45
IF l < 4 THEN cost = VAL(MID$(sk$(s), p, 1))
IF l > 3 THEN cost = VAL(MID$(sk$(s), p, 2))
IF letter$ = "M" THEN catnum = 1
IF letter$ = "C" THEN catnum = 2
IF letter$ = "S" THEN catnum = 3
IF letter$ = "E" THEN catnum = 4
IF letter$ = "G" THEN catnum = 5
RETURN
475 REM Language Skill
catnum = 6
IF l = 0 OR l = 5 THEN cost = 4
IF l > 0 AND l < 5 THEN cost = 2
RETURN

480 REM Reduce points of sklcat(c,catnum) by cost
IF cost > sklcat(c, catnum) THEN GOTO 482
REM Don't need to dip into spare points
sklcat(c, catnum) = sklcat(c, catnum) - cost
RETURN
482 REM Need to dip into spare points
cost = cost - sklcat(c, catnum)
sklcat(c, catnum) = 0
sklcat(c, 7) = sklcat(c, 7) - cost
RETURN

485 REM Detect unmet prerequisite on sk$(index(cp))
unmet = 1
REM Are there 0, 1, or 2 prereqs?
prereqs = 0
IF MID$(sk$(index(cp)), 51, 1) <> " " THEN prereqs = 1
IF MID$(sk$(index(cp)), 56, 1) <> " " THEN prereqs = 2
IF prereqs = 1 GOTO 486
IF prereqs = 2 GOTO 490
REM There are 0 prereqs
unmet = 0
RETURN
486 REM There is 1 prereq
pre$(1) = MID$(sk$(index(cp)), 51, 4)
FOR a = 1 TO num
IF pre$(1) <> LEFT$(sk$(index(a)), 4) THEN GOTO 488
IF opt$ = "N" THEN GOTO 487
maxlvl = 5
m$ = MID$(sk$(index(a)), 45, 1)
IF (ASC(m$) < 48 OR ASC(m$) > 57) THEN maxlvl = 3
m$ = MID$(sk$(index(a)), 43, 1)
IF (ASC(m$) < 48 OR ASC(m$) > 57) THEN maxlvl = 0
IF slvl(a) = maxlvl THEN GOTO 487
IF slvl(cp) > slvl(a) THEN GOTO 488
487 unmet = 0
488 NEXT a
RETURN
490 REM There are 2 prereqs
pre$(1) = MID$(sk$(index(cp)), 51, 4)
pre$(2) = MID$(sk$(index(cp)), 56, 4)
REM We just need one of the two prereqs
FOR a = 1 TO num
FOR b = 1 TO 2
IF pre$(b) <> LEFT$(sk$(index(a)), 4) THEN GOTO 492
IF opt$ = "N" THEN GOTO 491
maxlvl = 5
m$ = MID$(sk$(index(a)), 45, 1)
IF (ASC(m$) < 48 OR ASC(m$) > 57) THEN maxlvl = 3
m$ = MID$(sk$(index(a)), 43, 1)
IF (ASC(m$) < 48 OR ASC(m$) > 57) THEN maxlvl = 0
IF slvl(a) = maxlvl THEN GOTO 491
IF slvl(cp) <= slvl(a) THEN GOTO 491
GOTO 492
491 unmet = 0
492 NEXT b
NEXT a
RETURN

500 REM Non-Language Skill
GOSUB 460
IF num = 30 THEN GOTO 525
IF cp = num + 1 THEN GOTO 505
GOSUB 410
GOSUB 485
IF unmet = 0 THEN COLOR 12, 0
IF unmet = 1 THEN COLOR 28, 0
GOSUB 335
cp = num + 1
GOSUB 410
COLOR 0, 12
PRINT STRING$(37, 32);
505 GOSUB 410
COLOR 0, 12
a = 1
e$(a) = UCASE$(CHR$(k1))
PRINT e$(a);
510 GOSUB 60
IF k2 = 1 AND k1 = 72 THEN GOTO 340
IF k2 = 1 THEN GOTO 510
IF k1 = 8 THEN GOTO 515
IF k1 = 13 THEN GOTO 520
IF k1 > 47 AND k1 < 58 THEN GOTO 512
IF k1 > 64 AND k1 < 91 THEN k1 = k1 - 32
IF k1 > 96 AND k1 < 123 THEN GOTO 512
GOTO 510
512 REM number or letter
a = a + 1
IF a = 5 GOTO 523
e$(a) = CHR$(k1)
PRINT e$(a);
GOTO 510
515 REM backspace pressed
IF a > 1 THEN GOTO 516
LOCATE row, col
PRINT " ";
GOTO 300
516 LOCATE row, col + a - 1
PRINT " ";
LOCATE row, col + a - 1
a = a - 1
GOTO 510
520 REM enter pressed
REM What is the skill index? ex$
ex$ = "": s = 0
FOR b = 1 TO a
ex$ = ex$ + e$(b)
NEXT b
FOR b = a + 1 TO 5
ex$ = ex$ + " "
NEXT b
REM Is ex$ a valid index?
check = 0
FOR a = 1 TO nsk
IF ex$ = LEFT$(sk$(a), 5) THEN s = a
NEXT a
IF s <> 0 GOTO 525
523 w = 1
524 REM Warning
LOCATE row, col
PRINT "          ";
LOCATE 23, 1
COLOR 12, 0
IF ex$ = "S15  " THEN w = 5
IF ex$ = "S15  " THEN ex$ = ""
SOUND 100, 2
IF w = 1 THEN PRINT "Warning: An invalid skill # was detected.";
IF w = 2 THEN PRINT "Warning: This skill is non-repeatable.";
IF w = 3 THEN PRINT "Warning: You can't afford this skill.";
IF w = 4 THEN PRINT "Warning: There are only 30 skill slots.";
IF w = 5 THEN PRINT "Warning: This skill has been divided into subskills.";
IF w = 6 THEN PRINT "Warning: Already at maximum number of languages.";
GOTO 301
525 REM Valid Index, but do we have the skill already?
REM And do we have room?
IF num < 30 THEN GOTO 526
w = 4
GOTO 524
526 IF num = 0 GOTO 530
r = 0
FOR a = 1 TO num
IF s = index(a) THEN r = a
NEXT a
IF r = 0 THEN GOTO 530
REM The skill is not new
IF MID$(sk$(s), 60, 1) = "y" THEN GOTO 530
REM The skill choice is unacceptable
w = 2
GOTO 524
530 REM The skill chosen is new or repeatable and we have room
REM Do we have the points we need?
l = 0
GOSUB 470
IF cost <= (sklcat(c, catnum) + sklcat(c, 7)) THEN GOTO 540
REM The skill costs too much
w = 3
GOTO 524
540 REM We can afford the skill
REM Incorporate skill into repertoire
IF num > 0 GOTO 550
REM This is our first skill
num = 1
GOTO 553
550 REM This is not our first skill
num = num + 1
REM Find the first higher index
a = 1
551 IF index(a) > s OR a = num THEN GOTO 552
a = a + 1
GOTO 551
552 IF a < num THEN GOTO 554
553 REM There is no higher index
index(num) = s
sname$(num) = MID$(sk$(s), 6, 24)
scost(num) = cost
slvl(num) = 0
a = num
GOTO 560
554 REM Adjust the higher indexes down
FOR b = num - 1 TO a STEP -1
index(b + 1) = index(b)
sname$(b + 1) = sname$(b)
scost(b + 1) = scost(b)
slvl(b + 1) = slvl(b)
NEXT b
REM Stick in the new index
index(a) = s
sname$(a) = MID$(sk$(s), 6, 24)
scost(a) = cost
slvl(a) = 0
560 REM The skill has been incorporated
REM Now spend the skill points necessary to buy it
GOSUB 480
IF MID$(sk$(s), 60, 1) = "y" THEN specify = a
GOTO 300

600 REM Specify skill further
LOCATE 23, 1
COLOR 12, 0
PRINT "Specify skill further.";
cp = specify
GOSUB 410
GOSUB 485
IF unmet = 0 THEN COLOR 0, 12
IF unmet = 1 THEN COLOR 16, 12
GOSUB 335
FOR a = 1 TO 24
IF MID$(sname$(cp), a, 1) <> " " THEN b = a
NEXT a
LOCATE row, col + b + 5
PRINT ": ";
a = 0
room = 24 - (b + 2)
610 GOSUB 60
IF k2 = 1 THEN GOTO 610
IF k1 = 8 THEN GOTO 615
IF k1 = 13 THEN GOTO 620
IF k1 = 44 THEN GOTO 610
IF k1 > 31 AND k1 < 58 THEN GOTO 612
IF k1 > 64 AND k1 < 91 THEN GOTO 612
IF k1 > 96 AND k1 < 123 THEN GOTO 612
GOTO 610
612 REM number or letter
IF a = room GOTO 610
a = a + 1
e$(a) = CHR$(k1)
PRINT e$(a);
GOTO 610
615 REM backspace pressed
IF a = 0 THEN GOTO 610
a = a - 1
LOCATE row, col + a + b + 7
PRINT " ";
LOCATE row, col + a + b + 7
GOTO 610
620 REM enter pressed
REM What does it say?
ex$ = ""
IF a = 0 THEN GOTO 630
FOR d = 1 TO a
ex$ = ex$ + e$(d)
NEXT d
IF a = room THEN GOTO 640
630 FOR d = a + 1 TO room
ex$ = ex$ + " "
NEXT d
640 sname$(cp) = LEFT$(sname$(cp), b) + ": " + ex$
specify = 0
GOTO 300

650 REM Languages
IF num = 0 THEN GOTO 655
totlang = INT(st(3) / 10)
IF totlang <> (st(3) / 10) THEN totlang = totlang + 1
langnum = 0
FOR langck = 1 TO num
IF LEFT$(sk$(index(langck)), 1) = "L" THEN langnum = langnum + 1
NEXT langck
IF langnum < totlang THEN GOTO 655
w = 6
GOTO 524
655 a = 1
e$(1) = "L"
GOTO 520

700 REM Post-CharGen
COLOR 10, 0
CLS
LOCATE 10, 1
PRINT , ;
INPUT "Character's Name: ", char$
FOR note = 1 TO 10
SOUND 200 * note, .1
NEXT note
PRINT
PRINT , ;
INPUT "File Name: ", file$
FOR note = 1 TO 10
SOUND 200 * note, .1
NEXT note
PRINT
PRINT
COLOR 14, 0
PRINT , "Saving "; file$
PRINT
OPEN "o", 1, file$
PRINT #1, ""
PRINT #1, "Character: "; char$
PRINT #1, "Occupation Type: "; career$(c)
PRINT #1, ""
PRINT #1, ""
PRINT #1, "Attribute Chart"
PRINT #1, ""
PRINT #1, "Attribute", "Rating", "Hlf", "Qtr"
PRINT #1, STRING$(45, 45)
FOR a = 1 TO 7
PRINT #1, stn$(a), st(a), fnhlf(st(a)), fnqtr(st(a))
IF a MOD 5 <> 0 THEN GOTO 710
PRINT #1, STRING$(45, 45)
710 NEXT a
PRINT #1, ""
IF num = 0 THEN GOTO 750
PRINT #1, ""
PRINT #1, "Skill Chart"
PRINT #1, ""
PRINT #1, "#    Skill                    Lvl   Pts   Att   Ful   Hlf   Qtr"
PRINT #1, STRING$(63, 45)
FOR a = 1 TO num
snumber$ = LEFT$(sk$(index(a)), 5)
PRINT #1, snumber$;
PRINT #1, sname$(a);
PRINT #1, " ";
PRINT #1, slvl(a);
PRINT #1, "  ";
IF scost(a) < 10 THEN PRINT #1, " ";
PRINT #1, scost(a);
PRINT #1, "   ";
att$(1) = MID$(sk$(index(a)), 31, 4)
att$(2) = MID$(sk$(index(a)), 36, 4)
ful = 0
h = 0
e = 0
f(1) = 0
f(2) = 0
FOR b = 1 TO 2
IF LEFT$(att$(b), 1) = "h" THEN h = 1
IF h = 1 THEN att$(b) = RIGHT$(att$(b), 3)
IF h = 0 THEN att$(b) = LEFT$(att$(b), 3)
FOR d = 1 TO 7
IF att$(b) = stn$(d) THEN e = d
NEXT d
IF e = 0 THEN GOTO 720
IF h = 0 THEN f(b) = st(e)
IF h = 1 THEN f(b) = fnhlf(st(e))
720 NEXT b
IF f(1) >= f(2) THEN g = 1
IF f(2) > f(1) THEN g = 2
ful = f(g)
IF ful = 0 THEN PRINT #1, " -     -     -     -"
IF ful = 0 THEN GOTO 730
att$(1) = MID$(sk$(index(a)), 31, 4)
att$(2) = MID$(sk$(index(a)), 36, 4)
PRINT #1, att$(g);
PRINT #1, " ";
add = 5
IF MID$(sk$(index(a)), 61, 1) = "e" THEN add = 10
hlf = fnhlf(ful) + (add * slvl(a))
qtr = fnqtr(ful) + (add * slvl(a))
ful = ful + (add * slvl(a))
IF ful < 100 THEN PRINT #1, " ";
IF ful < 10 THEN PRINT #1, " ";
PRINT #1, ful;
PRINT #1, "  ";
IF hlf < 10 THEN PRINT #1, " ";
PRINT #1, hlf;
PRINT #1, "  ";
IF qtr < 10 THEN PRINT #1, " ";
PRINT #1, qtr
730 IF a MOD 5 <> 0 OR a = num THEN GOTO 740
PRINT #1, STRING$(63, 45)
740 NEXT a
PRINT #1, ""
750 CLOSE #1

1000 REM End Program
COLOR 7
CLS
PRINT
PRINT "For Assistance and/or Snide Remarks:"
PRINT
PRINT "     Email:  jimv@empirenet.com"
PRINT "             jimvassila@aol.com"
PRINT
PRINT "  Homepage:  http://members.aol.com/jimvassila"
PRINT
FOR note = 1 TO 60
SOUND 50 * note, .1
SOUND 3100 - (50 * note), .1
NEXT note
END

