// ISAPI.CPP - Implementation file for your Internet Server
//    isapi Extension

#include "stdafx.h"
#include "xmlisapi.h"

ULONG g_Count;

///////////////////////////////////////////////////////////////////////
// The one and only CWinApp object
// NOTE: You may remove this object if you alter your project to no
// longer use MFC in a DLL.

//CWinApp theApp;

///////////////////////////////////////////////////////////////////////
char* SkipWhitespace(char* ptr)
{
	while (*ptr == ' ' || *ptr == '\t' || *ptr == '\n' || *ptr == '\r')
		ptr++;
	return ptr;
}

char* SkipName(char* ptr)
{
	while (*ptr != ' ' && *ptr != '\t' && *ptr != '\n' && *ptr != '\r' && *ptr != '=')
		ptr++;
	return ptr;
}

struct STYLESHEET {
	char* pszType;
	char* pszHref;
    char* pszServerHref;
};

BOOL ParseStyleSheet(char* stylesheet, STYLESHEET* rec)
{
	rec->pszType = NULL;
	rec->pszHref = NULL;
    rec->pszServerHref = NULL;

	char* ptr = SkipWhitespace(stylesheet);
	while (*ptr)
	{
		char* name = ptr;
		ptr = SkipName(name);
		if (! *ptr)
			return FALSE;

		char* end = ptr; 
		ptr = SkipWhitespace(ptr);
		if (*ptr != '=')
			return FALSE;
		*end = '\0';

		ptr++;
		ptr = SkipWhitespace(ptr);

		if (*ptr != '\'' && *ptr != '"')
			return FALSE;

		char quote = *ptr;
		ptr++;
		char* value = ptr;
		while (*ptr && *ptr != quote)
			ptr++;

		if (*ptr != quote)
			return FALSE;
		*ptr = '\0';
		ptr = SkipWhitespace(ptr+1);

		// Ok, so now we have the name and value of the attribute.
		if (strcmp(name, "type") == 0)
			rec->pszType = value;
		else if (strcmp(name, "href") == 0)
			rec->pszHref = value;
        else if (strcmp(name, "server-href") == 0)
            rec->pszServerHref = value;
	}
	return TRUE;
}

MSXML::IXMLDOMDocument* 
CXslCache::Lookup(char* stylesheet)
{
    HRESULT hr = S_OK;

	// To keep memory under control, we can clear
	// the cache every 10000 requests.
	m_Count++;
	if (m_Count > 10000)
	{
		ClearCache();
		m_Count = 0;
	}

    MSXML::IXMLDOMDocument *pXsl = NULL;
	_variant_t xslurl;

	WIN32_FIND_DATA data;
	HANDLE h = FindFirstFile(stylesheet, &data);
	if (h== INVALID_HANDLE_VALUE)
		goto cleanup;
	FindClose(h);

	WIN32_FIND_DATA* cached;
	if (m_Cache.Lookup(stylesheet, (void*&)cached))
	{
		pXsl = (MSXML::IXMLDOMDocument*)cached->dwReserved0;
		if (memcmp(&cached->ftLastWriteTime,&data.ftLastWriteTime,sizeof(FILETIME)) == 0 &&
			cached->nFileSizeLow == data.nFileSizeLow)
			goto cleanup;

		// cache is out of date, we are going to reload the stylesheet.
	}

    // The cache is done with the old stylesheet.
    if (pXsl) 
        pXsl->Release();

	// Need a new xsl document object (so we don't clobber the existing
    // document in case it is still being used)
	hr = CoCreateInstance(MSXML::CLSID_DOMFreeThreadedDocument, NULL, CLSCTX_INPROC_SERVER , MSXML::IID_IXMLDOMDocument, (void**)&pXsl);
	if (FAILED(hr)) goto cleanup;
	cached = new WIN32_FIND_DATA;
	memcpy(cached,&data,sizeof(WIN32_FIND_DATA));
	
	xslurl = _bstr_t(stylesheet);
	if (! pXsl->load(xslurl)) 
		goto cleanup;
	cached->dwReserved0 = (DWORD)pXsl;

    // Need to lock the cache while we update it.
    EnterCriticalSection(&m_cs);
	m_Cache.SetAt(stylesheet, (void*)cached);
    LeaveCriticalSection(&m_cs);

cleanup:
    if (pXsl) pXsl->AddRef();
	return pXsl;
}

void CXslCache::ClearCache()
{
	// release cached resources.
	using namespace MSXML;

	POSITION p = m_Cache.GetStartPosition();
	void* value;
	CString key;
	while (p != NULL)
	{
		m_Cache.GetNextAssoc(p,key,value);
		WIN32_FIND_DATA* data = (WIN32_FIND_DATA*)value;
		MSXML::IXMLDOMDocument* pXsl = (MSXML::IXMLDOMDocument*)data->dwReserved0;
		pXsl->Release();
		delete data;
	}
	m_Cache.RemoveAll();
}

///////////////////////////////////////////////////////////////////////
// XmlHttpStream
HRESULT STDMETHODCALLTYPE 
CXmlHttpStream::QueryInterface(REFIID riid, void ** ppvObject)
{
    if (riid == IID_IUnknown || riid == IID_IStream)
    {
        AddRef();
        *ppvObject = this;
        return S_OK;
    }
    return E_NOINTERFACE;
}

//
// ISequentialStream
//

/* [local] */ HRESULT STDMETHODCALLTYPE 
CXmlHttpStream::Write( 
    /* [size_is][in] */ const void __RPC_FAR *pv,
    /* [in] */ ULONG cb,
    /* [out] */ ULONG __RPC_FAR *pcbWritten)
{
    *pcbWritten = cb;

    if (_pBuf == NULL)
    {
        _pBuf = new unsigned char[ 8192];
        if (_pBuf == NULL)
            return E_OUTOFMEMORY;
        _lSize = 8192;

        // Lop off any initial unicode byte order mark.
        if ( cb >= 2)
        {
            unsigned char* pb = (unsigned char*)pv;
            if (pb[0] == 0xff && pb[1] == 0xfe)
            {
                pv = pb + 2;
                cb -= 2;
            }
        }

        // Write out UTF-8 byte order mark
        const unsigned char bom[3] = { 0xEF, 0xBB, 0xBF };
        ULONG cbWritten = 3;
    	(_pECB->WriteClient)(_pECB->ConnID, (void*)bom, &cbWritten, HSE_IO_SYNC);

    }

    // Convert the unicode to UTF-8, and if the buffer is full,
    // write it out.  
    ULONG num = cb/2;
    while (num > 0)
    {
        ULONG space = _lSize - _lUsed;
        ULONG cch = num;
        HRESULT hr = WideCharToUtf8((WCHAR*)pv, &cch, &_pBuf[_lUsed], &space);
        _lUsed += space;
        pv = (char*)pv + cch;
        num -= cch;
        if (num > 0)
        {
            hr = Commit(0);
            if (FAILED(hr))
                return hr;
        }
    }
    return S_OK;
}

HRESULT STDMETHODCALLTYPE
CXmlHttpStream::Commit( 
    /* [in] */ DWORD grfCommitFlags)
{
    ULONG cbWritten = _lUsed;
	if ((_pECB->WriteClient)(_pECB->ConnID, (void*)_pBuf, &cbWritten, HSE_IO_SYNC))
    {
        _lUsed = 0;
        return S_OK;
    }
    return E_FAIL;
}

/**
 * Scans buffer and translates Unicode characters into UTF8 characters
 */
HRESULT 
CXmlHttpStream::WideCharToUtf8(WCHAR *buffer, ULONG *cch, BYTE* bytebuffer, ULONG * cb)
{
    UINT count = 0, num = *cch, m1 = *cb, m2 = m1 - 1, m3 = m2 - 1, m4 = m3 - 1;
    DWORD dw1;
    bool surrogate = false;

    for (UINT i = num; i > 0; i--)
    {
        DWORD dw = *buffer;

        if (surrogate) //  is it the second char of a surrogate pair?
        {
            if (dw >= 0xdc00 && dw <= 0xdfff)
            {
                // four bytes 0x11110xxx 0x10xxxxxx 0x10xxxxxx 0x10xxxxxx
                if (count < m4)
                    count += 4;
                else
                    break;
                ULONG ucs4 = (dw1 - 0xd800) * 0x400 + (dw - 0xdc00) + 0x10000;
                *bytebuffer++ = (byte)(( ucs4 >> 18) | 0xF0);
                *bytebuffer++ = (byte)((( ucs4 >> 12) & 0x3F) | 0x80);
                *bytebuffer++ = (byte)((( ucs4 >> 6) & 0x3F) | 0x80);
                *bytebuffer++ = (byte)(( ucs4 & 0x3F) | 0x80);
                surrogate = false;
                buffer++;
                continue;
            }
            else // Then dw1 must be a three byte character
            {
                if (count < m3)
                    count += 3;
                else
                    break;
                *bytebuffer++ = (byte)(( dw1 >> 12) | 0xE0);
                *bytebuffer++ = (byte)((( dw1 >> 6) & 0x3F) | 0x80);
                *bytebuffer++ = (byte)(( dw1 & 0x3F) | 0x80);
            }
            surrogate = false;
        }

        if (dw  < 0x80) // one byte, 0xxxxxxx
        {
            if (count < m1)
                count++;
            else
                break;
            *bytebuffer++ = (byte)dw;
        }
        else if ( dw < 0x800) // two WORDS, 110xxxxx 10xxxxxx
        {
            if (count < m2)
                count += 2;
            else
                break;
            *bytebuffer++ = (byte)((dw >> 6) | 0xC0);
            *bytebuffer++ = (byte)((dw & 0x3F) | 0x80);
        }
        else if (dw >= 0xd800 && dw <= 0xdbff) // Assume that it is the first char of surrogate pair
        {
            if (i == 1) // last wchar in buffer
                break;
            dw1 = dw;
            surrogate = true;
        }
        else // three bytes, 1110xxxx 10xxxxxx 10xxxxxx
        {
            if (count < m3)
                count += 3;
            else
                break;
            *bytebuffer++ = (byte)(( dw >> 12) | 0xE0);
            *bytebuffer++ = (byte)((( dw >> 6) & 0x3F) | 0x80);
            *bytebuffer++ = (byte)(( dw & 0x3F) | 0x80);
        }
        buffer++;
    }

    *cch = surrogate ? num - i - 1 : num - i;
    *cb = count;

    return S_OK;
}

///////////////////////////////////////////////////////////////////////
// command-parsing map

BEGIN_PARSE_MAP(CXmlIsapiExtension, CHttpServer)
	// TODO: insert your ON_PARSE_COMMAND() and 
	// ON_PARSE_COMMAND_PARAMS() here to hook up your commands.
	// For example:

	ON_PARSE_COMMAND(Default, CXmlIsapiExtension, ITS_EMPTY)
	DEFAULT_PARSE_COMMAND(Default, CXmlIsapiExtension)
END_PARSE_MAP(CXmlIsapiExtension)


///////////////////////////////////////////////////////////////////////
// The one and only CXmlIsapiExtension object

CXmlIsapiExtension theExtension;


///////////////////////////////////////////////////////////////////////
// CXmlIsapiExtension implementation

CXmlIsapiExtension::CXmlIsapiExtension()
{
}

CXmlIsapiExtension::~CXmlIsapiExtension()
{
}

BOOL CXmlIsapiExtension::GetExtensionVersion(HSE_VERSION_INFO* pVer)
{
	// Call default implementation for initialization
	CHttpServer::GetExtensionVersion(pVer);

	// Load description string
	TCHAR sz[HSE_MAX_EXT_DLL_NAME_LEN+1];
	ISAPIVERIFY(::LoadString(AfxGetResourceHandle(),
			IDS_SERVER, sz, HSE_MAX_EXT_DLL_NAME_LEN));
	_tcscpy(pVer->lpszExtensionDesc, sz);
	return TRUE;
}

BOOL CXmlIsapiExtension::TerminateExtension(DWORD dwFlags)
{
	HRESULT hr = CoInitialize(NULL);
	// release cached resources.
	m_Cache.ClearCache();
	CoUninitialize();
	return TRUE;
}

void CXmlIsapiExtension::Default(CHttpServerContext* pCtxt)
{
//    EXTENSION_CONTROL_BLOCK *pECB = pCtxt->m_pECB;
    // Turn off sending header by MFC.
//    pCtxt->m_bSendHeaders = FALSE;
}

///////////////////////////////////////////////////////////////////////
// CXmlIsapiExtension command handlers
DWORD CXmlIsapiExtension::HttpExtensionProc( EXTENSION_CONTROL_BLOCK *pECB )
{
	bool serverside = false;

	// If the client is not IE5 and this is a request for an .xml file
	// then do serverside processing of the stylesheet.
	char buffer[4097];
	ULONG len = 4096;

	(pECB->GetServerVariable)(pECB->ConnID, "HTTP_USER_AGENT", buffer, &len);
    if (strstr(buffer, "MSIE 5") == NULL ||
        strstr(buffer, "MSIE 5.0; Windows NT 5.0") != NULL) // special hack for broken NT5 beta3.
	{
		serverside = true;
	}


	// return requested file as is.
	HANDLE hFile = ::CreateFile(
		pECB->lpszPathTranslated, // lpFileName 
		GENERIC_READ, // dwDesiredAccess 
		FILE_SHARE_READ, // dwShareMode 
		NULL, // lpSecurityAttributes 
		OPEN_EXISTING, // dwCreationDisposition 
		FILE_FLAG_SEQUENTIAL_SCAN, // dwFlagsAndAttributes 
		NULL //hTemplateFile         
		);
			
	if (INVALID_HANDLE_VALUE == hFile)
	{
		pECB->dwHttpStatusCode = HTTP_STATUS_NOT_FOUND;
		return HTTP_STATUS_NOT_FOUND;
	}

	if (serverside)	
	{
		// find stylesheet tag (should be in first buffer).
		if (ReadFile(hFile, buffer, 4096, &len, NULL) && len > 0)
		{
			buffer[len] = '\0';
			char* stylesheet = strstr(buffer,"<?xml:stylesheet");
            if (! stylesheet)
			    stylesheet = strstr(buffer,"<?xml-stylesheet");
			if (stylesheet)
			{
				char* end = strstr(stylesheet, "?>");
				if (end)
				{
					*end = '\0';
					STYLESHEET rec;
					if (ParseStyleSheet(stylesheet+16, &rec) && 
						strcmp(rec.pszType, "text/xsl") == 0 &&
						rec.pszHref != NULL)
					{
						if (ProcessStylesheet(pECB, 
                            rec.pszServerHref ? rec.pszServerHref : rec.pszHref))
							goto Cleanup;
					}
				}
			}
		}
		// seek back to start of file and start over.
		SetFilePointer(hFile, 0, NULL, FILE_BEGIN);
	}

    WriteHeader(pECB, "Content-Type: text/xml\r\n\r\n");

	while (ReadFile(hFile, buffer, 4096, &len, NULL) && len > 0)
	{
		(pECB->WriteClient)(pECB->ConnID, buffer, &len, HSE_IO_SYNC);
	}
Cleanup:
	CloseHandle(hFile); 
    return S_OK;
}

const int BUFLEN = 2000;

bool 
CXmlIsapiExtension::ProcessStylesheet(EXTENSION_CONTROL_BLOCK *pECB, char* stylesheet)
{
	MSXML::IXMLDOMDocument *pDoc = NULL;
	MSXML::IXMLDOMDocument *pXsl = NULL;
	HRESULT hr = CoInitialize(NULL);
	ULONG len = strlen(stylesheet) + strlen(pECB->lpszPathTranslated);
	char* multi = NULL;
	char* ptr = NULL;
	_variant_t vt;
	_bstr_t result;
	bool rc = false;
    CXmlHttpStream* pStm = NULL;

    // make sure we have enough room to resolve/tweak the stylesheet URL.
	char* buffer = new char[ (len + 1000) * 2 ];
    if (buffer == NULL)
        goto cleanup;

	hr = CoCreateInstance(MSXML::CLSID_DOMFreeThreadedDocument, NULL, CLSCTX_INPROC_SERVER , MSXML::IID_IXMLDOMDocument, (void**)&pDoc);
	if (FAILED(hr)) goto cleanup;
	vt = _bstr_t(pECB->lpszPathTranslated);

	if (! pDoc->load(vt) )
		goto cleanup;

    // if stylesheet is a real URL then let document load it, 
    // otherwise resolve it as a local file using lpszPathTranslated
    // as the base filename.

    if (strstr(stylesheet, "http://") != NULL)
    {
        strcpy(buffer, stylesheet);
    }
    else
    {
	    for (ptr = stylesheet; *ptr; ptr++)
	    {
		    if (*ptr == '/')
			    *ptr = '\\';
	    }
	    if (stylesheet[0] == '\\')
	    {
		    len = BUFLEN;
		    strcpy(buffer,stylesheet);
		    if (! (pECB->ServerSupportFunction)(pECB->ConnID,  
			    HSE_REQ_MAP_URL_TO_PATH ,
			    buffer, &len, 0) )
		    {
			    goto cleanup;
		    }
	    }
	    else
	    {
		    strcpy(buffer,pECB->lpszPathTranslated);
		    ptr = strrchr(buffer, '\\');
		    ptr++;
		    strcpy(ptr, stylesheet);
	    }
    }

	pXsl = m_Cache.Lookup(buffer);
	if (! pXsl) goto cleanup;

    WriteHeader(pECB, "Content-Type: text/html\r\n\r\n");

    pStm = new CXmlHttpStream(pECB);
    vt = (IUnknown*)pStm;
	result = pDoc->transformNodeToObject(pXsl, vt);
    vt.Clear();

	rc = true;
    g_Count++;

cleanup:
	if (pDoc) pDoc->Release();
    if (pStm) pStm->Release();
    if (pXsl) pXsl->Release();
    delete buffer;
	CoUninitialize();
	return rc;
}

void 
CXmlIsapiExtension::WriteHeader(EXTENSION_CONTROL_BLOCK *pECB, char* header)
{
    DWORD dwSize = strlen(header);
   
    // Send our own headers.
    (pECB->ServerSupportFunction)(pECB->ConnID, 
        HSE_REQ_SEND_RESPONSE_HEADER,
        NULL, &dwSize, (LPDWORD ) header);
}

// Do not edit the following lines, which are needed by ClassWizard.
#if 0
BEGIN_MESSAGE_MAP(CXmlIsapiExtension, CHttpServer)
	//{{AFX_MSG_MAP(CXmlIsapiExtension)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif	// 0



///////////////////////////////////////////////////////////////////////
// If your extension will not use MFC, you'll need this code to make
// sure the extension objects can find the resource handle for the
// module.  If you convert your extension to not be dependent on MFC,
// remove the comments arounn the following AfxGetResourceHandle()
// and DllMain() functions, as well as the g_hInstance global.

/****

static HINSTANCE g_hInstance;

HINSTANCE AFXISAPI AfxGetResourceHandle()
{
	return g_hInstance;
}

BOOL WINAPI DllMain(HINSTANCE hInst, ULONG ulReason,
					LPVOID lpReserved)
{
	if (ulReason == DLL_PROCESS_ATTACH)
	{
		g_hInstance = hInst;
	}

	return TRUE;
}

****/
