#if !defined(AFX_ISAPI_H__48564854_1602_11D3_B4C9_000000000000__INCLUDED_)
#define AFX_ISAPI_H__48564854_1602_11D3_B4C9_000000000000__INCLUDED_

// XMLISAPI.H - Header file for your Internet Server
//    isapi Extension

#include "resource.h"

class CXslCache
{
public:
	CXslCache() { m_Count = 0; 
            InitializeCriticalSection(&m_cs);
    }
    ~CXslCache()
    {
        DeleteCriticalSection(&m_cs);
    }
	MSXML::IXMLDOMDocument* Lookup(char* stylesheet);
	void ClearCache();

private:
	CMapStringToPtr m_Cache;
	long m_Count;
    CRITICAL_SECTION m_cs; // need to lock cache on updates.
};

// This class delegates IStream::Write to the given CHttpServerContext object.
class CXmlHttpStream : public IStream
{
private:
    long _lRefs;
    EXTENSION_CONTROL_BLOCK* _pECB;

    unsigned char* _pBuf; // UTF-8 buffer.
    int   _lSize;
    int   _lUsed;

    // Convert as many chars as possible in the buffer to utf8 chars in
    // the bytebuffer, returning in cch the number of chars converted and
    // in cb the number of bytes written.
    HRESULT WideCharToUtf8(WCHAR *buffer, ULONG *cch, BYTE* bytebuffer, ULONG * cb);

public:
    CXmlHttpStream(EXTENSION_CONTROL_BLOCK *pECB)
    {
        _pECB = pECB;
        _lRefs = 1;
        _lSize = 0;
        _lUsed = 0;
        _pBuf = NULL;
    }

    ~CXmlHttpStream()
    {
        Commit(0);
        delete[] _pBuf;
    }

       // IUnknown
    virtual ULONG STDMETHODCALLTYPE AddRef( void)
    {
        return _lRefs++;
    }
    
    virtual ULONG STDMETHODCALLTYPE Release( void)
    {
        ULONG result = _lRefs--;
        if (_lRefs == 0)
            delete this;
        return result;
    }

    virtual HRESULT STDMETHODCALLTYPE QueryInterface(REFIID riid, void ** ppvObject);

    //
    // ISequentialStream
    //

    virtual /* [local] */ HRESULT STDMETHODCALLTYPE Write( 
        /* [size_is][in] */ const void __RPC_FAR *pv,
        /* [in] */ ULONG cb,
        /* [out] */ ULONG __RPC_FAR *pcbWritten);


    //########## the rest of the methods return E_NOTIMPL ################

    virtual /* [local] */ HRESULT STDMETHODCALLTYPE Read( 
        /* [length_is][size_is][out] */ void __RPC_FAR *pv,
        /* [in] */ ULONG cb,
        /* [out] */ ULONG __RPC_FAR *pcbRead)
    {
        return E_NOTIMPL;
    }
        
    //
    // IStream
    //

    virtual /* [local] */ HRESULT STDMETHODCALLTYPE Seek( 
        /* [in] */ LARGE_INTEGER dlibMove,
        /* [in] */ DWORD dwOrigin,
        /* [out] */ ULARGE_INTEGER __RPC_FAR *plibNewPosition)
    {
        return E_NOTIMPL;
    }
        
    virtual HRESULT STDMETHODCALLTYPE SetSize( 
        /* [in] */ ULARGE_INTEGER libNewSize)
    {
        return E_NOTIMPL;
    }
        
    virtual /* [local] */ HRESULT STDMETHODCALLTYPE CopyTo( 
        /* [unique][in] */ IStream __RPC_FAR *pstm,
        /* [in] */ ULARGE_INTEGER cb,
        /* [out] */ ULARGE_INTEGER __RPC_FAR *pcbRead,
        /* [out] */ ULARGE_INTEGER __RPC_FAR *pcbWritten)
    {
        return E_NOTIMPL;
    }
        
    virtual HRESULT STDMETHODCALLTYPE Commit( 
        /* [in] */ DWORD grfCommitFlags);
        
    virtual HRESULT STDMETHODCALLTYPE Revert(void)
    {
        return E_NOTIMPL;
    }
    
    virtual HRESULT STDMETHODCALLTYPE LockRegion( 
        /* [in] */ ULARGE_INTEGER libOffset,
        /* [in] */ ULARGE_INTEGER cb,
        /* [in] */ DWORD dwLockType)
    {
        return E_NOTIMPL;
    }
        
    virtual HRESULT STDMETHODCALLTYPE UnlockRegion( 
        /* [in] */ ULARGE_INTEGER libOffset,
        /* [in] */ ULARGE_INTEGER cb,
        /* [in] */ DWORD dwLockType)
    {
        return E_NOTIMPL;
    }
        
    virtual HRESULT STDMETHODCALLTYPE Stat( 
        /* [out] */ STATSTG __RPC_FAR *pstatstg,
        /* [in] */ DWORD grfStatFlag)
    {
        return E_NOTIMPL;
    }
        
    virtual HRESULT STDMETHODCALLTYPE Clone( 
        /* [out] */ IStream __RPC_FAR *__RPC_FAR *ppstm)
    {
        return E_NOTIMPL;
    }
};

class CXmlIsapiExtension : public CHttpServer
{
public:
	CXmlIsapiExtension();
	~CXmlIsapiExtension();

// Overrides
	// ClassWizard generated virtual function overrides
		// NOTE - the ClassWizard will add and remove member functions here.
		//    DO NOT EDIT what you see in these blocks of generated code !
	//{{AFX_VIRTUAL(CXmlIsapiExtension)
	public:
	virtual BOOL GetExtensionVersion(HSE_VERSION_INFO* pVer);
	//}}AFX_VIRTUAL
	virtual BOOL TerminateExtension(DWORD dwFlags);

	// TODO: Add handlers for your commands here.
	// For example:
	virtual DWORD HttpExtensionProc( EXTENSION_CONTROL_BLOCK *pECB );	

	void Default(CHttpServerContext* pCtxt);

	DECLARE_PARSE_MAP()

	//{{AFX_MSG(CXmlIsapiExtension)
	//}}AFX_MSG

private:
	bool ProcessStylesheet(EXTENSION_CONTROL_BLOCK *pECB, char* stylesheet);
    void WriteHeader(EXTENSION_CONTROL_BLOCK *pECB, char* header);

	CXslCache m_Cache;
};


//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ISAPI_H__48564854_1602_11D3_B4C9_000000000000__INCLUDED)
