program magic;

uses crt;

type


    Cardtype  = record
              is_tapped : boolean;
              name      : string[30];
              counters  : integer;
    end;

    Cardlist = record
             card     : array[1..70] of Cardtype;
             numcards : integer;
    end;

const
     Handid = '#';
     Inplayid = '@';
     Graveyardid = '&';

var
   landinplay, graveyard, deck, hand,inplay : Cardlist;
   life, amt : integer;

procedure swapem(var one : Cardtype; var two : Cardtype);
var
   temp : Cardtype;
begin
     temp := one;
     one  := two;
     two  := temp;
end;

procedure init_cardlist(var list : Cardlist);
begin
     list.numcards := 0;
end;

{Load Deckfile from Disk}
procedure load_deckfile(var list : Cardlist);
var
   fname,name: string;
   f         : text;
   num, i, j : integer;
   deckpos   : integer;
begin
     write('What is the path and filename of your deckfile? : ');
     readln(fname);

     assign(f,fname);
     reset(f);

     i := 0;
     deckpos := 0;
     while (not eof(f)) do begin
              inc(I);
              readln(f,num,name);

              delete(name,1,1);
              for J := 1 to num do begin
                  inc(deckpos);
                  list.card[deckpos].name := name;
                  list.card[deckpos].is_tapped := FALSE;
                  list.card[deckpos].counters := 0;
              end;
     end;

     close(f);
     list.numcards := deckpos;
end;

procedure print_cardlist(list : Cardlist; ident : char);
var
   I : integer;
begin
     for I := 1 to list.numcards do begin
         write('  ',ident,I,' ',list.card[I].name);
         if list.card[I].is_tapped then
            write(' (Tapped)');
         if list.card[I].counters > 0 then
            write(' counters:',list.card[I].counters);
         writeln;
     end;
end;

procedure map_delete(which : integer; var list : cardlist );
var
   temp : Cardlist;
   num,cntr, I : integer;
begin
     cntr := 0;
     init_cardlist(temp);
     for I := 1 to list.numcards do begin
           if not (I = which) then begin
              inc(cntr);
              temp.card[cntr] := list.card[I];
           end;
     end;
     list.card := temp.card;
     list.numcards := list.numcards - 1;
end;

procedure shuffle_deck;
var
   I,J,num : integer;
begin
     randomize;
     num := deck.numcards;
     writeln('Shuffling ',num,' cards.');
     for I := 1 to 1000 do
         for J := 1 to num do begin
              swapem(deck.card[1 + random(num)],deck.card[1 + random(num)]);
         end;
end;

procedure move(what : integer; var from : Cardlist; var Dest : cardlist);
begin
     dest.card[dest.numcards + 1] := from.card[what];
     map_delete(what,from);
     inc(dest.numcards);
end;

procedure draw(amt : integer);
var
   I : integer;
begin
if amt <= deck.numcards then begin
   for I := 1 to amt do
       move(1,deck,hand);
   writeln('You draw ',amt,' cards from your deck.');
end else
    writeln('You don''t have that many cards left.');
end;

procedure play(which : integer);
begin
     writeln('You play #',which,' ',hand.card[which].name,'.');
     move(which,hand,inplay);
end;

procedure discard(which : integer);
begin
     writeln('You discard ',hand.card[which].name,'.');
     move(which,hand,graveyard);
end;

procedure bury(which : integer);
begin
     writeln('You bury ',inplay.card[which].name,'.');
     move(which,inplay,graveyard);
end;

procedure pickup(var from: Cardlist; which : integer);
begin
     move(which,from,hand);
end;

procedure cast(which : integer);
begin
         writeln('You cast ',hand.card[which].name,'.');
         move(which,hand,graveyard);
end;

procedure show_hand;
begin
     writeln('Your hand is: ');
     print_cardlist(hand,Handid);
end;

procedure show_play;
begin
     writeln('Inplay:');
     print_cardlist(inplay,Inplayid);
end;

procedure show_graveyard;
begin
     writeln('Graveyard:');
     print_cardlist(graveyard,Graveyardid);
end;

procedure lose(amt : integer);
begin
     life := life - amt;
     writeln('You lose ',amt,' life. You are now at ',life,' life.');
end;

procedure gain(amt : integer);
begin
     life := life + amt;
     writeln('You gain ',amt,' life. You are now at ',life,' life.');
end;

procedure tap(which : integer);
begin
        inplay.card[which].is_tapped := true;
        writeln('You tap ',inplay.card[which].name,'.');
end;

procedure untap(which : integer);
begin
        inplay.card[which].is_tapped := false;
        writeln('You untap ',inplay.card[which].name,'.');
end;

procedure add_counters(which : integer; amt : integer);
begin
        inplay.card[which].counters := inplay.card[which].counters + amt;
        writeln('You add ',amt,' counters to ',inplay.card[which].name,'.');
end;

procedure remove_counters(which : integer; amt : integer);
begin
     inplay.card[which].counters := inplay.card[which].counters - amt;
     writeln('You remove ',amt,' counters from ',inplay.card[which].name,'.');
end;

procedure upkeep;
begin
     writeln('You enter you upkeep phase.');
end;

procedure done;
begin
     writeln('You end your turn.');
end;

Procedure User_Inst;
   Begin
      Writeln('The commands that this program will recognize are : ');
      Writeln('   shuffle : Shuffles the deck ');
      Writeln('   draw : Draw cards ');
      Writeln('   play : Plays a card ');
      Writeln('   hand : Shows your hand ');
      Writeln('   graveyard : Shows your graveyard ');
      Writeln('   upkeep : Enters upkeep phase ');
      Writeln('   inplay : Shows cards in play ');
      Writeln('   lose : Lose X life ');
      Writeln('   gain : Gain X life ');
      Writeln('   tap : taps card ');
      Writeln('   untap : untaps card ');
      Writeln('   add counters : add counters to card ');
      Writeln('   remove counters : remove counters from card ');
      Writeln('   redisplay : show the commands again ');
      Writeln('   bury : bury a card ');
      Writeln('   discard : discard a card ');
      Writeln('   quit : Ends your turn ');
   End;

procedure input_handler;
var
   done : boolean;
   tp1, input : string[30];
   ip1        : integer;
   cp1        : char;
begin
     writeln;
     writeln('Entering command mode.');
     User_Inst;
     done := false;
while (not done) do begin
      write('Command: ');
      readln(input);

      if input = 'quit' then done := true
      else if input = 'shuffle' then shuffle_deck
      else if input = 'upkeep' then upkeep
      else if input = 'hand' then show_hand
      else if input = 'inplay' then show_play
      else if input = 'graveyard' then show_graveyard
      else if input = 'redisplay' then User_inst
      else if input = 'draw' then begin
           write('How many cards? : ');
           readln(ip1);
           draw(ip1);
      end
      else if input = 'gain' then begin
           write('How much life? : ');
           readln(ip1);
           gain(ip1);
      end
      else if input = 'lose' then begin
           write('How much life? : ');
           readln(ip1);
           lose(ip1);
      end
      else if input = 'play' then begin
           show_hand;
           write('Which card? : ');
           readln(cp1,ip1);
           if not (cp1 = Handid) then
              writeln('You can only play from your hand.')
           else
              play(ip1);
      end

      else if input = 'tap' then begin
           write('Which card? : ');
           readln(cp1,ip1);
           tap(ip1);
      end
      else if input = 'untap' then begin
           write('Which card? : ');
           readln(cp1,ip1);
           untap(ip1);
      end
      else if input = 'add counters' then begin
           write('Which card? : ');
           readln(cp1,ip1);
           write('How many counters? : ');
           readln(amt);
           add_counters(ip1,amt);
      end
      else if input = 'remove counters' then begin
           write('Which card? : ');
           readln(cp1,ip1);
           write('How many counters? : ');
           readln(amt);
           remove_counters(ip1,amt);
      end
      else if input = 'bury' then begin
           show_play;
           write('Which card? : ');
           readln(cp1,ip1);
           bury(ip1);
      end
      else if input = 'discard' then begin
           show_hand;
           write('Which card? : ');
           readln(cp1,ip1);
           discard(ip1);
      end
      else if input = 'cast' then begin
           show_hand;
           write('Which card? : ');
           readln(cp1,ip1);
           cast(ip1);
      end
      else if input = 'pickup' then begin
           write('Which card? : ');
           readln(cp1,ip1);
           case cp1 of
                Handid : Writeln('You can''t pickup from yuor hand stupid.');
                Inplayid: pickup(inplay,ip1);
                Graveyardid: pickup(graveyard,ip1);
           end;
      end;

end;
end;


begin
clrscr;
     writeln('MAGIC: The Gathering. Net-game Player v.001');
     writeln('Copyright 1996 - Hypnosis Productions');
     writeln;

     life := 20;
     init_cardlist(deck);
     init_cardlist(hand);
     init_cardlist(inplay);
     init_cardlist(graveyard);
     load_deckfile(deck);
     input_handler;
end.