DECLARE SUB inputy ()
DECLARE SUB graph ()
DECLARE SUB setscrn ()

COMMON SHARED clrgrf$

OPEN "clrgrf.yon" FOR INPUT AS #1
INPUT #1, clrgrf$
CLOSE #1

CLS
SCREEN 12
COLOR 10

WHILE p% <> 4

    LOCATE 5, 34
    PRINT "Graphing Tool"
    LOCATE 8, 35
    PRINT "1) Input Y"
    LOCATE 10, 36
    PRINT "2) Graph"
    LOCATE 12, 32
    PRINT "3) Screen Options"
    LOCATE 14, 33
    PRINT "4) Clear Graph"
    LOCATE 16, 37
    PRINT "5) Exit"
   
    DO

        kbd$ = INKEY$

    LOOP UNTIL kbd$ <> ""

    p% = VAL(kbd$)

    SELECT CASE p%

        CASE 1

            inputy
            CLS
            COLOR 10

        CASE 2

            IF clrgrf$ = "yes" THEN

                CLS
                COLOR 9
                PRINT "There are no equations to graph"
                PRINT "Go to Input Y on the main menu"
                PRINT "Press any key to continue. . ."
                SLEEP
                RUN
           
            END IF

            graph
            CLS
            COLOR 10

        CASE 3

            setscrn
            CLS
            COLOR 10

        CASE 4

            CLS
            COLOR 1
            INPUT "Clear all graphs"; cag$
            IF UCASE$(cag$) = "YES" THEN KILL "graphs.sav"
            OPEN "graphs.sav" FOR OUTPUT AS #1
            CLOSE #1
            clrgrf$ = "yes"
            OPEN "clrgrf.yon" FOR OUTPUT AS #1
            PRINT #1, clrgrf$
            CLOSE #1
            RUN

        CASE 5

            SCREEN 0
            SYSTEM
            END

    END SELECT

    CLEAR

WEND

END
SYSTEM

SUB graph

    CLS
    COLOR 8

    OPEN "scrnset.up" FOR INPUT AS #1
    INPUT #1, xmax%, xmin%, ymax%, ymin%, grid$
    CLOSE #1

    WINDOW (xmin%, ymax%)-(xmax%, ymin%)

    IF UCASE$(grid$) = "ON" THEN

        LINE (xmin%, 0)-(xmax%, 0)
        LINE (0, ymin%)-(0, ymax%)

    END IF
   
    COLOR 4

    OPEN "cnt" FOR INPUT AS #1
    INPUT #1, i
    CLOSE #1
    OPEN "graphs.sav" FOR INPUT AS #1
   
    FOR q = 1 TO i

        INPUT #1, a%, b%, c%, d%, e%

        FOR x = xmin% TO xmax% STEP .1
   
            y = a% / b% * (x + c%) ^ d% + e%

            IF x = xmin% THEN PSET (x, y)
   
            LINE STEP(0, 0)-(x, y)

        NEXT x

    NEXT q

    CLOSE #1

    SLEEP
    
END SUB

SUB inputy

    DIM a%(100), b%(100), c%(100), d%(100), e%(100)

    CLS
    COLOR 12
   
    i = 0

    IF clrgrf$ = "no" THEN

        OPEN "graphs.sav" FOR INPUT AS #1

        DO
           
            i = i + 1

            INPUT #1, a%(i), b%(i), c%(i), d%(i), e%(i)
           
            PRINT "y ("; i; ") ="; a%(i); " / "; b%(i); " ( x +"; c%(i); " ) ^"; d%(i); "+"; e%(i)
            PRINT

        LOOP UNTIL EOF(1)

        CLOSE #1

    END IF

    i = 0

    DO
       
        i = i + 1

        PRINT "Use the following formula: y=a/b(x + c)^d+e"
        PRINT "To edit a certain equation, type `edit n'"
        PRINT "where n represents the y value."
        PRINT "Type `end' to end. . ."
        INPUT "Enter a: ", a$
   
        IF UCASE$(a$) = "END" THEN EXIT DO ELSE a%(i) = VAL(a$)
        IF UCASE$(LEFT$(a$, 4)) = "EDIT" THEN

            i = VAL(RIGHT$(a$, 2))
            INPUT "Enter a: ", a%(i)

        END IF

        INPUT "Enter b: ", b%(i)
        INPUT "Enter c: ", c%(i)
        INPUT "Enter d: ", d%(i)
        INPUT "Enter e: ", e%(i)
        PRINT

    LOOP UNTIL UCASE$(a$) = "END"

    OPEN "graphs.sav" FOR APPEND AS #1
   
    i = i - 1

    FOR t = 1 TO i

       PRINT #1, a%(t), b%(t), c%(t), d%(t), e%(t)
   
    NEXT t

    CLOSE #1

    clrgrf$ = "no"
   
    OPEN "clrgrf.yon" FOR OUTPUT AS #1
    PRINT #1, clrgrf$
    CLOSE #1
    OPEN "cnt" FOR OUTPUT AS #1
    PRINT #1, i
    CLOSE #1

END SUB

SUB setscrn

    OPEN "scrnset.up" FOR INPUT AS #1
    INPUT #1, xmax%, xmin%, ymax%, ymin%, grid$
    CLOSE #1

    CLS
    COLOR 6
   
    WHILE p% <> 6

        LOCATE 5, 33
        PRINT "Screen Options"
        LOCATE 8, 34
        PRINT "1) X Max"; xmax%; "   "
        LOCATE 10, 34
        PRINT "2) X Min"; xmin%; "   "
        LOCATE 12, 34
        PRINT "3) Y Max"; ymax%; "   "
        LOCATE 14, 34
        PRINT "4) Y Min"; ymin%; "   "
        LOCATE 16, 35
        PRINT "5) Grid "; grid$; "   "
        LOCATE 18, 37
        PRINT "6) Exit"
    DO

        kbd$ = INKEY$

    LOOP UNTIL kbd$ <> ""

    p% = VAL(kbd$)

    SELECT CASE p%

        CASE 1

            LOCATE 22, 37
            INPUT "X Max=", xmax%

        CASE 2

            LOCATE 22, 37
            INPUT "X Min=", xmin%

        CASE 3

            LOCATE 22, 37
            INPUT "Y Max=", ymax%

        CASE 4

            LOCATE 22, 37
            INPUT "Y Min=", ymin%

        CASE 5

            LOCATE 22, 36
            INPUT "Grid (On/Off)", grid$

        CASE 6

            OPEN "scrnset.up" FOR OUTPUT AS #1
            PRINT #1, xmax%, xmin%, ymax%, ymin%, grid$
            CLOSE #1

            EXIT SUB

    END SELECT

    LOCATE 22, 36
    PRINT SPACE$(20)

WEND

END SUB

