;*************************************************************************
; DICEGAME v.5 beta
; 
; by Doug Melton
;
; started     : 5/28/97
; last updated: 5/29/97
;
;*************************************************************************

#include "ti-85.h"

.org 0
.db "Dice Game v.5 by DM",0

;*************************************************************************
;;;Game Variables
randNum         = TEXT_MEM      ; Byte

asciiNumb       = TEXT_MEM+1    ; 6 Bytes       } 
tmp             = TEXT_MEM+1    ; Word          } temporary storage
die             = TEXT_MEM+4    ; byte          }

score           = TEXT_MEM+7    ; byte

arrow           = TEXT_MEM+8    ; byte number under which arrow is
arrowX          = TEXT_MEM+9    ; byte position of arrow (x-coord)

roll            = TEXT_MEM+10   ; byte current dice roll

pieces          = TEXT_MEM+11   ; 12 bytes, the individual pieces

;*************************************************************************
;main program

top:
        ld      a, 4
        out     (5), a

        ld      a, 1
        ld      (arrow), a

        ld      a, 78
        ld      (Score), a

;;;show title screen
titleScrn:
        ROM_CALL(CLEARLCD)
        set     3, (IY+5)

        ld      de, (PROGRAM_ADDR)

        ld      bc, $0002
        ld      (CURSOR_ROW), bc
        ld      hl, strTitle
        add     hl, de
        ROM_CALL(D_ZT_STR)                      ;display title stuff

        ld      hl, LowScore
        add     hl, de
        call    LD_HL_MHL
        CALL_(  DisplayNumber)                  ;display their score

        ld      hl, LowScrName0
        add     hl, de
        ROM_CALL(D_ZT_STR)                      ;display Low score name

        res     3, (IY+5)
titleScrnWait:
        call    GET_KEY
        or      a
        jr      z, titleScrnWait


startOfGame:
        ROM_CALL(CLEARLCD)
        ld      bc, $0506
        ld      hl, strNumbers
        CALL_(  DisplayMenuTxt)                 ;display 1-12

        ld      bc, $0007
        ld      (CURSOR_ROW), bc
        ld      hl, strScore
        add     hl, de
        ROM_CALL(D_ZT_STR)                      ;display "Score: "

displayScore:
        ld      bc, $0707
        ld      (CURSOR_ROW), bc
        ld      hl, Score
        call    LD_HL_MHL
        CALL_(  DisplayNumber)                  ;display their score

        ld      a, (arrow)
        sla     a
        ld      c, a
        sla     a
        sla     a
        add     a, c
        sub     4
        ld      (arrowX), a
        ld      c, a

        ld      b, $0C
        ld      hl, strArrow
        CALL_(  DisplayMenuTxt)                 ;display arrow

        ld      a, (roll)
        or      a
        ld      b, 2                            ;if they have 0 as a dice roll...
        CALL_Z( RollDice)                       ;roll dice

        ld      a, (roll)                       ;check for game over
        ld      b, a
        ld      hl, pieces
gameOverLoop:
        ld      a, (hl)
        or      a
        jr      z, noGameOver
        inc     hl
        djnz    gameOverLoop

        jr      gameOver
noGameOver:
;;;temp
;        ld      bc, $0404
;        ld      (CURSOR_ROW), bc
;        ld      hl, (roll)
;        CALL_(  DisplayNumber)                  ;display their score
;;;temp

keyLoop:
        halt
        call    GET_KEY
        cp      K_EXIT
        jr      z, quit
        cp      K_LEFT
        jr      z, left
        cp      K_RIGHT
        jr      z, right
        cp      K_SECOND
        jr      z, enter
        jr      keyLoop

gameOver:
        ld      a, (score)
        ld      b, a
        ld      a, (roll)
        add     a, b
        ld      (score), a
        CALL_(  LowScoreHand)
quit:
        call    GET_KEY                         ;take last key out of buffer
        ret                                     ;quit game

left:
        ld      a, (arrow)
        dec     a
        or      a
        jr      nz, rightLeft
        ld      a, 12
        jr      rightLeft

right:
        ld      a, (arrow)
        inc     a
        cp      13
        jr      nz, rightLeft
        ld      a, 1

rightLeft:
        ld      (arrow), a
        
        ld      a, (arrowX)
        ld      c, a

        ld      b, $0C
        ld      hl, strBlanks
        CALL_(  DisplayMenuTxt)                 ;display arrow
        JUMP_(  DisplayScore)

enter:
        ld      bc, (arrow)                     ;c is the selected number
        ld      b, 0
        ld      hl, pieces-1
        add     hl, bc
        ld      a, (hl)
        or      a
        jr      nz, enter2                      ;they've already taken that piece

        ld      a, (roll)
        cp      c
        jr      c, enter2                       ;their roll isn't high enough
        sub     c
        ld      (roll), a

        dec     (hl)

        ld      a, (score)
        sub     c
        ld      (score), a

        ld      b, $05
        ld      a, (arrowX)
        sub     2
        ld      c, a
        ld      hl, strBlanks
        CALL_(  DisplayMenuTxt)                 ;display arrow

enter2:
        JUMP_(  DisplayScore)


;********************* the dice rolling routine **************************
;Description:   rolls some dice
;Parameters:    b, number of dice
;Destroys:      a, bc, de, hl

rollDice:
        ld      hl, VIDEO_MEM+$01D4
        ld      c, 0
rollDice2:
;Chris Busch's Random Routine:
        ld      a, (randNum)
        ld      d, a                             
        sla     d
        sla     d
        add     a, d
        sla     d
        sla     d
        add     a, d
        ld      d, a
        ld      a, r
        add     a, d
        ld      (randNum), a
;;;end of the random routine
        and     7
        cp      7
        jr      z, rollDice2
        or      a
        jr      z, rollDice2

	CALL_(	DispDie)
        inc     hl
        inc     hl
        inc     hl

        add     a, c
        ld      c, a
        djnz    rollDice2

        ld      (roll), a

        ret

;***************  Display Die Routine  ***********************************
;Description:   Display die defined by register a
;Parameters:    hl - address of upper-left of die (die is 3 bytes wide)
;               a - number on die
;Destroys:      de

DispDie:            
        push    af
        push    bc
        push    hl
        ld      (die), a
        ld      c, a

        ld      a, $01
        ld      (tmp), a
        ld      a, $80
        ld      (tmp+2), a
        ld      a, $FF
        CALL_(  DispDieLoad3)
        ld      a, $02
        ld      (tmp), a
        ld      a, $40
        ld      (tmp+2), a
        xor     a
        CALL_(  DispDieLoad3)

        ld      b, 3
DispDieLoop:
        ld      (tmp+1), a
        push    hl
        ld      hl, tmp+1
        ld      a, b
        cp      1
        jr      z, DDrow3
        cp      2
        jr      z, DDrow2
DDrow1:
        ld      a, c
        cp      1
        jr      z, DDLoopDraw
        set     6, (hl)
        set     7, (hl)
        cp      4
        jr      c, DDLoopDraw
        set     0, (hl)
        set     1, (hl)
        cp      6
        jr      nz, DDLoopDraw
        set     3, (hl)
        set     4, (hl)
        jr      DDLoopDraw
DDrow2:
        ld      a, c
        bit     0, a
        jr      z, DDLoopDraw
        set     3, (hl)
        set     4, (hl)
        jr      DDLoopDraw
DDrow3:
        ld      a, c
        cp      1
        jr      z, DDLoopDraw
        set     0, (hl)
        set     1, (hl)
        cp      4
        jr      c, DDLoopDraw
        set     6, (hl)
        set     7, (hl)
        cp      6
        jr      nz, DDLoopDraw
        set     3, (hl)
        set     4, (hl)
DDLoopDraw:
        ld      a, (tmp+1)
        pop     hl
        CALL_(  DispDieLoad3)
        CALL_(  DispDieLoad3)
        xor     a
        CALL_(  DispDieLoad3)
        djnz    DispDieLoop

        ld      a, $01
        ld      (tmp), a
        ld      a, $80
        ld      (tmp+2), a
        ld      a, $FF
        CALL_(  DispDieLoad3)

        pop     hl
        pop     bc
        pop     af
        ret

DispDieLoad3:
        ld      (tmp+1), a
        push    bc
        ex      de, hl
        ld      hl, tmp
        ld      bc, 3
        ldir
        ex      de, hl
        ld      de, 13
        add     hl, de
        pop     bc
        ret


;******************* Display Text routines **************************
;Description:   Displays zero terminated text on the screen
;               in menu format
;Parameters:    hl - address of zero terminated string
;                    relative to top of program
;               bc - location on screen
;Destroys:      bc, de, hl

DisplayMenuTxt:
        ld      (CURSOR_X), bc
        ld      de, (PROGRAM_ADDR)
        add     hl, de
        ROM_CALL(D_ZM_STR)
        ret

;******************* Display Number routine *************************
;Description:   Displays a 2 digit number on the screen in text format
;Parameters:    hl - number to display (actually, l)
;               de - location on screen
;Destroys:      a, b, de, hl

DisplayNumber:
        ld      h, 0
        push    de
        ld      de, asciiNumb+5
        ld      b, 2
DispNumbLoop:
        dec     de
        call    UNPACK_HL
        add     a, '0'
        ld      (de), a
        djnz    DispNumbLoop

        ex      de, hl
        pop     de
        ROM_CALL(D_ZT_STR)
	ret

;-----------------------------------------------------------------------------
;Handle Low-score
;-----------------------------------------------------------------------------
LowScoreHand:
        ROM_CALL(CLEARLCD)
        ld      de, (PROGRAM_ADDR)
        ld      hl, LowScore
        add     hl, de
        ld      a, (Score)                      ;(hl) contains Lowscore, a actual score
        
        cp      (hl)
        ret     nc                              ;they don't have a Low score

        ld      hl, ZS_BITS
        set     0, (hl)                         ;make zshell recalc. checksum

        ld      hl, (PROGRAM_ADDR)
        ld      de, LowScore
        add     hl, de
        ld      (hl), a

        ld      hl, $0300
        ld      (CURSOR_ROW), hl
        ld      de, (PROGRAM_ADDR)
        ld      hl, LowScr
        add     hl, de
        ROM_CALL(D_ZT_STR)
        ld      hl, $0A1F
        ld      (CURSOR_X), hl
        ld      hl, EnterInit
        add     hl, de
        ROM_CALL(D_ZM_STR)
        ld      hl, $0803
        ld      (CURSOR_ROW), hl
        ld      hl, (PROGRAM_ADDR)
        ld      de, LowScrName
        add     hl, de                          ;hl points to Low-score name
        ld      b, 3
InitLoop:
        CALL_(  GetLetter)
        ld      (hl), a
        inc     hl
        djnz    InitLoop
        ret

;-----------------------------------------------------------------------------
;GetLetter: gets a letter(magnus hagander)
;-----------------------------------------------------------------------------
GetLetter:
        push    hl
        push    bc
        ld      hl,(PROGRAM_ADDR)
        ld      de,ASCII_Table-1                ;Point to one before, since we always inc once
        add     hl,de                           ;HL now points right
ConvertLoop:
        push    hl
        call    GET_KEY                         ;ACC holds key
        pop     hl
        and     a
        jr      z, ConvertLoop
        push    hl                              ;save away...
        ld      b, a
        ld      c, 0
ConversionLoop:
        inc     hl
        djnz    ConversionLoop                  ;After this, we have the correct offset...
        ld      a, (hl)
        pop     hl
        and     a
        jr      z, ConvertLoop                  ;Invalid key
        ROM_CALL(TX_CHARPUT)                    ;Show the char
        pop     bc
        pop     hl
        ret                                     ;Value is in acc

;*************************************************************************
Strings:
strTitle:       .db "      Dice Game      "
                .db "   by Doug Melton    "
                .db " <dx4@smartlink.net> "
strLowScore:    .db "Low "
strScore:       .db "Score: ",0

LowScr:         .db "NEW LOW SCORE!",0
EnterInit:      .db "ENTER YOUR INITIALS:",0
LowScore:       .db 78                          ;This is standard Low-score
LowScrName0:    .db " by "
LowScrName:     .db "DUG"
LowScrName1:    .db " "

ASCII_Table:                        ;Thanks to Magnus H. for this Table!!!
                .db 0,0,0,0,0,0,0,0,0,'X','T','O','J','E'
                .db 0,0,' ','W','S','N','I','D',0,0,'Z'
                .db 'V','R','M','H','C',0,0,'Y','U','Q'
                .db 'L','G','B',0,0,0,0,'P','K','F','A'
                .db 0,0,0,0,0,0,0,0,0,0,0

strNumbers:     .db "1      2      "
                .db "3      4      "
                .db "5      6      "
                .db "7      8      "
                .db "9    10  11  12",0

strArrow:       .db $1E,0
strBlanks:      .db "       ",0

.end

