; Space Invaders v1.2
; by David Lenhart

; I haven't discovered any bugs in this program, but I'll have 
; to admit it is a bit messy.  The Put8x5 routine may be useful 
; to you.  I haven't compared it to any other routines, but I 
; optimized it as best I could, and it should be fast.
; 
; This program copies many subroutines to graphics mem for faster calling.

; IMPROVEMENTS OVER v1.1
; - Allows you to skip the demo between levels.
; - Game speed is more constant when moveing left or right.
; - UFO end guy is tougher to kill now.

#include "ti-85.h"
.org 0
.db "Space Invaders  1.2",0

ArriveMem =     GRAPH_MEM
invPic =        ArriveMem+($10*11)
gunPic =        invPic+5
Put8x5 =        gunPic+5
divide =        Put8x5+59  ;59=size of routine
multiply =      divide+7
PutShields =    multiply+8
PutPiece =      PutShields+40
delay =         PutPiece+17
DrawBullet =    delay+8
dot =           DrawBullet+60
DetectHit =     dot+10
move =          DetectHit+12
Space =         move+11
Invaders =      Space+6
ByDavidLenhart = Invaders+9
YouWin  =       ByDavidLenhart+17
Zero =          YouWin+9-1
RotateUFO =     YouWin+9
UFO =           RotateUFO+47
ScreenOff =     UFO+(11*4)
ScreenOn =      ScreenOff+12
KillPlayer =    ScreenOn+9
BigText =       KillPlayer+10
DrawRow =       BigText+131
PutUFO =        DrawRow+25
Shifteroo =     PutUFO+27
o =             Shifteroo+12
StartPixel =    o
RandNum =       o+1
DestroyTimer =  o+2
ContrastLev =   o+3
ShotTimer =     o+4
DownCount =     o+5
playerLife =    o+6
RotateByte =    o+7
ExplXY =        o+8
ExplY =         ExplXY
ExplX =         ExplY+1
X =             ExplXY+2
invLeft =       o+11
invDir =        o+12
invDelay =      o+13
invTimer =      o+14
invRows =       o+15
InvThisLevel =  o+16 
invXY =         o+17 
invY =          invXY
invX =          invY+1
Bullets =       invXY+2                   ;3 bytes for: y, x, direction
pBullets =      Bullets+(maxBullets*3)       ; 2 bytes for y, x
gunXY =         pBullets+(pMaxBullets*2)
gunY =          gunXY
gunX =          gunY+1
shields =       gunXY+2
invExist =      shields+(ShieldHeight*6)           ; 6 8-bit wide shields


ShieldHeight = 5
alive = 1
dead = 0
pMaxBullets = 8
maxBullets = 7
FireButton =    $36
invXspacing =   13
invYspacing =   8
invPerRow =     6
invMax =        6*6
FiringDelay =   7
ShieldAltitude = 13
cursor = $800C

        ld a, 4        
        out (5), a

        ld hl, (PROGRAM_ADDR)
        ld de, pic1
        add hl, de
        ld de, invPic
 ld bc, 5+5+59+7+8+40+17+8+60+10+12+11+6+9+17+9+47+44+12+9+10+131+25+27+12
        ldir                    ; copy stuff to fixed mem
        
        ROM_CALL(ClearLCD)

        ld hl, Space
        ld b, (6*5)-1
        ld de, ((127-(12*5))/2)*$100+$2C
        call BigText

        ld hl, Invaders
        ld b, (6*8)-1
        ld de, ((127-(12*8))/2)*$100+$1C
        call BigText

        ld hl, $3925
        ld ($8333), hl
        ld hl, ByDavidLenhart
        ROM_CALL(D_ZM_STR)
        ld de, $FEA6
        call PutUFO
        ld hl, ($100*(48-21))+16+6
        ld (invXY), hl

rotate:
        call RotateUFO
        ld bc, $2000
        call delay
        call GET_KEY
;        ld a, (KEY_0)
        or a                    ; set flag
        jr z, rotate
        cp $37                   ; exit
        ret z

        xor a                   ;a=0
        ld (invRows), a         ; Starting level-1

NewLevel:        
        ld a, (invRows)
        inc a
        ld (invRows), a
        cp 7
        JUMP_Z(Winner)
        ROM_CALL(ClearLCD)
        cp 6
        CALL_NZ(invUnload)
LevelStart:
        ld a, alive
        ld (PlayerLife), a
        
        ROM_CALL(ClearLCD)
        ld a, (invRows)
        ld c, a
        ld b, invPerRow
        call multiply         ;a=b*c
        ld (invLeft), a
        ld (InvThisLevel), a

        ld hl, invExist
        ld (hl), alive
        ld de, invExist+1
        ld bc, invMax-1
        ldir                            ; rejuvenate invaders


        ld hl, pBullets
        ld (hl), 64
        ld de, pBullets+2
        ld bc, 2*(pmaxbullets-1)
        ldir                            ; set all player bullets offscreen
        
        ld hl, Bullets
        ld (hl), 64
        ld de, Bullets+3
        ld bc, 3*(maxbullets-1)
        ldir                            ; set all invader bullets offscreen

        ld  hl, shields                 
        ld (hl), 11111111b
        ld de, shields+1
        ld bc, (6*Shieldheight)-1
        ldir                            ; start with all shields solid
        call PutShields

        ld bc, $3C05
        ld (gunXY), bc
        ld de, gunPic
        call Put8x5
        
        ld a, (invRows)
        cp 6                    ; level 6 = end level
        push af
        CALL_Z(UFOArrive)
        ld a, (127-((invXspacing*invPerRow)-(invXspacing-7)))/2
        ld (invX), a
        ld a, 63
        ld (invY), a
        pop af
        CALL_NZ(invArrive)
        
        
        ld a, (invRows)
        inc a
        ld b, a
        ld a, 63
        call divide           ; c=a/b   a+b=remainder
        ld a, 1
        ld hl, bullets
drawnext:                       ; spread out bullets evenly
        push bc
        ld (hl), a
        ld c, a
        inc hl
        ld b, 2
        ld (hl), b
        inc hl
        ld (hl), 0
        inc hl
        push af
        call DrawBullet
        pop af
        pop bc
        add a, c
        djnz drawnext

        ld a, r
        and 2
        dec a                   ; random  -1 or 1
        ld (invDir), a
        ld a, 6
        ld (invDelay), a

      
        xor a
        ld (ShotTimer), a
        ld (DownCount), a
Shift:
        ld a, (DownCount)
        or a
        jr z, SkipDown
        dec a
        ld (DownCount), a
        CALL_(ShiftDown)
        jr SkipLeftRight
SkipDown:
        ld a, (invDir)
        push af
        inc a
        CALL_Z(ShiftLeft)               ;if a was -1
        pop af
        dec a
        CALL_Z(ShiftRight)              ;if a was 1
SkipLeftRight:
        call PutShields

        ld a, (invDelay)
        ld (invTimer), a
ActionLoop:
        ld a, (invRows)
        cp 6
        jr nz, SkipRotate
        call RotateUFO
SkipRotate:
        ld a, (PlayerLife)
        or a
        jr nz, SkipDestroy
        ld bc, (gunXY)
        ld de, GRAPH_MEM+256    ; use program instructions in graph mem
        ld a, r                 ; as graphic for explosion
        add a, e
        ld e, a
        ld a, r
        and 3
        add a, c
        ld c, a
        ld a, r
        and 3
        sub 2
        add a, b
        ld b, a
        call Put8x5               ;draw trash
        ld hl, DestroyTimer
        dec (hl)
        JUMP_Z(LevelStart)
        ld a, 250
        ld (invTimer), a
        JUMP_(DisableMoves)
SkipDestroy:
        ld a, 10111111b
        out (1), a
        in a, (1)
        bit 6, a                ; exit?
        jr nz, SkipExit
        call GET_KEY
        ret
SkipExit:
          ld hl, ShotTimer      ;recently added
        bit 5, a                ; 2nd = Fire Button
        jr nz, NoShot
        ld a, (hl)
        or a
        jr nz, NoShot
        ld a, FiringDelay
        ld (hl), a
          push hl               ;recently added
        ld hl, pBullets-2
SearchAgain:
        inc hl
        inc hl          ; 2 bytes, 1 for Y and 1 for X
        bit 6, (hl)
        jr z, SearchAgain       ; find an unused bullet
        
        ld c, 6                 ; bullet starts out at height of 6
        ld (hl), c              ; save Y coord
        inc hl
        ld a, (gunX)
        add a, 3
        ld b, a
        ld (hl), b              ; save X coord
        call DrawBullet
          pop hl                ;recently added
NoShot:
          ;;ld hl, ShotTimer    ;recently changed
        ld a, (hl)
        or a
        jr z, GunReady
        dec (hl)
GunReady:
        ld bc, (gunXY)
        ld a, 11111110b
        out (1), a
        in a, (1)
          push af        ; RECENT
          ld e, a
        and 00000110b
        cp 00000110b
        jr nz, pressedLorR
        push bc
        ld bc, $400
        call delay
        pop bc
pressedLorR:
          ld a, e
        bit 1, a        ;left
        jr nz, NotLeft
        ld de, gunPic
        call Put8x5
        ld a, b
        cp 1
        jr z, nope1        ; getting close to edge of screen?
        dec b
nope1:
        ld de, gunPic
        call Put8x5
NotLeft:
          pop af           ; RECENT
        bit 2, a        ;right
        jr nz, NotRight
        ld de, gunPic
        call Put8x5
        ld d, a         ;push
        ld a, b
        cp 127-7
        ld a, d         ;pop 
        jr z, nope2
        inc b
nope2:
        ld de, gunPic
        call Put8x5
NotRight:
        ld (gunXY), bc
DisableMoves:
        CALL_(DoBullets)
        JUMP_Z(NewLevel)       ; if level level has been won
        ld hl, invTimer
        dec (hl)
        JUMP_Z(Shift)

        ld bc, $940
        call delay
        JUMP_(ActionLoop)




DoBullets:
        ld hl, pBullets
        ld b, pMaxBullets
pGunLoop:
        push bc                 ; b = loop counter
        ld c, (hl)              ; Y
        ld a, c
        bit 6, c               ; off screen? 
        inc hl         ; adjust
        push bc
        ld bc, 200
        call nz, delay
        pop bc
        JUMP_NZ(BulletGone)
        dec hl
        ld a, c
        inc a
        cp 61
        jr nz, ok
        ld a, 64
ok:
        ld (hl), a              ; increment Y coord in mem
        inc hl
        ld b, (hl)              ; X

        push af
        call DrawBullet       ; erase
        pop af
        cp 64
        JUMP_Z(BulletGone)
        inc c
        call DrawBullet       ; redraw
        push hl                 ; save mem position in bullet info
        call DetectHit                ; z =hit, nz = miss
        JUMP_NZ(NoKills)
                                
        ld d, b                 ; bc,de = bulletXY
        ld e, c
        
        ld a, (invX)
        ld h, a
        ld a, d
        sub h                   ; a=bulletX-invX
        jr c, NoKills           ; bulletX-invX < 0
        
        ld b, a                 ; save a
        ld a, invPerRow*invXspacing
        sub b
        jr c, NoKills           ; bulletX > right side
        
        ld a, b                 ; b = bulletX-invaderX
     add a, 3           ; centering for UFO at end
        ld b, invXspacing
        call divide           ; c=a/b
        ld l, c                 ; save c  ; c=  # of inv in row
        add a, b                ; a+b=remainder
     sub 3
        ;;;;;;;;ld b, a                 ; b= leftover pixels
        ;;;;;;;;ld a, d                 ; d= bulletX    ; subtract extra pixels
        ;;;;;;;;sub b                   ; a= x coordinate of invader
                sub d   
                neg
        
        ld (ExplX), a


        ld a, (invY)
        sub e                   ; e= bulletY

        jr c, NoKills            ; bulletY>invY
        
        ;!!!!!!!!!!!
        ;ld b, a
        ;ld a, invPerCol*invYspacing
        ;sub b
        ;jr c, NoKills                  ; off the bottom
        ;ld a, b
        ;!!!!!!!!!!!

        ; ### Here a kill has occurred ###
        ld b, invYspacing
        call divide           ; c=a/b
        
        add a, b                   ; a+b=remainder
        ld b, a
        ld a, e                    ; e = bulletY
        add a, b                   ; find top of invader
                                   ; a= y coordinate of invader
        dec a                   ;#####
        ld (ExplY), a


        ld b, invPerRow
        ld a, c
        call multiply
                              ; l =  # of inv in row
        add a, l                ; a=invader#
        ;####################################################################
        ;cp (InvThisLevel)       ; check that it doesn't exceed
        push hl
        ld hl, InvThisLevel
        cp (hl)
        pop hl
        ;!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        jr nc, NoKills
        
        ld b, 0
        ld c, a
        ld hl, invExist
        add hl, bc              ; hl = invExist+a
        ld a, (hl)      
        or a                    ; invader alive?
        
        jr z, NoKills
        ld a, (invRows)
        cp 6
        jr z, SkipThisStuff
        ld (hl), 0      ; kill invader
        push de
        ld bc, (ExplXY)
        ld de, invPic
        call Put8x5
        pop de
SkipThisStuff:
        ld b, d                 ; get bullet coords
        ld c, e
        call DrawBullet
        pop hl
        push hl             ; hl = mem addr of bullet X value
        dec hl
        ld (hl), 64             ; remove used bullet

        ld a, (invRows)
        cp 6
        jr nz, skipUFOhelp
         ;;inc a           ; increase a little
         ;;inc a           ; increase a little more
         ;;sla a           ; double the denominater in delay
        ld a, (6+2)*2      ;16
skipUFOhelp:
        ld b, a
        ld a, (invLeft)
        dec a
        ld (invLeft), a

        call divide             ; c=a/b
        inc c
        ld a, c
        ld (invDelay), a        ;invLeft/invRows+1
NoKills:
        ld b, d
        ld c, e                 ; get bullet coords
        pop hl
        push hl
        dec hl                  ; hl = bullet Y
        CALL_(DoShield)

        pop hl
BulletGone:
        inc hl          ; set to next y
        pop bc
        ;djnz pGunLoop
        dec b
        JUMP_NZ(pGunLoop)
        
        ld a, (invLeft) 
        or a
        ret z           ; ###### if z then Level is complete
                        ; z must be set on return
        

; ============= Space Invader Bullets ===============

        ld hl, Bullets          ; (hl)=y, (hl+1)=x, (hl+2)=direction
        ld a, (invRows)         ; 1 bullet for each row
        inc a
BulletLoop:
        push af                 ; a = bullet counter
        ld c, (hl)              ; Y
        inc hl
        ld b, (hl)              ; X
        inc hl
        call DrawBullet       ; erase
        ;CALL_(pause)
        ld a, (hl)              ; a= direction of bullet
        bit 6, c                ; off screen?
        CALL_NZ(invShoot)       ; bc=xy; a=direction
        ld (hl), a              ; # save new direction
        add a, b
        cp 1
        jr nz, ok4
        ld c, 1
ok4:
        cp 126
        jr nz, ok5
        ld c, 1
ok5:    
        ld b, a                 ; b=X
        dec hl
        ld (hl), b              ; # save sew X coord
        dec c
        ld a, c
        jr nz, OnScreen
   ;;???      ld a, 64
        ld c, 64
OnScreen:
        dec hl
        ld (hl), c              ; # save new Y coord
        call DrawBullet
        ;CALL_(pause)
        ;inc hl
        ;inc hl
        ;inc hl
        
        call DetectHit
        jr nz, miss
        ld a, 7
        sub c
        jr c, miss      ; too far up to hit player
        ld a, b
        ld de, (gunXY)
        sub d
        jr c, miss      ; too far left to hit player
        sub 7
        jr nc, miss     ; too far right
        ld a, (PlayerLife)
        or a
        call nz, KillPlayer     ; if not already dead
Miss:
        push hl
        CALL_(DoShield)
        pop hl
        
        inc hl
        inc hl
        inc hl
        pop af
        dec a
        JUMP_NZ(BulletLoop)
        ld a, 1                 ; ###### if z then Level is complete
        or a                    ; ###### but not here
        ret
        
DoShield:                               ; hl = bullet Y to kill bullet
                                        ; if hit shield
                                ; bc = bullet (X,Y)
        ld a, b
        sub 24
        ret c
        cp 104-24               ; right end of last shield
        ret nc
        ;and 31
        bit 4, a                ; >15? (width of shield-1)
        ret nz
        ld a, ShieldAltitude
        sub c
        ret c
        cp ShieldHeight
        ret nc                  ; >4? (height of shield-1)
        push hl                 ;
        push af                 ; save a=line# of shield
        ROM_CALL(FIND_PIXEL)
        ld h, a                 ; save screen bit
        ld a, l
        and 15
        sub 3   
        ld l, a         ; a= byte# from left of screen
        srl a
        srl a           ; /4
        sla a           ; *2    ; 2 byte gap between shields
        sub l
        neg             ; a = l-a
        push bc
        ld c, a
        ld b, ShieldHeight
        call multiply
        pop bc
        ld e, a
        pop af
        add a, e
        ld d, 0
        ld e, a
        ld a, h                 ; restore screen bit
        ld hl, shields
        add hl, de              ; hl = addr of shield byte
        ld d, a
        and (hl)                ; check if piece of shield exists
        jr nz, FoundPiece
        pop hl
        ret
FoundPiece:
        ld a, d
        xor (hl)
        ld (hl), a              ; erase piece
        ROM_CALL(FIND_PIXEL)
        ld de, $FC00
        add hl, de
        xor (hl)
        ld (hl), a              ; toggle screen bit (could be reset if bullet
                                ; is near)
        call DrawBullet
        pop hl                  ;
        ld (hl), 64             ; kill bullet
        ret


invShoot:
        push hl
        ld hl, invExist
        ld a, (InvThisLevel)
        sub invPerRow
        ld d, 0
        ld e, a
        add hl, de

        ld a, r
;        rrca
        and 1
        ld (RandNum), a         ; for choosing search direction

        ld a, r
        ld b, invPerRow
        call divide           ; c=a/b   a+b=remainder
        add a, b                ; random col = r mod invPerRow
        ld d, 0    ;zeroed above
        ld e, a
        add hl, de
        
        ld c, a         ;col
RowLoop:
        ld de, -invPerRow
        ld a, (invRows)
        ld b, a
        ld a, alive
        push hl
FindLoop:
        cp (hl)
        jr z, Found             ; any in this row?
        add hl, de              ; check next row up
        djnz FindLoop           ; if 0 then column empty
        pop hl
        ld a, (RandNum)
        or a
        ld a, c                 ; !!
        jr z, GoRight
        dec c
        dec hl
        or a
        jr nz, RowLoop
        ld c, invPerRow-1       ; off left side; continue at right side
        ld a, (InvThisLevel)
        dec a
        jr Continue
GoRight:
        inc c
        inc hl
        cp invPerRow-1          ; row numbered 0..invPerRow-1
        jr nz, RowLoop
        ld c, 0                 ; off right; continue at left
        ld a, (invThisLevel)
        sub invPerRow
Continue:
        ld hl, invExist
        ld d, 0
        ld e, a
        add hl, de
        jr RowLoop
Found:
        pop de                  ; trash saved hl
                                ; hl = shooting invader + invExist

        ld de, invExist
        or a                            ; clear carry
        sbc hl, de                      ; hl = # of shooting invader
        ld a, l
        ld b, invPerRow
        call divide                   ; c=a/b   a+b=remainder
        ld de, (invXY)
        push bc
        add a, b
        ld b, a
        ld c, invXspacing
        call multiply
        add a, d                           ; a=x loc of inv bullet
        add a, 3                                ; center of invader
        ld d, a

        pop bc
        ld b, invYspacing
        call multiply
        ld b, a
        ld a, e
        sub b
        ld b, d                         ; b=X      <-- coords of new shot
        sub 3                           ; move down a little
        ld c, a                         ; c=Y
        ld de, (gunXY)
        ld a, b
        
        ;!!!!
        
        
        sub 4                   ; center of aa gun 8x8 pic
        sub d                   ; horiz dist between bullet and AA gun
        ld h, -1
        jr nc, Nright
        ld h, 1
Nright:
        jr nc, pos
        neg
pos:
        sla a                   ; a=a*2
        cp c                    ; 2*invX-gunX-vert dist
        jr nc, Nstraight
        ld h, 0
Nstraight:
        ld a, h
        pop hl
        ret



;############################################################################


ShiftLeft:
        ld hl, invX
        dec (hl)
        jr nz, SkipChgRight
        ld a, 1
        ld (invDir), a
        ld a, invYspacing
        ld (DownCount), a   ; prepare to move invaders down 1 row
SkipChgRight:
        ;ld d, 1
        ;ld e, 0              ;d=1 e=0 shift right
        ld de, 256
        CALL_(ShiftStuff)
        call PutShields
        ld hl, $FC00-1
Lshift:
        inc hl
        bit 2, h
        ret z
        sla (hl)
        jr nc, Lshift
        dec hl
        set 0, (hl)
        inc hl
        jr Lshift
        ;;;;;;;;call PutShields       ; done on return

ShiftRight:
        ld a, (invX)
        inc a
        ld (invX), a
        cp 127-(invPerRow-1)*invXspacing+5
        jr nz, SkipChgLeft
        ld a, -1
        ld (invDir), a
        ld a, invYspacing
        ld (DownCount), a   ; prepare to move invaders down 1 row
SkipChgLeft:
        ld d,-1
        ld e, 0                 ;d=-1 e=0 shift left
        CALL_(ShiftStuff)
        call PutShields

        ld hl, $FFFF+1
RShift:
        dec hl
        bit 2, h
        ret z
        srl (hl)
        jr nc, Rshift
        inc hl
        set 7, (hl)
        dec hl
        jr Rshift
        ;;;;;;;;call PutShields       ; done on return

ShiftDown:
        ld a, (invY)
        dec a
        ld (invY), a
        ld d, a
        
        ld a, (invThisLevel)
        ld b, 0
        ld c, a

        ld hl, invExist-1       
        add hl, bc              ; hl = addr of last invader
        ld a, alive
        cpdr                    ; search for lowest invader
        ld bc, -(invExist-1)
        add hl, bc
        ld a, l
        ld b, invPerRow
        call divide           ; c=a/b     ; c = rows left - 1

        ld b, invYspacing
        call multiply         ; a=b*c
        sub d
        neg                     ; a = d-a
        cp (ShieldAltitude-3)+invYspacing
        jr nz, ShieldsRemain
        call PutShields
        ld hl, Shields
        ld (hl), 0
        ld de, Shields+1
        ld bc, (6*ShieldHeight)-1
        ldir                    ; clear shield mem
ShieldsRemain:
        cp (-2)+invYspacing               ; check if invaders have landed
        call z, KillPlayer
        ld de, 1                ; move stuff up
        CALL_(ShiftStuff)
        call PutShields
        ld hl, $FFEF
        ld de, $FFFF
        ld bc, $3F0
        lddr                    ; move down one pixel
        ret
        ;;;;;;;;call PutShields       ; done on return

ShiftStuff:     ; de = shift x, shift y
        
        ld hl, Bullets
        ld b, maxBullets
LoopB:                  ; shift all invader bullets
        push bc
        ld c, (hl)
        inc hl
        ld b, (hl)
        inc hl
        inc hl          ; skip direction byte
        call DrawBullet
        ld a, b
        add a, d
        ld b, a
        ld a, c
        add a, e
        ld c, a
        call DrawBullet
        pop bc
        djnz LoopB

        
        ld hl, pBullets         ; move player bullets
        ld b, pMaxBullets
MoveLoop:
        push bc
        ld c, (hl)
        inc hl
        ld b, (hl)
        inc hl
        call DrawBullet
        ld a, b
        add a, d
        ld b, a
        ld a, c
        add a, e
        ld c, a
        call DrawBullet
        pop bc
        djnz MoveLoop

        
        ld bc, (gunXY)          ;move AAgun
        push de
        ld de, gunPic
        call Put8x5
        pop de
        ld a, b
        add a, d
        ld b, a
        ld a, c
        add a, e
        ld c, a
           push de
        ld de, gunPic
        call Put8x5
           pop de
        ret


invArrive:
        ld bc, (invXY)
        ld de, invPic
        ld h, invPerRow
DrawLoop:        
        call Put8x5
        ld a, b
        add a, invXspacing
        ld b, a
        dec h
        jr nz, DrawLoop
        ld hl, $FC00
        push hl
        ld de, ArriveMem
        ld bc, $10*5
        ldir                    ; copy for use with animation
        pop hl
        ld (hl), 0
        ld de, $FC01
        ld bc, ($10*5)-1
        ldir                    ; erase top of screen
        ld a, (invRows)
        ld c, a
Looperoo2:        
        ld b, invYspacing-5
SpaceLoop:        
        push bc
        call Shifteroo
        ld bc, $2800
        call delay
        pop bc
        djnz SpaceLoop
        
        ld b, 5
        ld hl, ArriveMem+($10*(5-1))
Looperoo:
        push bc
        push hl
        call Shifteroo
        pop hl
        push hl
        ld de, $FC10
        ld bc, $10
        ldir                    ; copy line of screen data
        pop hl
        ld bc, $2800
        call delay
        pop bc
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              