; * parameters :
; 	 - HL : coordinates of the 1st point
; 	 - DE : coordinates of the 2nd point

Flag = $80DF
Way = $80E0

Line: 													;beginning of the line routine
	ld a,0
	ld (Flag),a
	push		DE
	push		HL

	ld			A,D
	sub 		H
	jr			NC,DXPositive 	 ;delta_x > 0
DXNegative:
	neg
DXPositive:
	ld			B,A 						 ;B <- |delta_x|
	ld			A,E
	sub 		L
	jr			NC,DYPositive 	 ;delta_y > 0
DYNegative:
	neg
DYPositive:
	sub 		B 							;|delta_y|
	jr			C,DeltaX				;|delta_x| > |delta_y|
DeltaY:
	ld			A,H 						;if |delta_x| < |delta_y| then
	ld			H,L 						;then values x and y are swapped
	ld			L,A 						;so the loop will always be performed on the
	ld			A,D 						;x value. A flag must be set to
	ld			D,E 						;remind that data must be drawn (y,x)
	ld			E,A 						;instead of (x,y)

	ld			A,$01
	ld			(Flag),A				;the Flag !!!
DeltaX:
	ld			A,D
	sub 		H
	jr			NC,TestDY 			 ;x1 < x2
TestDX:
	ex			DE,HL
TestDY:
	ld			A,E
	sub 		L
	ld			A,$01
	jr			NC,StoreA
	neg 										;y1 > y2 : in case2 the 'y' variable
StoreA:
	ld			(Way),A
InitLine:
	ld			B,H
	ld			C,L
	ld			A,E
	sub 		L
	jr			NC,EndInit
	ld			A,L
	ld			L,E
	ld			E,A
EndInit:
	ld			A,E
	sub 		L
	rla
	ld			L,A 						;value to add in case1 (d < 0)
	add 		A,H
	sub 		D
	ld			E,A 						;'d' variable is initialised
	add 		A,H
	sub 		D
	ld			H,A 						;value to add in case2 (d >= 0)
Loop:
	;ld 		 A,B
	;sub		 D
	;jr 		 NC,EndLine 			;the line is completely drawn.
	ld			A,(Flag)
	or			A
	push		AF
	push		BC
	jr			Z,DrawPoint
	ld			A,B
	ld			B,C
	ld			C,A
DrawPoint:
	CALL_(PointOn)
	pop 		BC
	pop 		AF
TestD:
	bit 		7,E
	jr			NZ,Case1
Case2:													;d >= 0
	ld			A,E
	add 		A,H
	ld			E,A
	ld			A,(Way)
	add 		A,C
	ld			C,A
	jr			EndLoop
Case1:													;d < 0
	ld			A,E
	add 		A,L
	ld			E,A
EndLoop:
	inc 		B
	ld A,B
	dec a
	sub D
	jr C,Loop
	;jr 		 Loop
EndLine:
	pop 		HL
	pop 		DE
	ret 										;end of the circle routine

PointOn:
	push		DE							;MUST NOT BE REMOVED
	push		HL							;MUST NOT BE REMOVED
	ROM_CALL(FIND_PIXEL)
	ld			DE,$8641
	add 		HL,DE
	or			(HL)
	ld			(HL),A
	pop 		HL							;MUST NOT BE REMOVED
	pop 		DE							;MUST NOT BE REMOVED
	ret
