#INCLUDE ti-85.h

#DEFINE push_de_hl push de \ push hl
#DEFINE pop_hl_de pop hl \ pop de
#DEFINE yInv 55
#DEFINE xInv 86


lives	 = $80E1
lvlptr	 = $80E2
GhostSt  = $80E4
KEY	 = $80E7
DirStr	 = $80E8
Face	 = $80EA
TempLine = $80F0
PicCoor  = $80F8
offset	 = $80FA
tmp	 = $80FB
invert	 = $80FD
level	 = $80FE
NrGhosts = $80FF
curlev	 = $8100
tmpStr	 = $8102
exit	 = $8104
XY	 = $8106
oldpaddr = $8108
lvlmkr	 = $810A
blink	 = $810C
Ghosts	 = $8A6B

.org 0
.db "Labby v2.1",0

  ld a,4
  out (5),a
  CALL_(Titel)
  ROM_CALL(CLEARLCD)
  ld c,a
  ld hl,$0004
  ld ($800C),hl
  ld hl,(lvlmkr)
  ld a,h
  or l
  ret z
  ld a,c
  cp K_EXIT
  JUMP_Z(Quit)
  set 3,(iy+05)
  ROM_CALL(D_ZT_STR)
  res 3,(iy+05)
  ld hl,$0E14
  ld ($8333),hl
  ld hl,MakerText
  ld de,(PROGRAM_ADDR)
  add hl,de
  ROM_CALL(D_ZM_STR)
WKey:
  call GET_KEY
  or a
  jr z,WKey
  ROM_CALL(CLEARLCD)
  ld hl,0
  ld ($800C),hl
  ld a,1
  ld (blink),a
  ld (level),a
  ld hl,Game
  ld de,(PROGRAM_ADDR)
  add hl,de
  set 3,(iy+05)
  ROM_CALL(D_ZT_STR)
  res 3,(iy+05)
  ld hl,$FC0F
  ld de,16
  ld b,8
FixRight:
  ld (hl),$FF
  add hl,de
  djnz FixRight
StartLevel:
  CALL_(LoadLevel)
DShow3D:
  ld b,40
Show3D:
  push bc
  CALL_(ConvDir)
  ld (Face),a
  CALL_(Show)	 ; Draws your view
  pop bc
WaitKey:
  halt
  dec b
  ld a,b
  or a
  jr nz,ReadKey
  CALL_(MoveGhosts)
  CALL_(CheckColl)
  ld a,(tmp)
  or a
  jr z,DShow3D
  JUMP_(Die)
ReadKey:
  push hl
  call GET_KEY
  pop hl
  or a
  jr z,WaitKey
  cp K_EXIT
  jr z,Quit
  cp K_UP
  jr z,Forward
  cp K_DOWN
  jr z,Backward
  cp K_RIGHT
  jr z,TurnRight
  cp K_LEFT
  jr z,TurnLeft
  jr Show3D
Quit:
  CALL_(Clear)
  pop hl
  ret		 ; Exiting

Forward:	 ; Check if it's possible to move forward
  push hl
  ld a,d
  add a,h
  ld h,a
  ld a,e
  add a,l
  ld l,a
  push de
  ld de,(exit)
  call CP_HL_DE
  jr z,LevelCompleted
  pop de
CheckMove:
  CALL_(GetCoord)
  cp 0
  jr z,Move
  pop hl
  jr WaitKey
Move:
  pop bc
  CALL_(CheckColl)
  ld a,(tmp)
  or a
  JUMP_NZ(Die)
  jr Show3D

TurnRight:	 ; Turning right...
  ld a,e
  neg
  ld e,d
  ld d,a
JumpShow3D:
  JUMP_(Show3D)

TurnLeft:	 ; ...and turning left
  ld a,d
  neg
  ld d,e
  ld e,a
  jr JumpShow3D

Backward:	 ; Check if it's possible to move backward
  push hl
  ld a,d
  neg
  add a,h
  ld h,a
  ld a,e
  neg
  add a,l
  ld l,a
  jr CheckMove

ConvDir:	 ; Left = 0, Up = 1, Down = 2, Right = 3
  push de
  inc d
  inc e
  ld a,d
  sla a
  add a,e
  dec a
  pop de
  cp 2
  ret c
  dec a
  ret

LevelCompleted:
  pop_hl_de
  ld b,54
ScrollAgain:
  push bc
  ld b,54
  ld hl,$FFEB
  ld de,$FFFB
ScrollNewY:
  push bc
  ld bc,12
  lddr
  pop bc
  dec hl
  dec hl
  dec hl
  dec hl
  dec de
  dec de
  dec de
  dec de
  djnz ScrollNewY
  ld b,4
Wait:
  halt
  djnz Wait
  pop bc
  djnz ScrollAgain
  ld hl,$0203
  ld ($800C),hl
  ld hl,WellDone
  ld de,(PROGRAM_ADDR)
  add hl,de
  ROM_CALL(D_ZT_STR)
  push hl
  ld hl,$0205
  ld ($800C),hl
  pop hl
  ROM_CALL(D_ZT_STR)
WK:
  call GET_KEY
  cp K_ENTER
  jr nz,WK
  ld hl,level
  inc (hl)
  JUMP_(StartLevel)

CheckDirections:
  push_de_hl
  CALL_(MoveDir)
  CALL_(GetCoord)
  pop_hl_de
  ld b,a

  push_de_hl
  CALL_(MoveLeft)
  CALL_(GetCoord)
  pop_hl_de
  sla a
  or b
  ld b,a

  push_de_hl
  CALL_(MoveRight)
  CALL_(GetCoord)
  pop_hl_de
  sla a
  sla a
  or b
  ret

MoveDir:
  ld a,d
  add a,h
  ld h,a
  ld a,e
  add a,l
  ld l,a
  ret

MoveLeft:
  ld a,d
  neg
  ld d,e
  ld e,a
  CALL_(MoveDir)
  ret

MoveRight:
  ld a,e
  neg
  ld e,d
  ld d,a
  CALL_(MoveDir)
  ret

CheckColl:
  push bc
  push_de_hl
  ld hl,Ghosts
  ld a,(NrGhosts)
  ld b,a
  xor a
  ld (tmp),a
  inc a
CC:
  ld d,(hl)
  inc hl
  ld e,(hl)
  inc hl
  inc hl
  inc hl
  ex (sp),hl
  call CP_HL_DE
  jr nz,GNG
  ld (tmp),a
GNG:
  ex (sp),hl
  djnz CC
  pop_hl_de
  pop bc
  ret

MoveGhosts:
  push_de_hl
  ld hl,Ghosts
  ld a,(NrGhosts)
  ld b,a
TryMoveGhost:
  push bc
  push hl
  ld b,(hl)
  inc hl
  ld c,(hl)
  inc hl
  ld d,(hl)
  inc hl
  ld e,(hl)
  ld h,b
  ld l,c
  CALL_(CheckDirections)
  xor 7
  or a
  jr z,MoveBack
  cp 1
  jr z,MoveAhead
  bit 0,a
  jr z,LeftRight
  ld b,a
  ld a,r
  srl a
  and 3
  or a
  jr nz,MoveAhead
  ld a,b
  res 0,a
LeftRight:
  cp 2
  jr z,MLeft
  cp 4
  jr z,MRight
  ld a,r
  bit 0,a
  jr z,MLeft

MRight:
  CALL_(MoveRight)
  jr StoreNewGhost

MLeft:
  CALL_(MoveLeft)
  jr StoreNewGhost

MoveAhead:
  CALL_(MoveDir)
  jr StoreNewGhost

MoveBack:
  ld a,d
  neg
  ld d,a
  ld a,e
  neg
  ld e,a
  CALL_(MoveDir)

StoreNewGhost:
  ld b,h
  ld c,l
  pop hl
  ld (hl),b
  inc hl
  ld (hl),c
  inc hl
  ld (hl),d
  inc hl
  ld (hl),e
  inc hl
  pop bc
  djnz TryMoveGhost
  pop_hl_de
  ret

Die:
  CALL_(Show)
  ld b,16
Flash:
  push bc
  ld b,20
Wait10:
  halt
  djnz Wait10
  ld hl,$FC80
  ld b,4
FL2:
  push bc
  ld b,224
FL1:
  ld a,(hl)
  xor $FF
  ld (hl),a
  inc hl
  djnz FL1
  pop bc
  djnz FL2
  pop bc
  djnz Flash
  set 3,(iy+05)
  ld a,(lives)
  dec a
  ld (lives),a
  jr z,VeryDead
  ld hl,$0204
  ld ($800c),hl
  ld hl,DeadText
  ld de,(PROGRAM_ADDR)
  add hl,de
  ROM_CALL(D_ZT_STR)
WaitEnter:
  call GET_KEY
  cp K_ENTER
  jr nz,WaitEnter
  res 3,(iy+05)
  JUMP_(StartLevel)
VeryDead:
  ld hl,$0104
  ld ($800c),hl
  ld hl,VeryDeadText
  ld de,(PROGRAM_ADDR)
  add hl,de
  ROM_CALL(D_ZT_STR)
WaitEnter2:
  call GET_KEY
  cp K_ENTER
  jr nz,WaitEnter2
  res 3,(iy+05)
  JUMP_(Quit)

Show:
  push_de_hl
  CALL_(Clear)
  ld b,0
CheckStep:
  ld a,b
  ld (tmp),a
  push_de_hl	 ; Checking if wall on the left side
  ld a,d
  neg
  add a,l
  ld l,a
  ld a,e
  add a,h
  ld h,a
  CALL_(GetCoord)
  ld c,0
  CALL_(DrawWall)
  pop_hl_de
  push_de_hl	 ; Checking if wall on the right side
  ld a,e
  neg
  add a,h
  ld h,a
  ld a,d
  add a,l
  ld l,a
  CALL_(GetCoord)
  ld c,1
  CALL_(DrawWall)
  pop_hl_de

  ld a,d	 ; Check one step forward if no wall
  add a,h
  ld h,a
  ld a,e
  add a,l
  ld l,a
  CALL_(GetCoord)
  cp 1
  JUMP_Z(CoorEnd)
  ld a,b
  cp 6
  JUMP_Z(IncStep)

  ; Check if any ghosts here

  push bc
  push de
  ex de,hl
  ld hl,Ghosts
  ld a,(NrGhosts)
  ld b,a
CheckNewGhost:	; bc = ghost left, de = your position; hl = ghost pointer
  push bc
  push de
  ld d,(hl)
  inc hl
  ld e,(hl)
  inc hl
  push de
  ld d,(hl)
  inc hl
  ld e,(hl)
  inc hl
  CALL_(ConvDir)
  pop de
  ld (XY),hl
  pop hl     ; hl = your position
  ex de,hl
  call CP_HL_DE
  jr nz,NoGhostHere

  push_de_hl
  sla a
  sla a
  ld d,a
  ld a,(Face)
  add a,d
  ld hl,GhostMapping
  ld d,0
  ld e,a
  add hl,de
  ld de,(PROGRAM_ADDR)
  add hl,de
  ld a,(hl)
  push af
  ld h,0
  ld l,a
  add hl,de
  ld de,GhostTable
  add hl,de
  ld a,(tmp)
  sla a
  sla a
  sla a
  ld d,0
  ld e,a
  add hl,de
  call LD_HL_MHL
  ld de,(PROGRAM_ADDR)
  add hl,de
  pop af
  push af
  CALL_(PutImage)
  pop af
  or a
  jr nz,NoEyes
  ld hl,EyeTable
  ld a,(tmp)
  sla a
  ld d,0
  ld e,a
  add hl,de
  ld de,(PROGRAM_ADDR)
  add hl,de
  call LD_HL_MHL
  add hl,de
  xor a
  CALL_(PutImage)
NoEyes:
  pop_hl_de

NoGhostHere:
  ld hl,(XY)
  pop bc
  djnz CheckNewGhost
  ex de,hl
  pop de
  pop bc

  ; Check if too far

IncStep:
  inc b
  ld a,b
  cp 7
  JUMP_NZ(CheckStep)
  jr DrawRadar

CoorEnd:	 ; End of corridor
  ex de,hl
  ld hl,(exit)
  call CP_HL_DE
  jr nz,NoDoor
  push af
  ld hl,Door1
  ld a,b
  or a
  jr nz,SkipD
  ld hl,Door2
SkipD:
  ld de,(PROGRAM_ADDR)
  add hl,de
  xor a
  push bc
  CALL_(PutImage)
  pop bc
  pop af
NoDoor:
  ld hl,Walls
  ld de,(PROGRAM_ADDR)
  add hl,de
  inc b
  sla b
  ld d,0
  ld e,b
  add hl,de
  call LD_HL_MHL
  ld a,xInv
  ld b,h
  sub b
  ld d,a
  ld e,l
  CALL_(Line)
  ld a,yInv
  ld b,l
  sub b
  ld l,a
  ld e,a
  CALL_(Line)

DrawRadar:
  pop_hl_de
  push_de_hl
  ld a,l
  ld (XY),a
  ld a,h
  ld (XY+1),a
  ld hl,Ghosts
  ld a,(NrGhosts)
  ld b,a
NewGhost:
  ld d,(hl)
  inc hl
  ld e,(hl)
  inc hl
  inc hl
  inc hl
  push hl
  ld hl,XY
  call LD_HL_MHL
  ld a,d
  add a,5
  sub h
  jr c,NextGhost
  cp 11
  jr nc,NextGhost
  sub 5
  ld c,a
  ld a,e
  add a,5
  sub l
  jr c,NextGhost
  cp 11
  jr nc,NextGhost
  sub 5
  push bc
  ld d,a

  ; Here, x = c & y = d

  ld a,(Face)
  bit 0,a
  jr nz,Skip1
  ld a,d
  neg
  ld d,a
Skip1:
  ld a,(Face)
  bit 1,a
  jr z,Skip2
  ld a,c
  neg
  ld c,a
Skip2:
  ld a,(Face)
  inc a
  ld b,d
  bit 1,a
  jr z,Plot
  ld b,c
  ld c,d
Plot:
  ld a,b
  add a,105
  ld b,a
  ld a,c
  neg
  add a,20
  ld c,a
  ROM_CALL(FIND_PIXEL)
  ld de,$8641
  add hl,de
  or (hl)
  ld (hl),a
  pop bc
NextGhost:
  pop hl
  djnz NewGhost

  ld hl,$630E  ; Draw quadrant
  ld de,$6F0E
  CALL_(Line)
  ld hl,$6F1A
  CALL_(Line)
  ld de,$631A
  CALL_(Line)
  ld hl,$630E
  CALL_(Line)

  ld a,(Face)
  sla a
  sla a
  ld hl,DirLet
  ld de,(PROGRAM_ADDR)
  add hl,de
  ld d,0
  ld e,a
  add hl,de
  ld de,DirStr
  push de
  ldi
  xor a
  ld (de),a
  ld de,$8333
  ldi
  ldi
  ld hl,$86CC  ; Draw a vertical line
  ld b,56
  ld de,16
NewInvRow:
  ld a,$30
  xor (hl)
  ld (hl),a
  add hl,de
  djnz NewInvRow

  ld hl,$86C1
  ld de,$FC80
  ld b,22
FlipNextRow:
  push bc
  ld bc,12
  ldir
  inc hl
  inc hl
  inc hl
  inc hl
  inc de
  inc de
  inc de
  inc de
  pop bc
  djnz FlipNextRow
  ld bc,512
  ldir

  ld a,(blink)
  inc a
  ld (blink),a
  bit 0,a
  jr z,NoDot
  ld hl,$FEBD
  ld a,64
  or (hl)
  ld (hl),a
NoDot:
  pop hl
  set 3,(iy+05)
  ROM_CALL(D_ZM_STR)
  res 3,(iy+05)
  ld hl,$0D60
  ld ($8333),hl
  ld hl,LevelText
  ld de,(PROGRAM_ADDR)
  add hl,de
  ROM_CALL(D_ZM_STR)
  ld a,(level)
  add a,48
  ld h,0
  ld l,a
  ld (tmpStr),hl
  ld hl,tmpStr
  ROM_CALL(D_ZM_STR)
  ld hl,$1560
  ld ($8333),hl
  ld hl,LivesText
  add hl,de
  ROM_CALL(D_ZM_STR)
  ld a,(lives)
  add a,48
  ld h,0
  ld l,a
  ld (tmpStr),hl
  ld hl,tmpStr
  ROM_CALL(D_ZM_STR)
  pop_hl_de
  ret

DrawWall:	 ; Draw a wall or an opening at distance b
  push bc	 ; a=1 => Wall, a=0 => Opening
  push_de_hl	 ; c=0 => Left, c=1 => Right
  ld hl,Walls
  ld de,(PROGRAM_ADDR)
  add hl,de
  sla b
  ld d,0
  ld e,b
  add hl,de
  push af
  push hl
  call LD_HL_MHL
  ld a,c
  cp 0
  jr z,NoXInv1
  ld a,xInv
  ld b,h
  sub b
  ld h,a
NoXInv1:
  ld (XY),hl
  pop hl
  ld e,2
  add hl,de
  call LD_HL_MHL
  ld a,c
  cp 0
  jr z,NoXInv2
  ld a,xInv
  ld b,h
  sub b
  ld h,a
NoXInv2:
  ld de,(XY)
  pop af
  cp 1
  jr z,NoOpen
  ld e,l
NoOpen:
  CALL_(Line)
  ld a,l
  ld b,yInv
  sub b
  neg
  push de
  ld d,h
  ld e,a
  CALL_(Line)
  pop hl
  ld a,l
  ld b,yInv
  sub b
  neg
  ld l,a
  CALL_(Line)
  pop_hl_de
  pop bc
  ret

PutImage:	 ; Put image at (hl)
  cp 3
  jr c,NoPicInvert
  ld a,(hl)
  inc hl
  ld b,(hl)
  add a,b
  ld b,a
  ld a,1
  ld (invert),a
  jr GetPicData
NoPicInvert:
  xor a
  ld (invert),a
  inc hl
  ld b,(hl)
GetPicData:
  inc hl
  ld c,(hl)
  inc hl
  ld d,(hl)
  inc hl
  ld e,(hl)
  inc hl
  ld (PicCoor),hl
  ld a,64
  sub c
  ld c,a
  ROM_CALL(FIND_PIXEL)
  ld b,e	 ; b <= Rows
  ld c,d	 ; c <= Bytes in xdir
  ld de,$8641	 ; Put to graphmem
  add hl,de
NewImRow:
  push bc
  push hl
  push bc
  ld b,0
  push hl
  ld hl,(PicCoor)
  ld de,TempLine
  ldir
  ld (PicCoor),hl
  pop hl	 ; hl -> lcdmem
  ld de,TempLine
  pop bc
  ld b,c
NextXByte:
  push bc
  ld b,8
NextPixel:
  ex de,hl
  bit 7,(hl)
  jr z,NoPixel
  ex de,hl
  push af
  or (hl)
  ld (hl),a
  pop af
  ex de,hl
NoPixel:
  ld c,a
  ld a,(invert)
  or a
  ld a,c
  jr nz,BackRotate
  rlc (hl)
  rrca
  jr nc,NoNewByte
  inc de
  jr NoNewByte
BackRotate:
  rlc (hl)
  rlca
  jr nc,NoNewByte
  dec de
NoNewByte:
  ex de,hl
  djnz NextPixel
  inc de
  pop bc
  djnz NextXByte
  pop hl
  pop bc
  ld de,16
  add hl,de
  djnz NewImRow
  ret

GetCoord:	 ; Returns a = 1 if wall at (h,l) else a = 0
  push_de_hl
  ex de,hl
  ld hl,(curlev)
  push bc
  push de

  ld a,e
  sla e
  add a,e
  ld e,a

  ld d,0
  add hl,de
  pop de
  push de
  ld e,d
  ld d,0
  push de
  srl e
  srl e
  srl e
  add hl,de
  pop de
  ld a,e
  and 7
  sub 7
  neg
  cp 0
  ld b,a
  ld a,(hl)
  jr z,Return
Loop2:
  srl a
  djnz Loop2
Return:
  and 1
  pop de
  pop bc
  pop_hl_de
  ret

Titel:
  ROM_CALL(CLEARLCD)
  ld hl,$0600
  ld ($800C),hl
  ld hl,TitelMess
  ld de,(PROGRAM_ADDR)
  add hl,de
  ROM_CALL(D_ZT_STR)
  push hl
  ld hl,$0C2B
  ld ($8333),hl
  pop hl
  ROM_CALL(D_ZM_STR)
  push hl
  set 3,(iy+05)
  ld hl,$0003
  ld ($800C),hl
  pop hl
  ROM_CALL(D_ZT_STR)
  res 3,(iy+05)
  push hl
  ld hl,$2219
  ld ($8333),hl
  pop hl
  ROM_CALL(D_ZM_STR)
  push hl
  ld hl,$2D14
  ld ($8333),hl
  pop hl
  ROM_CALL(D_ZM_STR)
  push hl
  ld hl,$0007
  ld ($800C),hl
  pop hl
  ROM_CALL(D_ZT_STR)
WaitStart:
  call GET_KEY
  cp K_EXIT
  jr z,Ret3
  cp K_SECOND
  jr nz,WaitStart
Ret3:
  ret

LoadLevel:	; Loads level A, inits the ghosts and the mappointer
  ld hl,(lvlptr)
  ld a,(level)
  dec a
  sla a
  ld d,0
  ld e,a
  add hl,de
  call LD_HL_MHL
  ld a,h
  or l
  jr z,NoMore
  ld de,(oldpaddr)
  add hl,de
  ld b,(hl)
  inc hl
  ld c,(hl)
  push bc
  inc hl
  ld d,(hl)
  inc hl
  ld e,(hl)
  push de
  inc hl
  ld a,(hl)
  ld (NrGhosts),a
  inc hl
  ld d,(hl)
  inc hl
  ld e,(hl)
  inc hl
  push de
  ld d,(hl)
  inc hl
  ld e,(hl)
  inc hl
  ld (exit),de
  pop de
  ld (curlev),hl
  ld hl,Ghosts
  ld b,a
PutGhost:
  ld (hl),d
  inc hl
  ld (hl),e
  inc hl
  ld (hl),1
  inc hl
  ld (hl),0
  inc hl
  djnz PutGhost
  pop de
  pop hl
  ret

NoMore:
  pop hl
  CALL_(Clear)
  ROM_CALL(CLEARLCD)
  ret

Clear:
  push bc
  push_de_hl
  ld de,$8641
  ld h,d
  ld l,e
  ld (hl),0
  inc de
  ld bc,1023
  ldir
  pop_hl_de
  pop bc
  ret

#INCLUDE grline.h

TitelMess:
  .db "Labby 2.1",0
  .db "was made by",0
  .db "    Jimmy Mardell    ",0
  .db "Email: mja@algonet.se",0
  .db "Graphics by Lance Bradley",0
  .db "2ND Begin  EXIT Quit",0
Game:
  .db "Labby 2.1            ",0
LevelText:
  .db "Level: ",0
LivesText:
  .db "Lives: ",0
WellDone:
  .db "Well done!!",0
DeadText:
  .db "Press ENTER",0
VeryDeadText:
  .db "You're dead!!"
  .db 0
MakerText:
  .db "These levels were made by",0

Walls:
  .dw $0004,$0306,$0D0B,$150F,$1B12,$1F14,$2215,$2416

DirLet:
  .db 207,94,40,0,6,103,31,0,7,103,49,0,5,114,40

#INCLUDE labby.gfx

.end
