#include "ti-85.h"

.org 0
.db "Labby levels", 0

lives	 = $80E1
lvlptr	 = $80E2
oldpaddr = $8108
lvlmkr	 = $810A

  ld a,5
  ld (lives),a
  ld hl,(PROGRAM_ADDR)
  ld (oldpaddr),hl
  ex de,hl
  ld hl,LevelMaker
  add hl,de
  ld (lvlmkr),hl
  ld hl,LevelTable
  add hl,de
  ld (lvlptr),hl
  ld hl,Find
  add hl,de
  rst 20h
  rst 10h
  jr nc,Next
  ret
Next:
  push de
  ld hl,Back
  ld de,(PROGRAM_ADDR)
  add hl,de
  pop de
  push hl
  ld h,d
  ld l,e
  ld de,5
  add hl,de
  ld (PROGRAM_ADDR),hl
Loop:
  ld a,(hl)
  or a
  jr z,Loop1
  inc hl
  jr Loop
Loop1:
  inc hl
  jp (hl)

Back:
  ld hl,$0201
  ld ($800C),hl
  ld hl,HappyText
  ld de,(oldpaddr)
  add hl,de
  ROM_CALL(D_ZT_STR)
  push hl
  ld hl,$0503
  ld ($800C),hl
  pop hl
  ROM_CALL(D_ZT_STR)
  push hl
  ld hl,$0104
  ld ($800C),hl
  pop hl
  ROM_CALL(D_ZT_STR)
WaitKey:
  call GET_KEY
  or a
  jr z,WaitKey
  ret

Find:
  .db $0C,5,"labby"

HappyText:
  .db "Congratulations!!",0
  .db "You made it",0
  .db "through all levels!",0

LevelTable:
  .dw Level1,Level2,Level3,Level4,0

LevelMaker:
  .db "    Jimmy Mardell    ",0

; The coordinates are in (X,Y) with (0,0) as origin (top left)

Level1:
  .db 1,1,1,0	   ; Your start XY, your start dirXY
  .db 6,11,10	   ; NrGhosts, ghostXY
  .db 1,19	   ; Exit

  .db %11111111,%11111111,%11111110
  .db %10000010,%00000010,%00100010
  .db %10111010,%11101010,%10101010
  .db %10100000,%00000010,%10001010
  .db %10101111,%10111010,%11101010
  .db %10000000,%00001000,%00001010
  .db %10111110,%10101010,%11101010
  .db %10000000,%10101010,%10000010
  .db %11111110,%10100010,%10101110
  .db %10000000,%00111010,%00100010
  .db %10111010,%10101010,%11111010
  .db %10000010,%10000000,%00000010
  .db %11101110,%10111011,%11101010
  .db %10000010,%00100000,%00001010
  .db %10111010,%10101010,%11111010
  .db %10000000,%10101010,%00000010
  .db %11111111,%10000010,%11101110
  .db %10000010,%10101000,%00000010
  .db %11101010,%10101011,%10111010
  .db %11101000,%00100000,%00001010
  .db %10101011,%10101011,%11101010
  .db %10000000,%00001000,%00000010
  .db %11111111,%11111111,%11111110

Level2:
  .db 1,11,1,0
  .db 8,19,11
  .db 21,21

  .db %11111111,%11111111,%11111110
  .db %10000000,%00001000,%00000010
  .db %10101010,%11101011,%10101110
  .db %10100010,%00001000,%00100010
  .db %10101010,%11101011,%10101010
  .db %10101000,%00000000,%00001010
  .db %10101010,%10101111,%10101010
  .db %10000010,%10100000,%00001010
  .db %10111010,%10101010,%11101010
  .db %10000000,%00001010,%10000010
  .db %11101011,%11101010,%10111010
  .db %10001010,%00000000,%00100010
  .db %10101010,%10111110,%11111010
  .db %10101010,%10100000,%00000010
  .db %10101010,%10101011,%10111010
  .db %10000000,%00001010,%10100010
  .db %10111110,%10111010,%10101010
  .db %10000000,%10000000,%00001010
  .db %11101110,%10111011,%10111010
  .db %10000000,%10000000,%00100010
  .db %10111111,%10101110,%10101110
  .db %10000000,%00100000,%00100110
  .db %11111111,%11111111,%11111110

Level3:
  .db 15,15,0,-1
  .db 8,3,3
  .db 1,1

  .db %11111111,%11111111,%11111110
  .db %11001000,%00000010,%00100010
  .db %11101010,%11111010,%10101010
  .db %10000010,%00000000,%10001010
  .db %10101110,%10111010,%10111010
  .db %10100000,%10000010,%00000010
  .db %10101011,%11101011,%11101110
  .db %10001010,%00001000,%10001010
  .db %11101010,%11101110,%10101010
  .db %10000000,%10000000,%00100010
  .db %10101110,%10111011,%10101110
  .db %10100010,%00001010,%00000010
  .db %10101010,%11101010,%10111010
  .db %10001000,%10100000,%10000010
  .db %11101110,%10101110,%10111010
  .db %10000000,%00000000,%00001010
  .db %10111011,%10111110,%11101010
  .db %10000010,%00000000,%00000010
  .db %10101110,%10111010,%11101010
  .db %10100000,%10000010,%00101010
  .db %10101011,%10101110,%10101010
  .db %10001000,%00100000,%10000010
  .db %11111111,%11111111,%11111110

Level4:
  .db 19,3,-1,0
  .db 10,13,17
  .db 13,21

  .db %11111111,%11111111,%11111110
  .db %10100000,%00001000,%00000010
  .db %10101110,%11101010,%11101010
  .db %10001000,%00100010,%00001010
  .db %10111010,%10101110,%10101010
  .db %10000010,%10000000,%10000010
  .db %11101010,%10111010,%10111010
  .db %10000010,%00000010,%00000010
  .db %10111010,%11101010,%11101010
  .db %10000000,%00001000,%00001010
  .db %10101110,%11101110,%10101010
  .db %10100010,%00000010,%10100010
  .db %10111010,%10111010,%10101110
  .db %10000000,%10001000,%00000010
  .db %10111010,%10101010,%11101010
  .db %10100010,%00100010,%10001010
  .db %10101010,%11111010,%10111010
  .db %10001000,%00000000,%00001010
  .db %11101011,%10101111,%10101010
  .db %10000000,%10100000,%10000010
  .db %10111110,%10101010,%10111010
  .db %10000000,%00001110,%00000010
  .db %11111111,%11111111,%11111110

.end
