    ; ***********************************************************************
    ; *
    ; *                P A C M A N      9 7
    ; *
    ; *
    ; *           Programmed by Patrick Davidson
    ; *
    ; *             last updated : 15-August-97
    ; *
    ; ***********************************************************************
NUM_LEVELS        =3
 ; -------------- PROGRAM HEADER --------------------------------------------
         .org     0
         .include "ti-85.h"
         .db      "PacMan 97 v77 by Patrick D"
         .db      0
.define  RAND     ld de,(rptr) \ inc de \ res 7,d \ ld (rptr),de \ ld a,(de) \ xor e
 ; -------------- VARIABLE ADDRESSES ----------------------------------------
scrlstart         =$8100
scrlpos           =$8110
temp              =$8120
rptr              =$817d

lives             =$80df
data              =$80e0
x                 =$8140
y                 =$8141
xv                =$8142
yv                =$8143
level             =$8144
score             =$8145
image             =$8147
pills             =$8149
enemies           =$8150 
jp2nd             =$8164
nxv               =$8165
nyv               =$8166
countdown         =$8167
 ; -------------- INITIALIZATION CODE ---------------------------------------
         ld       hl,rptr_backup
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         call     LD_HL_MHL
         ld       (rptr),hl
         ld       (iy+13),0
         ld       (iy+5),2
         ROM_CALL(CLEARLCD)
         ld       b,96
         ld       a,32
         ld       ix,$8641
pcl:     ld       hl,0
         ld       ($800c),hl
         push     af
         push     bc
         ROM_CALL(TX_CHARPUT)
         ld       hl,$fc00
         ld       b,8
         ld       de,16
il2:     ld       a,(hl)
         ld       (ix),a
         sla      a
         or       (ix)
         ld       (ix),a
         add      hl,de
         inc      ix
         djnz     il2
         pop      bc
         pop      af
         inc      a
         djnz     pcl
         ld       a,1
         ld       (ZS_BITS),a

         CALL_(display_ttl_scr)
         CALL_(play_game)
         ld       de,(rptr)
         ld       hl,rptr_backup
         ld       bc,(PROGRAM_ADDR)
         add      hl,bc
         ld       (hl),e
         inc      hl
         ld       (hl),d
         ld       a,%111111
         out      (1),a
         in       a,(1)
         sla      a
         JUMP_NC(save_the_game)
         CALL_(do_scores)
         ROM_CALL(CLEARLCD)
         ld       hl,0
         ld       ($800c),hl
         ld       hl,hstitle
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ROM_CALL(D_ZT_STR)
         ld       hl,$1001
         ld       ($800c),hl
         ld       ix,hsdata
         ld       de,(PROGRAM_ADDR)
         add      ix,de
         ld       b,7
         ld       de,17
high_display_loop:
         ld       l,(ix+0)
         ld       h,(ix+1)
         push     bc
         push     de
         push     hl
         ROM_CALL(D_HL_DECI)
         pop      hl
         pop      de
         pop      bc
         ld       hl,$800c
         dec      (hl)
         inc      ix
         inc      ix
         push     ix
         pop      hl
         ROM_CALL(D_ZT_STR)
         add      ix,de
         ld       hl,$800c
         inc      (hl)
         inc      hl
         ld       (hl),16
         djnz     high_display_loop
loop_wk: call     GET_KEY
         or       a
         jr       z,loop_wk
         ret
save_the_game:
         ld       hl,(PROGRAM_ADDR)
         ld       de,saved_flag
         add      hl,de
         ex       de,hl
         ld       a,3
         ld       (de),a
         inc      de
         ld       hl,$80df
         ld       bc,137
         ldir
         ld       (ZS_BITS),a
         ret
 ; -------------- SCORING ---------------------------------------------------
do_scores:
         ld       hl,lowest                  ;See if ya got a hi-score
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         call     LD_HL_MHL
         ld       de,(score)
         call     CP_HL_DE
         ret      nc
         ROM_CALL(CLEARLCD)
         ld       hl,0
         ld       ($800c),hl
         ld       hl,hi_score_str
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ROM_CALL(D_ZT_STR)
         ld       hl,lowest+2
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ld       (temp),hl
         ld       b,16
space_loop:
         ld       (hl),32
         inc      hl
         djnz     space_loop
         ld       ix,(temp)
         ld       b,0
enter_name_loop:
         call     GET_KEY
         cp       0
         jr       z,enter_name_loop
         cp       K_DEL
         jr       z,backup
         cp       K_ENTER
         jr       z,nomore
         ld       c,a
         ld       a,15
         cp       b
         jr       z,enter_name_loop
         ld       hl,chartable
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ld       e,c
         ld       d,0
         add      hl,de
         ld       a,(hl)
         ld       (ix),a
         ROM_CALL(TX_CHARPUT) 
         inc      b
         inc      ix
         jr       enter_name_loop
backup:  dec      b
         ld       a,255
         cp       b
         jr       z,too_far
         dec      ix
         ld       (ix),32
         ld       hl,$800d
         dec      (hl)
         ld       a,32
         ROM_CALL(TX_CHARPUT)
         dec      (hl)
         jr       enter_name_loop
too_far: inc      b
         jr       enter_name_loop
nomore:
         ld       ix,lowest
         ld       de,(PROGRAM_ADDR)
         add      ix,de
         ld       de,(score)
         ld       (ix),e
         ld       (ix+1),d

         ld       b,6
sort_scores
         ld       e,(ix)
         ld       d,(ix+1)
         ld       l,(ix-19)
         ld       h,(ix-18)
         call     CP_HL_DE
         ret      nc
         push     bc
         ld       b,19
         ld       d,0
exg_loop:ld       e,(ix)
         ld       c,(ix-19)
         ld       (ix),c
         ld       (ix-19),e
         inc      ix
         djnz     exg_loop
         ld       de,-38
         add      ix,de
         pop      bc
         djnz     sort_scores
         ret

 ; -------------- TITLE SCREEN ----------------------------------------------
display_ttl_scr:
         ROM_CALL(CLEARLCD)
         ld       hl,0
         ld       ($800c),hl
         ld       (score),hl
         ld       hl,title
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ROM_CALL(D_ZT_STR)
         ld       ix,$800c
         inc      (ix)
         ROM_CALL(D_ZT_STR)
         inc      (ix)
         ROM_CALL(D_ZT_STR)
         ld       hl,0
         ld       (scrlpos),hl
         ld       hl,$0806
         ld       ($8941),hl

intro_loop:
         ld       hl,$89c1
         ld       b,128
lclearscrl:
         ld       (hl),0
         inc      hl
         djnz     lclearscrl
         ld       hl,(scrlpos)
         inc      hl
         ld       de,(scrl_end-scrltext)*8
         call     CP_HL_DE
         jr       nz,okscrl
         ld       hl,0
okscrl:  ld       (scrlpos),hl
         ld       a,8
         call     UNPACK_HL+2
         cpl
         and      7
         ld       de,scrltext
         add      hl,de
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ld       b,15
scroll_loop:
         push     bc
         push     hl
         push     af
         ld       a,(hl)
         sub      32
         ld       l,a
         ld       h,0
         add      hl,hl
         add      hl,hl
         add      hl,hl
         ld       de,$8641
         add      hl,de
         ld       de,$8943
         ld       bc,8
         ldir
         pop      af
         push     af
         ld       d,a
         ld       e,56
         ld       ix,$8941
         CALL_(drw_spr)
         pop      af
         pop      hl
         pop      bc
         add      a,8
         inc      hl
         djnz     scroll_loop
         ld       de,15
         ld       hl,$89c1
         ld       b,8
         ld       a,255
loop_blox:
         ld       (hl),a
         add      hl,de
         ld       (hl),a
         inc      hl
         djnz     loop_blox
         dec      hl
         ld       de,$ffff
         ld       bc,128
         lddr

         call     GET_KEY
         or       a
                           
         JUMP_Z(intro_loop)

         ret
title:   .db      "P A C M A N       9 7",0
         .db      "by Patrick A Davidson"
         .db      "  (ariwsi@juno.com)  ",0
         .db      "   Copyright 1997",0
         .db      0
scrltext:.db      "                 "
         .db      "WELCOME TO PACMAN 97!   "
         .db      "PRESS ANY KEY TO START "
         .db      "PLAYING.  USE ARROW KEYS "
         .db      "TO PLAY, EXIT TO GIVE UP, "
         .db      "AND MORE TO SAVE THE GAME.  "
         .db      "PRESS 2nd TO TURN AUTOPILOT "
         .db      "ON OR OFF. "
         .db      " TEXT RESTARTS ...  "
scrl_end:.db      "                  "
 ; ---------------------- HIGH SCORES ---------------------------------------
hi_score_str:
         .db      "----> PACMAN 97 <----"
         .db      "  You have a hiscore!"
         .db      "Enter your name here:",0
hstitle: .db      "= PACMAN HIGHSCORES =",0
hsdata:  .dw      666
         .db      "Bill Gates      ",0
         .dw      666
         .db      "Bill Gates      ",0
         .dw      666
         .db      "Bill Gates      ",0
         .dw      666
         .db      "Bill Gates      ",0
         .dw      666
         .db      "Bill Gates      ",0
         .dw      666
         .db      "Bill Gates      ",0
lowest   .dw      666
         .db      "Bill Gates      ",0
 ; -------------- THE ACTUAL GAME -------------------------------------------
restore: ld       de,$80df
         ld       bc,137
         ld       (hl),0
         inc      hl
         ldir
         ld       hl,image_still
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ld       (image),hl
         jr       main_loop
play_game:
         ROM_CALL(CLEARLCD)
         ld       hl,$1000
         ld       ($800c),hl
         ld       hl,initialtemplate
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ROM_CALL(D_ZT_STR)
         ld       de,$1003
         ld       ($800c),de
         ROM_CALL(D_ZT_STR)
         ld       de,$1006
         ld       ($800c),de
         ROM_CALL(D_ZT_STR)
         ld       hl,saved_flag
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ld       a,(hl)
         or       a
         jr       nz,restore
         ld       a,5
         ld       (lives),a
         ld       a,1
         ld       (level),a
         dec      a
         ld       (score),a
level_start:
         CALL_(make_level)
         CALL_(prepare_to_play_)
main_loop:
         CALL_(render_backgroun)
         CALL_(do_you)
         CALL_(do_enemies)
         CALL_(display_stats)
         CALL_(display_data)
         CALL_(toggle_autopilot)
         ld       a,(pills)
         or       a
         jr       z,you_won
         ld       a,%111111
         out      (1),a
         in       a,(1)
         rla
         ret      nc
         rla
         jr       c,main_loop
         ret
you_won: ld       hl,level
         ld       a,(hl)
         cp       NUM_LEVELS
         jr       z,win
         inc      (hl)
         ld       b,100
         ld       a,(lives)
         ld       e,a
         ld       d,0
         ld       hl,(score)
loopis:  add      hl,de
         ld       (score),hl
         push     hl
         push     de
         push     bc
         CALL_(display_stats)
         pop      bc
         pop      de
         pop      hl
         djnz     loopis
         CALL_(display_stats)
         jr       level_start
win:     ld       hl,(score)
         ld       de,1000
         add      hl,de
         ld       (score),hl
         CALL_(display_stats)
         ld       b,3
loop_flickerw:
         push     bc
         CALL_(display_data)
         ld       bc,0
lww1:    dec      bc
         ld       a,b
         or       c
         jr       nz,lww1
         ld       hl,$0303
         ld       ($800c),hl
         ld       hl,youwin
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ROM_CALL(D_ZT_STR)
         ld       bc,0
lww2:    dec      bc
         ld       a,b
         or       c
         jr       nz,lww2
         pop      bc
         djnz     loop_flickerw        
         ret
youwin:  .db      "YOU WIN!!!!",0
 ; -------------- DISPLAY STATUS INFORMATION --------------------------------
display_stats:
         ld       hl,$1001
         ld       ($800c),hl
         ld       hl,(score)
         ROM_CALL(D_HL_DECI)
         ld       hl,$1004
         ld       ($800C),hl
         ld       a,(lives)
         ld       l,a
         ld       h,0
         ROM_CALL(D_HL_DECI)
         ld       hl,$1007
         ld       ($800C),hl
         ld       a,(level)
         ld       l,a
         ld       h,0
         ROM_CALL(D_HL_DECI)
         ret
 ; -------------- RENDER THE BACKGROUND -------------------------------------
render_backgroun:
         ld       ix,$8641
         ld       de,data
         ld       b,8
line_loop:
         push     bc
         ld       b,12
blocks_loop:
         push     bc
         ld       hl,(PROGRAM_ADDR)
         ld       bc,block_images
         add      hl,bc
         ld       c,l
         ld       b,h
         ld       a,(de)
         ld       l,a
         inc      de
         ld       h,0
         add      hl,hl
         add      hl,hl
         add      hl,hl
         add      hl,bc
         pop      bc
         ld       a,(hl)
         ld       (ix),a
         inc      hl
         ld       a,(hl)
         ld       (ix+16),a
         inc      hl
         ld       a,(hl)
         ld       (ix+32),a
         inc      hl
         ld       a,(hl)
         ld       (ix+48),a
         inc      hl
         ld       a,(hl)
         ld       (ix+64),a
         inc      hl
         ld       a,(hl)
         ld       (ix+80),a
         inc      hl
         ld       a,(hl)
         ld       (ix+96),a
         inc      hl
         ld       a,(hl)
         ld       (ix+112),a
         inc      ix
         djnz     blocks_loop
         ld       bc,116
         add      ix,bc
         pop      bc
         djnz     line_loop
         ret
 ; -------------- COPY THE IMAGE TO THE SCREEN ------------------------------
display_data:
         ld       de,$fc00
         ld       hl,$8641
         ld       a,32
loop_copy_image:
         ld       bc,12
         ldir
         inc      de
         inc      de
         inc      de
         inc      de
         inc      hl
         inc      hl
         inc      hl
         inc      hl
         ld       bc,12
         ldir
         inc      de
         inc      de
         inc      de
         inc      de
         inc      hl
         inc      hl
         inc      hl
         inc      hl
         dec      a
         jr       nz,loop_copy_image
         ret
 ; -------------- SET UP A LEVEL --------------------------------------------
make_level:
         ld       h,0
         ld       a,(level)
         ld       l,a
         add      a,a
         add      a,l
         ld       l,a
         add      hl,hl
         add      hl,hl
         add      hl,hl
         add      hl,hl
         add      hl,hl
         ld       de,level_maps-96

         add      hl,de
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ld       de,data
         ld       b,96
         ld       c,0
loop_make_level_map:
         ld       a,(hl)
         bit      4,a
         jr       z,nph
         inc      c
nph:     ld       (de),A
         INC      HL
         INC      DE
         djnz     loop_make_level_map
         ld       a,c
         ld       (pills),a
         ret

prepare_to_play_:
         CALL_(render_backgroun)    
         CALL_(display_stats)
         ld       hl,image_still
         LD       DE,(PROGRAM_ADDR)
         add      hl,de
         ld       (image),hl
         ld       hl,0
         ld       (x),hl
         ld       (xv),hl
         ld       (nxv),hl
         ld       a,$5f
         ld       hl,bitsmc+1
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ld       (hl),a
         ld       b,3
loop_flicker:
         push     bc
         CALL_(display_data)
         ld       bc,0
lw1:     dec      bc
         ld       a,b
         or       c
         jr       nz,lw1
         ld       hl,$0303
         ld       ($800c),hl
         ld       hl,getready
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ROM_CALL(D_ZT_STR)
         ld       bc,0
lw2:     dec      bc
         ld       a,b
         or       c
         jr       nz,lw2
         pop      bc
         djnz     loop_flicker
         ld       hl,default_enemy_data
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ld       de,enemies
         ld       bc,20
         ldir
         ret
getready:.db      "GET READY!",0
default_enemy_data:
         .DB      2,40,16,0,0
         .DB      2,48,16,0,0
         .DB      2,40,40,0,0
         .DB      2,48,40,0,0       
initialtemplate:
         .db      "SCORE",0
         .db      "LIVES",0
         .db      "LEVEL",0
 ; -------------- SPRITE RENDERING ROUTINE ----------------------------------
offsets_table:
         .db      128,64,32,16,8,4,2,1
drw_spr: ld       a,d
         and      7
         ld       hl,offsets_table
         ld       c,a
         ld       b,0
         add      hl,bc
         ld       bc,(PROGRAM_ADDR)
         add      hl,bc
         ld       a,(hl)
         ld       hl,smc1+1
         add      hl,bc
         ld       (hl),a

         ld       hl,$8641          ;Calculate byte number
         ld       B,0
         ld       a,e
         add      a,a
         add      a,a
         add      a,a
         rl       b
         add      a,a
         rl       b
         ld       c,d
         srl      c
         srl      c
         srl      c
         or       c
         ld       c,a
         add      hl,bc                                    
          
         ld       d,(ix)       
         inc      ix
         ld       b,(ix)        
         inc      ix
oloop:   push     bc                ;Save # of rows
         push     hl                ;Save screen address
         ld       b,d               ;Load width
         ld       c,(ix)            ;Load one line of image
         inc      ix
smc1     ld       a,1               ;Load pixel mask
iloop:   sla      c                 ;Test leftmost pixel
         jr       nc,noplot         ;See if a plot is needed
         ld       e,a               ;OR pixel with screen
         or       (hl)
         ld       (hl),a
         ld       a,e
noplot:  rrca
         jr       nc,notedge        ;Test if edge of byte reached
         inc      hl                ;Go to next byte
notedge: djnz     iloop
         pop      hl                ;Restore address
         ld       bc,16             ;Go to next line
         add      hl,bc
         pop      bc                ;Restore data
         djnz     oloop
         ret

 ; -------------- LEVEL DATA ------------------------------------------------
level_maps:
         .db      03,21,21,17,21,21,21,21,17,21,21,41
         .db      26,19,17,24,03,09,03,09,18,17,25,26
         .db      26,26,26,26,10,06,12,10,26,26,26,26
         .db      18,28,26,18,20,21,21,20,24,26,22,24
         .db      18,25,26,18,17,21,21,17,24,26,19,24
         .db      26,26,26,26,10,03,09,10,26,26,26,26
         .db      26,22,20,24,06,12,06,12,18,20,28,26
         .db      38,21,21,20,21,21,21,21,20,21,21,44

         .db      03,21,21,21,17,21,21,17,21,21,21,25
         .db      26,35,21,21,16,25,19,16,21,21,41,26
         .db      26,26,19,17,24,10,10,18,17,25,26,26
         .db      18,28,26,22,28,26,26,22,28,26,22,24
         .db      18,25,26,19,25,26,26,19,25,26,19,24
         .db      26,26,22,20,24,10,10,18,20,28,26,26
         .db      26,38,21,21,16,28,22,16,21,21,44,26
         .db      22,21,21,21,20,21,21,20,21,21,21,28

         .db      03,21,17,21,21,25,19,21,21,17,21,25
         .db      26,35,28,19,21,28,22,21,25,22,41,26
         .db      26,26,19,24,03,13,07,09,18,25,26,26
         .db      18,28,26,22,20,21,21,20,28,26,22,24
         .db      18,25,26,19,17,21,21,17,25,26,19,24
         .db      26,26,22,24,06,13,07,12,18,28,26,26
         .db      26,38,25,22,21,25,19,21,28,19,44,26
         .db      22,21,20,21,21,28,22,21,21,20,21,28

 ; -------------- BLOCK IMAGES ----------------------------------------------
block_images:
         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00000000

         .db      %11111111
         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00000000

         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10000000

         .db      %11111111
         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10000000

         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %11111111

         .db      %11111111
         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %11111111

         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %11111111

         .db      %11111111
         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %11111111

         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00000001

         .db      %11111111
         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00000001

         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10000001

         .db      %11111111
         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10000001

         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %11111111

         .db      %11111111
         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %11111111

         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %11111111

         .db      %11111111
         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %11111111



         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00011000
         .db      %00011000
         .db      %00000000
         .db      %00000000
         .db      %00000000

         .db      %11111111
         .db      %00000000
         .db      %00000000
         .db      %00011000
         .db      %00011000
         .db      %00000000
         .db      %00000000
         .db      %00000000

         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10011000
         .db      %10011000
         .db      %10000000
         .db      %10000000
         .db      %10000000

         .db      %11111111
         .db      %10000000
         .db      %10000000
         .db      %10011000
         .db      %10011000
         .db      %10000000
         .db      %10000000
         .db      %10000000

         .db      %00000000
         .db      %00000000
         .db      %00000000
         .db      %00011000
         .db      %00011000
         .db      %00000000
         .db      %00000000
         .db      %11111111

         .db      %11111111
         .db      %00000000
         .db      %00000000
         .db      %00011000
         .db      %00011000
         .db      %00000000
         .db      %00000000
         .db      %11111111

         .db      %10000000
         .db      %10000000
         .db      %10000000
         .db      %10011000
         .db      %10011000
         .db      %10000000
         .db      %10000000
         .db      %11111111

         .db      %11111111
         .db      %10000000
         .db      %10000000
         .db      %10011000
         .db      %10011000
         .db      %10000000
         .db      %10000000
         .db      %11111111

         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00011001
         .db      %00011001
         .db      %00000001
         .db      %00000001
         .db      %00000001

         .db      %11111111
         .db      %00000001
         .db      %00000001
         .db      %00011001
         .db      %00011001
         .db      %00000001
         .db      %00000001
         .db      %00000001

         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10011001
         .db      %10011001
         .db      %10000001
         .db      %10000001
         .db      %10000001

         .db      %11111111
         .db      %10000001
         .db      %10000001
         .db      %10011001
         .db      %10011001
         .db      %10000001
         .db      %10000001
         .db      %10000001

         .db      %00000001
         .db      %00000001
         .db      %00000001
         .db      %00011001
         .db      %00011001
         .db      %00000001
         .db      %00000001
         .db      %11111111

         .db      %11111111
         .db      %00000001
         .db      %00000001
         .db      %00011001
         .db      %00011001
         .db      %00000001
         .db      %00000001
         .db      %11111111

         .db      %10000001
         .db      %10000001
         .db      %10000001
         .db      %10011001
         .db      %10011001
         .db      %10000001
         .db      %10000001
         .db      %11111111

         .db      %11111111
         .db      %10000001
         .db      %10000001
         .db      %10011001
         .db      %10011001
         .db      %10000001
         .db      %10000001
         .db      %11111111



         .db      %00000000
         .db      %00000000
         .db      %00011000
         .db      %00111100
         .db      %00111100
         .db      %00011000
         .db      %00000000
         .db      %00000000

         .db      %11111111
         .db      %00000000
         .db      %00011000
         .db      %00111100
         .db      %00111100
         .db      %00011000
         .db      %00000000
         .db      %00000000

         .db      %10000000
         .db      %10000000
         .db      %10011000
         .db      %10111100
         .db      %10111100
         .db      %10011000
         .db      %10000000
         .db      %10000000

         .db      %11111111
         .db      %10000000
         .db      %10011000
         .db      %10111100
         .db      %10111100
         .db      %10011000
         .db      %10000000
         .db      %10000000

         .db      %00000000
         .db      %00011000
         .db      %00111100
         .db      %00111100
         .db      %00011000
         .db      %00000000
         .db      %00000000
         .db      %11111111

         .db      %11111111
         .db      %00000000
         .db      %00011000
         .db      %00111100
         .db      %00111100
         .db      %00011000
         .db      %00000000
         .db      %11111111

         .db      %10000000
         .db      %10000000
         .db      %10011000
         .db      %10111100
         .db      %10111100
         .db      %10011000
         .db      %10000000
         .db      %11111111

         .db      %11111111
         .db      %10000000
         .db      %10011000
         .db      %10111100
         .db      %10111100
         .db      %10011000
         .db      %10000000
         .db      %11111111

         .db      %00000001
         .db      %00000001
         .db      %00011001
         .db      %00111101
         .db      %00111101
         .db      %00011001
         .db      %00000001
         .db      %00000001

         .db      %11111111
         .db      %00000001
         .db      %00011001
         .db      %00111101
         .db      %00111101
         .db      %00011001
         .db      %00000001
         .db      %00000001

         .db      %10000001
         .db      %10000001
         .db      %10011001
         .db      %10111101
         .db      %10111101
         .db      %10011001
         .db      %10000001
         .db      %10000001

         .db      %11111111
         .db      %10000001
         .db      %10011001
         .db      %10111101
         .db      %10111101
         .db      %10011001
         .db      %10000001
         .db      %10000001

         .db      %00000001
         .db      %00000001
         .db      %00011001
         .db      %00111101
         .db      %00111101
         .db      %00011001
         .db      %00000001
         .db      %11111111

         .db      %11111111
         .db      %00000001
         .db      %00011001
         .db      %00111101
         .db      %00111101
         .db      %00011001
         .db      %00000001
         .db      %11111111

         .db      %10000001
         .db      %10000001
         .db      %10011001
         .db      %10111101
         .db      %10111101
         .db      %10011001
         .db      %10000001
         .db      %11111111

         .db      %11111111
         .db      %10000001
         .db      %10011001
         .db      %10111101
         .db      %10111101
         .db      %10011001
         .db      %10000001
         .db      %11111111
 ; -------------- DO STUFF ABOUT YOU ----------------------------------------
do_you:
         ld       ix,(image)
         ld       hl,x
         ld       d,(hl)
         inc      hl
         ld       e,(hl)
         CALL_(drw_spr)
         ld       hl,x
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(hl)
         dec      hl
         dec      hl
         ld       (hl),a
         inc      hl
         ld       b,a
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(hl)
         ld       (y),a
         or       b
         and      7
         jr       nz,read_arrows
 ; -------------- POSSIBLY CHANGE YOUR MOVEMENT ------------------------------
autop:   ld       a,0
         or       a
         jr       z,km
         ld       hl,0
         ld       (nxv),hl
km:
         CALL_(read_arrows)
         ld       hl,(nxv)
         ld       (xv),hl
         ld       hl,x
         ld       c,(hl)            ;C = X
         srl      c                 ;C = X / 2
         srl      c                 ;C = X / 4
         srl      c                 ;C = X / 8
         inc      hl                ;HL -> Y
         ld       a,(hl)            ;A = Y
         ld       b,a               ;B = Y
         srl      a                 ;A = Y / 2
         add      a,b               ;A = 12 * Y / 8
         add      a,c               ;A = (X / 8) + (12 * Y / 8)
         ld       hl,data           ;HL -> MAP
         ld       c,a               ;C = (X / 8) + (12 * Y / 8)
         ld       b,0               ;BC = (X / 8) + (12 * Y / 8)
         add      hl,bc             ;HL -> MAP + (X / 8) + (12 * Y / 8)
         ld       a,(hl)

         bit      4,a
         jr       z,nopill
         push     hl
         ld       hl,pills
         dec      (hl)
         ld       hl,(score)
         inc      hl
         ld       (score),hl
         pop      hl
nopill:  bit      5,a
         jr       z,nospill
         push     af
         push     hl
         ld       hl,enemies
         ld       de,5
         ld       B,4
lse:     ld       a,(hl)
         cp       2
         jr       nz,cste
         ld       (hl),4
cste:    add      hl,de
         djnz     lse
         ld       a,120
         ld       (countdown),a
         ld       hl,(score)
         add      hl,de
         ld       (score),hl
         pop      hl
         pop      af
         nop
nospill: and      15
         ld       (hl),a

bitsmc:  bit      3,a
         ret      z
         ld       hl,0
         ld       (xv),hl
         ret
read_arrows:
         LD       A,%1111110
         ld       ix,bitsmc+1
         ld       de,(PROGRAM_ADDR)
         add      ix,de
         OUT      (1),a
         in       a,(1)
         srl      a
         jr       c,no_down
         ld       hl,image_down
         add      hl,de
         ld       (image),hl
         ld       hl,$0100
         ld       (nxv),hl
         ld       (ix),$57
no_down: srl      a
         jr       c,no_left
         ld       hl,image_left
         add      hl,de
         ld       (image),hl
         ld       hl,$00ff
         ld       (nxv),hl
         ld       (ix),$4f
no_left: srl      a
         jr       c,no_right
         ld       hl,image_right
         add      hl,de
         ld       (image),hl
         ld       hl,$0001
         ld       (nxv),hl
         ld       (ix),$5f
no_right:srl      a
         ret      c
         ld       hl,image_up
         add      hl,de
         ld       (image),hl
         ld       hl,$ff00
         ld       (nxv),hl
         ld       (ix),$47
         ret

 ; -------------- IMAGES ----------------------------------------------------
image_right:
         .db      7,7
         .db      %00000000
         .db      %00111100
         .db      %01110110
         .db      %01111100
         .db      %01111000
         .db      %01111110
         .db      %00111100
image_up:
         .db      7,7
         .db      %00000000
         .db      %00100100
         .db      %01110110
         .db      %01011110
         .db      %01111110
         .db      %01111110
         .db      %00111100
image_left:
         .db      7,7
         .db      %00000000
         .db      %00111100
         .db      %01101110
         .db      %00111110
         .db      %00011110
         .db      %01111110
         .db      %00111100
image_down:
         .db      7,7
         .db      %00000000
         .db      %00111100
         .db      %01111110
         .db      %01111110
         .db      %01111010
         .db      %01101110
         .db      %00100100
image_still:
         .db      7,7
         .db      %00000000
         .db      %00111100
         .db      %01110110
         .db      %01111110
         .db      %01111110
         .db      %01111110
         .db      %00111100
image_ghost:
         .db      7,7
         .db      %00000000
         .db      %00111100
         .db      %01111110
         .db      %01111010
         .db      %01111110
         .db      %01111110
         .db      %01010100
image_ghost_scared:
         .db      7,7
         .db      %00000000
         .db      %00101000
         .db      %01010100
         .db      %00101010
         .db      %01010100
         .db      %00101010
         .db      %01010100
 ; -------------- TOGGLE AUTOPILOT ------------------------------------------
toggle_autopilot:
         ld       a,%111111
         out      (1),a
         ld       hl,jp2nd
         in       a,(1)
         bit      5,a
         jr       nz,notpressed
         ld       a,(hl)
         or       a
         ret      nz
         ld       hl,autop+1
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ld       a,(hl)
         cpl
         ld       (hl),a
         ret
notpressed:
         ld       (hl),0
         ret
 ; -------------- STUFF RELATED TO ENEMIES ----------------------------------
do_enemies:
         ld       a,(countdown)
         or       a
         jr       z,ncd
         dec      a
         ld       (countdown),a
ncd:     ld       hl,enemies
         ld       b,4
enemy_loop:
         push     bc
         push     hl
         ld       b,0
         ld       c,(hl)
         ld       ix,enemy_routine_table
         add      ix,bc
         ld       bc,(PROGRAM_ADDR)
         add      ix,bc
         jp       (ix)
eback:   pop      hl
         pop      bc
         ld       de,5
         add      hl,de
         djnz     enemy_loop
         ret
enemy_routine_table:
         jr       eback
         jr       enemy_normal
         JUMP_(enemy_scared)
         inc      hl
         dec      (hl)
         jr       nz,eback
         dec      hl
         ld       (hl),2
         jr       eback
 ; -------------- NORMAL ENEMY ---------------------------------------------
enemy_normal:
         inc      hl
         ld       a,(hl)
         inc      hl
         or       (hl)
         and      7
         CALL_Z(change_enemy_re)

         ld       a,(y)
         sub      (hl)
         dec      hl
         add      a,5
         bit      7,a
         jr       nz,nocoll1
         cp       10
         jr       nc,nocoll1
         ld       a,(x)
         sub      (hl)
         add      a,5
         bit      7,a
         jr       nz,nocoll1
         cp       10
         jr       nc,nocoll1
         inc      sp
         inc      sp
         inc      sp
         inc      sp
         inc      sp
         inc      sp
         ld       hl,lives
         dec      (hl)
         ret      z
         CALL_(prepare_to_play_)
         JUMP_(main_loop)
nocoll1:
      
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(Hl)
         dec      hl
         dec      hl
         ld       (hl),a
         ld       d,a
         inc      hl
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(hl)
         dec      hl
         dec      hl
         ld       (hl),a
         ld       e,A
         ld       ix,image_ghost
         ld       bc,(PROGRAM_ADDR)
         add      ix,bc
         CALL_(drw_spr)
         JUMP_(eback)
 ; -------------- SCARED ENEMY ---------------------------------------------
slow:    inc      hl
         ld       d,(hl)
         inc      hl
         ld       e,(Hl)
         jr       drawit         
btn:     ld       (hl),2
         JUMP_(enemy_normal)
enemy_scared:
         ld       a,(countdown)
         or       a
         jr       z,btn
         rra
         jr       nc,slow
         inc      hl
         ld       a,(hl)
         inc      hl
         or       (hl)
         and      7
         CALL_Z(change_enemy_re)

         ld       a,(y)
         sub      (hl)
         dec      hl
         add      a,5
         bit      7,a
         jr       nz,nocoll2
         cp       10
         jr       nc,nocoll2
         ld       a,(x)
         sub      (hl)
         add      a,5
         bit      7,a
         jr       nz,nocoll2
         cp       10
         jr       nc,nocoll2
         ld       (hl),20
         dec      hl
         ld       (hl),9
         ld       hl,(score)
         ld       de,50
         add      hl,de
         ld       (score),hl
         JUMP_(eback)
nocoll2:
                
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(Hl)
         dec      hl
         dec      hl
         ld       (hl),a
         ld       d,a
         inc      hl
         ld       a,(hl)
         inc      hl
         inc      hl
         add      a,(hl)
         dec      hl
         dec      hl
         ld       (hl),a
         ld       e,A
drawit:
         ld       ix,image_ghost_scared
         ld       bc,(PROGRAM_ADDR)
         add      ix,bc
         CALL_(drw_spr)
         JUMP_(eback)
 ; -------------- CHANGE ENEMY DIRECTION -----------------------------------
change_enemy_re:
         push     hl
         RAND
         and      3
         add      a,a
         ld       b,0
         ld       c,a
         ld       hl,enemy_dirs_table
         add      hl,bc
         ld       bc,(PROGRAM_ADDR)
         add      hl,bc
         jp       (hl)
enemy_dirs_table:
         jr       left
         jr       right
         jr       up
         ld       a,$57
         ld       bc,$0100
         jr       enemy_continue
left:    ld       a,$4f
         ld       bc,$00ff
         jr       enemy_continue
right:   ld       a,$5f
         ld       bc,1
         jr       enemy_continue
up:      ld       a,$47
         ld       bc,$ff00
enemy_continue:
         ld       hl,smcebit+1
         ld       de,(PROGRAM_ADDR)
         add      hl,de
         ld       (hl),a
         pop      hl
         inc      hl
         ld       (hl),c
         inc      hl
         ld       (hl),b
         dec      hl
         dec      hl

         ld       a,(hl)            ;A = Y
         push     hl
         dec      hl
         ld       c,(hl)            ;C = X
         srl      c                 ;C = X / 2
         srl      c                 ;C = X / 4
         srl      c                 ;C = X / 8
         ld       b,a               ;B = Y
         srl      a                 ;A = Y / 2
         add      a,b               ;A = 12 * Y / 8
         add      a,c               ;A = (X / 8) + (12 * Y / 8)
         ld       hl,data           ;HL -> MAP
         ld       c,a               ;C = (X / 8) + (12 * Y / 8)
         ld       b,0               ;BC = (X / 8) + (12 * Y / 8)
         add      hl,bc             ;HL -> MAP + (X / 8) + (12 * Y / 8)
         ld       a,(hl)
         pop      hl
smcebit: bit      0,a
         ret      z
         inc      hl
         ld       (hl),0
         inc      hl
         ld       (hl),0
         dec      hl
         dec      hl
         ret
 ; -------------- SAVED GAME DATA -------------------------------------------
saved_flag:
         .db      0
save_data:
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0,0,0,0,0
         .dw      0,0,0,0,0,0,0,0
         .db      0
rptr_backup:
         .dw      $1234
chartable:
         .db      "..........XTOJE."
         .db      ". WSNID!.ZVRMHC?"
         .db      ".YUQLGB#x~+PKFA|"
         .db      "@54321.~+"

         .end
