     #include "ti-85.h"

     .org 0
     .db "Quick Snake",0

bigx = TEXT_MEM
bigy = TEXT_MEM+1
direction = TEXT_MEM+2
score = TEXT_MEM+4

	ld a,4

	out (5),a
begin:
	ROM_CALL(CLEARLCD)
	ld a,2
	ld (direction),a
	ld a,63
	ld (bigx),a
	ld a,25
	ld (bigy),a
	ld hl,0
	ld (score),hl


				;draw the walls
bottomwall:
	ld b,0	;x
	ld c,0  ;y
bottomwallloop:
	CALL_(PutPixel)
	inc b
	ld a,b
	cp 128
	jr nz,bottomwallloop
	ld b,0
	ld c,55
topwallloop:
	CALL_(PutPixel)
	inc b
	ld a,b
	cp 128
	jr nz, topwallloop
	ld b,0
	ld c,1
leftwallloop:
	CALL_(PutPixel)
	inc c
	ld a,c
	cp 55
	jr nz, leftwallloop
	ld b,127
	ld c,1
rightwallloop:
	CALL_(PutPixel)
	inc c
	ld a,c
	cp 55
	jr nz, rightwallloop

	ld de,(PROGRAM_ADDR)
	ld bc,$0101
	ld hl,msg
	ld (CURSOR_X),bc
	add hl,de
	ROM_CALL(D_ZM_STR)

loop:
	ld a,(bigx)	
	ld b,a
	ld a,(bigy)
	ld c,a

	ld hl,$0900
	ld ($800C),hl
	ld hl,(score)
	ROM_CALL(D_HL_DECI)

	call GET_KEY
	cp K_EXIT
	JUMP_Z(  quit)
	cp K_RIGHT
	jr z,turnright
	cp K_LEFT
	jr z,turnleft
	jr plotnewpoint

turnright:
	ld a,(direction)
	inc a
	cp 5
	CALL_Z(  reset)
	ld (direction),a
	jr plotnewpoint

turnleft:
	ld a,(direction)
	dec a
	cp 0
	CALL_Z(  resettwo)
	ld (direction),a
	jr plotnewpoint

plotnewpoint:
	ld a,(bigx)
	ld b,a
	ld a,(bigy)
	ld c,a
	ld a,(direction)
	cp 1
	CALL_Z(  moveup)
	cp 2
	CALL_Z(  moveright)
	cp 3
	CALL_Z(  movedown)
	cp 4
	CALL_Z(  moveleft)
	ld a,b
	ld (bigx),a
	ld a,c
	ld (bigy),a
	JUMP_(  PutPixeltwo)

die: 
	call GET_KEY
	cp K_EXIT
	jr z,quit
	cp K_ENTER
	JUMP_Z(  begin)
	jr die

quit:
	ret

delay:
        ld bc,$0BFF
dloop:
        dec bc
        ld a,b
        or c
        jr nz,dloop
        JUMP_(  loop)

moveup:
	inc c
	ret
movedown:
	dec c
	ret
moveleft:
	dec b
	ret
moveright:
	inc b
	ret	

PutPixel:

   push bc                  ;Save away, so it can be used again
   ROM_CALL(FIND_PIXEL)     ;Get the pixel offset
   ld   de,$FC00
   add  hl,de               ;Point into the graphics memory
   or   (HL)                ;A now contains the modified screen byte
   ld   (HL),A              ;Write back to screen to update
   pop  bc                  ;Restore
   ret

PutPixeltwo:

   push bc                  ;Save away, so it can be used again
   ROM_CALL(FIND_PIXEL)     ;Get the pixel offset
   ld   de,$FC00
   add  hl,de               ;Point into the graphics memory
	ld c,(hl)
   or   (HL)                ;A now contains the modified screen byte
   ld   (HL),A              ;Write back to screen to update
	sub c
   pop  bc                  ;Restore
	JUMP_Z(  die)
	ld hl,(score)
	inc hl
	ld (score),hl
   jr delay

reset:
	ld a,1
	ret
resettwo:
	ld a,4
	ret

msg:	.db "By Mike Nistler",0

     .end
