; Simon 1.0 by David Lenhart

#Include "ti-85.h"

up =            $FC87
down =          $FE87
left =          $FD85
right =         $FD89

CursorXY =      $800C
SimonMem =      $80DF
rand =          SimonMem + 168 - 1      ; last byte of text mem


.org 0
.db "Simon 1.0",0

      
        ROM_CALL(CLEARLCD)
        ld hl, $0003
        ld (CursorXY), hl
        ld hl, (PROGRAM_ADDR)
        ld de, TitleScreen
        add hl, de
        set 3,(iy+5)                    ; reverse text ON
        ROM_CALL(D_ZT_STR)              ; dislay title
        ld hl, $1004
        ld (CursorXY), hl
        ld hl, (PROGRAM_ADDR)
        ld de, HighScore
        add hl, de
        call LD_HL_MHL                  ; load high score to hl
        ROM_CALL(D_HL_DECI)             ; display it
        res 3,(iy+5)                    ; reverse text OFF
        CALL_(pause)
        ROM_CALL(CLEARLCD)
        CALL_(EraseBlocks)              ; draw all the lights (squares)
        ld de, SimonMem
        ld bc, $FFFF                    ; $FFFF = max delay time
        CALL_(delay)

AddNew:
        ld a, (rand)                    ; get random number
        and 3                           ; <=3
        inc a                           ; make it 1-4 instead of 0-3
        ld h, d                         ; de = addr of last light in seq.
        ld l, e
        ld (hl), a                      ; new light = random number a
        ld hl, SimonMem - 1             ; start at first light

Replay:                                 ; replay light sequence
        inc hl
        ld a, (hl)
        CALL_(DrawBlock)
        ld bc, $A000
        CALL_(Delay)
        CALL_(EraseBlocks)
        ld bc, $4000                    ; delay time
        CALL_(Delay)
        ld a, l                         ; check to see if address of current
        xor e                           ;   light and last light in seq. are
        jr nz, Replay                   ;   same.  If not then continue. 
        ld hl, SimonMem - 1             ;   test low order bytes.

PlayerTurn:
        ld bc, $5000
        ld a, (KEY_0)
WaitKey:
        CALL_(IncRand)                  ; randomize
        push hl
        call GET_KEY
        pop hl
        or a                            ; set flag
        jr nz, EndKey                   ; if key pressed then done
        dec bc                          ; time remaining for move
        ld a, b                         
        or c                            ; time up?
        jr z, GameOver
        jr WaitKey
EndKey:
        CALL_(EraseBlocks)
        CALL_(DrawBlock)
        inc hl                          ; next light in sequence
        cp (hl)                         ; check if same
        jr nz, GameOver                 ; if not, they lose

        ld b, a                         ; save a for later
        ld a, l
        xor e                           ; done with sequence?
        jr nz, PlayerTurn
        
        ld a, b                         ; restore a
        inc de                          ; inc position for new random #
        ld bc, $8000
        CALL_(delay)                    ; to see last move
        CALL_(EraseBlocks)
        ld bc, $FFFF
        CALL_(delay)
        ld a, $86                       ; $8186 = last byte of text mem
                                        ; $86=least sig. byte of addr.
        cp e                            ; check if we're out of text mem.
                                        
        ret z
        JUMP_(AddNew)

GameOver:
        ex de, hl
        push hl
        ROM_CALL(CLEARLCD)
        pop hl
        ld de, SimonMem
        or a                            ; clear carry
        sbc hl, de                      ; subtract address of last light
                                        ; in seq with address of first
                                        ; to get score
        
        push hl                         ; hl = current score
        ld de, $0C04
        ld (CursorXY), de
        ROM_CALL(D_HL_DECI)             ; display score
        
        ld hl, (PROGRAM_ADDR)
        ld de, HighScore
        add hl, de
        call LD_HL_MHL
        pop de                          ; de = current score

        call CP_HL_DE                   ; compare high score w/ current
        jr nc, SkipSave                 ; don't replace if current <= high

        ld a, e
        ld hl, (PROGRAM_ADDR)
        ld de, HighScore
        add hl, de
        ld (hl), a                      ; save new high score
        
        ld hl, $0503                    ; (x,y)
        ld (CursorXY), hl
        ld hl, (PROGRAM_ADDR)
        ld de, HighScoreMsg             ; inform player of high score
        add hl, de
        set 3,(iy+5)
        ROM_CALL(D_ZT_STR)
SkipSave:
        res 3,(iy+5)                    ; reverse OFF
        ld hl, $0404                    ; (x,y)
        ld (CursorXY), hl
        ld hl, (PROGRAM_ADDR)
        ld de, ScoreMsg
        add hl, de
        ROM_CALL(D_ZT_STR)
        
        ld hl, ZS_BITS
        set 0, (hl)                     ; tell Zshell to re-calc checksum
                                        ;    because program changed
        CALL_(pause)
        call GET_KEY
        ret


pause:
        CALL_(IncRand)                  ; randomize while pausing
        ld a, (KEY_0)
        sub 5                           ; any key but arrows
        jr c, pause
        ret
        
IncRand:                                ; cycle through lights until
        push af                         ;    user presses key
        ld a, (rand)
        inc a
        and 3
        ld (rand), a
        pop af
        ret

Delay:
        dec bc                  ; bc = delay time
        ld a, b
        or c
        jr nz, Delay
        ret

FindBlock:                      ; find position in graphics mem 
                                ; for beginning of block
        ld hl, down
        cp 1            ; scancode
        ret z
        ld hl, left
        cp 2
        ret z
        ld hl, right
        cp 3
        ret z
        ld hl, up
        ret

DrawBlock:              ; (16*16 pixels)
        push de
        push hl
        CALL_(FindBlock)
        ld b, $10
        ld de, $F
Repeat:
        ld (hl), $FF
        inc hl
        ld (hl), $FF
        add hl, de
        djnz Repeat
        pop hl
        pop de
        ret

EraseBlocks:
        push af
        push de
        push hl
        ld a, 4
NextBlock:        
        CALL_(FindBlock)
        ld de, $F
        ld (hl), $FF
        inc hl
        ld (hl), $FF
        ld b, 14
Repeat2:
        add hl, de
        ld (hl), 10000000b
        inc hl
        ld (hl), 00000001b
        djnz Repeat2
        add hl, de
        ld (hl), $FF
        inc hl
        ld (hl), $FF
        dec a
        jr nz, NextBlock
        pop hl
        pop de
        pop af
        ret

HighScore:
.dw 0

TitleScreen:
.db "Simon   By D. Lenhart"
.db "High Score:     ",0

ScoreMsg:
.db "Your Score:",0

HighScoreMsg:
.db "High Score!",0


.end


