
#INCLUDE "TI-85.H"

;version history

;v0.1
;    PLAY option enabled
;    random garbage drawn on screen, more of it when you press buttons

;v0.2
;   no more random garbage, just the border around the screen works
;   ability to exit the game included
v0.21
;   there is a snake, but nothing can be done with him
;   ability to exit game removed

;v0.3
; snake moves now!

;v0.4
;made KillTime function, included speed settings
;it's now also possible to die

; Snakeman board layout is as follows:
;
;------------------
;|                |
;|                |     
;|   Play Area    |               note regarding plot pixel:  
;|                |                         b register = pixels to go right
;|                |                         c register = pixels to go down
;|                |
;------------------

random = $39E8   ; a random number

.org 0
.db "SnakeMan v.0.4",0

snake_x   = $80DF  ;snake head coords
snake_y   = $80E0

food_x = $80E1    ;location of food things
food_y = $80E2
dir    = $80E3    ;player's direction 
level  = $80E4    ; level #

next_x = $80E5    ; where snake's head is about to be
next_y = $80E6
food_exists = $80E7  ;1 means there is a food on the screen
bob = $80E8
quitvar = $80E9

speed = $80EA

score = $80F0     ; the score

    ld a, 0
    ld (score),a
    ld (food_exists),a
    ld (quitvar),a

Initialize:

           ld A, 4                          
           out (5),A                        
                                            
           ld  hl,ZS_BITS                   
           set 0,(hl)
           
           ld A,90
           ld (snake_x),A
           ld A,35
           ld (snake_y),A
           ld A,6
           ld (dir),A
           ld A,0
           ld (level),A
           ld hl,0
           ld (score),hl
           
           ROM_CALL(CLEARLCD)
           
TitleScreen:
            
           set 3,(IY+05)     ;set text to white-on-black
           
           ld hl,$0001
           ld ($800C),hl
           ld hl, (PROGRAM_ADDR)
           ld de, snakeman
           add hl,de
           ROM_CALL(D_ZT_STR)      ; displays string1
           ld hl,$0003
           ld ($800C),hl
           ld hl,(PROGRAM_ADDR)
           ld de, version
           add hl,de
           ROM_CALL(D_ZT_STR)
           ld hl,$0004
           ld ($800C),hl
           ld hl,(PROGRAM_ADDR)
           ld de,bykorn
           add hl,de
           ROM_CALL(D_ZT_STR)
           
           res 3, (IY+05)
           
       ;    ld hl, $2C1A
       ;    ld ($8333), hl
       ;    ld hl, (PROGRAM_ADDR)
       ;    ld de,string2
       ;    add hl,de
       ;    ROM_CALL(D_ZM_STR)
           
           ld hl,$384C
           ld ($8333),hl
           ld hl, (PROGRAM_ADDR)
           ld de, hitEnter
           add hl, de
           ROM_CALL(D_ZM_STR)
           
WaitForEnter:
           call GET_KEY
           cp $09       ;hex code for enter
           jr z,nextScreen
           jr WaitForEnter
           
           
nextScreen:
           ROM_CALL(CLEARLCD)
           ld hl, $0032
           ld ($8333), hl
           ld hl, (PROGRAM_ADDR)
           ld de, chooseDiff
           add hl,de
           ROM_CALL(D_ZM_STR)

           ld hl, $2032
           ld ($8333), hl
           ld hl, (PROGRAM_ADDR)
           ld de, f1
           add hl,de
           ROM_CALL(D_ZM_STR)

           ld hl, $2632
           ld ($8333), hl
           ld hl, (PROGRAM_ADDR)
           ld de, f2
           add hl,de
           ROM_CALL(D_ZM_STR)

           ld hl, $2C32
           ld ($8333), hl
           ld hl, (PROGRAM_ADDR)
           ld de, f3
           add hl,de
           ROM_CALL(D_ZM_STR)

           ld hl, $3332
           ld ($8333), hl
           ld hl, (PROGRAM_ADDR)
           ld de, f4
           add hl,de
           ROM_CALL(D_ZM_STR)

Fred:
        call GET_KEY
        cp $35
        jr z, speed1
        cp $34
        jr z, speed2
        cp $33
        jr z, speed3
        cp $32
        jr z, speed4
        jr Fred

speed1:
        ld a,1
        jr how
speed2:
        ld a,2
        jr how
speed3:
        ld a,4
        jr how
speed4:
        ld a,8

how:
        ld (speed), a
	ROM_CALL(CLEARLCD)
DrawScreen:                    ;Yay!! This part works!!
           ld a, $75           ; and it's plusspeedful
           ld b, a
           ld a, $3F
           ld c, a
Label:                     ;draws vert lines
           ld a,$08
           ld b,a
	   CALL_(PlotPixel)
           ld a, $78
           ld b, a
           CALL_(PlotPixel)

           dec c
           ld a,c
	   cp $08
	   jr nz, Label
           ld a, $3F      ;63
           ld c, a
Label2:         ;draws horiz lines
           
	   ld a, $08
           ld c, a
	   CALL_(PlotPixel)
           ld a, $3F                    ;!!!!!
           ld c, a 			;x,y = over,up, like in real graphing
           CALL_(PlotPixel)

           dec b
           ld a,b
	   cp $08
	   jr nz, Label2       


;///////////////////Main loop///////////////////////////////////////
Snake:
           CALL_(drawSnake)   ;draw snake's head
;          CALL_(foodFunc)    ;fails to determine if pixel is food
           CALL_(getKy)       ;get key from player
           ld a, (quitvar)
           cp 1
           JUMP_Z(Wiedersehen)
           CALL_(pixelAhead)  ;is there a pixel right ahead?
           ld a, (quitvar)
           cp 1
           JUMP_Z(Dead)
           CALL_(moveSnake)   ;new feature of v0.3
           CALL_(KillTime) ; ok, definitely need this
           jr Snake
;////////////////////////////////////////////////////////////////////
Quit:
     ld hl,$3040
     ld ($8333),hl
     ld hl, (PROGRAM_ADDR)
     ld de, pressedquit
     add hl, de
     ROM_CALL(D_ZM_STR)
     ld a, 1
     ld (quitvar), a
      ret

KillTime:
    ld a, (speed)
    ld c, a
three:
    ld a,$f
    ld b,a
two:
    ld a, $ff
one:
    dec a
    cp 0
    jr nz, one

    dec b
    ld a, b
    cp 0
    jr nz,two

    dec c
    ld a,c
    cp 0
    jr nz, three
    ret

drawSnake:
        ld a, (snake_x)
        ld b, a
        ld a, (snake_y)
        ld c, a
        CALL_(PlotPixel)
	ret

foodFunc:
	ld a, (food_exists) ; this doens't load correct number!!
	cp $01
	jr z, isFood
    ld a, r
	sra a
	ld b, a
    ;inc random
    ld a, r
	sra a
	;sra a
	ld c,a
	CALL_(GetPixel)  ; is there a pixel here?
	cp 01
	jr z, foodFunc   ; yes, get another one

    ld a, b
    ld (food_x),a
    ld a, c          ; b = right, c = up
    ld (food_y),a
	CALL_(PlotPixel) ; plot the pixel
	ld a, 1
    ld (food_exists),a
isFood:
	ret

	
getKy:                        ;      04 -up
       call GET_KEY           ; lt-02  03-rt
       cp $01                  ;      01-dn
       CALL_Z(Down)
       cp $02
       CALL_Z(Left)
       cp $03
       CALL_Z(Right)
       cp $04
       CALL_Z(Up)
       cp $37
       CALL_Z(Quit)
       cp $09
       CALL_Z(Pause)
       ret
Pause:
	ld hl,$382C
	ld ($8333),hl
	ld hl, (PROGRAM_ADDR)
	ld de, paused
	add hl, de
	ROM_CALL(D_ZM_STR)
Pause2:
	call GET_KEY
	cp $00
	jr z, Pause2

	ld hl,$382C
	ld ($8333),hl
	ld hl, (PROGRAM_ADDR)
	ld de, clear
	add hl, de
	ROM_CALL(D_ZM_STR)

	ld hl,$3832
	ld ($8333),hl
	ld hl, (PROGRAM_ADDR)
	ld de, clear
	add hl, de
	ROM_CALL(D_ZM_STR)

	ret
Up:
       ld hl, 8
       ld (dir), hl
;//       ld hl,$3040         ;Snake stops 6 pixels below this point
;//       ld ($8333),hl
;//       ld hl, (PROGRAM_ADDR)
;//       ld de, upmessage
;//       add hl, de
;//       ROM_CALL(D_ZM_STR)
       ret

Down:
       ld hl, 2
       ld (dir),hl
       ret
Left:
       ld hl, 4
       ld (dir), hl
       ret
Right:
       ld hl, 6
       ld (dir), hl
       ret

moveSnake: 
      ld a, (dir)
      cp 2
      CALL_Z(moveDown)
      cp 4
      CALL_Z(moveLeft)
      cp 6
      CALL_Z(moveRight)
      cp 8
      CALL_Z(moveUp)
      ret

moveDown:
      ld a, (snake_y)
      dec a
      ld (snake_y), a
      ret

moveLeft:
      ld a, (snake_x)
      dec a
      ld (snake_x), a
      ret

moveRight:
      ld a, (snake_x)
      inc a
      ld (snake_x), a
      ret

moveUp:
      ld a, (snake_y)
      inc a
      ld (snake_y), a
      ret

;/////////////////////////////////////////////////////
;//////////THIS DOESN'T WORK!!! FIX IT!!!/////////////
;/////////////////////////////////////////////////////
pixelAhead:       ;checks to see if pixel's in the way
       ld a, (dir)
       cp 2
       CALL_Z(TestDown)
       cp 4
       CALL_Z(TestLeft)
       cp 6
       CALL_Z(TestRight)
       cp 8
       CALL_Z(TestUp)
       ret           
           
TestDown:       ;send a message to let me know that 
 		;program has gotten this far

       ld a, (snake_x)
       ld b, a
       ld a, (snake_y)
       ld c, a
       dec c           
       CALL_(GetPixel)
       or 0
       JUMP_NZ(SuDs)
       ret

TestUp:
       ld a, (snake_x)
       ld b, a
       ld a, (snake_y)
       ld c, a
       inc c           
       CALL_(GetPixel)
       or 0
       JUMP_NZ(SuDs)
       ret

TestLeft:
       ld a, (snake_x)
       ld b, a
       ld a, (snake_y)
       ld c, a
       dec b           
       CALL_(GetPixel)
       or 0
       JUMP_NZ(SuDs)
       ret

TestRight:

;           ld hl, $2F32
;           ld ($8333), hl
;           ld hl, (PROGRAM_ADDR)
;           ld de, testing
;           add hl,de
;           ROM_CALL(D_ZM_STR)

       ld a, (snake_x)
       ld b, a
       ld a, (snake_y)
       ld c, a
       inc b           
       CALL_(GetPixel)
       or 0
       JUMP_NZ(SuDs)
       ret

;/////////////////////////////////////////////////////
;////////////////////////////////////////////////////
;/////////This is the function that screws up///////
;//////////////////////////////////////////////////
;/////////////////////////////////////////////////

SuDs:              ;snake _has_ run into a pixel

       
           ld hl, $2032
           ld ($8333), hl
           ld hl, (PROGRAM_ADDR)
           ld de, pixel
           add hl,de
           ROM_CALL(D_ZM_STR)

;    ld a, 8;;
;    ld (CURSOR_ROW), a;;
;    ld a, 1;;
;    ld (CURSOR_COL), a;;
    ld a, (food_x)
	and 127
;    ld hl, a;;
;    ROMC_CALL(D_HL_DECI);;
	ld a, (food_y)
	and 127
;    ld a, 7
;    ld (CURSOR_COL), a
	ld a, (snake_x)
	and 127
;    ld hl, a
;    ROM_CALL(D_HL_DECI)

;Label3:
;    call GET_KEY
;    cp 0
;    jr z Label3

;    ld a, hl
	cp (food_x)
    jr nz, Brake  ; if pixel isn't the food
	ld a, (snake_y)     ; pixel, then the player
	and 127
	cp (food_y) ; has smashed his head into a
    jr nz, Dead     ; wall or bitten himself
    ld a, (score)
    add a, 10
    ld (score), a
	ld hl, 0
	ld (food_exists), hl
	ret

Brake:
	ld a,1
	ld (quitvar),a
	ret

Dead:

       
           ROM_CALL(CLEARLCD)
           ld hl, $2F32
           ld ($8333), hl
           ld hl, (PROGRAM_ADDR)
           ld de, youaredead
           add hl,de
           ROM_CALL(D_ZM_STR)

youdontknowjack:
	call GET_KEY
	cp 0
	jr z,youdontknowjack	

	ret z   ; We'll do more later, like tell
		; the player that he SKs
		; right now it's 3:30 AM, I'm very
		; tired, and I want to sleep



;These routines were stolen from Magnus Hagander's Useful Zshell Routines page.
;Obviously he knows a LOT more about the TI-85 than me, so I'll take this
;opportunity to pay homage to him.  Danke schn, Magnus


PlotPixel:                         ; B is x-coord, C is y-coord
        ROM_CALL(FIND_PIXEL)
        ld de,$FC00
        add hl,de
        or (HL)
        ld (HL),A
        ret



ErasePixel:
        ROM_CALL(FIND_PIXEL)
        ld de,$FC00
        add hl,de
        xor 255
        and (HL)
        ld (HL),A
        ret



GetPixel:
        ROM_CALL(FIND_PIXEL)
        ld de,$FC00
        add hl,de
        and (hl)
        ret


Wiedersehen:
    ret z

; Here's all the text that needs to be displayed...


bykorn:          .db "by kornboy",0
snakeman:        .db "Snakeman",0
version:         .db "Snakeman v.0.4",0
yousok:          .db "YoU SK!!",0    ; becomes  on the TI
lives:           .db "Lives: ",0
;score:           .db "Score: ",0
;level:           .db "Level: ",0
rust:            .db "Rust in Peace",0
hitEnter:        .db "Hit ENTER or die...",0
clear:           .db "                              ",0
paused:          .db "*Paused*",0
;instructions

howtoplay:   .db "How to Play",0

up:          .db "Up - start going up",0
left:        .db "Left - start going left",0
right:       .db "Right - start going right",0
down:        .db "Down - start going down",0
exit:        .db "EXIT - quits the game",0
suicide:     .db "DEL - suicide",0
;polaris:     .db "2nd - launches the Polaris missile",0
alpha:       .db "ALHPA - nothing",0
upmessage:   .db "You pressed UP",0
pressedquit: .db "You pressed QUIT",0

chooseDiff:  .db "Choose level of difficulty",0
f1:        .db "F1 - Impossible",0
f2:        .db "F2 - Hard",0
f3:        .db "F3 - Average",0
f4:        .db "F4 - Easy",0

testing:   .db "Testing right",0
pixel:     .db "Found a pixel!!",0
youaredead: .db "You are dead!!",0

.end
