#include ti-85.h

CurPiece       = $80DF ; 9 bytes
NextPiece      = $80E8 ; 9 bytes
tmpPiece       = $80F1 ; 9 bytes (temporary space when rotating)
xy	       = $80FA ; 1 word
corner	       = $80FC ; 1 byte
time	       = $80FD ; 1 byte
mult	       = $80FE ; 1 byte
rotrel	       = $80FF ; 1 byte
score	       = $8100 ; 1 word
multtimer      = $8102 ; 1 byte
count	       = $8103 ; 1 byte
board	       = $8681 ; 640 bytes

.org 0
.db "Squarez 1.0 - by JM",0

 ROM_CALL(CLEARLCD)
 ex de,hl
 ld (score),hl
 xor a
 ld (multtimer),a
 inc a
 ld (mult),a
 ld hl,$FC10
 ld b,62
VLine:
 ld (hl),$01
 ld de,9
 add hl,de
 ld (hl),$80
 ld de,7
 add hl,de
 djnz VLine
 ld hl,$FC11
 ld ix,$FFE1
 ld a,$FF
 ld b,8
HLine:
 ld (hl),a
 ld (ix),a
 inc hl
 inc ix
 djnz HLine
 ld hl,$0D01
 ld ($800C),hl
 ld hl,SquarezText
 ld de,(PROGRAM_ADDR)
 add hl,de
 ROM_CALL(D_ZT_STR)
 ld hl,InfoText
 ld de,(PROGRAM_ADDR)
 add hl,de
 ld de,$1854
 ld ($8333),de
 ROM_CALL(D_ZM_STR)
 ld de,$2550
 ld ($8333),de
 ROM_CALL(D_ZM_STR)
 ld de,$2C50
 ld ($8333),de
 ROM_CALL(D_ZM_STR)
 ld de,$3250
 ld ($8333),de
 ROM_CALL(D_ZM_STR)
 ld de,$3850
 ld ($8333),de
 ROM_CALL(D_ZM_STR)
 ld hl,$256A
 ld ($8333),hl
 ld hl,Hiscore
 ld de,(PROGRAM_ADDR)
 add hl,de
 call LD_HL_MHL
 CALL_(ShowHLDec)
 CALL_(ShowScore)
 CALL_(ShowMult)
 ld hl,$FC31
 ld de,31
 ld b,6
PutDots:
 ld (hl),%01010101
 inc hl
 ld (hl),%01010000
 add hl,de
 djnz PutDots
 CALL_(NewPiece)
 CALL_(NewPiece)
 ld hl,board
 ld (hl),0
 ld d,h
 ld e,l
 inc de
 ld bc,639
 ldir
 ld hl,board+32
 ld ix,board+544
 ld b,20
 ld a,128
FillHBorder:
 ld (hl),a
 ld (ix),a
 inc hl
 inc ix
 djnz FillHBorder
 ld ix,board+32
 ld de,32
 ld b,16
FillVBorder:
 ld (ix+1),a
 ld (ix+18),a
 add ix,de
 djnz FillVBorder
WaitKey:
 CALL_(UpdateTimer)
 ld b,15
Wait:
 halt
 djnz Wait
 ld a,(KEY_0)
 cp $37
 JUMP_Z(Quit)
 ld hl,(xy)
 cp K_MORE
 jr z,Pause
 cp K_SECOND
 jr z,TryDrop
 cp K_ENTER
 jr z,TryDrop
 cp K_ALPHA
 JUMP_Z(TryRotate)
 push hl
 ld hl,RotRel
 res 0,(hl)
 pop hl
 dec a
 jr z,MoveDown
 dec a
 jr z,MoveLeft
 dec a
 jr z,MoveRight
 dec a
 jr z,MoveUp
WaitKeyJump:
 jr WaitKey

MoveDown:
 inc l
TestUpdate:
 ld de,CurPiece
 CALL_(TestPiece)
 jr nz,WaitKey
UpdatePiece:
 push hl
 ld hl,(xy)
 ld de,CurPiece
 CALL_(ShowPiece)
 pop hl
 ld (xy),hl
 CALL_(ShowPiece)
 jr WaitKeyJump
MoveUp:
 dec l
 jr TestUpdate
MoveLeft:
 dec h
 jr TestUpdate
MoveRight:
 inc h
 jr TestUpdate

Pause:
 ld hl,$8007
 ld a,(hl)
 push af
 xor a
 out (2),a
 push hl
 call GET_KEY
PWaitKey:
 call GET_KEY
 or a
 jr z,PWaitKey
 pop hl
 pop af
 out (2),a
 jr WaitKeyJump

TryDrop:	   ; Check if it's possible to drop the piece here
 CALL_(TestCorner)
 jr nz,WaitKeyJump
 ld hl,(xy)
 CALL_(DropPiece)
 CALL_(Search3x3Block)
 ld a,(count)
 cp 16
 jr c,NoMultInc
 ld hl,mult
 inc (hl)
 CALL_(ShowMult)
NoMultInc:
 ld d,0
 ld e,a
 ld a,(time)
 srl a
 srl a
 srl a
 srl a
 inc a
 ld h,0
 ld l,a
 add hl,de
 ex de,hl
 ld l,0
 ld a,(mult)
 ld b,a
Multiply:
 add hl,de
 djnz Multiply
 ld de,(score)
 add hl,de
 ld (score),hl
 CALL_(ShowScore)
 CALL_(NewPiece)
WaitKeyJump2:
 JUMP_(WaitKeyJump)

TryRotate:
 ld hl,RotRel
 bit 0,(hl)
 jr nz,WaitKeyJump2
 set 0,(hl)
 CALL_(RotatePiece)
 ld de,tmpPiece
 ld hl,(xy)
 CALL_(TestPiece)
 jr nz,WaitKeyJump2
 push de
 ld de,CurPiece
 CALL_(ShowPiece)
 pop hl
 ld bc,9
 ldir
 ld hl,(xy)
 ld de,CurPiece
 CALL_(ShowPiece)
 jr WaitKeyJump2

NewPiece:	   ; Copy NextPiece->CurPiece and randomize a new NextPiece
 ld de,NextPiece
 ld hl,$1B07
 CALL_(ShowPiece)
 ex de,hl
 ld de,CurPiece
 ld bc,9
 ldir
 ld hl,$0202
 ld (xy),hl
 CALL_(ShowPiece)
 ld a,r
 srl a
 cp 39
 jr c,InRange
 sub 39
InRange:
 CALL_(ExtractPiece)
 ld hl,$1B07
 CALL_(ShowPiece)
 ld a,144
 ld (time),a
 ret

RotatePiece:	   ; Rotates the current piece clockwise
 ld ix,RotateData
 ld de,(PROGRAM_ADDR)
 add ix,de
 ld hl,CurPiece
 ld de,tmpPiece
 ld bc,9
 push de
 push hl
 ldir
 pop de
 pop hl
 ld b,9
Rotate:
 push bc
 push hl
 ld b,0
 ld c,(ix)
 add hl,bc
 ld a,(de)
 ld (hl),a
 inc de
 inc ix
 pop hl
 pop bc
 djnz Rotate
 ret

TestCorner:	   ; Test if part of CurPiece is in the startcorner
 ld de,CurPiece
 ld hl,(xy)
 ld c,h
 ld b,3
TestCRow:
 push bc
 ld b,3
TestCCol:
 ld a,(de)
 or a
 jr z,TC_NextSq
 ld a,h
 cp 5
 jr nc,TC_NextSq
 ld a,l
 cp 5
 jr nc,TC_NextSq
 pop bc
 ret
TC_NextSq:
 inc de
 inc h
 djnz TestCCol
 pop bc
 ld h,c
 inc l
 djnz TestCRow
 xor a
 ret

TestPiece:	   ; Test if piece at DE fits at H,L
 push de
 push hl
 CALL_(GetBoardPos)
 ld b,3
TestRow:
 push bc
 ld b,3
TestCol:
 ld a,(de)
 or a
 jr z,NoCollide
 ld a,(hl)
 or a
 jr nz,Collide
NoCollide:
 inc de
 inc hl
 djnz TestCol
 ld c,29
 add hl,bc
 pop bc
 djnz TestRow
 pop hl
 pop de
 xor a
 ret
Collide:
 pop bc
 pop hl
 pop de
 inc a
 ret

DropPiece:	   ; Drops the piece at H,L
 push hl
 CALL_(GetBoardPos)
 ld de,CurPiece
 ld b,3
DropRow:
 push bc
 ld b,3
DropCol:
 ld a,(de)
 or (hl)
 ld (hl),a
 inc de
 inc hl
 djnz DropCol
 ld c,29
 add hl,bc
 pop bc
 djnz DropRow
 pop hl
 ret

Search3x3Block:    ; Search 3x3 blocks and make them disappear
 ld hl,board+66
 ld b,13
SearchY:
 push bc
 ld b,14
SearchX:
 ld a,(hl)
 and $7F
 jr z,SB_NextSq
 ld ix,SurData
 ld de,(PROGRAM_ADDR)
 add ix,de
 push bc
 push ix
 push hl
 ld b,8
 ld d,0
CheckSurr:
 ld e,(ix)
 inc ix
 add hl,de
 ld a,(hl)
 or a
 jr z,NoBlock
 cp 128
 jr z,NoBlock
 djnz CheckSurr
 pop hl
 pop ix
 push hl
 ld b,9
ClearSurr:
 ld (hl),2
 ld e,(ix)
 add hl,de
 inc ix
 djnz ClearSurr
 pop hl
 pop bc
 jr SB_NextSq
NoBlock:
 pop hl
 pop ix
 pop bc
SB_NextSq:
 inc hl
 djnz SearchX
 ld c,18
 add hl,bc
 pop bc
 djnz SearchY

 ld de,board+66
 ld hl,count
 ld (hl),0
 ld hl,$FC21
 ld c,$0F
 ld b,15
ClearY:
 push bc
 ld b,16
 push hl
ClearX:
 ld a,(de)
 cp 2
 jr nz,C_NextSq
 push hl
 ld hl,count
 inc (hl)
 pop hl
 xor a
 ld (de),a
 push bc
 push de
 ld de,16
 ld b,4
C_PutSq:
 ld a,c
 and (hl)
 ld (hl),a
 add hl,de
 djnz C_PutSq
 ld de,-64
 add hl,de
 pop de
 pop bc
C_NextSq:
 ld a,c
 cpl
 ld c,a
 cp $0F
 jr nz,CSameByte
 inc hl
CSameByte:
 inc de
 djnz ClearX
 pop hl
 ld c,64
 add hl,bc
 ex de,hl
 ld c,16
 add hl,bc
 ex de,hl
 pop bc
 djnz ClearY
 ret

ShowScore:
 ld hl,$326A
 ld ($8333),hl
 ld hl,(score)
ShowHLDec:
 ld de,tmpPiece+5
 xor a
 ld (de),a
 ld b,5
Unpack:
 call UNPACK_HL
 add a,48
 dec de
 ld (de),a
 djnz Unpack
 ex de,hl
 ROM_CALL(D_ZM_STR)
 ret

ShowMult:
 push af
 push hl
 ld hl,$2C76
 ld ($8333),hl
 ld a,'x'
 ROM_CALL(M_CHARPUT)
 ld a,(mult)
 add a,48
 ROM_CALL(M_CHARPUT)
 pop hl
 pop af
 ret

UpdateTimer:
 ld hl,mult
 ld de,multtimer
 ld a,(hl)
 dec a
 jr z,DecTimer
 ld a,(de)
 dec a
 ld (de),a
 jr nz,DecTimer
 dec (hl)
 CALL_(ShowMult)
DecTimer:
 ld hl,time
 dec (hl)
 ld a,(hl)
 cp 255
 push af
 jr z,ShowTime
 srl a
 srl a
 srl a
 srl a
ShowTime:
 add a,49
 ld hl,$387A
 ld ($8333),hl
 ROM_CALL(M_CHARPUT)
 pop af
 ret nz
OutOfTime:
 ld hl,OOTText
 ld de,(PROGRAM_ADDR)
 add hl,de
 ld de,$0403
 ld b,21
ShowOOT:
 ld a,(iy+5)
 xor 8
 ld (iy+5),a
 ld ($800C),de
 push hl
 ROM_CALL(D_ZT_STR)
 pop hl
 push bc
 ld b,25
OOT_Pause:
 halt
 djnz OOT_Pause
 pop bc
 djnz ShowOOT
 pop af
 CALL_(CheckHiscore)
OOTWaitKey:
 call GET_KEY
 or a
 jr z,OOTWaitKey
 ret

Quit:
 call GET_KEY
 CALL_(CheckHiscore)
 ret

CheckHiscore:
 ld hl,Hiscore
 ld de,(PROGRAM_ADDR)
 add hl,de
 push hl
 call LD_HL_MHL
 ld de,(score)
 ld a,h
 cp d
 jr c,NewHi
 jr nz,NoHi
 ld a,l
 cp e
 jr nc,NoHi
NewHi:
 pop hl
 ld (hl),e
 inc hl
 ld (hl),d
 ld hl,$8C40
 set 0,(hl)
 set 3,(iy+5)
 ld c,11
Blink:
 ld hl,$2226
 ld ($8333),hl
 ld hl,HiText
 ld de,(PROGRAM_ADDR)
 add hl,de
 ROM_CALL(D_ZM_STR)
 ld b,25
BWait:
 halt
 djnz BWait
 dec c
 jr nz,Blink
NWaitKey:
 call GET_KEY
 or a
 jr z,NWaitKey
NoHi:
 pop hl
 ret

GetBoardPos:	   ; Converts H,L to address to board
 ld c,h
 ld b,0
 ld a,l
 add a,a
 add a,a
 add a,a
 ld h,0
 ld l,a
 add hl,hl
 add hl,hl
 add hl,bc
 ld bc,board
 add hl,bc
 ret

ShowPiece:	   ; Shows an extracted piece stored at (DE) at H,L
 push de
 push hl
 CALL_(GetScreenOfs)
 ld b,3
PutRow:
 push bc
 push hl
 ld b,3
PutCol:
 ld a,(de)
 inc de
 or a
 jr z,NoSq
 push bc
 push de
 ld de,16
 ld b,4
PutSq:
 ld a,c
 xor (hl)
 ld (hl),a
 add hl,de
 djnz PutSq
 ld de,-64
 add hl,de
 pop de
 pop bc
NoSq:
 ld a,c
 cpl
 ld c,a
 cp $F0
 jr nz,SameByte
 inc hl
SameByte:
 djnz PutCol
 pop hl
 ld c,64
 add hl,bc
 pop bc
 djnz PutRow
 pop hl
 pop de
 ret

GetScreenOfs:	   ; Converts H,L to its position on the screen
 push de
 ld a,h
 ld h,l
 ld l,0
 srl h
 rr l
 srl h
 rr l
 ld c,$F0
 srl a
 jr nc,EvenX
 ld c,$0F
EvenX:
 ld d,0
 ld e,a
 add hl,de
 ld de,$FBA0
 add hl,de
 pop de
 ret

ExtractPiece:	   ; Extract piece no A into (DE)
 push de
 ld hl,Pieces
 ld bc,(PROGRAM_ADDR)
 add hl,bc
 ld b,0
 ld c,a
 srl c
 srl c
 srl c
 add hl,bc
 ld c,128
 and 7
 jr z,NoShift
 ld b,a
RepShift:
 srl c
 djnz RepShift
NoShift:
 ld b,9
ExtractBit:
 ld a,c
 and (hl)
 ld a,0
 jr z,NoBit
 inc a
NoBit:
 ld (de),a
 inc de
 inc hl
 inc hl
 inc hl
 inc hl
 inc hl
 djnz ExtractBit
 pop de
 ret

Pieces:   ; Data for the 39 pieces, 45 bytes
 .db %11111111,%11010110,%11101100,%11110011,%10111110
 .db %11111111,%11011110,%01111111,%11111111,%11111010
 .db %11011111,%10001111,%01110011,%01101011,%01011000
 .db %11110110,%10111011,%11111010,%00101110,%01101110
 .db %11101111,%11111111,%10011111,%11011101,%11100000
 .db %11110101,%01111101,%11111100,%00010110,%10010000
 .db %11011010,%11101001,%11000011,%00100000,%00000100
 .db %10101111,%01100110,%00011001,%11011100,%00000000
 .db %01111001,%00110001,%10100100,%10000000,%00000000

RotateData:
 .db 2,5,8,1,4,7,0,3,6

SurData:
 .db 1,1,30,1,1,30,1,1

OOTText:
 .db " Out of time ",0

SquarezText:
 .db "Squarez",0

InfoText:
 .db "Next",0
 .db "Best:",0
 .db "Mult:",0
 .db "Score:",0
 .db "Time:",0

HiText:
 .db "A New Hiscore!",0

Hiscore:
 .dw 0

.end
