PROGRAM CMCard; {Version 1.30 vom 12.04.96}
{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 | Programm zum Auslesen von Magnetkarten nach ISO 3554        |
 | in: Turbo Pascal 6.0, 7.0, TurboProfessional                |
 | Mit Schreibmglichkeit ber Portleitung LPT Bit 0           |
 +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

{$N- G- X+}
{ Definieren: COLOR fr Farbdisplay, MOUSE fr Mausbetrieb, }
{ DISPREAD fr Anzeige whrend Lesen }

USES   TPCrt,
{$IFDEF MOUSE}
       TPmouse,
{$ENDIF}
			 TPEdit, Dos, TPWindow, TpPick, TPDir, CMCDef, CMCdec;



  PROCEDURE Initialisiere;
  BEGIN
    window(01,01,80,1);
    textattr := c1d;
    clrscr;
    gotoxy(1,1);
    write(concat('CMCARD Magnetkarten-Analyzer ',VerStr));
    InitRec.Timing1 := 20;
    InitRec.Timing2 := -10;
    InitRec.Timing3 := -5;

    InitRec.PrinterPort := Lpt1;
    InitRec.StatusPort  := Lpt1_status;
    InitRec.Comment := 'Default';
    assign(InitFile,InitFileName);
    {$I-} reset(InitFile); {$I+}
    if ioresult <> 0 then
      begin
        rewrite(InitFile);
        write(InitFile,InitRec);
      end
    else
      read(InitFile,InitRec);
    close(InitFile);
    PrinterPort := InitRec.PrinterPort;
    StatusPort  := InitRec.StatusPort;
  end;

  procedure goupr;
  begin
    window(01,05,80,16);
    textattr := c1f;
  end;

  procedure showupr;
  begin
    window(01,02,80,5);
    textattr := c71;
    gotoxy(1,2);
    for count := 1 to 9 do
      write('F',count,'      ');
    write('F10');
    fastwritewindow('Help  ',2,3,c7e);
    fastwritewindow('Write ',2,11,c7e);
    fastwritewindow('EdBit ',2,19,c7e);
    fastwritewindow('EdISO ',2,27,c7e);
    if DispHex then fastwritewindow('EdHex ',2,35,c7e)
      else
        fastwritewindow('Dec   ',2,35,c7e);
    if DigitDir then fastwritewindow('-->-->',2,43,c3e)
      else
        fastwritewindow('<--<--',2,43,c3e);
    if PosiLog then fastwritewindow('PosLog',2,51,c3c)
      else
        fastwritewindow('NegLog',2,51,c39);
    if BitSign then fastwritewindow('LSBiso',2,59,c3e)
      else
        fastwritewindow('MSBrev',2,59,c3e);
    fastwritewindow('FindSE',2,67,c7e);
    fastwritewindow('Fill0',2,76,c7e);
    textattr := c1d;
    gotoxy(1,3);
    for count := 1 to 8 do write('0----5----');
    goUpr;
  end;

  procedure golwr;
  begin
    window(01,18,80,25);
    textAttr:=c1f;
  end;

  procedure showlwr;
{ Untere Bildschirmhlfte aktualisieren }
  begin
    window(01,17,80,25);
    gotoxy(1,1);
    fastwritewindow('Buff:    Bits:     Start:     Ende:     ',1,1,c71);
    fastwritewindow('Zeichen:              BPI:     PW 1:    ',1,41,c71);
    textAttr:=c7e;
    gotoxy(7,1);
    write(RecNo);
    textAttr:=c7e;
    gotoxy(16,1);
    write(CardData[RecNo].NumOfBits);
    gotoxy(27,1);
    write(CardData[RecNo].StartPos);
    gotoxy(37,1);
    write(CardData[RecNo].EndPos);
    gotoxy(50,1);
    write(NumOfChars);
    gotoxy(68,1);
    write(BitsPerInch);
    gotoxy(77,1);
    write(CardData[RecNo].WritePW);
    textAttr:=$7d;
    write(' ');
    textAttr:=c1d;
    gotoxy(1,9);
    write('Kommentar: ');
    fastwritewindow(CardData[RecNo].Comment,9,12,c1f);
    goLwr;
  end;



  Procedure msgLine(s:String; WaitForKey:Boolean);
  begin
    window(01,02,80,2);
    textattr := c71;
    clrscr;
    gotoxy(1,2);
    write(s);
    If WaitForKey then
      ch:=readkey;
    textattr := c1f;
  end;


  procedure PickTiming;
{ Timing-Eingabe }
  var n: Integer;
    escpd: boolean;
    s: String;
  begin
    msgLine('Timing-Faktor:       Korrektur:       Kommentar:',false);
    ClearFirstChar := true;
    InsertByDefault:= false;
    CursorToEnd := false;
    ForceUpper := true;
    textattr := c7e;
    n := initRec.Timing1;
    readInteger('',2,16,3,c71,c3e,1,99,escpd,n);
    if not escpd then initRec.Timing1 := n;
    gotoxy(16,1);
    write(initRec.Timing1,'   ');
    n := initRec.Timing2;
    readInteger('',2,33,3,c71,c3e,-99,99,escpd,n);
    if not escpd then initRec.Timing2 := n;
    gotoxy(33,1);
    write(initRec.Timing2,'   ');
    s := initRec.Comment;
    readString('',2,51,20,c71,c3e,c3e,escpd,s);
    if not escpd then initRec.Comment := s;
  end;


  {$F+}
  function PortMenuItem(Item:word): String;
  begin
    case Item of
    1: PortMenuItem := 'LPT 1    $378';
    2: PortMenuItem := 'LPT 2    $278';
    3: PortMenuItem := 'Hercules $3BC';
    4: PortMenuItem := 'Timing...';
    end;
  end;
  {$F-}

  procedure PickParameters;
{ Auswahlbox Parameter }
  const
    NumOfChoices = 4;
  var choice: word;
  begin
    case
      InitRec.PrinterPort of
      $378: choice := 1;
      $278: choice := 2;
      $3bc: choice := 3;
    else
      choice := 1;
    end;

    if PickWindow(@PortMenuItem,NumOfChoices,33,6,47,15,
       true,DirColors,' Parameter ',Choice) then
      if PickCmdNum = PksSelect then
        case choice of
        1:
          begin
            PrinterPort := lpt1;
            StatusPort := lpt1_status;
          end;
        2:
          begin
            PrinterPort := lpt2;
            StatusPort := lpt2_status;
          end;
        3:
          begin
            PrinterPort := Herc;
            StatusPort := Herc_status;
          end;
        4: PickTiming;
        end;
    InitRec.PrinterPort:=PrinterPort;
    InitRec.StatusPort:=StatusPort;
    assign(InitFile,InitFileName);
    rewrite(InitFile);
    write(InitFile,InitRec);
    close(InitFile);
  end;

  {$F+}
  function BPIMenuItem(Item:word): String;
  begin
    case Item of
    1: BPIMenuItem := ' 60 BpI (200 Bits)';
    2: BPIMenuItem := ' 75 BpI (250 Bits)';
    3: BPIMenuItem := '100 BpI (335 Bits)';
    4: BPIMenuItem := '150 BpI (500 Bits)';
    5: BPIMenuItem := '210 BpI (700 Bits)';
    6: BPIMenuItem := 'Eigener Wert...';
    end;
  end;
  {$F-}

  procedure PickBPI;
{ Auswahlbox Bitdichte }
  const
    NumOfChoices = 6;
  var choice: word;
      n: Integer;
      escpd: Boolean;
  begin
    case
      BitsPerInch of
      50..65:   choice := 1;
      66..88:   choice := 2;
      89..120:  choice := 3;
      121..179: choice := 4;
      180..250: choice := 5;
    else
      choice := 2;
    end;
    if PickWindow(@BPIMenuItem,NumOfChoices,31,6,50,15,
       true,DirColors,' Schreibdichte ',Choice) then
      if PickCmdNum = PksSelect then
        case choice of
        1:
          CardData[RecNo].NumOfBits := 200;
        2:
          CardData[RecNo].NumOfBits := 250;
        3:
          CardData[RecNo].NumOfBits := 333;
        4:
          CardData[RecNo].NumOfBits := 500;
        5:
          CardData[RecNo].NumOfBits := 700;
        6:
          begin
            ClearFirstChar := true;
            InsertByDefault:= false;
            CursorToEnd := false;
            ForceUpper := true;
            n := CardData[RecNo].NumOfBits;
            readInteger('Anzahl Bits: ',2,1,3,c71,c3e,1,999,escpd,n);
            if not escpd then CardData[RecNo].NumOfBits := n;
          end;
        end;
  end;

  {$F+}
  function PWMenuItem(Item:word): String;
  begin
    case Item of
    1: PWMenuItem := 'F2F   1:1 = 50%';
    2: PWMenuItem := 'Puls  1:2 = 33%';
    3: PWMenuItem := 'Puls  1:3 = 25%';
    end;
  end;
  {$F-}

  procedure PickPW;
{ Auswahlbox Puls/Pausenverhltnis }
  const
    NumOfChoices = 3;
  var choice: word;
      n: Integer;
      escpd: Boolean;
  begin
    choice := CardData[RecNo].WritePW;
    if (choice<1) or (choice>3) then choice:=1;
    if PickWindow(@PWMenuItem,NumOfChoices,31,6,49,15,
       true,DirColors,' Schreib-Bitcode ',Choice) then
      if PickCmdNum = PksSelect then
        CardData[RecNo].WritePW := Choice;
  end;


  function NumToHex (theByte: byte): string;
  var k,x,y: byte;
  begin
   if CardData[RecNo].DigitLen >4 then
       begin
         k := 2;
         NumToHex := '00';
       end
     else
       begin
         k := 1;
         NumToHex := '0';
       end;
   for x := k downto 1 do
     begin
       y := theByte and $F;
       theByte := theByte shr 4;
       NumToHex[x] := char(HexStr[y + 1]);
     end;
  end;



  PROCEDURE WriteCard;
{ Schreiben eines Magnetstreifens per Handdurchzug mit modifiziertem
  Omron-Durchzugsleser.  }

  VAR oldStatus: byte;
      t: LongInt;
      i,j,k,t0,t1,t2: Integer;
      p : boolean;
      TempDataBits: BitArrType;

  BEGIN
    textattr := c1f;
    window(01,05,80,16);
    clrscr;
    writeln('Hinweis: Karte muss VOR dem Aufruf dieser Funktion zwischen den Lichtschranken');
    writeln('des modifizierten Schreibers plaziert werden, da der Rechner auf einen ');
    writeln('Startimpuls wartet.');
    textattr := c1e;
    writeln;
    writeln('Eine Umbauanleitung fr den Omron HNR mit Schaltplan ist bei den Autoren gegen');
    writeln('Einsendung der Shareware-Gebhr von 20 DM (Schein oder Scheck) erhltlich:');
    writeln('Ute Westphal, Carsten Meyer');
    writeln('Darwinstr. 14, D-30165 Hannover');
    writeln('Bitte sehen Sie von telefonischen Anfragen ab.');

    msgLine('Karte nun gleichmig durchziehen...',false);
    t := 0;
    p := false;
    TempDataBits := CardData[RecNo].DataBits;
    for i := CardData[RecNo].NumOfBits+1 to MaxBits do
      TempDataBits[i] := 0;
    j:= BitsPerInch;
    oldStatus := Port[StatusPort];
{$I-,V-,S-,R-}
    ASM cli END;

{ Geschwindigkeit der Magnetkarte messen }
    repeat
    until Port[StatusPort] <> oldStatus;
    repeat
      repeat
        inc(t);
      until Port[StatusPort] = oldStatus;
    until t > 500;
{ Formeln zur Berechnung der Zeitschleifen.
  Grere i oder kleinere t bedeuten hhere Schreibdichte,
  Faktor abhngig von Lichtschranke, Ausgleich fr hhere
  Schreibdichten und Overhead }
    i := (InitRec.Timing1 * j) div 20 + InitRec.Timing2;  { - Korrektur fr hhere Dichte }
    t0 := 10 * t div i + InitRec.Timing3;    { - Gesamt-Overhead }
{ Impuls-Pausenverhltnis bestimmen }
    if CardData[RecNo].WritePW=3 then
    begin
      t1 := t0 div 4 - 2;        { - Overhead in Bit-Schleife }
      t2 := 3*t1;
    end
    else
    begin
      t1 := t0 div 2 - 2;        { - Overhead in Bit-Schleife }
      t2 := t1;
    end;
    k := maxBits;

{ ein paar Sync-Bits (Nullen) schreiben }
    for i := 0 to 7 do
    begin
      p:= not p;
      if p then
        port[PrinterPort] := 1
      else
        port[PrinterPort] := 0;
      for j:= 0 to t0 do;
    end;
{ jetzt geht's los! }
    for i := 0 to maxBits do
    begin
      p:= not p;
      if p then
        port[PrinterPort] := 1
      else
        port[PrinterPort] := 0;
      for j:= 0 to t1 do;
      if TempDataBits[i] = 1 then
        p:= not p;
      if p then
        port[PrinterPort] := 1
      else
        port[PrinterPort] := 0;
      for j:= 0 to t2 do;
    end;

    ASM sti END;
{$I+,V+,S+,R-}

    textattr := c1f;
    goUpr;
    Showupr;
    clrscr;
    gotoxy(1,12);
    write('Startpuls-Loops: ',t);
    write('  Bit0-Loops: ',t0);
    write('  Bit1-Loops: ',t1,'   ');
  END;


  PROCEDURE ReadBits;
{ Liest eine Spur der Magnetkarte aus und schreibt die Bits in
  das Feld CardData[RecNo].DataBits und ggf. auf den Bildschirm }
  VAR j: Integer;
      l: BYTE;
      import: BYTE;
  BEGIN
    textattr := c1f;
    FOR j := 0 TO MaxBits DO
      CardData[RecNo].DataBits[j] :=  0;
    j :=  0;
    REPEAT
      {ASM cli END;}
      IF (Port[StatusPort] AND $40) = 0 then
        BEGIN
          l := (Port[StatusPort] AND $80) SHR 7;
          CardData[RecNo].DataBits[j] := l ;
          inc (j);
          if DispBits then
            write(l:1);
          repeat
          until ((Port[StatusPort] AND $40) <> 0) or keypressed;
        END;
      ASM sti END;
    UNTIL (KeyPressed or (j > MaxBits));
    CardData[RecNo].NumOfBits :=  j;
  END;

  Function CompParity(Val:Integer):Integer;
{ Errechnet die Paritt eines bergebenen Wertes }
{ Ungerade = 1, Gerade = 0 }
  VAR
    i,j,n: Integer;
  begin
    i := 0;
    for n := 0 to 15 do
      begin
        if (Val mod 2) = 1 then
          inc(i);
        Val := Val div 2;
      end;
    CompParity := abs((i mod 2)-1);
  end;

  Function Bits2Int(Pos: Integer): Integer;
{ Konvertiert Bits in CardData[RecNo].DataBits ab Pos mit Lnge
  CardData[RecNo].DigitLen in eine Integer }
  VAR
    i,j,k,n: Integer;
  Begin
    i:= 0;
    j:= 1;
    if BitSign then
      begin
        for n := 0 to CardData[RecNo].DigitLen-1 do
          begin
            if PosiLog then
              i := i + CardData[RecNo].DataBits[Pos+n] * j
            else
              i := i + (1 xor CardData[RecNo].DataBits[Pos+n]) * j;
            j := j * 2;
          end;
      end
    else
      for n := CardData[RecNo].DigitLen-1 downto 0 do
        begin
          if PosiLog then
            i := i + CardData[RecNo].DataBits[Pos+n] * j
          else
            i := i + (1 xor CardData[RecNo].DataBits[Pos+n]) * j;
          j := j * 2;
        end;
    Bits2Int := i;
  End;


  procedure Int2Bits(Pos: Integer; val: Integer);
{ Konvertiert Bits in CardData[RecNo].DataBits ab Pos mit Lnge
  CardData[RecNo].DigitLen in eine Integer }
  VAR
    k,n: Integer;
  Begin
    k := val;
    if BitSign then
      begin
        for n := 0 to CardData[RecNo].DigitLen-1 do
          begin
            if PosiLog then
              CardData[RecNo].DataBits[Pos+n] := 1 and (k shr(n))
            else
              CardData[RecNo].DataBits[Pos+n] := 1 xor (1 and (k shr(n)));
          end;
      end
    else
      for n := CardData[RecNo].DigitLen-1 downto 0 do
        begin
          if PosiLog then
            CardData[RecNo].DataBits[Pos+n] := 1 and (k shr(n))
          else
            CardData[RecNo].DataBits[Pos+n] := 1 xor (1 and (k shr(n)));
        end;
  End;

  PROCEDURE FindStartEnd;
{ Sucht Start-und Endkennung nach ISO }
  var
    Pos: Integer;
  BEGIN
    Pos := -1;
    repeat
      inc(Pos);
    until (Bits2Int(Pos)= Startzeichen) or (pos > CardData[RecNo].NumOfBits-CardData[RecNo].DigitLen);
    CardData[RecNo].StartPos := Pos;
    repeat
      Pos:=Pos+CardData[RecNo].DigitLen;
    until (Bits2Int(Pos)= Endzeichen) or (pos > CardData[RecNo].NumOfBits-CardData[RecNo].DigitLen);
    CardData[RecNo].EndPos := Pos;
  END;

  PROCEDURE Bitfield2Data;
{ Liest aus dem Datenfeld CardData[RecNo].DataBits, beginnend ab
  CardData[RecNo].StartPos bis CardData[RecNo].EndPos-Kennung }
  var i,j,n,Pos,ParMask: Integer;
  begin
    Pos:=CardData[RecNo].StartPos;
    NumOfChars := 1 + (CardData[RecNo].EndPos-CardData[RecNo].StartPos)
      div CardData[RecNo].DigitLen;
    ParityErrs:=0;
    if DigitDir then
      for n := 0 to NumOfChars do
        begin
          RawData[n]:=Bits2Int(Pos);
          Pos:=Pos+CardData[RecNo].DigitLen;
        end
      else
      for n := NumOfChars downto 0 do
        begin
          RawData[n]:=Bits2Int(Pos-CardData[RecNo].DigitLen);
          Pos:=Pos+CardData[RecNo].DigitLen;
        end;

    ParMask:=1;
    for n:= 1 to CardData[RecNo].DigitLen-1 do
      ParMask:=ParMask*2;

    If GetParity then
      for n := 0 to NumOfChars do
        begin
          i := RawData[n];
          j := i and ParMask;    { Parity-Bit isolieren }
          if j <> 0 then
            j:=1;
          i := i and (ParMask-1);
          RawData[n]:=i;
          if CompParity(i) <> j then
            begin
              inc(ParityErrs);
              ParErrArr[n]:=1;
            end
          else
            ParErrArr[n]:=0;
        end;
  END;


  procedure ShowBits;
{ zeigt Bits im oberen Bildschirmfenster an }
  var
    n: Integer;
  begin
    goUpr;
    gotoxy(1,1);
    for n:= 0 to CardData[RecNo].NumOfBits-1 do
      begin
        if n >= CardData[RecNo].StartPos then
          textattr := c3f;
        if n >= CardData[RecNo].EndPos+CardData[RecNo].DigitLen then
          textattr := c1f;
        write(CardData[RecNo].DataBits[n]);
      end;
  end;


  procedure FillBits;
{ Fllt Bit-Datenfeld mit Nullen }
  var
    n: Integer;
  begin
    CardData[RecNo].StartPos:=0;
    CardData[RecNo].EndPos:=0;
    for n:= 0 to MaxBits do
      CardData[RecNo].DataBits[n]:=0;
  end;


  procedure showdecoded;
{ Liefert Dekodierung nach eingestellter Basis }
  var
    i,n,luhn,exor:integer;
    z:char;

  begin
    goLwr;
    clrscr;
    textattr := c1d;
    gotoxy(1,1);
    write('Decodierung nach ', CardData[RecNo].DigitLen);
    if DispASCII then
      write('-Bit-ASCII ')
    else
      write('-Bit-ISO   ');
    writeln('(Offset',zeichenoffset:3,')');
    gotoxy(1,2);
    DecStr:='';
    textattr := c1f;
    FOR n := 0 TO NumOfChars-1 DO
      begin
        if GetParity then
          if ParErrArr[n] = 0 then
            textattr := c1f
          else
            textattr := c2f;
        if DispASCII then
          begin
            if RawData[n]>$31 then
              z:=char(RawData[n])
            else
              z:='.';
          end
        else
          begin
            z:=char(RawData[n]+zeichenoffset);
          end;
        write(z);
        DecStr:=concat(DecStr,z);
      end;
    textattr := c1d;
    gotoxy(45,1);
    write('Luhn-PS:   XOR:    LRC:');
    textattr := c1a;
    gotoxy(54,1);
    write(luhnCS(DecStr));
    gotoxy(61,1);
    write(exorCS(DecStr));
    textattr := c1d;
    gotoxy(1,4);
    write('Rohdaten:');
    gotoxy(1,5);
    textattr := c1f;
    checksum := 0;
    FOR n := 0 TO NumOfChars-1 DO
      begin
        checksum := checksum xor RawData[n];
        if n mod 2 = 0 then
          textattr := c1f
        else textattr := c1a;
        if DispHex then
          Write(NumToHex(RawData[n]))
        else
          write(RawData[n]);
      end;
    textattr := c1a;
    gotoxy(69,1);
    write('$',NumToHex(checksum));
  end;

  procedure HelpWindow;
  begin
    FrameWindow(1, 2, 80, 25, BoxAttr, BoxAttr,' Hilfe ');
    textattr := c1f;
    window(02,03,79,24);
    clrscr;
    window(04,03,79,24);
    writeln('ENTER, r   Lese Karte');
    writeln('F2     w   Schreibe Karte (manueller Durchzug, Modifikation erforderlich)');
    writeln('F3     b   Editiere Bits (Rohdaten)');
    writeln('F4     i   Editiere ISO/ASCII-Daten');
    writeln('F5     x   Editiere Hexadezimal-Daten');
    writeln('       k   Editiere Kommentar');
    writeln('       d   Zeige dekodierten Datensatz (EC/Kredit-/Kundenkarte)');
    writeln('       c   Einstellung der Bitdichte bzw. Anzahl der Bits');
    writeln('       t   Timing (Puls/Pausenverhltnis) der Schreibimpulse');
    writeln('F6         ndere Dekodier-Richtung der Zeichen');
    writeln('F7         ndere positive/negative Logik');
    writeln('F8         ndere Bit-Ausrichtung innerhalb der Zeichen');
    writeln('F9, DEL    Finde Start/Ende-Zeichen fr Dekodierung');
    writeln('F10,   f   Flle alle Bits mit Nullen (lscht Datensatz)');
    writeln('HOME/END   Setze Dekodierlnge auf Anfang/Ende');
    writeln('PgUp/Dwn   Erhhe/verringere Bits pro Zeichen fr Dekodierung');
    writeln('Pfeile     Verschiebe Dekodier-Startposition und -Ende');
    writeln('0...9      Whle Datensatz-Zwischenspeicher 0 bis 9');
    writeln('      s/l  Speichere/Lese Karten-Datensatz auf/von Disk');
    writeln('       p   Einstellung Port-Adresse, Rechner-Timing');
    writeln('       q   Beenden');
    textAttr:=c1e;
    writeln;
    write('Idee und Programm von Ute Westphal und Carsten Meyer, (c) 1/1995');
    ch := readkey;
    Showupr;
    clrscr;
    golwr;
    clrscr;
  end;


  procedure editBits;
{ Einfacher Bitfeld-Editor }
  var i,j,k,n,x,y: Integer;

  begin
    window(01,04,80,16);
    y := CardData[RecNo].StartPos div 80 + 2;
    x := CardData[RecNo].StartPos mod 80 + 1;
    n := CardData[RecNo].StartPos;
    gotoxy(x,y);
    normalCursor;
    textattr := c3e;
    repeat
      z := byte(readkey);
      case z of
      48,49:
        begin
          i := z - 48;
          write(i);
          CardData[RecNo].DataBits[n] := i;
          inc(n);
        end;
      end;
    until (z = 27) or (z = 13);
    ch := ' ';
    hiddenCursor;
  end;


  procedure editISO;
{ ISO-Daten eingeben oder ndern }
  var i,j,k,n: Integer;
    escpd: Boolean;
    s: String;

  begin
    n := 0;
    s := '';
    for n := 0 to NumOfChars-1 do
      s := concat(s,(char(RawData[n]+zeichenoffset)));
    ClearFirstChar := false;
    InsertByDefault:= false;
    CursorToEnd := false;
    if CardData[RecNo].DigitLen < 8 then
      ForceUpper := true
    else
      ForceUpper := false;
    readString('',19,1,159,c1d,c3e,c3e,escpd,s);
    if not escpd then
      begin
        n := length(s);
        if n > 0 then
          for k := 0 to n - 1 do
          begin
            CardData[RecNo].EndPos:= CardData[RecNo].StartPos + k * CardData[RecNo].DigitLen;
            j := byte(s[k+1])-zeichenoffset;
            if GetParity then
              j := j or (CompParity(j) shl (CardData[RecNo].DigitLen-1));
            Int2Bits(CardData[RecNo].EndPos,j);
          end;
      end;
    ch := ' ';
    if CardData[RecNo].EndPos > CardData[RecNo].NumOfBits - CardData[RecNo].DigitLen then
      CardData[RecNo].NumOfBits := CardData[RecNo].EndPos + CardData[RecNo].DigitLen;
  end;

  procedure editHEX;
{ Hex-Daten eingeben oder ndern }
  var i,j,k,n: Integer;
    escpd: Boolean;
    s: String;

  begin
    n := 0;
    s := '';
    for n := 0 to NumOfChars-1 do
      s := concat(s,(NumToHex(RawData[n])));
    ClearFirstChar := false;
    InsertByDefault:= false;
    CursorToEnd := false;
    ForceUpper := true;
    readString('',22,1,239,c1d,c3e,c3e,escpd,s);
    if not escpd then
      begin
        n := length(s) div 2;
        if n > 0 then
          for k := 0 to n - 1 do
          begin
            CardData[RecNo].EndPos:= CardData[RecNo].StartPos + k * CardData[RecNo].DigitLen;
            j := byte(s[k*2+1])-48;
            if j>9 then j := j-7;
            i := byte(s[k*2+2])-48;
            if i>9 then i := i-7;
            j := j*16 + i;
            if GetParity then
              j := j or (CompParity(j) shl (CardData[RecNo].DigitLen-1));
            Int2Bits(CardData[RecNo].EndPos,j);
          end;
      end;
    ch := ' ';
    if CardData[RecNo].EndPos > CardData[RecNo].NumOfBits - CardData[RecNo].DigitLen then
      CardData[RecNo].NumOfBits := CardData[RecNo].EndPos + CardData[RecNo].DigitLen;
  end;

  procedure ReadCard;
{ Karte komplett lesen }
  begin
    FillBits;
    msgLine('Bitte Magnetkarte durchziehen und Taste drcken!',false);
    goupr;
    ReadBits;
    ch := ReadKey;
    FindStartEnd;
  end;

  procedure ReadBuf;
  begin
    ShowExtension:=false;
    if GetFileName('*.DAT',AnyFile,8,5,16,6,DirColors,FileName) = 0 then
    if length(FileName) <> 0 then
      begin
        assign(CardFile,FileName);
        {$I-} reset(CardFile); {$I+}
        if ioresult <> 0 then
          msgLine('Datei nicht gefunden...', true)
        else
          begin
            read(CardFile,CardData[RecNo]);
            close(CardFile);
          end;
      end;
  end;


  procedure WriteBuf;
{ Kartendaten auf Disk schreiben }
  var n: Integer;
    escpd: Boolean;
  begin
    msgLine('',false);
    ClearFirstChar := true;
    InsertByDefault:= true;
    CursorToEnd := true;
    ForceUpper := true;
		readString('Datei schreiben: ',2,1,60,c71,c3e,c3e,escpd,FileName);
    if not escpd then
      begin
        n := pos('.',FileName);
		    if n > 0 then
    	    FileName:=copy(FileName,1,n-1);
        FileName := concat(FileName,'.DAT');
        assign(CardFile,FileName);
        rewrite(CardFile);
        write(CardFile,CardData[RecNo]);
        close(CardFile);
      end;
   end;

  procedure GetComment;
{ Kommentar eingeben oder ndern }
  var n: Integer;
    s: String;
    escpd: Boolean;
  begin
    s := CardData[RecNo].Comment;
    ClearFirstChar := true;
    InsertByDefault:= true;
    CursorToEnd := true;
    ForceUpper := false;
    readString('Kommentar: ',25,1,68,c1d,c3e,c3e,escpd,s);
    if not escpd then
      begin
        CardData[RecNo].Comment := s;
      end;

   end;


  procedure SetValues;
{ Parameter entsprechend der Dekodier-Basis setzen }
  begin
    case CardData[RecNo].DigitLen of
    4:  begin
          zeichenoffset := BitCode5;
          startzeichen  := $1;
          endzeichen    := $FF;
          GetParity := false;
          DispASCII := false;
        end;
    5:  begin
          zeichenoffset := Bitcode5;
          startzeichen  := Startzeichen5;
          endzeichen    := Endzeichen5;
          GetParity := true;
          DispASCII := false;
        end;
    6:  begin
          zeichenoffset := BitCode7;
          startzeichen  := $1;
          endzeichen    := $FF;
          GetParity := false;
          DispASCII := false;
        end;
    7:  begin
          zeichenoffset := Bitcode7;
          startzeichen  := Startzeichen7;
          endzeichen    := Endzeichen7;
          GetParity := true;
          DispASCII := false;
        end;
    8:  begin
          zeichenoffset := BitCode7;
          startzeichen  := $1;
          endzeichen    := $FF;
          GetParity := false;
          DispASCII := true;
        end;
    9:  begin
          zeichenoffset := BitCode7;
          startzeichen  := $1;
          endzeichen    := $FF;
          GetParity := true;
          DispASCII := true;
        end;
    end;
    BitsPerInch := round((CardData[RecNo].NumOfBits) / 3.33);
  end;

  procedure handlekey;
  var
    dlen,dz:Integer;

{ Auf Tastatureingaben reagieren }
  begin
    case z of
      13,114:
        begin        { F1, r }
          goUpr;
          clrscr;
          goLwr;
          clrscr;
          ReadCard;
        end;
      60,119: WriteCard; { F2 }

      48..57:        { 0....9 }
        begin
          RecNo:=z-48;
          goUpr;
          clrscr;
          goLwr;
          clrscr;
        end;
      68, 102:       { F10, f }
        begin
          FillBits;
          goUpr;
          clrscr;
          goLwr;
          clrscr;
        end;
      73:            { PgUp }
        begin
          if CardData[RecNo].DigitLen < 9 then
            inc(CardData[RecNo].DigitLen)
          else
            CardData[RecNo].DigitLen := 4;
          dlen:=3+CardData[RecNo].EndPos-CardData[RecNo].StartPos;
          dz:=dlen div CardData[RecNo].DigitLen;
          dlen:=dz*CardData[RecNo].DigitLen;
          CardData[RecNo].EndPos:=CardData[RecNo].StartPos+dlen;
          goUpr;
          clrscr;
          goLwr;
          clrscr;
        end;
      81:            { PgDwn }
        begin
          if CardData[RecNo].DigitLen > 4 then
            dec(CardData[RecNo].DigitLen)
          else
            CardData[RecNo].DigitLen := 9;
          dlen:=3+CardData[RecNo].EndPos-CardData[RecNo].StartPos;
          dz:=dlen div CardData[RecNo].DigitLen;
          dlen:=dz*CardData[RecNo].DigitLen;
          CardData[RecNo].EndPos:=CardData[RecNo].StartPos+dlen;
        end;
      67,83:         { F9, Del }
        begin
          goUpr;
          clrscr;
          goLwr;
          clrscr;
          FindStartEnd;
        end;
      61, 98:        { F3, b }
        begin
          editBits;
        end;
      100:           { d }
        begin
          str(RecNo,aStr);
          aStr:=concat(' Kartendaten Buffer ',aStr,' ');
          FrameWindow(1, 2, 80, 25, BoxAttr, BoxAttr, aStr);
          window(02,03,79,24);
          clrscr;
          window(03,04,78,24);
          showcardData(DecStr,BitsPerInch);
          ch := readkey;
          Showupr;
          clrscr;
          golwr;
          clrscr;
        end;
      62,105:        { F4, i }
        begin
          editISO;
          goUpr;
          clrscr;
          goLwr;
          clrscr;
        end;
      63,120:        { F5, x }
        begin
          EditHex;
          goUpr;
          clrscr;
          goLwr;
          clrscr;
        end;
      64: 
        begin
          DigitDir:=not DigitDir;    { F6 }
					showUpr;
        end;
      65:
        begin
          PosiLog:= not PosiLog;     { F7 }
          showUpr;
        end;
      66:
        begin
          BitSign:= not BitSign;     { F8 }
			    showUpr;
        end;
      71: CardData[RecNo].StartPos := 0; { Home }
      79:            { End }
          CardData[RecNo].EndPos := CardData[RecNo].StartPos +
          CardData[RecNo].DigitLen * ((CardData[RecNo].NumOfBits-CardData[RecNo].StartPos)
          div CardData[RecNo].DigitLen);
      77:            { <- }
          if CardData[RecNo].StartPos < CardData[RecNo].NumOfBits then
            begin
              inc(CardData[RecNo].StartPos);
              inc(CardData[RecNo].EndPos);
            end;
      75:            { -> }
          if CardData[RecNo].StartPos > 0 then
            begin
              dec(CardData[RecNo].StartPos);
              dec(CardData[RecNo].EndPos);
            end;
      72:            { ^ }
          if CardData[RecNo].EndPos < CardData[RecNo].NumOfBits-CardData[RecNo].DigitLen then
            CardData[RecNo].EndPos := CardData[RecNo].EndPos+CardData[RecNo].DigitLen;
      80:            { v }
          if CardData[RecNo].EndPos > CardData[RecNo].StartPos then
            CardData[RecNo].EndPos := CardData[RecNo].EndPos-CardData[RecNo].DigitLen;
      59,104:        { F1, h }
        HelpWindow;
      107:           { k }
        begin
          GetComment;
          golwr;
          clrscr;
        end;
      112:           { p, Port und Parameter }
        PickParameters;

      99:
        begin
          PickBPI;
          goUpr;
          clrscr;
        end;
      108:           { l, Lese von Disk }
        begin
          goUpr;
          clrscr;
          goLwr;
          clrscr;
          ReadBuf;
        end;
      115: WriteBuf; { s, Speichere Datensatz }
      116: PickPW;   { t, Timing Pulscode }
    end;
    SetValues;
    showBits;
    Bitfield2Data;
    showdecoded;
    showlwr;
  end;

{$IFDEF MOUSE}
  procedure HandleMouse;
{ Maus zur bestimmung des Anfangspunkts im Bitfeld }
  var i,j:Integer;
  begin
    repeat
      mouseWhereXY(mouseX,mouseY,Status);
    until status <> LeftButton;
    case mouseY of
    5..16:
      begin
        i := CardData[RecNo].EndPos-CardData[RecNo].StartPos;
        CardData[RecNo].StartPos := 80*(mouseY - 5) + mouseX - 1;
        CardData[RecNo].EndPos := CardData[RecNo].StartPos + i;
        If CardData[RecNo].StartPos > (CardData[RecNo].NumOfBits - CardData[RecNo].DigitLen) then
          begin
            CardData[RecNo].StartPos := CardData[RecNo].NumOfBits - CardData[RecNo].DigitLen;
            CardData[RecNo].EndPos := CardData[RecNo].StartPos + i;
          end;
        SetValues;
        hidemouse;
        showbits;
        Bitfield2Data;
        showdecoded;
        showlwr;
        showmouse;
      end;
    3:
      begin
        z := 59 + ((mouseX-1) div 8);
        handlekey;
      end;
    18..25:
      begin
      end;
    end;
  end;
{$ENDIF}


BEGIN
  Initialisiere;
{$IFDEF MOUSE}
  showmouse;
{$ENDIF}

  TpPick.PickSrch:=StringPickSrch;
  TpDir.ShowSizeDateTime := False;
  FileName:='CARD.DAT';
  FrameChars := 'Ȼͺ';
  BoxAttr := c1d;
  BoxTextAttr := c1d;
  hiddencursor;
  RecNo:=0;
  zeichenoffset := Bitcode5;
  startzeichen  := Startzeichen5;
  endzeichen    := Endzeichen5;
  DispASCII := false; { Daten zustzlich (hexa)dezimal anzeigen }
  BitSign := true;  { Bitfolge LSB first, nach ISO }
  PosiLog := true;  { Positive Logik, 1=1 }
  DispHex := true;  { zustzliche Anzeige als Hexadezimal }
  DigitDir := true; { Digit-Lesefolge nach ISO }

  for RecNo := 9 downto 0 do
    begin
      FillBits;
      CardData[RecNo].Comment := '';
      CardData[RecNo].DigitLen := 5;
      CardData[RecNo].StartPos := 0;
      CardData[RecNo].NumOfBits := 250;
      CardData[RecNo].Comment := '';
      CardData[RecNo].WritePW := 1;
    end;
  SetValues;
  showupr;
  clrscr;
  ShowBits;
  golwr;
  clrscr;
  ShowDecoded;
  showlwr;

  REPEAT
    msgLine('< > ^ v Home End Del PgUp PgDwn F1..F10 0..9 Enter r/w b/i/x/k c d f s/l p q',false);
    ch := ' ';
    repeat until keypressed
{$IFDEF MOUSE}
		or
      (mouseButtonPressed(LeftButton, count, LastX, LastY));
{$ELSE}
		;
{$ENDIF}
{$IFDEF MOUSE}
    if mouseButtonPressed(LeftButton, count, LastX, LastY) then
      handlemouse
    else
{$ENDIF}
      begin
        ch := readkey;
        z := byte(ch);
        handlekey;
      end;
  UNTIL ch = 'q';
  window(01,01,80,25);
  TextAttr:= c0f;
  clrscr;
  Port[PrinterPort] :=  0;       {* Schalte Spannungsversorgung aus *}
END.
