Attribute VB_Name = "modDIAccounts"
Global Const INSTALLKEY As String = "FCS-0001-01"

Global NewPupilName As String

Global Username As String
Global InstallCode As String
Global BusinessName As String
Global UseWizard As Boolean
Global DoCheckList As Boolean
Global Summaries As Boolean
Global SaveReminder As Boolean
Global PricePerLesson As Currency
Global WizardShowIntro As Boolean
Sub LoadINI()
Dim FN As String
Dim Temp As String
Dim EncryptedName As String
Dim X As Integer

    If Right$(App.Path, 1) <> "\" Then
        FN = App.Path & "\DIAccnts.ini"
    Else
        FN = App.Path & "DIAccnts.ini"
    End If
    
    InstallCode = ReadFileValue(FN, "Fresh=")
    If InstallCode = INSTALLKEY Then
        'This is a new installation and needs to be setup
        Username = InputBox("Please enter your full name:", "Program setup")
        If Username = "" Then
            MsgBox "You have to enter a user name before this program will work!"
            End
        End If
        For X = 1 To Len(Username)
            Temp = Str(Asc(Mid$(Username, X, 1)))
            Temp = Trim(Temp)
            If Len(Temp) = 1 Then
                Temp = "00" & Temp
            ElseIf Len(Temp) = 2 Then
                Temp = "0" & Temp
            End If
            EncryptedName = EncryptedName & Temp
        Next X
        InstallCode = EncryptedName & Chr(69) & InstallCode
        'DEFAULT OPTION VALUES SET HERE!
        BusinessName = "Not Set"
        UseWizard = True
        DoCheckList = True
        Summaries = False
        SaveReminder = True
        PricePerLesson = 14.5
        WizardShowIntro = True
        'Save the default values and initialize the program
        Call SaveINI
        MsgBox "Thank you for using this software, setup is now complete and you can use the program.", , "Completed setup"
    Else
        Username = ReadFileValue(FN, "Username=")
        InstallCode = ReadFileValue(FN, "Install Code=")
        'Check to make sure that the user information is correct
        For X = 1 To Len(Username) * 3 Step 3
            Temp = Temp & Chr(Val(Mid$(InstallCode, X, 3)))
        Next X
        If Temp <> Username Then
            MsgBox "You are either using an invalid username or your install code has been altered. Please reinstall this program to prove that you are licensed to use it.", , "License error"
            End
        End If
        
        If Asc(Mid$(InstallCode, (Len(Username) * 3) + 1, 1)) <> 69 Then
            MsgBox "Your install code has been corrupted, please reinstall this program to prove that you are licensed to use it.", , "License error"
            End
        End If
        
        'If the code gets here then everything is ok
        BusinessName = ReadFileValue(FN, "Business Name=")
        If UCase(ReadFileValue(FN, "Use wizard mode=")) = "TRUE" Then UseWizard = True
        If UCase(ReadFileValue(FN, "Run check list=")) = "TRUE" Then DoCheckList = True
        If UCase(ReadFileValue(FN, "Show summaries=")) = "TRUE" Then Summaries = True
        If UCase(ReadFileValue(FN, "Save reminder=")) = "TRUE" Then SaveReminder = True
        If UCase(ReadFileValue(FN, "Price per lesson=")) = "TRUE" Then PricePerLesson = True
        If UCase(ReadFileValue(FN, "Show wizard intro=")) = "TRUE" Then WizardShowIntro = True
    End If
End Sub

Function ReadFileValue(ByVal TFilename As String, ByVal ValueKey As String) As String
Dim FNum As Integer
Dim CLine As String

    FNum = FreeFile
    Open (TFilename) For Input As FNum
        Do While Not EOF(FNum)
            Line Input #FNum, CLine
            If UCase(Left$(CLine, Len(ValueKey))) = UCase(ValueKey) Then
                'Found it
                ReadFileValue = Right$(CLine, Len(CLine) - Len(ValueKey))
                Close FNum
                Exit Function
            End If
        Loop
    Close FNum
    ReadFileValue = "|_/ERROR\_|"
End Function


Sub SaveINI()
Dim FNum As Integer
Dim WF As String
Dim FN As String

    WF = "[DI Accounts Initialization File]" & vbCrLf
    WF = WF & vbCrLf & "[Install Information]"
    WF = WF & vbCrLf & "Username=" & Username
    WF = WF & vbCrLf & "Install Code=" & InstallCode
    WF = WF & vbCrLf & "Business name=" & BusinessName & vbCrLf
    WF = WF & vbCrLf & "[Program Options]"
    WF = WF & vbCrLf & "Use wizard mode=" & UseWizard
    WF = WF & vbCrLf & "Run check list=" & DoCheckList
    WF = WF & vbCrLf & "Show summaries=" & Summaries
    WF = WF & vbCrLf & "Save reminder=" & SaveReminder & vbCrLf
    WF = WF & vbCrLf & "[Cash Setup]"
    WF = WF & vbCrLf & "Price per lesson=" & PricePerLesson & vbCrLf
    WF = WF & vbCrLf & "[Other Program Information]"
    WF = WF & vbCrLf & "Show wizard intro=" & WizardShowIntro
    
    If Right$(App.Path, 1) <> "\" Then
        FN = App.Path & "\DIAccnts.ini"
    Else
        FN = App.Path & "DIAccnts.ini"
    End If
    
    FNum = FreeFile
    Open (FN) For Output As FNum
        Print #FNum, WF
    Close FNum
End Sub


