// Include header files.  Make sure you have the DirectX headers
// in your compilers include directory, and that ddutil.cpp and
// ddutil.h are in the same directory as the program.

#include "axis.h"

int ScreenWidth = 640;       // Resolution Width
int ScreenHeight = 480;      // Resoluction Height
int ScreenColorLevel= 8;     // Number of Colors, 8 is 256 color,
                             // 16 is High color, and 32 is True Color.
// global DirectDraw objects
LPDIRECTDRAW            lpDD;           // DirectDraw object
LPDIRECTDRAWSURFACE     lpDDSPrimary;   // DirectDraw primary surface
LPDIRECTDRAWSURFACE     lpDDSBack;      // DirectDraw back surface
LPDIRECTDRAWSURFACE     lpDDSMap;       // Offscreen surface #1
LPDIRECTDRAWPALETTE     lpDDPal;        // DirectDraw palette
BOOL                    bActive;        // is application active?

// Reference to the Bitmap with your graphics on it, stored in a Resource.
// Your game will probably use several different graphics files stored in
// several different DirectDraw surfaces.
char szBitmap[] = "Graphics";

// The name of the program.
#define NAME "Easy DirectX C++ Template"
#define TITLE "Brian's DirectX Template #1"

// Some simple game variables
int GameState = 1;  // What state is the program in?

void critical();

// restoreALL function.
// Fixes the graphics if some fool decides to multi-task in the
// middle of the game!
HRESULT restoreAll( void )
{
    HRESULT     ddrval;

    ddrval = lpDDSPrimary->Restore();
    if( ddrval == DD_OK )
    {
        ddrval = lpDDSMap->Restore();
        if( ddrval == DD_OK )
        {
            DDReLoadBitmap(lpDDSMap, szBitmap);
        }
    }
    return ddrval;

}

// FlipScreen function.
// Transfers all video memory from the back buffer onto the screen.
// This is usually the very last thing to do in you update frame loop.
void FlipScreen()
{
    HRESULT ddrval;
    // Flip the surfaces
    while( 1 )
    {
        ddrval = lpDDSPrimary->Flip( NULL, 0 );
        if( ddrval == DD_OK )
        {
            break;
        }
        if( ddrval == DDERR_SURFACELOST )
        {
            ddrval = restoreAll();
            if( ddrval != DD_OK )
            {
                break;
            }
        }
        if( ddrval != DDERR_WASSTILLDRAWING )
        {
            break;
        }
    }
}

// finiObjects function.
// Frees up all the memory the surfaces allocated.
// This function is called on exit.
extern void finiObjects( void )
{
    if( lpDD != NULL )
    {
        if( lpDDSPrimary != NULL )
        {
            lpDDSPrimary->Release();
            lpDDSPrimary = NULL;
        }
        if( lpDDSMap != NULL )
        {
            lpDDSMap->Release();
            lpDDSMap = NULL;
        }
        if( lpDDPal != NULL )
        {
            lpDDPal->Release();
            lpDDPal = NULL;
        }
        lpDD->Release();
        lpDD = NULL;
    }
}

// WindowProc function.
// This is the windows message handling function.
// It can be used to get keyboard commands, but it's probably better
// to put that into your main loop instead.
long FAR PASCAL WindowProc( HWND hWnd, UINT message,
                            WPARAM wParam, LPARAM lParam )
{
    switch( message )
    {
    case WM_ACTIVATEAPP:
        bActive = wParam;
        break;

    case WM_SETCURSOR:
		SetCursor(NULL);         // Disable the mouse.
        return TRUE;

    case WM_CREATE:
		break;

    case WM_KEYDOWN:             // What to do if a key is pressed?
        switch (wParam) {
		case VK_ESCAPE:          // Exit the program
            PostMessage(hWnd, WM_CLOSE, 0, 0);
            break;
		}
		break;
    case WM_DESTROY:
        finiObjects();
        PostQuitMessage( 0 );
        break;
    }

    return DefWindowProc(hWnd, message, wParam, lParam);

}

// doInit function
// This initializes and sets up DirectDraw.
static BOOL doInit( HINSTANCE hInstance, int nCmdShow )
{
    HWND                hwnd;
    WNDCLASS            wc;
    DDSURFACEDESC       ddsd;
    DDSCAPS             ddscaps;
    HRESULT             ddrval;

    /*
     * set up and register window class
     */
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = WindowProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon( hInstance, IDI_APPLICATION );
    wc.hCursor = LoadCursor( NULL, IDC_ARROW );
    wc.hbrBackground = GetStockObject(BLACK_BRUSH);
    wc.lpszMenuName = NAME;
    wc.lpszClassName = NAME;
    RegisterClass( &wc );

    /*
     * create a window
     */
    hwnd = CreateWindowEx(
        0,
        NAME,
        TITLE,
        WS_POPUP,
        0,
        0,
        GetSystemMetrics(SM_CXSCREEN),
        GetSystemMetrics(SM_CYSCREEN),
        NULL,
        NULL,
        hInstance,
        NULL );

    if( !hwnd )
    {
        return FALSE;
    }

	ShowWindow( hwnd, nCmdShow );
    UpdateWindow( hwnd );

    /*
     * create the main DirectDraw object
     */
    ddrval = DirectDrawCreate( NULL, &lpDD, NULL );
    if( ddrval != DD_OK )
    {
        return DDError(hwnd, ddrval, "Error creating directdraw obj\n");
    }

    // Get exclusive mode
    ddrval = lpDD->SetCooperativeLevel( hwnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN );
    if( ddrval != DD_OK )
    {
        return DDError(hwnd, ddrval, "Error getting Exclusion/Fullscreen\n");
    }

    // Set the video mode to 640x480x8
    ddrval = lpDD->SetDisplayMode( ScreenWidth, ScreenHeight, ScreenColorLevel);
    if( ddrval != DD_OK )
    {
        return DDError(hwnd, ddrval, "Error setting display mode\n");
    }

    // Create the primary surface with 1 back buffer
	ddsd.dwSize = sizeof( ddsd );
    ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE |
                          DDSCAPS_FLIP |
                          DDSCAPS_COMPLEX;
    ddsd.dwBackBufferCount = 1;
    ddrval = lpDD->CreateSurface( &ddsd, &lpDDSPrimary, NULL );
    if( ddrval != DD_OK )
    {
        return DDError(hwnd, ddrval, "Error Creating primary surface\n");
    }

    ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
    ddrval = lpDDSPrimary->GetAttachedSurface(&ddscaps, &lpDDSBack);
    if( ddrval != DD_OK )
    {
        return DDError(hwnd, ddrval, "Error attaching primary surface\n");
    }
	

    // create and set the palette
    lpDDPal = DDLoadPalette(lpDD, "Graphics");

    if (lpDDPal)
        lpDDSPrimary->SetPalette(lpDDPal);

    // Create the offscreen surface, by loading our bitmap.
    lpDDSMap = DDLoadBitmap(lpDD, "Graphics", 0, 0);

    if( lpDDSMap == NULL )
    {
        return DDError(hwnd, ddrval, "Error loading bitmap\n");
    }

	DDCOLORKEY ckey;
	
    ckey.dwColorSpaceLowValue       = 0;
    ckey.dwColorSpaceHighValue      = 0;

	lpDDSMap->SetColorKey(DDCKEY_SRCBLT, &ckey);

    return TRUE;
}


// WinMain fucntion
// This function is run first thing when the program starts.
int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
                        LPSTR lpCmdLine, int nCmdShow)
{
    MSG         msg;

    lpCmdLine = lpCmdLine;
    hPrevInstance = hPrevInstance;

    if( !doInit( hInstance, nCmdShow ) )
    {
        return FALSE;
    }
    
	LoadMap();
	DrawMap();

	while( 1 )
    {
        if( PeekMessage( &msg, NULL, 0, 0, PM_NOREMOVE ) )
        {
            if( !GetMessage( &msg, NULL, 0, 0 ) )
                return msg.wParam;
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
        else if( bActive )
        {
            critical(); // Call to the Main Loop!
        }
        else
        {
            // make sure we go to sleep if we have nothing else to do
            WaitMessage();
        }
    }
}

//////////////////////////////////////////////////////////
//////////  CRITICAL  ////////////////////////////////////
//////////////////////////////////////////////////////////
void critical()
{

}