// 
// Isometric Map Functions
//

#include "axis.h"

short map[200][40];

int x_coord = 0;
int y_coord = 0;

extern void LoadMap()
{
	int x;
	int y;

	for (y=0; y<20; y++)
	{
		for (x=0; x<100; x++)
		{
			map[x][y] = 0;
		}
	}
	
	for ( y=20; y<40; y++)
	{
		for (x=100; x<200; x++)
		{
			map[x][y] = 1;
		}
	}
}

extern HRESULT DrawMap()
{
	RECT                rcRect; // Declare DirectDraw blitting variables.
	HRESULT             ddrval;
	
	rcRect.left = 0;           // Position of the graphic
	rcRect.bottom = 15;		// on the offscreen surface.
	rcRect.right = 32;
 
	unsigned char sizex = 32;			// width to begin drawing
	unsigned char sizey = 8;				// height to begin drawing
	
	short x;						// declare x pixel pos
	short y = 8;					// set y pixel pos
	rcRect.top = 7;			// draw bottom 1/2 of first tile

	short tiles;					// number of tiles to run
 
	short i;				
	short j;

	short right = 32;
	short left = 0;

	int temp_x_coord = x_coord;
	int temp_y_coord = y_coord;

	// vertical loop
	for (i=0; i<=60; i++)
	{
		// set default pixel begin position
		x = 32;
	
		// check if even row
		if (!(i & 0x01)) {
			// if last row draw only top of tiles
			if ( i == 60 ) {
				rcRect.bottom = 8;
				sizey = 8;
				y = y - 8;
			}
			// first tile can only show right 1/2
			x = x-16;
			left = 16;
			sizex = 16;
			tiles = 20;		// even rows have 20 tiles
		} else {
			tiles = 19;		// odd rows have 19 tiles
		}
		
		// horizontal loop
		for (j=0; j<=tiles; j++)
		{
			rcRect.left = map[temp_x_coord][temp_y_coord] * 32 + left;
			rcRect.right = map[temp_x_coord][temp_y_coord] * 32 + right;

			// draw tile 
			ddrval = lpDDSBack->BltFast( x-sizex, y-sizey, lpDDSMap, &rcRect, DDBLTFAST_SRCCOLORKEY );
			// if error return value don't try to rebuild now
			if( ddrval != DD_OK ) 
			{
				return ddrval;
			}
	
			// reset shown part of tiles for next row
			if (j == 0) {
				left = 0;
				sizex = 32;
			}
	
			// if last row show only top 1/2
			if ((j == 19) && (!(i & 0x01))) {
				right = 16;
				sizex = 16;
				x = x - 16;
			} 
	
			// move over 32 to draw next row
			x = x + 32;
			temp_x_coord++;
		}
	
		// reset default width attribs for tile
		right = 32;
		sizex = 32;
	
		// if first row reset tile height attribs 
		if (i == 0) {
			rcRect.top = 0;
			sizey = 15;
		}

		// get set to draw next row
		y = y + 8;
		if (!(i & 0x01))
		{
			temp_x_coord++;
		} else {
			temp_x_coord = x_coord;
			temp_y_coord++;
		}
	
	}
	
	FlipScreen();
 // no problems
	return 0;
}