{***************************************************************************}
{* Program made by Johan Bos.                                              *}
{* --------------------------                                              *}
{* This program will display 'burning' pixels. You can set the time each   *}
{* pixel will burn and the number of burning pixels.                       *}
{*                                                                         *}
{* For questions feel free to E-mail me at BOSJOH@FCMAIL.COM.              *}
{* Homepage: HTTP://skyscraper.fortunecity.com/compiler/379                *}
{***************************************************************************}

program burning;
uses smallcrt;                {Needed for I/O}
type XMSrec=record
        Amount:LongInt;
        SrcHandle:Word;
        SrcOffset:LongInt;
        DestHandle:Word;
        DestOffset:LongInt;
     end;
const MAXBURN=400;            {The number of burning pixels}
      BURNTIME=100;           {Each pixel's burning time   }
var XMSMoveInfo:XMSrec;
    buffer,screen,XMSControl:pointer;
    red,green,blue:array[0..255]of byte;
    x,y,btime:array[1..MAXBURN]of word;

procedure SetPalette(col,red,gre,blu:byte);
Begin
   Port[$3C8]:=col;
   Port[$3C9]:=red;
   Port[$3C9]:=gre;
   Port[$3C9]:=blu;
End;{Set one palette DAC entry}

procedure GetPalette(col:byte;var red,gre,blu:byte);
Begin
   Port[$3C7]:=col;
   red:=Port[$3C9];
   gre:=Port[$3C9];
   blu:=Port[$3C9];
End;{Get the RGB values of one palette DAC entry}

procedure VGAscreen;assembler;
Asm
   mov ax, $13
   int $10
End;{Sets up the VGA-screen: 320x200  256 colors}

procedure Textscreen;assembler;
Asm
   mov ax, $3
   int $10
End;{Restores the textscreen}

procedure blur;
var address:word;
Begin
   address:=seg(buffer^);
   asm
      mov es, address
      mov di, 320
      mov cx, 63360
      xor ax, ax
      xor bx, bx
      @Loop:
      mov al, [es:di-1]
      mov bl, [es:di+1]
      add ax, bx
      mov bl, [es:di-320]
      add ax, bx
      mov bl, [es:di+320]
      add ax, bx
      shr ax, 2
      @Done:
      stosb
      loop @Loop
   end;
End;{Makes a really cool blurring effect, and it's fast!}

function XMSInstalled:boolean;
var return:byte;
Begin
   asm
      mov ax, $4300
      int $2F
      mov return, al
   end;
   if return=$80 then XMSInstalled:=TRUE else XMSInstalled:=FALSE;
End;{Check wether XMS is installed or not}

function GetXMSControlAPI:pointer;
var address,offsetptr:word;
Begin
   asm
      mov ax, $4310
      int $2F
      mov address, es
      mov offsetptr, bx
   end;
   GetXMSControlAPI:=ptr(address,offsetptr);
End;{Get the address of XMS-control}

function Ptr2Long(p:pointer):LongInt;Assembler;
Asm
  Mov AX, P.WORD[0]
  Mov DX, P.WORD[2]
End;{Convert a pointer to a LongInt (32 bit decimal number)}

procedure XMSMoveBlock(var movstruct:XMSrec);
begin
   asm
      lds si, movstruct
      mov ah, $0B
      call [XMSControl]
   end;
end;{Move blocks around in the XMS but also in Conventional}

procedure MoveMem(Amount:LongInt;p1:pointer;p2:pointer);
Begin
   XMSMoveInfo.Amount:=Amount;
   XMSMoveInfo.SrcHandle:=0;
   XMSMoveInfo.SrcOffset:=Ptr2Long(p1);
   XMSMoveInfo.DestHandle:=0;
   XMSMoveInfo.DestOffset:=Ptr2Long(p2);
   XMSMoveBlock(XMSMoveInfo);
End;{Moves a memory block}

procedure VSync;
Begin
   while (Port[$3da] and $8)=0 do;
   while not (Port[$3da] and $8)=0 do;
End;{Wait for vertical retrace (no ugly screen).}

procedure BufPutPixel2(x2,y2:word;col:byte);
var address:word;
    ToMem:LongInt;
Begin
   address:=seg(buffer^);
   If (x2>=0) then if (x2<320) then if (y2>=0) then if (y2<200) then begin
      ToMem:=y2 shl 6+y2 shl 8+x2;
      Mem[address:ToMem]:=col;
   end;
End;{Plots a pixel in the buffer}

procedure InitPalette;
var r:byte;
    dump:byte;
Begin
   Randomize;
   dump:=random(6);
   if dump=0 then
      Begin
         For r:=0 to 63 do SetPalette(r,r,0,0);
         For r:=0 to 63 do SetPalette(r+64,63,r,0);
         For r:=0 to 63 do SetPalette(r+128,63,63,r);
         For r:=0 to 63 do SetPalette(r+192,63,63,63);
      End;
   if dump=1 then
      Begin
         For r:=0 to 63 do SetPalette(r,0,r,0);
         For r:=0 to 63 do SetPalette(r+64,r,63,0);
         For r:=0 to 63 do SetPalette(r+128,63,63,r);
         For r:=0 to 63 do SetPalette(r+192,63,63,63);
      End;
   if dump=2 then
      Begin
         For r:=0 to 63 do SetPalette(r,r,0,0);
         For r:=0 to 63 do SetPalette(r+64,63,0,r);
         For r:=0 to 63 do SetPalette(r+128,63,r,63);
         For r:=0 to 63 do SetPalette(r+192,63,63,63);
      End;
   if dump=3 then
      Begin
         For r:=0 to 63 do SetPalette(r,0,0,r);
         For r:=0 to 63 do SetPalette(r+64,r,0,63);
         For r:=0 to 63 do SetPalette(r+128,63,r,63);
         For r:=0 to 63 do SetPalette(r+192,63,63,63);
      End;
   if dump=4 then
      Begin
         For r:=0 to 63 do SetPalette(r,0,r,0);
         For r:=0 to 63 do SetPalette(r+64,0,63,r);
         For r:=0 to 63 do SetPalette(r+128,r,63,63);
         For r:=0 to 63 do SetPalette(r+192,63,63,63);
      End;
   if dump=5 then
      Begin
         For r:=0 to 63 do SetPalette(r,0,0,r);
         For r:=0 to 63 do SetPalette(r+64,0,r,63);
         For r:=0 to 63 do SetPalette(r+128,r,63,63);
         For r:=0 to 63 do SetPalette(r+192,63,63,63);
      End;
End;{Makes a nice palette}

procedure InitNewPalette;
var r:byte;
    dump:byte;
Begin
   For r:=0 to 191 do begin
      red[r]:=0;
      green[r]:=0;
      blue[r]:=0;
   end;
   For r:=192 to 255 do begin
      red[r]:=63;
      green[r]:=63;
      blue[r]:=63;
   end;
   Randomize;
   dump:=random(6);
   if dump=0 then
      Begin
         For r:=0 to 63 do red[r]:=r;
         For r:=0 to 63 do begin
            red[r+64]:=63;
            green[r+64]:=r;
         end;
         For r:=0 to 63 do begin
            red[r+128]:=63;
            green[r+128]:=63;
            blue[r+128]:=r;
         end;
      End;
   if dump=1 then
      Begin
         For r:=0 to 63 do green[r]:=r;
         For r:=0 to 63 do begin
            red[r+64]:=r;
            green[r+64]:=63;
         end;
         For r:=0 to 63 do begin
            red[r+128]:=63;
            green[r+128]:=63;
            blue[r+128]:=r;
         end;
      End;
   if dump=2 then
      Begin
         For r:=0 to 63 do red[r]:=r;
         For r:=0 to 63 do begin
            red[r+64]:=63;
            blue[r+64]:=r;
         end;
         For r:=0 to 63 do begin
            red[r+128]:=63;
            green[r+128]:=r;
            blue[r+128]:=63;
         end;
      End;
   if dump=3 then
      Begin
         For r:=0 to 63 do blue[r]:=r;
         For r:=0 to 63 do begin
            red[r+64]:=r;
            blue[r+64]:=63;
         end;
         For r:=0 to 63 do begin
            red[r+128]:=63;
            green[r+128]:=r;
            blue[r+128]:=63;
         end;
      End;
   if dump=4 then
      Begin
         For r:=0 to 63 do green[r]:=r;
         For r:=0 to 63 do begin
            green[r+64]:=63;
            blue[r+64]:=r;
         end;
         For r:=0 to 63 do begin
            red[r+128]:=r;
            green[r+128]:=63;
            blue[r+128]:=63;
         end;
      End;
   if dump=5 then
      Begin
         For r:=0 to 63 do blue[r]:=r;
         For r:=0 to 63 do begin
            green[r+64]:=r;
            blue[r+64]:=63;
         end;
         For r:=0 to 63 do begin
            red[r+128]:=r;
            green[r+128]:=63;
            blue[r+128]:=63;
         end;
      End;
End;{Makes a new palette to fade to}

procedure InitBuffer;
Begin
   XMScontrol:=GetXMSControlAPI;
   screen:=Ptr($A000,0);
   GetMem(buffer,64000);
   movemem(64000,screen,buffer);
End;{Makes the buffer ready for use}

procedure InitBurn;
var r:integer;
Begin
   For r:=1 to MAXBURN do begin
      x[r]:=random(300)+10;
      y[r]:=random(180)+10;
      btime[r]:=r mod BURNTIME;
   end;
End;{Initialize the burning}

procedure Burn;
var r:integer;
Begin
   For r:=1 to MAXBURN do begin
      inc(btime[r]);
      if btime[r]>BURNTIME then begin
         btime[r]:=0;
         x[r]:=random(300)+10;
         y[r]:=random(180)+10;
      end;
   end;
End;{Burn the pixels}

procedure Burn2Screen;
var r:integer;
Begin
   For r:=1 to MAXBURN do BufPutPixel2(x[r],y[r],255);
   Vsync;
   blur;
   MoveMem(64000,buffer,ptr($A000,0));
End;{Transfer the burning to your eyes}

procedure NewPalette;
var fade,r:byte;
    re,gr,bl:array[0..255]of byte;
Begin
   For r:=0 to 255 do GetPalette(r,re[r],gr[r],bl[r]);
   InitNewPalette;
   fade:=0;
   Repeat
      inc(fade);
      For r:=0 to 255 do begin
         if re[r]>red[r] then dec(re[r]);
         if gr[r]>green[r] then dec(gr[r]);
         if bl[r]>blue[r] then dec(bl[r]);
         if re[r]<red[r] then inc(re[r]);
         if gr[r]<green[r] then inc(gr[r]);
         if bl[r]<blue[r] then inc(bl[r]);
         SetPalette(r,re[r],gr[r],bl[r]);
      end;
      Burn;
      Burn2Screen;
   Until fade=64;
End;{Starts a fading session}

procedure KillBurn;
var r,kill:integer;
Begin
   For kill:=1 to MAXBURN+50 do begin
      For r:=kill to MAXBURN do BufPutPixel2(x[r],y[r],255);
      Vsync;
      blur;
      MoveMem(64000,buffer,ptr($A000,0));
   end;
End;{Fading when exit program routine}

{main}
var ctr:word;
Begin
   VGAscreen;
   InitPalette;
   InitBuffer;
   InitBurn;
   ctr:=0;
   Repeat
      Burn;
      Burn2Screen;
      inc(ctr);
      if ctr>=600 then begin
         NewPalette;
         ctr:=0;
      end;
   Until keypressed;
   KillBurn;
   Textscreen;
End.