{***************************************************************************}
{* Program made by Johan Bos.                                              *}
{* --------------------------                                              *}
{* This is the source for programming 3D. It doesn't use any 3DFX-card     *}
{* though. It can show 3D, make 3D polygons and rotate 3D.                 *}
{*                                                                         *}
{* For questions feel free to E-mail me at BOSJOH@FCMAIL.COM.              *}
{* Homepage: HTTP://skyscraper.fortunecity.com/compiler/379                *}
{***************************************************************************}
program cube;
Uses smallcrt;    {Needed for I/O}

function Deg2Rad(v:real):real;
Begin
   Deg2Rad:=v*0.01745;
End;{Convert degrees to radians}

function InvSin(x:real):real;
Begin
   x:=ArcTan(x/sqrt(1-sqr(x)));
   InvSin:=x;
End;{Calculates the inverted sine}

function InvCos(x:real):real;
Begin
   if x=0 then x:=1.570796327 else x:=ArcTan(sqrt(1-sqr(x))/x);
   InvCos:=x;
End;{Calculates the inverted cosine}

function GetRotated(co1,co2:real;midco1,midco2:integer):real;
var cosine,sine,rad,tdeg,deg,dist,plusco1,plusco2:real;
    dico1,dico2:ShortInt;
Begin
   plusco1:=co1-midco1;
   plusco2:=co2-midco2;
   if plusco1<0 then dico1:=-1 else dico1:=1;
   if plusco2<0 then dico2:=-1 else dico2:=1;
   if dico1=-1 then if dico2=-1 then tdeg:=0 else tdeg:=90
   else if dico1=1 then if dico2=-1 then tdeg:=270 else tdeg:=180;
   plusco1:=abs(plusco1);
   plusco2:=abs(plusco2);
   dist:=sqrt(sqr(plusco1)+sqr(plusco2));
   if dist=0 then rad:=0 else begin
      if plusco1>plusco2 then begin
         cosine:=plusco2/dist;
         rad:=InvCos(cosine);
      end else begin
         sine:=plusco1/dist;
         rad:=InvSin(sine);
      end;
   end;
   deg:=rad/(PI/180);
   if (tdeg=90) or (tdeg=270) then deg:=90-deg;
   deg:=deg+tdeg;
   GetRotated:=deg;
End;{Retrieve the degrees a point already has rotated}

procedure Vsync;
Begin
   while (Port[$3da] and $8)=0 do;
   while not (Port[$3da] and $8)=0 do;
End;{You really need this one...}

procedure RelRotate(var co1,co2:real;midco1,midco2,deg:integer);
var plusco1,plusco2,dist,tdeg:real;
Begin
   tdeg:=GetRotated(co1,co2,midco1,midco2)+deg;
   if tdeg<0 then tdeg:=360-tdeg;
   tdeg:=tdeg-trunc(tdeg/360)*360; {You can't use MOD here...}
   dist:=sqrt(sqr(abs(midco1-co1))+sqr(abs(midco2-co2)));
   plusco1:=dist*sin(Deg2Rad(tdeg));
   plusco2:=dist*cos(Deg2Rad(tdeg));
   co1:=midco1-plusco1;
   co2:=midco2-plusco2;
End;{Makes a point rotate relative to its position}

procedure RelRotate3D(var x,y,z:real;midx,midy,midz,deg:integer;di:byte);
Begin
   if di=1 then RelRotate(x,z,midx,midz,deg);
   if di=2 then RelRotate(x,y,midx,midy,deg);
   if di=3 then RelRotate(z,y,midz,midy,deg);
End;{Rotates a 3D point in 3 Directions. Choose the one you like.}

procedure conv3DTo2D(x,y,z:integer;var newx,newy:integer);
Begin
   z:=abs(z);
   newx:=x+trunc(z*(-x/(320+z)))+160;
   newy:=y+trunc(z*(-y/(200+z)))+100;
End;{Convert a 3D point to a 2D screen coordinate}

procedure VGAscreen;assembler;
Asm
   mov ax, $13
   int $10
End;{Sets up the VGA-screen: 320x200  256 colors}

procedure Textscreen;assembler;
Asm
   mov ax, $3
   int $10
End;{Restores the textscreen}

procedure PutPixel(x,y:word;col:byte);
var ToMem:LongInt;
Begin
   If (x>=0) then if (x<320) then if (y>=0) then if (y<200) then begin
      ToMem:=y*320+x;
      Mem[$A000:ToMem]:=col;
   end;
End;{Procedure for plotting a pixel}

procedure Line(x1,y1,x2,y2:integer;Color:byte);
var r,xlen,ylen,xup,yup,xplus,yplus,step:integer;
Begin
   step:=0;
   xlen:=x2-x1;
   ylen:=y2-y1;
   yplus:=0;
   xplus:=0;
   if xlen>=0 then xup:=1 else begin
      xup:=-1;
      xlen:=-xlen;
   end;
   if ylen>=0 then yup:=1 else begin
      yup:=-1;
      ylen:=-ylen;
   end;
   if (xlen>ylen) then begin
      for r:=0 to xlen do begin
         PutPixel(x1+xplus,y1+yplus,color);
         inc(step,ylen);
         if (step>xlen) then begin
            step:=step-xlen;
            inc(yplus,yup);
         end;
         inc(xplus,xup);
      end;
   end else begin
      for r:=0 to ylen do begin
         PutPixel(x1+xplus,y1+yplus,color);
         inc(step,xlen);
         if (step>0) then begin
            step:=step-ylen;
            inc(xplus,xup);
         end;
         inc(yplus,yup);
      end;
   end;
End;{Draw a line between 2 points}

procedure Draw3DLine(x1,y1,z1,x2,y2,z2:integer;col:byte);
var x3d1,x3d2,y3d1,y3d2:integer;
Begin
   conv3DTo2D(x1,y1,z1,x3d1,y3d1);
   conv3DTo2D(x2,y2,z2,x3d2,y3d2);
   Line(x3d1,y3d1,x3d2,y3d2,col);
End;{Draws a 3D Line. Connect 3 or more points for a polygon.}

{main}
var x,y,z:array[1..8]of real;
    xi,yi,zi:array[1..8]of integer;
    midx,midy,midz:integer;
    r:byte;
Begin
   VGAscreen;
   midx:=0;
   midy:=0;
   midz:=100;{Rotate around this mid-point}
   x[1]:=-50;
   y[1]:=-50;
   z[1]:=50;
   x[2]:=50;
   y[2]:=-50;
   z[2]:=50;
   x[3]:=50;
   y[3]:=50;
   z[3]:=50;
   x[4]:=-50;
   y[4]:=50;
   z[4]:=50;
   x[5]:=-50;
   y[5]:=-50;
   z[5]:=150;
   x[6]:=50;
   y[6]:=-50;
   z[6]:=150;
   x[7]:=50;
   y[7]:=50;
   z[7]:=150;
   x[8]:=-50;
   y[8]:=50;
   z[8]:=150;{Initialize the cube}
   Repeat
      For r:=1 to 8 do begin
         RelRotate3D(x[r],y[r],z[r],midx,midy,midz,1,1);
         xi[r]:=trunc(x[r]);{Convert the real variables}
         yi[r]:=trunc(y[r]);{to use-able screen        }
         zi[r]:=trunc(z[r]);{positions.                }
      end;
      Draw3DLine(xi[1],yi[1],zi[1],xi[2],yi[2],zi[2],15);
      Draw3DLine(xi[2],yi[2],zi[2],xi[3],yi[3],zi[3],15);
      Draw3DLine(xi[3],yi[3],zi[3],xi[4],yi[4],zi[4],15);
      Draw3DLine(xi[4],yi[4],zi[4],xi[1],yi[1],zi[1],15);
      Draw3DLine(xi[5],yi[5],zi[5],xi[6],yi[6],zi[6],15);
      Draw3DLine(xi[6],yi[6],zi[6],xi[7],yi[7],zi[7],15);
      Draw3DLine(xi[7],yi[7],zi[7],xi[8],yi[8],zi[8],15);
      Draw3DLine(xi[8],yi[8],zi[8],xi[5],yi[5],zi[5],15);
      Draw3DLine(xi[1],yi[1],zi[1],xi[5],yi[5],zi[5],15);
      Draw3DLine(xi[2],yi[2],zi[2],xi[6],yi[6],zi[6],15);
      Draw3DLine(xi[3],yi[3],zi[3],xi[7],yi[7],zi[7],15);
      Draw3DLine(xi[4],yi[4],zi[4],xi[8],yi[8],zi[8],15);
      Vsync;
      Draw3DLine(xi[1],yi[1],zi[1],xi[2],yi[2],zi[2],0);
      Draw3DLine(xi[2],yi[2],zi[2],xi[3],yi[3],zi[3],0);
      Draw3DLine(xi[3],yi[3],zi[3],xi[4],yi[4],zi[4],0);
      Draw3DLine(xi[4],yi[4],zi[4],xi[1],yi[1],zi[1],0);
      Draw3DLine(xi[5],yi[5],zi[5],xi[6],yi[6],zi[6],0);
      Draw3DLine(xi[6],yi[6],zi[6],xi[7],yi[7],zi[7],0);
      Draw3DLine(xi[7],yi[7],zi[7],xi[8],yi[8],zi[8],0);
      Draw3DLine(xi[8],yi[8],zi[8],xi[5],yi[5],zi[5],0);
      Draw3DLine(xi[1],yi[1],zi[1],xi[5],yi[5],zi[5],0);
      Draw3DLine(xi[2],yi[2],zi[2],xi[6],yi[6],zi[6],0);
      Draw3DLine(xi[3],yi[3],zi[3],xi[7],yi[7],zi[7],0);
      Draw3DLine(xi[4],yi[4],zi[4],xi[8],yi[8],zi[8],0);
   Until keypressed;
   TextScreen;
End.