//***************************************************************************
//* Program made by Johan Bos.                                              *
//* --------------------------                                              *
//* This program will display fire using a very fast buffer routine.        *
//*                                                                         *
//* For questions feel free to E-mail me at BOSJOH@FCMAIL.COM.              *
//* Homepage: HTTP://skyscraper.fortunecity.com/compiler/379                *
//***************************************************************************

#include <stdlib.h>
#include <conio.h>
#include <malloc.h>
#include <iostream.h> //Needed libs

unsigned char far *screen=(unsigned char far *)0xA0000000L;
unsigned char far *buffer;
unsigned char firestrength;

void setpalette(unsigned char col,unsigned char red,unsigned char gre,unsigned char blu){
   outp(0x3C8,col);
   outp(0x3C9,red);
   outp(0x3C9,gre);
   outp(0x3C9,blu);
};//Set one palette DAC entry

void vgascreen(void){
   asm{
      mov ax, 0x13
      int 0x10
   };
};//Sets up the VGA-screen: 320x200  256 colors

void textscreen(void){
   asm{
      mov ax, 3
      int 0x10
   };
};//Restores the textscreen

void fireeffect(void){
   asm{
      les di, buffer
      mov cx, 31680
      xor ax, ax
      xor bx, bx
   };
   Loop:
   asm{
      mov al, [es:di+319]
      mov bl, [es:di+321]
      add ax, bx
      mov bl, [es:di+320]
      add ax, bx
      mov bl, [es:di+640]
      add ax, bx
      shr ax, 2
      jz Done
      dec ax
   };
   Done:
   asm{
      stosb
      loop Loop
   };
};//Buffer routine to create fire

void vsync(void){
   while (inp(0x3da) & 8);
   while (!(inp(0x3da) & 8));
};//Wait for vertical retrace (no ugly screen).

void initpalette(void){
   unsigned char r;
   for(r=0;r<64;r++) setpalette(r,r,0,0);
   for(r=0;r<64;r++) setpalette(r+64,63,r,0);
   for(r=0;r<64;r++) setpalette(r+128,63,63,r);
   for(r=0;r<64;r++) setpalette(r+192,63,63,63);
};//Makes a nice palette

void initbuffer(void){
   firestrength=255;
   buffer=(unsigned char far *)_fmalloc(64000);
   _fmemset(screen,0,64000);
   _fmemset(buffer,0,32000);
};//Makes the buffer ready for use

void movefire(void){
   unsigned short r;
   for (r=0;r<320;r++) buffer[31999-r]=random(2)*firestrength;
};//Fire!

void fire_to_screen(void){
   unsigned char r;
   vsync();
   fireeffect();
   for (r=0;r<97;r++){
      _fmemcpy(screen+r*640,buffer+r*320,320);
      _fmemcpy(screen+r*640+320,buffer+r*320,320);
   };
};//Make the fire go to the screen

void killfire(void){
   do{
      firestrength--;
      movefire();
      fire_to_screen();
   }while (firestrength>0);
};//Extinguish fire

void main(void){
   vgascreen();
   initpalette();
   initbuffer();
   fire_to_screen();
   do{
      movefire();
      fire_to_screen();
   }while (!kbhit());
   killfire();
   textscreen();
};