// DJGPP Example program 1: Test all videomodes
//
// A part of the graphics engine GFX.H
// CopyRight (c) 2001, Johan Bos
// www.sludgesoft.com/johan
// bosjoh@fcmail.com
//////////////////////////////////////////////////////////////////////////////

#include <gfx.h>      //For all the graphics funtions
#include <conio.h>    //For textmode I/O
#include <stdio.h>    //For textmode I/O
//Needed libraries

GFXENGINE Gfx    = NULL; //The engine itself
SCREEN    Screen = NULL; //Handles the primary screen
//All variables needed for the graphics engine

bool Initialize(void){
   if (!CreateEngine(Gfx)) return(false);
   if (!Gfx->CreateScreen(Screen)) return(false);
   return(true);
};//Prepare the program

void Cleanup(void){
   if (Gfx!=NULL){
      if (Screen!=NULL) Screen->Release();
      Gfx->Release();
   };
};//Prepare to exit the program

void TestMode(unsigned short XRes,unsigned short YRes,unsigned char ColorDepth){
   unsigned long White;     //Stores a white pixel value
   unsigned short XCtr,YCtr;//Counter variables
   unsigned char Key;       //Stores the key a user has pressed

   //Ask the user if he wants to test the videomode
   clrscr();
   printf("%s","Testing: ");
   printf("%U",XRes);
   printf("%s","x");
   printf("%U",YRes);
   printf("%s","x");
   printf("%U",ColorDepth);
   printf("%s","...\n");
   printf("%s","Do you want to proceed (Y/N)?\n");
   do{
      Key=getch();
      if (Key=='n' || Key=='N') return;//stop when the user presses 'n'
   }while (Key!='y' && Key!='Y');       //wait until the user pressed 'y'
   printf("%s","Searching for the videomode...");

   //Try to set the videomode, show an error message on failure
   if (!Screen->SetGfxMode(XRes,YRes,ColorDepth)){
      clrscr();
      printf("%s","\nFailed to set the videomode.\n");
      printf("%s","Press any key to continue...");
      getch();
      return;
   };

   //Determine a white pixel
   if (ColorDepth==8)  White=255;
   if (ColorDepth==15) White=32767;
   if (ColorDepth==16) White=65535;
   if (ColorDepth==32) White=16777215;

   //Draw a pattern on the screen
   if (ColorDepth==8) for (YCtr=0;YCtr<16;YCtr++) for (XCtr=0;XCtr<16;XCtr++) Screen->Bar(XRes-96+XCtr*6,YRes-96+YCtr*6,XRes-89+XCtr*6,YRes-89+YCtr*6,YCtr*16+XCtr);
   if (ColorDepth==15) for (YCtr=0;YCtr<96;YCtr++) for (XCtr=0;XCtr<96;XCtr++) Screen->PutPixel(XRes-96+XCtr,YRes-96+YCtr,XCtr/3+XCtr/6*32+YCtr/3*1024);
   if (ColorDepth==16) for (YCtr=0;YCtr<96;YCtr++) for (XCtr=0;XCtr<96;XCtr++) Screen->PutPixel(XRes-96+XCtr,YRes-96+YCtr,XCtr/3*33+YCtr/3*2048);
   if (ColorDepth==32) for (YCtr=0;YCtr<100;YCtr++) for (XCtr=0;XCtr<100;XCtr++) Screen->PutPixel(XRes-96+XCtr,YRes-96+YCtr,XCtr*258+YCtr*131072);
   Screen->Rectangle(0,0,XRes-1,YRes-1,White);
   Screen->Line(0,0,XRes-1,YRes-1,White);
   Screen->Line(XRes-1,0,0,YRes-1,White);

   //Wait for a key and return
   getch();
   Screen->CloseGfxMode();
};//Tests a videomode

void main(){
   if (Initialize()){
      //Show some copyright information
      clrscr();
      printf("%s","DJGPP videomode test example\n");
      printf("%s","Made using the GFX.H graphics engine\n");
      printf("%s","CopyRight (c) 2001, Johan Bos\n");
      printf("%s","\nPress any key to continue...\n");
      getch();

      //Test all videomodes
      TestMode(320,200,8);
      TestMode(320,200,15);
      TestMode(320,200,16);
      TestMode(320,200,32);
      TestMode(320,240,8);
      TestMode(320,240,15);
      TestMode(320,240,16);
      TestMode(320,240,32);
      TestMode(400,300,8);
      TestMode(400,300,15);
      TestMode(400,300,16);
      TestMode(400,300,32);
      TestMode(512,384,8);
      TestMode(512,384,15);
      TestMode(512,384,16);
      TestMode(512,384,32);
      TestMode(640,480,8);
      TestMode(640,480,15);
      TestMode(640,480,16);
      TestMode(640,480,32);
      TestMode(800,600,8);
      TestMode(800,600,15);
      TestMode(800,600,16);
      TestMode(800,600,32);
      TestMode(1024,768,8);
      TestMode(1024,768,15);
      TestMode(1024,768,16);
      TestMode(1024,768,32);
      TestMode(1280,1024,8);
      TestMode(1280,1024,15);
      TestMode(1280,1024,16);
      TestMode(1280,1024,32);
      TestMode(1600,1200,8);
      TestMode(1600,1200,15);
      TestMode(1600,1200,16);
      TestMode(1600,1200,32);

      //Exit message
      clrscr();
      printf("%s","Made by Johan Bos\n");
      printf("%s","Visit my website at http://www.sludgesoft.com/johan\n");
   };
   Cleanup();
};
