// DJGPP Example program 2: How to use buffers to program a screensaver
//                          Retrieving a pointer to the buffer memory
//                          Setting up a palette
//
// A part of the graphics engine GFX.H
// CopyRight (c) 2001, Johan Bos
// www.sludgesoft.com/johan
// bosjoh@fcmail.com
//////////////////////////////////////////////////////////////////////////////

#include <gfx.h>   //For all the graphics funtions
#include <conio.h> //For textmode I/O
#include <stdio.h> //For textmode I/O
//Needed libraries

#define NUM_OF_VERTEXES 3 //The number of vertexes on the screen

GFXENGINE Gfx    = NULL; //The engine itself
SCREEN    Screen = NULL; //Handles the primary screen
BUFFER    Buffer = NULL; //Handles the backbuffer
PALETTE   Pal;           //Palette data
//All variables needed for the graphics engine

BUFFERINFO info; //Holds the pointer to the backbuffer

unsigned short vx[NUM_OF_VERTEXES]  ,vy[NUM_OF_VERTEXES];
char           vxdi[NUM_OF_VERTEXES],vydi[NUM_OF_VERTEXES];
//Global variables needed for the screensaver

bool Initialize(void){
   if (!CreateEngine(Gfx)) return(false);
   if (!Gfx->CreateScreen(Screen)) return(false);
   if (!Screen->SetGfxMode(320,240,8)) return(false);
   if (!Screen->AttachBuffer(Buffer)) return(false);
   if (!Buffer->GetInfo(&info)) return(false);
   return(true);
};//Prepare the program

void Cleanup(void){
   if (Gfx!=NULL){
      if (Screen!=NULL){
         if (Buffer!=NULL) Buffer->Release();
         Screen->CloseGfxMode();
         Screen->Release();
      };
      Gfx->Release();
   };
};//Prepare to exit the program

void MakePalette(void){
   unsigned char Ctr;//Counter variable

   for (Ctr=0;Ctr<64;Ctr++){
      Pal[Ctr*3]=Ctr;
      Pal[Ctr*3+1]=0;
      Pal[Ctr*3+2]=0;       //Black->Red
      Pal[192+Ctr*3]=63;
      Pal[192+Ctr*3+1]=Ctr;
      Pal[192+Ctr*3+2]=0;    //Red->Yellow
      Pal[384+Ctr*3]=63;
      Pal[384+Ctr*3+1]=63;
      Pal[384+Ctr*3+2]=Ctr; //Yellow->White
      Pal[576+Ctr*3]=63;
      Pal[576+Ctr*3+1]=63;
      Pal[576+Ctr*3+2]=63;  //White
   };
   Screen->SetPalette(Pal);
};//Make a nice white-yellow-red-black 256 color palette

void BlurBuffer(void){
   __asm__("
      addl $0x140, %%edi
      addl $0x140, %%esi
      movl $0x12980, %%ecx
      xorl %%eax, %%eax
      xorl %%ebx, %%ebx
   0:\n
      dec %%esi
      lodsb
      movw %%ax, %%bx
      inc %%esi
      lodsb
      addw %%ax, %%bx
      subl $0x142, %%esi
      lodsb
      addw %%ax, %%bx
      addl $0x27F, %%esi
      lodsb
      subl $0x140, %%esi
      addw %%bx, %%ax
      shrw $0x2, %%ax
      jz 1f\n
      dec %%ax
   1:\n
      stosb
      dec %%ecx
      jnz 0b\n
      "
      :
      : "D" (info.Data8), "S" (info.Data8)
      : "eax","ebx","ecx","memory"
   );
};//Use blurring to get a smooth fading effect

void InitScreenSaver(void){
   unsigned char Ctr;//Counter variable

   for (Ctr=0;Ctr<NUM_OF_VERTEXES;Ctr++){
      vx[Ctr]=random()%300+10;
      vy[Ctr]=random()%220+10;
      if (random()%2==0) vxdi[Ctr]=-1; else vxdi[Ctr]=1;
      if (random()%2==1) vydi[Ctr]=-1; else vydi[Ctr]=1;
   };//Determine vertex positions and directions
};//Initialize the screensaver

void UpdateFrame(void){
   unsigned char Ctr;//Counter variable

   for (Ctr=0;Ctr<NUM_OF_VERTEXES;Ctr++){
      vx[Ctr]+=vxdi[Ctr];
      vy[Ctr]+=vydi[Ctr];
      if (vx[Ctr]<5 || vx[Ctr]>314) vxdi[Ctr]=-vxdi[Ctr];
      if (vy[Ctr]<5 || vy[Ctr]>234) vydi[Ctr]=-vydi[Ctr];
   };//Move vertexes and collision detection from the sides of the screen

   //Draw the vertexes
   for (Ctr=0;Ctr<NUM_OF_VERTEXES-1;Ctr++) Buffer->Line(vx[Ctr],vy[Ctr],vx[Ctr+1],vy[Ctr+1],255);
   Buffer->Line(vx[0],vy[0],vx[NUM_OF_VERTEXES-1],vy[NUM_OF_VERTEXES-1],255);

   //Blur and send it to the screen
   BlurBuffer();
   Screen->VSync();
   Screen->Flip(Buffer);
};//Run the screensaver

void main(){
   //Show some copyright information
   clrscr();
   printf("%s","DJGPP screensaver example\n");
   printf("%s","Made using the GFX.H graphics engine\n");
   printf("%s","CopyRight (c) 2001, Johan Bos\n");
   printf("%s","\nPress any key to continue...\n");
   getch();

   //Run the screensaver until a user presses a key
   if (Initialize()){
      Buffer->Clear();
      MakePalette();
      InitScreenSaver();
      while (!kbhit()) UpdateFrame();
   };
   Cleanup();

   //Exit message
   clrscr();
   printf("%s","Made by Johan Bos\n");
   printf("%s","Visit my website at http://www.sludgesoft.com/johan\n");
};
