// DJGPP Example program 3: Load a font and write graphics text to the screen
//                          Aligned font writing
//                          Grab an image from a buffer
//                          Blitting images
//
// A part of the graphics engine GFX.H
// CopyRight (c) 2001, Johan Bos
// www.sludgesoft.com/johan
// bosjoh@fcmail.com
//////////////////////////////////////////////////////////////////////////////

#include <gfx.h>   //For all the graphics funtions
#include <conio.h> //For textmode I/O
#include <stdio.h> //For textmode I/O
//Needed libraries

GFXENGINE Gfx    = NULL; //The engine itself
SCREEN    Screen = NULL; //Handles the primary screen
FONT      Font   = NULL; //The font itself
IMAGE     Image  = NULL; //The image itself
//All variables needed for the graphics engine

bool Initialize(void){
   if (!CreateEngine(Gfx)) return(false);
   if (!Gfx->CreateScreen(Screen)) return(false);
   if (!Screen->SetGfxMode(640,480,8)) return(false);
   if (!Screen->CreateFont(Font)) return(false);
   Font->Load("std8bit.fnt");
   if (!Screen->CreateImage(Image)) return(false);
   return(true);
};//Prepare the program

void Cleanup(void){
   if (Gfx!=NULL){
      if (Image!=NULL) Image->Release();
      if (Font!=NULL) Font->Release();
      if (Screen!=NULL){
         Screen->CloseGfxMode();
         Screen->Release();
      };
      Gfx->Release();
   };
};//Prepare to exit the program

void main(){
   unsigned short XCtr,YCtr;//Counter variables

   if (Initialize()){
      //Show some copyright information in graphics (aligned)
      Screen->WriteFontAlign(0,0,"DJGPP font and image example",Font);
      Screen->WriteFontAlign(0,16,"CopyRight (c) 2001, Johan Bos",Font);
      Screen->WriteFontAlign(0,32,"Made using the GFX.H graphics engine",Font);
      Screen->WriteFontAlign(0,64,"Press any key to continue...",Font);
      getch();

      //Clear screen and draw a pattern
      Screen->Clear();
      Screen->HLine(0,7,0,63);
      Screen->VLine(0,15,0,63);
      Screen->HLine(0,7,15,255);
      Screen->VLine(0,15,7,255);
      Screen->Bar(1,1,6,14,2+8+32);
      Screen->WriteFont(0,32,"Press a key to see the whole pattern...",Font);
      getch();

      //Grab the pattern into an image
      Image->Grab(0,0,7,15,Screen);
      Screen->Clear();

      //And repeat it on the screen
      for (YCtr=0;YCtr<30;YCtr++) for (XCtr=0;XCtr<80;XCtr++) Screen->Blit(XCtr*8,YCtr*16,0,Image);
      Screen->WriteFont(0,0,"Press any key to exit...",Font);
      getch();
   };
   Cleanup();

   //Exit message
   clrscr();
   printf("%s","Made by Johan Bos\n");
   printf("%s","Visit my website at http://www.sludgesoft.com/johan\n");
};
