// DJGPP Example program 4: Advanced image operations
//
// A part of the graphics engine GFX.H
// CopyRight (c) 2001, Johan Bos
// www.sludgesoft.com/johan
// bosjoh@fcmail.com
//////////////////////////////////////////////////////////////////////////////

#include <gfx.h>   //For all the graphics funtions
#include <conio.h> //For textmode I/O
#include <stdio.h> //For textmode I/O
//Needed libraries

#define  STARS 50  //The number of stars on the screen

GFXENGINE Gfx    = NULL; //The engine itself
SCREEN    Screen = NULL; //Handles the primary screen
BUFFER    Buffer = NULL; //The offscreen buffer
BUFFER    Saved  = NULL; //Saves the buffer state
IMAGE     Image  = NULL; //The image itself
FONT      Font   = NULL; //To write text on the screen
//All variables needed for the graphics engine

unsigned short sx[STARS],sy[STARS];
unsigned char  sf[STARS];
//Globals needed to hold the star positions

bool Initialize(void){
   if (!CreateEngine(Gfx)) return(false);
   if (!Gfx->CreateScreen(Screen)) return(false);
   if (!Screen->SetGfxMode(640,480,16)) return(false);
   if (!Screen->AttachBuffer(Buffer)) return(false);
   if (!Screen->AttachBuffer(Saved)) return(false);
   if (!Screen->CreateImage(Image)) return(false);
   if (!Screen->CreateFont(Font)) return(false);
   Font->Load("std16bit.fnt");
   return(true);
};//Prepare the program

void Cleanup(void){
   if (Gfx!=NULL){
      if (Font!=NULL) Font->Release();
      if (Image!=NULL) Image->Release();
      if (Saved!=NULL) Saved->Release();
      if (Buffer!=NULL) Buffer->Release();
      if (Screen!=NULL){
         Screen->CloseGfxMode();
         Screen->Release();
      };
      Gfx->Release();
   };
};//Prepare to exit the program

void InitStars(void){
   unsigned char SCtr;//Star counter
   for (SCtr=0;SCtr<STARS;SCtr++){
      sx[SCtr]=random()%620;
      sy[SCtr]=random()%440;
      sf[SCtr]=random()%17;
   };
};//Calculate star positions etc.

void UpdateFrame(void){
   unsigned char SCtr;//Star counter
   Saved->Flip(Buffer);
   for (SCtr=0;SCtr<STARS;SCtr++){
      sf[SCtr]++;
      if (sf[SCtr]==17){
         sx[SCtr]=random()%620;
         sy[SCtr]=random()%440;
         sf[SCtr]=0;
      };
      if (sf[SCtr]<9) Buffer->AlphaBlendAdd(sx[SCtr],sy[SCtr]+20,sf[SCtr],0,Image);
      else Buffer->AlphaBlendAdd(sx[SCtr],sy[SCtr]+20,16-sf[SCtr],0,Image);
   };
   Screen->VSync();
   Screen->Flip(Buffer);
   Buffer->Flip(Saved);
};//Update the stars

void MakeImagePattern(void){
   unsigned short *Ptr;     //Stores the image information
   unsigned short YCtr,XCtr;//x and y position counters
   Ptr=(unsigned short *)malloc(2048);
   for (YCtr=0;YCtr<32;YCtr++) for (XCtr=0;XCtr<32;XCtr++){
      if (XCtr<YCtr) Ptr[YCtr*32+XCtr]=YCtr*64;
      else Ptr[YCtr*32+XCtr]=XCtr*64;
   };
   Image->Make(32,32,Ptr);
   free(Ptr);
};

void main(){
   unsigned short XCtr,YCtr;//x and y position counter
   if (Initialize()){
      //Show some copyright information in graphics (aligned)
      Screen->WriteFontAlign(0,0,"DJGPP advanced image handling example",Font);
      Screen->WriteFontAlign(0,16,"CopyRight (c) 2001, Johan Bos",Font);
      Screen->WriteFontAlign(0,32,"Made using the GFX.H graphics engine",Font);
      Screen->WriteFontAlign(0,64,"Press any key to continue...",Font);
      getch();

      //Create a 'dark sky' pattern on the screen and some info text
      for (YCtr=0;YCtr<480;YCtr++) Buffer->HLine(0,639,YCtr,YCtr/15);
      Buffer->WriteFontAlign(0,0,"Press any key to proceed...",Font);

      //Load 4 stars images from the 24 bits 'stars.bmp' bitmap file
      //The engine converts it automatically at the first blit
      Image->LoadMultiBmp("stars.bmp",20,20);

      //Alphablend the images for a starry night until the user presses a key
      InitStars();
      do{
         UpdateFrame();
      }while(!kbhit());
      getch();

      //Creates a pattern on the screen using alpha blending
      MakeImagePattern();
      for (YCtr=0;YCtr<480;YCtr++) Buffer->HLine(0,639,YCtr,63488-YCtr/15*2048+YCtr/15);
      for (YCtr=0;YCtr<15;YCtr++) for (XCtr=0;XCtr<20;XCtr++) Buffer->AlphaBlendAdd(XCtr*32,YCtr*32,0,0,Image);
      Buffer->WriteFontAlign(0,0,"Press any key to proceed...",Font);
      Screen->Flip(Buffer);
      getch();
   };
   Cleanup();

   //Exit message
   clrscr();
   printf("%s","Made by Johan Bos\n");
   printf("%s","Visit my website at http://www.sludgesoft.com/johan\n");
};
