// DJGPP Example program 5: 8-bit alpha blending
//
// A part of the graphics engine GFX.H
// CopyRight (c) 2001, Johan Bos
// www.sludgesoft.com/johan
// bosjoh@fcmail.com
//////////////////////////////////////////////////////////////////////////////

#include <gfx.h>   //For all the graphics funtions
#include <conio.h> //For textmode I/O
#include <stdio.h> //For textmode I/O
//Needed libraries

GFXENGINE Gfx    = NULL; //The engine itself
SCREEN    Screen = NULL; //Handles the primary screen
IMAGE     Image  = NULL; //The image itself
//All variables needed for the graphics engine

bool Initialize(void){
   if (!CreateEngine(Gfx)) return(false);
   if (!Gfx->CreateScreen(Screen)) return(false);
   if (!Screen->SetGfxMode(640,480,8)) return(false);
   if (!Screen->CreateImage(Image)) return(false);
   Image->LoadBmp("pattern.bmp");
   return(true);
};//Prepare the program

void Cleanup(void){
   if (Gfx!=NULL){
      if (Image!=NULL) Image->Release();
      if (Screen!=NULL){
         Screen->CloseGfxMode();
         Screen->Release();
      };
      Gfx->Release();
   };
};//Prepare to exit the program

void main(){
   unsigned short YCtr,XCtr;//x and y position counters

   //Show some copyright information
   clrscr();
   printf("%s","DJGPP 8bit Alphablend example\n");
   printf("%s","Made using the GFX.H graphics engine\n");
   printf("%s","CopyRight (c) 2001, Johan Bos\n");
   printf("%s","\nPress any key to continue...\n");
   getch();

   if (Initialize()){
      //Draw a background pattern
      for (YCtr=0;YCtr<480;YCtr++) for (XCtr=0;XCtr<640;XCtr++) Screen->PutPixel(XCtr,YCtr,XCtr+YCtr);

      //Creating a palette lookup table:
      //Call this function before a conversion or alpha blend procedure,
      //when the screen is initialized or when a palette is changed.
      Screen->CreatePaletteLookupTable();

      //Alpha blend the pattern
      for (YCtr=0;YCtr<8;YCtr++) for (XCtr=0;XCtr<10;XCtr++) Screen->AlphaBlend(XCtr*64,YCtr*64,0,1,Image);
      getch();
   };
   Cleanup();

   //Exit message
   clrscr();
   printf("%s","Made by Johan Bos\n");
   printf("%s","Visit my website at http://www.sludgesoft.com/johan\n");
};
