// Demonstration 1: Test all videomodes
//////////////////////////////////////////////////////////////////////

bool Initialize1(HWND hwnd){
   if (!CreateEngine(Gfx)) return(false);
   if (!Gfx->RegisterWindow(hwnd)) return(false);
   if (!Gfx->CreateScreen(Screen)) return(false);
   return(true);
};//Prepare the program

void Cleanup1(void){
   if (Gfx!=NULL){
      if (Screen!=NULL) Screen->Release();
      Gfx->Release();
   };
};//Prepare to exit the program

void TestMode(unsigned short XRes,unsigned short YRes,unsigned char ColorDepth,HWND hwnd){
   char ValStr[9];          //A value in a string
   char Message[256];       //The message inside the messagebox
   unsigned long White;     //Stores a white pixel value
   unsigned short XCtr,YCtr;//Counter variables

   //Ask the user if he wants to test the videomode
   strcpy(Message,"Testing ");
   itoa(XRes,ValStr,10);
   strcpy(&Message[strlen(Message)],ValStr);
   strcpy(&Message[strlen(Message)],"x");
   itoa(YRes,ValStr,10);
   strcpy(&Message[strlen(Message)],ValStr);
   strcpy(&Message[strlen(Message)],"x");
   itoa(ColorDepth,ValStr,10);
   strcpy(&Message[strlen(Message)],ValStr);
   strcpy(&Message[strlen(Message)],"...\nClick on OK to proceed...");
   if (MessageBox(hwnd,Message,"Videomode test",1)==2) return;
   
   //Try to set the videomode, show an error message on failure
   if (!Screen->SetGfxMode(XRes,YRes,ColorDepth)){
      Screen->CloseGfxMode();
	  MessageBox(hwnd,"Could not find the videomode","Error",0);
	  return;
   };

   //Determine a white pixel
   if (ColorDepth==8)  White=255;
   if (ColorDepth==15) White=32767;
   if (ColorDepth==16) White=65535;
   if (ColorDepth==32) White=16777215;

   //Draw a pattern on the screen
   Screen->Lock();
   Screen->Clear();
   if (ColorDepth==8) for (YCtr=0;YCtr<16;YCtr++) for (XCtr=0;XCtr<16;XCtr++) Screen->Bar(XRes-96+XCtr*6,YRes-96+YCtr*6,XRes-89+XCtr*6,YRes-89+YCtr*6,YCtr*16+XCtr);
   if (ColorDepth==15) for (YCtr=0;YCtr<96;YCtr++) for (XCtr=0;XCtr<96;XCtr++) Screen->PutPixel(XRes-96+XCtr,YRes-96+YCtr,XCtr/3+XCtr/6*32+YCtr/3*1024);
   if (ColorDepth==16) for (YCtr=0;YCtr<96;YCtr++) for (XCtr=0;XCtr<96;XCtr++) Screen->PutPixel(XRes-96+XCtr,YRes-96+YCtr,XCtr/3*33+YCtr/3*2048);
   if (ColorDepth==32) for (YCtr=0;YCtr<100;YCtr++) for (XCtr=0;XCtr<100;XCtr++) Screen->PutPixel(XRes-96+XCtr,YRes-96+YCtr,XCtr*258+YCtr*131072);
   Screen->Rectangle(0,0,XRes-1,YRes-1,White);
   Screen->Line(0,0,XRes-1,YRes-1,White);
   Screen->Line(XRes-1,0,0,YRes-1,White);
   Screen->Unlock();

   //Wait for a key and return
   emptykeystate();
   while (!keypressed());
   Screen->CloseGfxMode();
};//Tests a videomode

void rundemo1(HWND hwnd){
   if (Initialize1(hwnd)){
      //Test all videomodes
      TestMode(320,200,8,hwnd);
      TestMode(320,200,15,hwnd);
      TestMode(320,200,16,hwnd);
      TestMode(320,200,32,hwnd);
      TestMode(320,240,8,hwnd);
      TestMode(320,240,15,hwnd);
      TestMode(320,240,16,hwnd);
      TestMode(320,240,32,hwnd);
      TestMode(400,300,8,hwnd);
      TestMode(400,300,15,hwnd);
      TestMode(400,300,16,hwnd);
      TestMode(400,300,32,hwnd);
      TestMode(512,384,8,hwnd);
      TestMode(512,384,15,hwnd);
      TestMode(512,384,16,hwnd);
      TestMode(512,384,32,hwnd);
      TestMode(640,480,8,hwnd);
      TestMode(640,480,15,hwnd);
      TestMode(640,480,16,hwnd);
      TestMode(640,480,32,hwnd);
      TestMode(800,600,8,hwnd);
      TestMode(800,600,15,hwnd);
      TestMode(800,600,16,hwnd);
      TestMode(800,600,32,hwnd);
      TestMode(1024,768,8,hwnd);
      TestMode(1024,768,15,hwnd);
      TestMode(1024,768,16,hwnd);
      TestMode(1024,768,32,hwnd);
      TestMode(1280,1024,8,hwnd);
      TestMode(1280,1024,15,hwnd);
      TestMode(1280,1024,16,hwnd);
      TestMode(1280,1024,32,hwnd);
      TestMode(1600,1200,8,hwnd);
      TestMode(1600,1200,15,hwnd);
      TestMode(1600,1200,16,hwnd);
      TestMode(1600,1200,32,hwnd);
   };
   Cleanup1();
};
